/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.unify.service.impl;

import com.jxdinfo.crm.analysis.unify.dto.UnifyPortalAnalysisDto;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalApiService;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalService;
import com.jxdinfo.crm.analysis.unify.vo.ProductContractAmountVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UnifyPortalApiServiceImpl
implements UnifyPortalApiService {
    @Resource
    private UnifyPortalService unifyPortalService;
    @Resource
    private IUserBoService iUserBoService;
    @Resource
    private CrmCommonProperties crmProperties;

    @Override
    public List<ProductContractAmountVo> portalProductContractAmount(UnifyPortalAnalysisDto dto) {
        SalesStatisticsDto staticsDto = new SalesStatisticsDto();
        LocalDateTime date = LocalDateTime.now();
        Long currentUserId = dto.getCurrentUserId();
        SecurityUser user = this.iUserBoService.selectSecurityByUserId(currentUserId);
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)staticsDto, (CrmCommonProperties)this.crmProperties, (Long)currentUserId);
        return this.unifyPortalService.getProductContractAmountVos(dto, user, staticsDto, date);
    }
}

