/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.jxdinfo.crm.analysis.intelligentanalysis.dao.CrmSalesPersonDiligentMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonBehaviorDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.CrmSalesPersonDiligent;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.CrmSalesPersonDiligentService;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.SalespersonAnalysisService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonBehaviorVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmSalesPersonDiligentServiceImpl
extends HussarServiceImpl<CrmSalesPersonDiligentMapper, CrmSalesPersonDiligent>
implements CrmSalesPersonDiligentService {
    @Autowired
    private CrmSalesPersonDiligentMapper crmSalesPersonDiligentMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private SalespersonAnalysisService salespersonAnalysisService;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;

    @Override
    public void calculateDiligent() {
        List diligentLevelList = this.commonService.getDicValue("diligent_level", null, null);
        if (diligentLevelList.size() != 3) {
            return;
        }
        CrmBaseConfigVo baseConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("diligent_calculate_range");
        if (!ToolUtil.isNotEmpty((Object)baseConfig)) {
            return;
        }
        int calculateRange = Integer.valueOf(baseConfig.getConfigValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, -1);
        String endTime = format.format(cale.getTime());
        cale.add(5, -calculateRange);
        String startTime = format.format(cale.getTime());
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
        List salesmanList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        Set permissionSet = salesmanList.stream().map(UserVo::getId).collect(Collectors.toSet());
        List<CrmSalesPersonDiligent> salesPersonList = this.crmSalesPersonDiligentMapper.getCrmSalesPersonDiligentScore(startTime, endTime, new ArrayList<Long>(permissionSet));
        SalespersonBehaviorDto dto = new SalespersonBehaviorDto();
        dto.setStartTime(LocalDate.parse(startTime));
        dto.setEndTime(LocalDate.parse(endTime));
        dto.setPermissionUserId(new ArrayList<Long>(permissionSet));
        dto.setUserIds(new ArrayList<Long>(permissionSet));
        List<SalespersonBehaviorVo> list = this.salespersonAnalysisService.selectSignificantRecordCount(dto);
        for (CrmSalesPersonDiligent crmSalesPersonDiligent : salesPersonList) {
            for (SalespersonBehaviorVo vo : list) {
                if (!vo.getUserId().equals(crmSalesPersonDiligent.getSalesPersonId())) continue;
                Double score = ((double)(vo.getSignificantRecordCount() * 1) - (double)vo.getInsignificantRecordCount() * 0.5) / (double)calculateRange;
                crmSalesPersonDiligent.setDiligentScore(crmSalesPersonDiligent.getDiligentScore() + score.intValue());
            }
        }
        ArrayList<CrmSalesPersonDiligent> repairSalesPersonList = new ArrayList<CrmSalesPersonDiligent>();
        for (Long salesPerson : permissionSet) {
            boolean isExist = false;
            for (CrmSalesPersonDiligent cspd : salesPersonList) {
                if (!salesPerson.equals(cspd.getSalesPersonId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            repairSalesPersonList.add(this.initCrmSalesPersonDiligent(salesPerson));
        }
        salesPersonList.addAll(repairSalesPersonList);
        salesPersonList = salesPersonList.stream().sorted(Comparator.comparing(CrmSalesPersonDiligent::getDiligentScore).reversed()).collect(Collectors.toList());
        boolean bl = false;
        int ranking = 0;
        for (int i = 0; i < salesPersonList.size(); ++i) {
            int n;
            CrmSalesPersonDiligent sales = salesPersonList.get(i);
            if (i == 0 || sales.getDiligentScore() != n) {
                ranking = i + 1;
            }
            n = sales.getDiligentScore();
            sales.setDiligentRanking(ranking);
            int diligent = ranking * 100 / salesPersonList.size();
            if (diligent <= 10) {
                sales.setDiligentLevel("1");
            } else if (diligent > 10 && diligent <= 70) {
                sales.setDiligentLevel("2");
            } else {
                sales.setDiligentLevel("3");
            }
            sales.setDiligentDate(endTime);
            sales.setCreateTime(LocalDateTime.now());
            sales.setCreatePersonName("system");
            this.crmSalesPersonDiligentMapper.insert(sales);
        }
    }

    private CrmSalesPersonDiligent initCrmSalesPersonDiligent(Long salesPerson) {
        CrmSalesPersonDiligent cspd = new CrmSalesPersonDiligent();
        cspd.setSalesPersonId(salesPerson);
        cspd.setDiligentScore(0);
        return cspd;
    }
}

