/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.unify.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.analysis.unify.dao.OpportunityAnalysisMapper;
import com.jxdinfo.crm.analysis.unify.dao.PortalStatisticsMapper;
import com.jxdinfo.crm.analysis.unify.dto.UnifyPortalAnalysisDto;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalApiService;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalService;
import com.jxdinfo.crm.analysis.unify.vo.PortalProductAmountVo;
import com.jxdinfo.crm.analysis.unify.vo.ProductContractAmountVo;
import com.jxdinfo.crm.analysis.unify.vo.ProductTreeVo;
import com.jxdinfo.crm.analysis.unify.vo.StatisticalResultsVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.config.OsApiProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunitySuccessRateAPIService;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityPermissionService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.ProductTypeA;
import com.jxdinfo.crm.core.product.service.ProductTypeAService;
import com.jxdinfo.crm.core.unify.dao.UnifyPortalMapper;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UnifyPortalApiServiceImpl
implements UnifyPortalApiService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private ProductTypeAService productTypeAService;
    @Resource
    private UnifyPortalMapper unifyPortalMapper;
    @Resource
    private IOpportunitySuccessRateAPIService opportunitySuccessRateAPIService;
    @Resource
    private OpportunityAnalysisMapper opportunityAnalysisMapper;
    @Resource
    private UnifyPortalService unifyPortalService;
    @Resource
    private PortalStatisticsMapper portalStatisticsMapper;
    @Resource
    private IUserBoService iUserBoService;
    @Resource
    private IOpportunityPermissionService opportunityPermissionService;
    @Resource
    private OsApiProperties osApiProperties;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    @Override
    public List<ProductContractAmountVo> portalProductContractAmount(UnifyPortalAnalysisDto dto) {
        List productIdList;
        SalesStatisticsDto staticsDto = new SalesStatisticsDto();
        LocalDateTime date = LocalDateTime.now();
        Long currentUserId = dto.getCurrentUserId();
        SecurityUser user = this.iUserBoService.selectSecurityByUserId(currentUserId);
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        }
        List roleIdList = user.getRolesList();
        staticsDto.setDelFlag("0");
        IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)staticsDto, (CrmCommonProperties)this.crmProperties, (Long)currentUserId);
        List productTypeAIds = this.productTypeAService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ProductTypeA::getProductId}).orderByAsc(ProductTypeA::getShowOrder), s -> Long.valueOf(s.toString()));
        List leadershipRoles = DataPermission.getLeadershipRoles();
        DataPermission.isLeadship((List)roleIdList, (List)leadershipRoles);
        if (roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            staticsDto.setCurrentDeptId(null);
            staticsDto.setPermissionDeptIds(null);
            staticsDto.setPermissionUserId(null);
            productIdList = productTypeAIds;
        } else if (roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getProductManager()))) {
            productIdList = this.productMapper.getProductByUserIdOrder(user.getUserId());
        } else if (roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader())) || roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) || roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector()))) {
            productIdList = productTypeAIds;
        } else if (DataPermission.isLeadship((List)roleIdList, (List)leadershipRoles)) {
            productIdList = productTypeAIds;
        } else if (roleIdList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesman()))) {
            List productOperateIds = this.unifyPortalMapper.selectOperateProductId(staticsDto);
            if (CollectionUtil.isEmpty((Collection)productOperateIds)) {
                return null;
            }
            for (int i = productTypeAIds.size() - 1; i >= 0; --i) {
                if (productOperateIds.contains(productTypeAIds.get(i))) continue;
                productTypeAIds.remove(i);
            }
            productIdList = Stream.of(productTypeAIds, productOperateIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        } else {
            productIdList = productTypeAIds;
        }
        if (CollectionUtil.isEmpty((Collection)productIdList)) {
            return null;
        }
        Long categoryId = dto.getProductCategoryId();
        List<ProductTreeVo> productTreeVoList = this.unifyPortalService.getProductTreeByProductIds(productIdList, categoryId);
        if (!ToolUtil.isNotEmpty(productTreeVoList)) {
            return null;
        }
        List<Long> searchProductIds = this.unifyPortalService.getProductListByTree(productTreeVoList, productIdList);
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List winStageIdList = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        List<Long> tqkgStageIdList = Arrays.stream(this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config").getConfigValue().split(",")).map(Long::valueOf).collect(Collectors.toList());
        ArrayList<Long> opportunityIds = this.opportunityPermissionService.getOpportunityIdListByPermission(user.getUserId(), searchProductIds, winStageIdList);
        if (opportunityIds == null) {
            opportunityIds = new ArrayList<Long>();
        }
        DefaultCacheUtil.put((Object)("permissionOpptyId" + user.getUserId()), opportunityIds, (long)86400L);
        List signedProductList = new ArrayList();
        List<Long> signedOpportunityIdList = new ArrayList<Long>();
        if (this.osApiProperties.isOsEnable()) {
            HashMap<String, String> body = new HashMap<String, String>();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            body.put("startTime", LocalDateTime.of(LocalDate.from(LocalDateTime.now().with(TemporalAdjusters.firstDayOfYear())), LocalTime.MIN).format(formatter));
            body.put("endTime", LocalDateTime.of(LocalDate.from(LocalDateTime.now().with(TemporalAdjusters.lastDayOfYear())), LocalTime.MAX).format(formatter));
            body.put("sjIds", opportunityIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            HashMap param = new HashMap();
            param.put("body", body);
            ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getProductContractAmount(), (Map)param);
            Map map = (Map)contractJSON.getData();
            if (CollectionUtil.isNotEmpty((Collection)((List)map.get("sjIds")))) {
                signedOpportunityIdList = ((List)map.get("sjIds")).stream().map(Long::parseLong).collect(Collectors.toList());
            }
            signedProductList = BeanUtil.copy((Collection)((List)map.get("results")), StatisticalResultsVo.class);
            DefaultCacheUtil.put((Object)("signedOpptyId" + user.getUserId()), signedOpportunityIdList, (long)86400L);
        } else {
            signedOpportunityIdList.add(-1L);
        }
        List<PortalProductAmountVo> list = this.portalStatisticsMapper.selectPortalProductContractAmount(searchProductIds, winStageIdList, tqkgStageIdList, date, staticsDto, opportunityIds, signedOpportunityIdList);
        ArrayList<ProductContractAmountVo> productContractAmountVoList = new ArrayList<ProductContractAmountVo>();
        for (PortalProductAmountVo portalProductAmountVo2 : list) {
            ProductContractAmountVo vo = new ProductContractAmountVo();
            vo.setProductId(portalProductAmountVo2.getProductId());
            vo.setProductName(portalProductAmountVo2.getProductName());
            Double signedContract = 0.0;
            for (StatisticalResultsVo srv : signedProductList) {
                if (srv.getCpid().contains("-") || !vo.getProductId().equals(Long.parseLong(srv.getCpid())) || srv.getCpxsje() == null) continue;
                signedContract = signedContract + srv.getCpxsje();
            }
            vo.setSignedContract(signedContract);
            vo.setUnsignedContract(portalProductAmountVo2.getAmountWin());
            vo.setMentionThisYear(portalProductAmountVo2.getAmountMention());
            vo.setPreviousMention(portalProductAmountVo2.getAmountMentionAll() - portalProductAmountVo2.getAmountMention());
            productContractAmountVoList.add(vo);
        }
        Map<Object, Object> productAmountMap = new HashMap();
        if (HussarUtils.isNotEmpty(list)) {
            productAmountMap = productContractAmountVoList.stream().collect(Collectors.toMap(ProductContractAmountVo::getProductId, portalProductAmountVo -> portalProductAmountVo));
        }
        ICrmBaseConfigBoService crmBaseConfigBoService = (ICrmBaseConfigBoService)SpringUtils.getBean(ICrmBaseConfigBoService.class);
        CrmBaseConfigVo configVo = crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = configVo.getConfigValue();
        ProductContractAmountVo total = new ProductContractAmountVo();
        total.setProductName("\u4ea7\u54c1\u603b\u8ba1");
        Double amountAll1 = productContractAmountVoList.stream().mapToDouble(ProductContractAmountVo::getSignedContract).sum();
        total.setSignedContract(Double.parseDouble(CommonUtills.transferAmount((Double)amountAll1, (String)amountDisplay)));
        Double amountAll2 = productContractAmountVoList.stream().mapToDouble(ProductContractAmountVo::getUnsignedContract).sum();
        total.setUnsignedContract(Double.parseDouble(CommonUtills.transferAmount((Double)amountAll2, (String)amountDisplay)));
        Double amountAll3 = productContractAmountVoList.stream().mapToDouble(ProductContractAmountVo::getMentionThisYear).sum();
        total.setMentionThisYear(Double.parseDouble(CommonUtills.transferAmount((Double)amountAll3, (String)amountDisplay)));
        Double amountAll4 = productContractAmountVoList.stream().mapToDouble(ProductContractAmountVo::getPreviousMention).sum();
        total.setPreviousMention(Double.parseDouble(CommonUtills.transferAmount((Double)amountAll4, (String)amountDisplay)));
        ArrayList<ProductContractAmountVo> returnlist = new ArrayList<ProductContractAmountVo>();
        returnlist.add(0, total);
        for (ProductTreeVo productTreeVo : productTreeVoList) {
            ProductContractAmountVo productAmountVo = new ProductContractAmountVo();
            productAmountVo.setProductId(productTreeVo.getId());
            productAmountVo.setProductName(productTreeVo.getName());
            List<Long> allChildList = productTreeVo.getAllChildIdsList();
            productAmountVo.setChildProductId(productTreeVo.getAllChildIdsList());
            productAmountVo.getChildProductId().remove(productAmountVo.getProductId());
            if (CollectionUtil.isEmpty(productAmountVo.getChildProductId())) {
                productAmountVo.setIsType("0");
            } else {
                productAmountVo.setIsType("1");
            }
            allChildList.add(productTreeVo.getId());
            Double amount1 = 0.0;
            Double amount2 = 0.0;
            Double amount3 = 0.0;
            Double amount4 = 0.0;
            for (Long childId : allChildList) {
                ProductContractAmountVo vo = (ProductContractAmountVo)productAmountMap.get(childId);
                if (!HussarUtils.isNotEmpty((Object)vo)) continue;
                amount1 = amount1 + vo.getSignedContract();
                amount2 = amount2 + vo.getUnsignedContract();
                amount3 = amount3 + vo.getMentionThisYear();
                amount4 = amount4 + vo.getPreviousMention();
            }
            String amount1String = CommonUtills.transferAmount((Double)amount1, (String)amountDisplay);
            String amount2String = CommonUtills.transferAmount((Double)amount2, (String)amountDisplay);
            String amount3String = CommonUtills.transferAmount((Double)amount3, (String)amountDisplay);
            String amount4String = CommonUtills.transferAmount((Double)amount4, (String)amountDisplay);
            if (HussarUtils.isNotEmpty((Object)amount1String) && Double.parseDouble(amount1String) > 0.0) {
                productAmountVo.setSignedContract(Double.parseDouble(amount1String));
            } else {
                productAmountVo.setSignedContract(0.0);
            }
            if (HussarUtils.isNotEmpty((Object)amount2String) && Double.parseDouble(amount2String) > 0.0) {
                productAmountVo.setUnsignedContract(Double.parseDouble(amount2String));
            } else {
                productAmountVo.setUnsignedContract(0.0);
            }
            if (HussarUtils.isNotEmpty((Object)amount3String) && Double.parseDouble(amount3String) > 0.0) {
                productAmountVo.setMentionThisYear(Double.parseDouble(amount3String));
            } else {
                productAmountVo.setMentionThisYear(0.0);
            }
            if (HussarUtils.isNotEmpty((Object)amount4String) && Double.parseDouble(amount4String) > 0.0) {
                productAmountVo.setPreviousMention(Double.parseDouble(amount4String));
            } else {
                productAmountVo.setPreviousMention(0.0);
            }
            returnlist.add(productAmountVo);
        }
        return returnlist;
    }
}

