/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.marketingactivity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.common.CommonUtil;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityVo;
import com.jxdinfo.crm.analysis.marketingactivity.dao.MarketingEvaluationMapper;
import com.jxdinfo.crm.analysis.marketingactivity.dto.MarketingActivityAnalysisDto;
import com.jxdinfo.crm.analysis.marketingactivity.dto.OpportunityAnalysisDto;
import com.jxdinfo.crm.analysis.marketingactivity.dto.OpportunityTrendDto;
import com.jxdinfo.crm.analysis.marketingactivity.service.MarketingEvaluationService;
import com.jxdinfo.crm.analysis.marketingactivity.vo.CampaignAnalysisVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityFromVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityGrowthDataVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityGrowthTrendsVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunitySourcesAnalysisVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityTrendDateVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityTrendProductVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityTrendSearchVo;
import com.jxdinfo.crm.analysis.marketingactivity.vo.OpportunityTrendVo;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalService;
import com.jxdinfo.crm.analysis.unify.vo.ProductTreeVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.marketingactivity.dao.MarketingActivityMapper;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.model.ProductTypeA;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.product.service.ProductTypeAService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.ExcelStyle;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.crm.product.model.ProductCategory;
import com.jxdinfo.crm.product.service.ProductCategoryService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class MarketingEvaluationServiceImpl
implements MarketingEvaluationService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private MarketingActivityMapper marketingActivityMapper;
    @Resource
    private MarketingEvaluationMapper marketingEvaluationMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private ProductTypeAService productTypeAService;
    @Resource
    private UnifyPortalService unifyPortalService;
    @Resource
    private ProductCategoryService productCategoryService;
    @Resource
    private ProductService productService;

    @Override
    public OpportunitySourcesAnalysisVo opportunitySourcesAnalysis(OpportunityAnalysisDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        dto.setCurrentUserId(user.getUserId());
        List<OpportunityFromVo> opportunityFromVoList = this.marketingEvaluationMapper.getCrmOpportunityList(this.assemblyParameters(dto));
        return this.getCommonAnalysis(opportunityFromVoList, "opportunitySources");
    }

    @Override
    public OpportunitySourcesAnalysisVo customerSourcesAnalysis(OpportunityAnalysisDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        dto.setCurrentUserId(user.getUserId());
        List<OpportunityFromVo> customerEntities = this.marketingEvaluationMapper.getCustomerLists(this.assemblyParameters(dto));
        return this.getCommonAnalysis(customerEntities, "customerSources");
    }

    private OpportunitySourcesAnalysisVo getCommonAnalysis(List<OpportunityFromVo> opportunityFromVoList, String methodType) {
        if (ToolUtil.isEmpty(opportunityFromVoList)) {
            return new OpportunitySourcesAnalysisVo();
        }
        int sum = opportunityFromVoList.stream().mapToInt(OpportunityFromVo::getOpportunityFromNumbers).sum();
        OpportunitySourcesAnalysisVo opportunitySourcesAnalysisVo = new OpportunitySourcesAnalysisVo();
        if ("opportunitySources".equals(methodType) || "customerSources".equals(methodType)) {
            Optional<Integer> networkSizeOptional = opportunityFromVoList.stream().filter(f -> "5".equals(f.getOpportunityFromId())).map(OpportunityFromVo::getOpportunityFromNumbers).findFirst();
            int networkSize = networkSizeOptional.orElse(0);
            opportunitySourcesAnalysisVo.setNewOpportunityNumbers(sum);
            opportunitySourcesAnalysisVo.setNetworkPromotionNumbers(networkSize);
            opportunitySourcesAnalysisVo.setNonNetworkNumbers(sum - networkSize);
        }
        opportunitySourcesAnalysisVo.setOpportunityFromVos(opportunityFromVoList);
        opportunityFromVoList.forEach(f -> {
            if (0 == f.getOpportunityFromNumbers()) {
                f.setOpportunityPercentage("0");
            } else {
                double percentage = (double)f.getOpportunityFromNumbers() / (double)sum;
                f.setOpportunityPercentage(String.format("%.2f", percentage * 100.0) + "%");
            }
        });
        return opportunitySourcesAnalysisVo;
    }

    @Override
    public List<OpportunityFromVo> onlineChannelsAnalysis(OpportunityAnalysisDto dto) {
        OpportunitySourcesAnalysisVo opportunitySourcesAnalysisVo;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        dto.setCurrentUserId(user.getUserId());
        List<OpportunityFromVo> opportunityFromVoList = this.marketingEvaluationMapper.onlineChannelsAnalysis(this.assemblyParameters(dto));
        if (ToolUtil.isNotEmpty(opportunityFromVoList) && opportunityFromVoList.size() > 7) {
            List<OpportunityFromVo> opportunityFromVoList1 = opportunityFromVoList.subList(7, opportunityFromVoList.size());
            int sum = opportunityFromVoList1.stream().mapToInt(OpportunityFromVo::getOpportunityFromNumbers).sum();
            String idString = opportunityFromVoList1.stream().map(OpportunityFromVo::getOpportunityFromId).collect(Collectors.joining(","));
            OpportunityFromVo opportunity = new OpportunityFromVo();
            opportunity.setOpportunityFromId(idString);
            opportunity.setOpportunityFromName("\u5176\u4ed6");
            opportunity.setOpportunityFromNumbers(sum);
            List collect = opportunityFromVoList.stream().limit(7L).collect(Collectors.toList());
            collect.add(opportunity);
            opportunityFromVoList = collect;
        }
        if (ToolUtil.isNotEmpty((Object)(opportunitySourcesAnalysisVo = this.getCommonAnalysis(opportunityFromVoList, null)))) {
            return opportunitySourcesAnalysisVo.getOpportunityFromVos();
        }
        return new ArrayList<OpportunityFromVo>();
    }

    @Override
    public List<OpportunityGrowthTrendsVo> opportunityGrowthTrends(OpportunityAnalysisDto dto) {
        LocalDate today = LocalDate.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        OpportunityAnalysisDto analysisDto = new OpportunityAnalysisDto();
        analysisDto.setCurrentUserId(user.getUserId());
        List<String> products = dto.getProducts();
        String opportunityGrowthTrendDemission = dto.getOpportunityGrowthTrendDemission();
        List<String> opptyFroms = dto.getOpptyFrom();
        List campaignList = CollectionUtil.isEmpty(dto.getCampaignIds()) ? this.commonMapper.getDicValue("campaign_name", null, null).stream().map(DicVo::getLabel).collect(Collectors.toList()) : dto.getCampaignIds().stream().map(String::valueOf).collect(Collectors.toList());
        List opportunityFroms = this.marketingActivityMapper.selectList((Wrapper)new LambdaQueryWrapper().in(MarketingActivityEntity::getCampaignId, campaignList)).stream().map(MarketingActivityEntity::getCampaignId).collect(Collectors.toList());
        ArrayList<OpportunityGrowthTrendsVo> trendsVoList = new ArrayList<OpportunityGrowthTrendsVo>();
        if ("1".equals(opportunityGrowthTrendDemission)) {
            List dates;
            List<OpportunityGrowthDataVo> opportunityGrowthOpptyTotal = this.marketingEvaluationMapper.opportunityGrowthTrendsOpptyTotal(today.minusDays(9L), today, user.getUserId(), products, opptyFroms);
            if (ToolUtil.isNotEmpty(opportunityGrowthOpptyTotal)) {
                List datesNoNull;
                for (OpportunityGrowthDataVo opportunityGrowthDataVo : opportunityGrowthOpptyTotal) {
                    opportunityGrowthDataVo.setChartColName(opportunityGrowthDataVo.getCreateDate().toString());
                    opportunityGrowthDataVo.setStartDate(opportunityGrowthDataVo.getCreateDate());
                    opportunityGrowthDataVo.setEndDate(opportunityGrowthDataVo.getCreateDate());
                }
                List finalDatesNoNull = datesNoNull = opportunityGrowthOpptyTotal.stream().map(OpportunityGrowthDataVo::getCreateDate).collect(Collectors.toList());
                dates = CrmDateUtils.getNearlyTenDays().stream().filter(s -> !finalDatesNoNull.contains(s)).collect(Collectors.toList());
            } else {
                dates = CrmDateUtils.getNearlyTenDays();
            }
            ArrayList<OpportunityGrowthDataVo> vosTemp = new ArrayList<OpportunityGrowthDataVo>();
            for (LocalDate date : dates) {
                OpportunityGrowthDataVo opportunityGrowthDataVo = new OpportunityGrowthDataVo();
                opportunityGrowthDataVo.setCreateDate(date);
                opportunityGrowthDataVo.setChartColName(date.toString());
                opportunityGrowthDataVo.setStartDate(date);
                opportunityGrowthDataVo.setEndDate(date);
                vosTemp.add(opportunityGrowthDataVo);
            }
            if (ToolUtil.isNotEmpty(opportunityGrowthOpptyTotal)) {
                vosTemp.addAll(opportunityGrowthOpptyTotal);
            }
            OpportunityGrowthTrendsVo opportunityGrowthTrendsVo = new OpportunityGrowthTrendsVo();
            List<OpportunityGrowthDataVo> vos = vosTemp.stream().sorted(Comparator.comparing(OpportunityGrowthDataVo::getCreateDate)).collect(Collectors.toList());
            opportunityGrowthTrendsVo.setOpportunityGrowthDataVos(vos);
            trendsVoList.add(opportunityGrowthTrendsVo);
            if (opptyFroms.size() == 1 && "5".equals(opptyFroms.get(0))) {
                List<OpportunityGrowthDataVo> opportunityGrowthDataVos = this.marketingEvaluationMapper.opportunityGrowthTrendsByCampaign(today.minusDays(9L), today, user.getUserId(), products, opptyFroms);
                List opptyTrendsVoList = opportunityFroms.stream().map(f -> {
                    List<OpportunityGrowthDataVo> collect = opportunityGrowthDataVos.stream().filter(s -> f.equals(s.getCampaignId())).collect(Collectors.toList());
                    collect.forEach(c -> c.setChartColName(c.getCreateDate().toString()));
                    List dates2 = CrmDateUtils.getNearlyTenDays();
                    List<LocalDate> localDates = dates2.stream().filter(s -> collect.stream().noneMatch(data -> data.getCreateDate().equals(s))).collect(Collectors.toList());
                    MarketingActivityEntity activity = (MarketingActivityEntity)this.marketingActivityMapper.selectById((Serializable)f);
                    String campaignName = "";
                    if (ToolUtil.isNotEmpty(collect)) {
                        campaignName = ((OpportunityGrowthDataVo)collect.get(0)).getCampaignName();
                    } else if (activity != null) {
                        campaignName = activity.getCampaignName();
                    }
                    String finalCampaignName = campaignName;
                    localDates.forEach(localDate -> {
                        OpportunityGrowthDataVo opportunityGrowthDataVo = new OpportunityGrowthDataVo();
                        opportunityGrowthDataVo.setCampaignId((Long)f);
                        opportunityGrowthDataVo.setCampaignName(finalCampaignName);
                        opportunityGrowthDataVo.setCreateDate((LocalDate)localDate);
                        opportunityGrowthDataVo.setChartColName(localDate.toString());
                        opportunityGrowthDataVo.setStartDate((LocalDate)localDate);
                        opportunityGrowthDataVo.setEndDate((LocalDate)localDate);
                        collect.add(opportunityGrowthDataVo);
                    });
                    List<OpportunityGrowthDataVo> opportunityGrowthDataVoList = collect.stream().sorted(Comparator.comparing(OpportunityGrowthDataVo::getCreateDate)).collect(Collectors.toList());
                    OpportunityGrowthTrendsVo opportunityGrowthTrendsVo = new OpportunityGrowthTrendsVo();
                    opportunityGrowthTrendsVo.setCampaignId((Long)f);
                    opportunityGrowthTrendsVo.setCampaignName(campaignName);
                    opportunityGrowthTrendsVo.setOpportunityGrowthDataVos(opportunityGrowthDataVoList);
                    return opportunityGrowthTrendsVo;
                }).collect(Collectors.toList());
                trendsVoList.addAll(opptyTrendsVoList);
            }
        } else {
            ArrayList dateMapListTemp = new ArrayList();
            if ("2".equals(opportunityGrowthTrendDemission)) {
                CrmDateUtils.getNearlyWeeks(dateMapListTemp, (LocalDate)today, (int)6);
            } else if ("3".equals(opportunityGrowthTrendDemission)) {
                CrmDateUtils.getNearlyMonths(dateMapListTemp, (LocalDate)today, (LocalDate)today, (int)6);
            } else if ("4".equals(opportunityGrowthTrendDemission)) {
                CrmDateUtils.getNearlyQuarters(dateMapListTemp, (LocalDate)today, (LocalDate)today, (int)4);
            } else if ("5".equals(opportunityGrowthTrendDemission)) {
                CrmDateUtils.getNearlyYears(dateMapListTemp, (LocalDate)today, (LocalDate)today, (int)5);
            }
            List dateMapList = dateMapListTemp.stream().sorted(Comparator.comparing(map -> (LocalDate)map.get("startDate"))).collect(Collectors.toList());
            LocalDate startTime = (LocalDate)((Map)dateMapList.get(0)).get("startDate");
            LocalDate endTime = (LocalDate)((Map)dateMapList.get(dateMapList.size() - 1)).get("endDate");
            List<OpportunityGrowthDataVo> list = this.marketingEvaluationMapper.opportunityGrowthTrendsOpptyTotal(startTime, endTime, user.getUserId(), products, opptyFroms);
            ArrayList<OpportunityGrowthDataVo> vosTemp = new ArrayList<OpportunityGrowthDataVo>();
            for (Map map2 : dateMapList) {
                OpportunityGrowthDataVo voTemp = new OpportunityGrowthDataVo();
                int num = 0;
                for (OpportunityGrowthDataVo vo : list) {
                    if (vo.getCreateDate().isBefore((ChronoLocalDate)map2.get("startDate")) || vo.getCreateDate().isAfter((ChronoLocalDate)map2.get("endDate"))) continue;
                    num += vo.getOpportunityNumbers();
                }
                voTemp.setOpportunityNumbers(num);
                voTemp.setChartColName(MarketingEvaluationServiceImpl.getChartColNameByType(map2, opportunityGrowthTrendDemission));
                voTemp.setStartDate((LocalDate)map2.get("startDate"));
                voTemp.setEndDate((LocalDate)map2.get("endDate"));
                vosTemp.add(voTemp);
            }
            OpportunityGrowthTrendsVo growthTrendsVo = new OpportunityGrowthTrendsVo();
            growthTrendsVo.setOpportunityGrowthDataVos(vosTemp);
            trendsVoList.add(growthTrendsVo);
            if (opptyFroms.size() == 1 && "5".equals(opptyFroms.get(0))) {
                List<OpportunityGrowthDataVo> opportunityGrowthDataVos = this.marketingEvaluationMapper.opportunityGrowthTrendsByCampaign(startTime, endTime, user.getUserId(), products, opptyFroms);
                List opptyTrendsVoList = opportunityFroms.stream().map(f -> {
                    List collect = opportunityGrowthDataVos.stream().filter(s -> f.equals(s.getCampaignId())).collect(Collectors.toList());
                    ArrayList<OpportunityGrowthDataVo> vosTemp2 = new ArrayList<OpportunityGrowthDataVo>();
                    MarketingActivityEntity activity = (MarketingActivityEntity)this.marketingActivityMapper.selectById((Serializable)f);
                    String campaignName = "";
                    if (ToolUtil.isNotEmpty(collect)) {
                        campaignName = ((OpportunityGrowthDataVo)collect.get(0)).getCampaignName();
                    } else if (activity != null) {
                        campaignName = activity.getCampaignName();
                    }
                    String finalCampaignName = campaignName;
                    for (Map map : dateMapList) {
                        OpportunityGrowthDataVo voTemp = new OpportunityGrowthDataVo();
                        int num = 0;
                        for (OpportunityGrowthDataVo vo : collect) {
                            if (vo.getCreateDate().isBefore((ChronoLocalDate)map.get("startDate")) || vo.getCreateDate().isAfter((ChronoLocalDate)map.get("endDate"))) continue;
                            num += vo.getOpportunityNumbers();
                        }
                        voTemp.setCampaignId((Long)f);
                        voTemp.setCampaignName(finalCampaignName);
                        voTemp.setOpportunityNumbers(num);
                        voTemp.setChartColName(MarketingEvaluationServiceImpl.getChartColNameByType(map, opportunityGrowthTrendDemission));
                        voTemp.setStartDate((LocalDate)map.get("startDate"));
                        voTemp.setEndDate((LocalDate)map.get("endDate"));
                        vosTemp2.add(voTemp);
                    }
                    OpportunityGrowthTrendsVo opportunityGrowthTrendsVo = new OpportunityGrowthTrendsVo();
                    opportunityGrowthTrendsVo.setCampaignId((Long)f);
                    opportunityGrowthTrendsVo.setCampaignName(campaignName);
                    opportunityGrowthTrendsVo.setOpportunityGrowthDataVos(vosTemp2);
                    return opportunityGrowthTrendsVo;
                }).collect(Collectors.toList());
                trendsVoList.addAll(opptyTrendsVoList);
            }
        }
        return trendsVoList;
    }

    private static String getChartColNameByType(Map<String, LocalDate> dateMap, String type) {
        String chartColName = "";
        if ("2".equals(type)) {
            chartColName = dateMap.get("startDate").toString().replace("-", "") + "-" + dateMap.get("endDate").toString().replace("-", "");
        } else if ("3".equals(type)) {
            chartColName = dateMap.get("startDate").toString().substring(0, 7).replace("-", "");
        } else if ("4".equals(type)) {
            int quarterValue = (dateMap.get("startDate").getMonthValue() - 1) / 3 + 1;
            chartColName = quarterValue == 1 ? dateMap.get("startDate").toString().substring(0, 4) + "\u4e00\u5b63\u5ea6" : (quarterValue == 2 ? dateMap.get("startDate").toString().substring(0, 4) + "\u4e8c\u5b63\u5ea6" : (quarterValue == 3 ? dateMap.get("startDate").toString().substring(0, 4) + "\u4e09\u5b63\u5ea6" : dateMap.get("startDate").toString().substring(0, 4) + "\u56db\u5b63\u5ea6"));
        } else if ("5".equals(type)) {
            chartColName = dateMap.get("startDate").toString().substring(0, 4);
        }
        return chartColName;
    }

    private OpportunityAnalysisDto assemblyParameters(OpportunityAnalysisDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getTimeRange()) && !"3".equals(dto.getTimeRange())) {
            DateConvertVo currentTime = IndexUtil.getCurrentTime((String)dto.getTimeRange());
            dto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            dto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        return dto;
    }

    private SalesStatisticsDto opportunityOperate(MarketingActivityAnalysisDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        String opportunityView = dto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)opportunityView) && !"2".equals(opportunityView) && !"0".equals(opportunityView) && !"10".equals(opportunityView)) {
            if (dto.getCurrentUserId() != null) {
                IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties, (Long)dto.getCurrentUserId());
            } else {
                IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            }
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
                CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
                user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    private MarketingActivityAnalysisDto opportunityQueryCondition(MarketingActivityAnalysisDto dto) {
        DateConvertVo dateConvertVo;
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && !dto.getChargePersonIds().isEmpty()) {
            for (String userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && !departments.isEmpty()) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (idsTemp.isEmpty()) continue;
                odpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        dto.setDelFlag("0");
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getTimeRange()) && !"6".equals(dto.getTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTimeRange())) != null) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSuccessTimeRange()) && !"6".equals(dto.getSuccessTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange())) != null) {
            dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    private SalesStatisticsDto customerOperate(CustomerDto dto) {
        String customerView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(customerView = dto.getCustomerView())) && !"2".equals(customerView) && !"4".equals(customerView) && !"0".equals(customerView)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    private CustomerDto customerQueryCondition(CustomerDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        String customerView = dto.getCustomerView();
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getChargePersonIds()) && !dto.getChargePersonIds().isEmpty()) {
            for (Object userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getTeamMemberIds()) && !dto.getTeamMemberIds().isEmpty()) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List departments = dto.getOwnDepartments();
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)departments) && !departments.isEmpty()) {
            for (String odpId : departments) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.isEmpty()) continue;
                odpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(customerView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    @Override
    public List<CampaignAnalysisVo> getCampaignAnalysis(MarketingActivityAnalysisDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        this.createTimeFlag(dto);
        dto.setOpportunityView("0");
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        MarketingActivityAnalysisDto opportunityDto = this.opportunityQueryCondition(dto);
        CustomerDto custAbnormalInfoDto = new CustomerDto();
        custAbnormalInfoDto.setCustomerView("0");
        custAbnormalInfoDto.setCreateTimeFlag(dto.getCreateTimeFlag());
        SalesStatisticsDto custPermissionDto = this.customerOperate(custAbnormalInfoDto);
        CustomerDto customerDto = this.customerQueryCondition(custAbnormalInfoDto);
        String statisticsDimension = dto.getStatisticsDimension();
        List<Object> campaignAnalysisVoList = new ArrayList();
        if ("1".equals(statisticsDimension)) {
            campaignAnalysisVoList = this.marketingEvaluationMapper.getCampaignAnalysisByOpptyFrom(opportunityDto, permissionDto, customerDto, custPermissionDto);
            List opportunityFroms = this.sysDicRefService.getDicListByType("opportunity_from");
            ArrayList arrayList = new ArrayList();
            if (ToolUtil.isNotEmpty(campaignAnalysisVoList)) {
                List list = campaignAnalysisVoList.stream().map(CampaignAnalysisVo::getOpportunityFromValue).collect(Collectors.toList());
                for (DicVo vo : opportunityFroms) {
                    if (list.contains(vo.getValue())) continue;
                    CampaignAnalysisVo campaignAnalysisVoTemp = new CampaignAnalysisVo();
                    campaignAnalysisVoTemp.setOpportunityFromValue(vo.getValue());
                    campaignAnalysisVoTemp.setAllOppoTotal(0);
                    campaignAnalysisVoTemp.setCustTotal(0);
                    campaignAnalysisVoTemp.setWinCount(0);
                    campaignAnalysisVoTemp.setWinAmount(0.0);
                    campaignAnalysisVoTemp.setWinRate(0.0);
                    campaignAnalysisVoTemp.setLoseCount(0);
                    campaignAnalysisVoTemp.setLoseRate(0.0);
                    campaignAnalysisVoTemp.setAbandonCount(0);
                    campaignAnalysisVoTemp.setAbandonRate(0.0);
                    campaignAnalysisVoTemp.setCloseCount(0);
                    campaignAnalysisVoList.add(campaignAnalysisVoTemp);
                }
            }
        } else if ("2".equals(statisticsDimension)) {
            campaignAnalysisVoList = this.marketingEvaluationMapper.getCampaignAnalysisByCampaign(opportunityDto, permissionDto, customerDto, custPermissionDto);
        }
        for (CampaignAnalysisVo campaignAnalysisVo : campaignAnalysisVoList) {
            DecimalFormat df = new DecimalFormat("#.##");
            campaignAnalysisVo.setWinRate(Double.valueOf(df.format(campaignAnalysisVo.getWinRate() * 100.0)));
            campaignAnalysisVo.setLoseRate(Double.valueOf(df.format(campaignAnalysisVo.getLoseRate() * 100.0)));
            campaignAnalysisVo.setAbandonRate(Double.valueOf(df.format(campaignAnalysisVo.getAbandonRate() * 100.0)));
            if (!StringUtil.isNotBlank((CharSequence)campaignAnalysisVo.getOpportunityFromValue())) continue;
            campaignAnalysisVo.setOpopportunityFrom(this.sysDicRefService.getDictLabel("opportunity_from", campaignAnalysisVo.getOpportunityFromValue()));
        }
        return campaignAnalysisVoList;
    }

    @Override
    public void campaignAnalysisExport(HttpServletResponse response, MarketingActivityAnalysisDto dto) {
        String statisticsDimension = dto.getStatisticsDimension();
        List<CampaignAnalysisVo> campaignAnalysisVos = this.getCampaignAnalysis(dto);
        String[] titleStrings = "1".equals(statisticsDimension) ? new String[]{"\u5546\u673a\u6765\u6e90", "\u5546\u673a\u603b\u6570", "\u8d62\u5355\u5546\u673a\u6570", "\u8d62\u5355\u5546\u673a\u91d1\u989d", "\u8d62\u5355\u7387", "\u5e9f\u5f03\u5546\u673a\u6570", "\u5e9f\u5f03\u7387", "\u53ea\u8f6c\u5ba2\u6237\u6570", "\u8f93\u5355\u6570", "\u8f93\u5355\u7387"} : new String[]{"\u5e02\u573a\u6d3b\u52a8\u540d\u79f0", "\u5546\u673a\u603b\u6570", "\u5ba2\u6237\u603b\u6570", "\u8d62\u5355\u5546\u673a\u6570", "\u8d62\u5355\u5546\u673a\u91d1\u989d", "\u8d62\u5355\u7387", "\u5e9f\u5f03\u5546\u673a\u6570", "\u5e9f\u5f03\u7387", "\u53ea\u8f6c\u5ba2\u6237\u6570", "\u8f93\u5355\u6570", "\u8f93\u5355\u7387"};
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            String lastFileName = "1".equals(statisticsDimension) ? "\u5e02\u573a\u6d3b\u52a8\u5206\u6790.xlsx" : "\u5546\u673a\u6765\u6e90\u5206\u6790.xlsx";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            String sheetName = "Sheet1";
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
            Row dataRowTitle = sheet.createRow(0);
            for (int i = 0; i < titleStrings.length; ++i) {
                Cell titleCell = dataRowTitle.createCell(i);
                titleCell.setCellType(CellType.STRING);
                titleCell.setCellStyle(style);
                titleCell.setCellValue(titleStrings[i]);
            }
            if (campaignAnalysisVos != null && campaignAnalysisVos.size() > 0) {
                for (int index = 0; index < campaignAnalysisVos.size(); ++index) {
                    SXSSFRow dataRow = workbook.getSheet(sheetName).createRow(index + 1);
                    CampaignAnalysisVo cav = campaignAnalysisVos.get(index);
                    NumberFormat percentFormat = NumberFormat.getPercentInstance();
                    percentFormat.setMinimumFractionDigits(2);
                    String winRate = percentFormat.format(cav.getWinRate() / 100.0);
                    String loseRate = percentFormat.format(cav.getLoseRate() / 100.0);
                    String abandonRate = percentFormat.format(cav.getAbandonRate() / 100.0);
                    block29: for (int i = 0; i < titleStrings.length; ++i) {
                        Cell cell = dataRow.createCell(i);
                        if (i == 0) {
                            cell.setCellType(CellType.STRING);
                        } else {
                            cell.setCellType(CellType.NUMERIC);
                        }
                        cell.setCellStyle(style);
                        if ("1".equals(statisticsDimension)) {
                            switch (i) {
                                case 0: {
                                    cell.setCellValue(cav.getOpopportunityFrom());
                                    break;
                                }
                                case 1: {
                                    cell.setCellValue((double)cav.getAllOppoTotal());
                                    break;
                                }
                                case 2: {
                                    cell.setCellValue((double)cav.getWinCount());
                                    break;
                                }
                                case 3: {
                                    cell.setCellValue(cav.getWinAmount());
                                    break;
                                }
                                case 4: {
                                    cell.setCellValue(winRate);
                                    break;
                                }
                                case 5: {
                                    cell.setCellValue((double)cav.getAbandonCount());
                                    break;
                                }
                                case 6: {
                                    cell.setCellValue(abandonRate);
                                    break;
                                }
                                case 7: {
                                    cell.setCellValue((double)cav.getCloseCount());
                                    break;
                                }
                                case 8: {
                                    cell.setCellValue((double)cav.getLoseCount());
                                    break;
                                }
                                case 9: {
                                    cell.setCellValue(loseRate);
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (i) {
                            case 0: {
                                cell.setCellValue(cav.getCampaignName());
                                continue block29;
                            }
                            case 1: {
                                cell.setCellValue((double)cav.getAllOppoTotal());
                                continue block29;
                            }
                            case 2: {
                                cell.setCellValue((double)cav.getCustTotal());
                                continue block29;
                            }
                            case 3: {
                                cell.setCellValue((double)cav.getWinCount());
                                continue block29;
                            }
                            case 4: {
                                cell.setCellValue(cav.getWinAmount());
                                continue block29;
                            }
                            case 5: {
                                cell.setCellValue(winRate);
                                continue block29;
                            }
                            case 6: {
                                cell.setCellValue((double)cav.getAbandonCount());
                                continue block29;
                            }
                            case 7: {
                                cell.setCellValue(abandonRate);
                                continue block29;
                            }
                            case 8: {
                                cell.setCellValue((double)cav.getCloseCount());
                                continue block29;
                            }
                            case 9: {
                                cell.setCellValue((double)cav.getLoseCount());
                                continue block29;
                            }
                            case 10: {
                                cell.setCellValue(loseRate);
                                continue block29;
                            }
                        }
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Page<OpportunityEntity> selectCrmOpportunityList(MarketingActivityAnalysisDto dto) {
        dto.setDelFlag("0");
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (!CommonUtil.OPPO_VIEW_SALES_ANALYSIS.equals(dto.getOpportunityView()) && !"0".equals(dto.getOpportunityView())) {
            dto.setOpportunityView("1");
            permissionDto = this.opportunityOperate(dto);
        }
        MarketingActivityAnalysisDto queryDto = this.opportunityQueryCondition(dto);
        List overdueFollowStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageType, Arrays.asList("20", "21"))).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        dto.setOverdueFollowStageIds(overdueFollowStageIds);
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        Page page = dto.getPage();
        List<OpportunityEntity> list = this.marketingEvaluationMapper.selectCrmOpportunityList(page, dto.getCurrentUserId(), queryDto, permissionDto, sevenDaysLater, fifteenDaysLater, thirtyDaysLater);
        page.setRecords(list);
        return page;
    }

    @Override
    public Page<OpportunityEntity> selectCampaignAnalysisList(MarketingActivityAnalysisDto dto) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper = ToolUtil.isNotEmpty((Object)dto.getStageType()) ? (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getStageType, (Object)dto.getStageType())).eq(OpportunityStage::getDelFlag, (Object)"0") : (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getDelFlag, (Object)"0");
        List stageIds = this.opportunityStageService.listObjs((Wrapper)lambdaQueryWrapper, s -> Long.valueOf(s.toString()));
        if (CollectionUtil.isEmpty((Collection)stageIds)) {
            return null;
        }
        dto.setStageIds(stageIds);
        dto.setOpportunityView("0");
        return this.selectCrmOpportunityList(dto);
    }

    @Override
    public Page<OpportunityEntity> getOpportunityList(MarketingActivityAnalysisDto dto) {
        dto.setOpportunityView("0");
        return this.selectCrmOpportunityList(dto);
    }

    private void createTimeFlag(MarketingActivityAnalysisDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isNotBlank((CharSequence)dto.getCreateTimeFlag()) && !"3".equals(dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ApiResponse<OpportunityTrendVo> selectOpportunityTrend(OpportunityTrendDto dto) {
        void var18_54;
        int n;
        List departments = dto.getDeptIds().stream().map(String::valueOf).collect(Collectors.toList());
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty(departments) && !departments.isEmpty()) {
            for (String odpId : departments) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.isEmpty()) continue;
                odpIds.addAll(idsTemp);
            }
        }
        dto.setDeptIds(odpIds.stream().map(Long::parseLong).collect(Collectors.toList()));
        OpportunityTrendVo opportunityTrendVo = new OpportunityTrendVo();
        List<OpportunityTrendDateVo> dateVoList = this.getOpportunityTrendDateVoList(dto);
        dto.setDateStart(dateVoList.get(0).getStartTime());
        dto.setDateEnd(dateVoList.get(dateVoList.size() - 1).getFinalTime());
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        List<Object> otpvList = new ArrayList();
        List productEntityList = new ArrayList();
        List productCategoryEntityList = new ArrayList();
        List<Object> showProductIds = new ArrayList();
        HashMap<String, ArrayList<Long>> categoryMap = new HashMap<String, ArrayList<Long>>();
        ArrayList<String> showOpportunityFromIds = new ArrayList<String>();
        boolean notSelectProduct = false;
        Map<String, DicSingle> dicFromsMap = this.sysDicRefService.getDictByType("opportunity_from").stream().collect(Collectors.toMap(DicSingle::getValue, d -> d));
        if ("1".equals(dto.getOpportunityTrendDimension()) && CollectionUtil.isEmpty(dto.getCategoryIds()) && CollectionUtil.isEmpty(dto.getProducts())) {
            notSelectProduct = true;
            List productTypeAIds = this.productTypeAService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ProductTypeA::getProductId}).orderByAsc(ProductTypeA::getShowOrder), s -> Long.valueOf(s.toString()));
            List<ProductTreeVo> list = this.unifyPortalService.getProductTreeByProductIds(productTypeAIds, null);
            showProductIds = this.unifyPortalService.getProductListByTree(list, productTypeAIds);
            for (int i = 0; i < list.size(); ++i) {
                OpportunityTrendProductVo opportunityTrendProductVo = new OpportunityTrendProductVo();
                opportunityTrendProductVo.setId(String.valueOf(list.get(i).getId()));
                opportunityTrendProductVo.setName(list.get(i).getName());
                if ("1".equals(list.get(i).getTreeType())) {
                    opportunityTrendProductVo.setColumnCategory("1");
                } else {
                    opportunityTrendProductVo.setColumnCategory("2");
                }
                opportunityTrendProductVo.setOrderNum(i);
                otpvList.add(opportunityTrendProductVo);
            }
            OpportunityTrendProductVo otpvOther = new OpportunityTrendProductVo();
            otpvOther.setId("-1");
            otpvOther.setName("\u5176\u4ed6");
            otpvOther.setColumnCategory("0");
            otpvOther.setOrderNum(9999);
            otpvList.add(otpvOther);
        } else {
            Object otpv;
            if ("1".equals(dto.getOpportunityTrendDimension())) {
                if (CollectionUtil.isNotEmpty(dto.getCategoryIds())) {
                    categoryIds.addAll(dto.getCategoryIds());
                    productCategoryEntityList = this.productCategoryService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ProductCategory::getCategoryId, dto.getCategoryIds())).eq(ProductCategory::getDelFlag, (Object)"0"));
                }
                if (CollectionUtil.isNotEmpty(dto.getProducts())) {
                    productEntityList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Product::getProductId, dto.getProducts())).eq(Product::getDelFlag, (Object)"0"));
                }
                if (!productCategoryEntityList.isEmpty()) {
                    for (ProductCategory productCategory : productCategoryEntityList) {
                        otpv = new OpportunityTrendProductVo();
                        ((OpportunityTrendProductVo)otpv).setId(String.valueOf(productCategory.getCategoryId()));
                        ((OpportunityTrendProductVo)otpv).setName(productCategory.getCategoryName());
                        ((OpportunityTrendProductVo)otpv).setColumnCategory("1");
                        ((OpportunityTrendProductVo)otpv).setOrderNum(productCategory.getShowOrder());
                        otpvList.add(otpv);
                    }
                }
                if (!productEntityList.isEmpty()) {
                    for (Product product : productEntityList) {
                        otpv = new OpportunityTrendProductVo();
                        ((OpportunityTrendProductVo)otpv).setId(String.valueOf(product.getProductId()));
                        ((OpportunityTrendProductVo)otpv).setName(product.getShortName());
                        ((OpportunityTrendProductVo)otpv).setColumnCategory("2");
                        ((OpportunityTrendProductVo)otpv).setOrderNum(Integer.parseInt(product.getOrderNumber()));
                        otpvList.add(otpv);
                    }
                }
            } else if ("2".equals(dto.getOpportunityTrendDimension())) {
                if (CollectionUtil.isEmpty(dto.getOpportunityFroms())) {
                    dto.setOpportunityFroms(new ArrayList<String>(dicFromsMap.keySet()));
                    List<String> showFroms = Arrays.asList("5", "4", "6", "8", "10");
                    Iterator iterator = showFroms.iterator();
                    while (iterator.hasNext()) {
                        String of = (String)iterator.next();
                        OpportunityTrendProductVo opportunityTrendProductVo = new OpportunityTrendProductVo();
                        DicSingle ds = dicFromsMap.get(of);
                        opportunityTrendProductVo.setId(String.valueOf(Long.valueOf(ds.getValue())));
                        opportunityTrendProductVo.setName(ds.getLabel());
                        opportunityTrendProductVo.setColumnCategory("3");
                        opportunityTrendProductVo.setOrderNum(ds.getSort());
                        otpvList.add(opportunityTrendProductVo);
                    }
                    OpportunityTrendProductVo opportunityTrendProductVo = new OpportunityTrendProductVo();
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.addAll(dto.getOpportunityFroms());
                    ids.removeAll(showFroms);
                    opportunityTrendProductVo.setId(String.join((CharSequence)",", ids));
                    opportunityTrendProductVo.setName("\u5176\u4ed6");
                    opportunityTrendProductVo.setColumnCategory("0");
                    opportunityTrendProductVo.setOrderNum(9999);
                    otpvList.add(opportunityTrendProductVo);
                } else {
                    if (dto.getOpportunityFroms().contains("14")) {
                        dto.getOpportunityFroms().remove("14");
                        dto.getOpportunityFroms().add("14");
                    }
                    for (String string : dto.getOpportunityFroms()) {
                        otpv = new OpportunityTrendProductVo();
                        DicSingle dicSingle = dicFromsMap.get(string);
                        ((OpportunityTrendProductVo)otpv).setId(String.valueOf(Long.valueOf(dicSingle.getValue())));
                        ((OpportunityTrendProductVo)otpv).setName(dicSingle.getLabel());
                        ((OpportunityTrendProductVo)otpv).setColumnCategory("3");
                        ((OpportunityTrendProductVo)otpv).setOrderNum(dicSingle.getSort());
                        otpvList.add(otpv);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(categoryIds)) {
                List categoryList = this.productCategoryService.list((Wrapper)new LambdaQueryWrapper().eq(ProductCategory::getDelFlag, (Object)"0"));
                HashSet<Long> hashSet = new HashSet<Long>();
                for (Long l : categoryIds) {
                    ArrayList<Long> childCategoryIds = new ArrayList<Long>();
                    childCategoryIds.add(l);
                    this.getCategoryAllChildId(childCategoryIds, categoryList, l);
                    hashSet.addAll(childCategoryIds);
                    categoryMap.put(String.valueOf(l), childCategoryIds);
                }
                dto.setCategoryIds(new ArrayList<Long>(hashSet));
            }
        }
        otpvList = otpvList.stream().sorted(Comparator.comparing(OpportunityTrendProductVo::getOrderNum)).collect(Collectors.toList());
        if (otpvList.size() > 8) {
            Iterator<OpportunityTrendDateVo> otpvOther = new OpportunityTrendProductVo();
            ((OpportunityTrendProductVo)((Object)otpvOther)).setName("\u5176\u4ed6");
            ((OpportunityTrendProductVo)((Object)otpvOther)).setColumnCategory("0");
            ((OpportunityTrendProductVo)((Object)otpvOther)).setOrderNum(9999);
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = otpvList.size() - 1; i >= 7; --i) {
                if ("1".equals(((OpportunityTrendProductVo)otpvList.get(i)).getColumnCategory())) {
                    hashSet.addAll(((List)categoryMap.get(((OpportunityTrendProductVo)otpvList.get(i)).getId())).stream().map(String::valueOf).collect(Collectors.toList()));
                } else {
                    hashSet.add(((OpportunityTrendProductVo)otpvList.get(i)).getId());
                }
                otpvList.remove(i);
            }
            ((OpportunityTrendProductVo)((Object)otpvOther)).setId(String.join((CharSequence)",", hashSet));
            otpvList.add(otpvOther);
        }
        for (OpportunityTrendProductVo opportunityTrendProductVo : otpvList) {
            if (!opportunityTrendProductVo.getId().contains(",")) {
                showProductIds.add(Long.valueOf(opportunityTrendProductVo.getId()));
            }
            if (!dto.getOpportunityTrendDimension().equals("2") || opportunityTrendProductVo.getId().contains(",")) continue;
            showOpportunityFromIds.add(opportunityTrendProductVo.getId());
        }
        for (OpportunityTrendDateVo opportunityTrendDateVo : dateVoList) {
            List list = BeanUtil.copyToList(otpvList, OpportunityTrendProductVo.class);
            opportunityTrendDateVo.setOpportunityTrendProductVoList(list);
        }
        List<OpportunityTrendSearchVo> list = this.marketingEvaluationMapper.selectOpportunityTrend(dto);
        for (OpportunityTrendDateVo opportunityTrendDateVo : dateVoList) {
            for (OpportunityTrendProductVo opportunityTrendProductVo : opportunityTrendDateVo.getOpportunityTrendProductVoList()) {
                HashMap opportunityFromCountMap = new HashMap();
                HashSet<Long> opportunityIdSet = new HashSet<Long>();
                for (OpportunityTrendSearchVo opportunityTrendSearchVo : list) {
                    if (opportunityTrendDateVo.getStartTime().isAfter(opportunityTrendSearchVo.getCreateTime()) || opportunityTrendDateVo.getFinalTime().isBefore(opportunityTrendSearchVo.getCreateTime())) continue;
                    if (opportunityTrendProductVo.getColumnCategory().equals("2") && opportunityTrendProductVo.getId().equals(String.valueOf(opportunityTrendSearchVo.getProductId()))) {
                        opportunityIdSet.add(opportunityTrendSearchVo.getOpportunityId());
                        continue;
                    }
                    if (opportunityTrendProductVo.getColumnCategory().equals("1") && (opportunityTrendProductVo.getId().equals(String.valueOf(opportunityTrendSearchVo.getProductCategoryId())) || categoryMap.get(opportunityTrendProductVo.getId()) != null && ((List)categoryMap.get(opportunityTrendProductVo.getId())).contains(opportunityTrendSearchVo.getProductCategoryId()))) {
                        opportunityIdSet.add(opportunityTrendSearchVo.getOpportunityId());
                        continue;
                    }
                    if (opportunityTrendProductVo.getColumnCategory().equals("3") && opportunityTrendProductVo.getId().equals(opportunityTrendSearchVo.getOpportunityFrom())) {
                        opportunityIdSet.add(opportunityTrendSearchVo.getOpportunityId());
                        continue;
                    }
                    if (!opportunityTrendProductVo.getColumnCategory().equals("0")) continue;
                    if ("1".equals(dto.getOpportunityTrendDimension()) && !showProductIds.contains(opportunityTrendSearchVo.getProductCategoryId()) && !showProductIds.contains(opportunityTrendSearchVo.getProductId())) {
                        opportunityIdSet.add(opportunityTrendSearchVo.getOpportunityId());
                        continue;
                    }
                    if (!"2".equals(dto.getOpportunityTrendDimension()) || showOpportunityFromIds.contains(opportunityTrendSearchVo.getOpportunityFrom())) continue;
                    opportunityIdSet.add(opportunityTrendSearchVo.getOpportunityId());
                }
                opportunityTrendProductVo.setOpportunityCount(opportunityIdSet.size());
            }
        }
        boolean bl = false;
        int countNow = 0;
        Object var18_51 = null;
        String maxIdNow = null;
        String maxSourceNow = null;
        String nowType = null;
        int maxCountLast = 0;
        int countLast = 0;
        String maxNameLast = null;
        String maxIdLast = null;
        String maxSourceLast = null;
        String lastType = null;
        boolean otherCheckNow = false;
        boolean otherCheckLast = false;
        for (OpportunityTrendProductVo vo : dateVoList.get(dateVoList.size() - 1).getOpportunityTrendProductVoList()) {
            int n2;
            if (vo.getOpportunityCount() > n2) {
                if (!vo.getColumnCategory().equals("0")) {
                    n2 = vo.getOpportunityCount();
                    String string = vo.getName();
                    maxIdNow = vo.getId();
                    nowType = vo.getColumnCategory();
                } else {
                    otherCheckNow = true;
                }
            }
            countNow += vo.getOpportunityCount().intValue();
        }
        for (OpportunityTrendProductVo vo : dateVoList.get(dateVoList.size() - 2).getOpportunityTrendProductVoList()) {
            if (vo.getOpportunityCount() > maxCountLast) {
                if (!vo.getColumnCategory().equals("0")) {
                    maxCountLast = vo.getOpportunityCount();
                    maxNameLast = vo.getName();
                    maxIdLast = vo.getId();
                    lastType = vo.getColumnCategory();
                } else {
                    otherCheckLast = true;
                }
            }
            countLast += vo.getOpportunityCount().intValue();
        }
        if ("1".equals(dto.getOpportunityTrendDimension())) {
            Optional<String> mostFrequentColor;
            boolean changeFlag;
            Map<String, List<OpportunityTrendSearchVo>> map;
            LocalDate dateStartNow = dateVoList.get(dateVoList.size() - 1).getStartTime();
            LocalDate dateEndNow = dateVoList.get(dateVoList.size() - 1).getFinalTime();
            LocalDate dateStartLast = dateVoList.get(dateVoList.size() - 2).getStartTime();
            LocalDate dateEndLast = dateVoList.get(dateVoList.size() - 2).getFinalTime();
            if (otherCheckNow) {
                map = list.stream().filter(o -> (HussarUtils.isNotEmpty((Object)o.getProductId()) || HussarUtils.isNotEmpty((Object)o.getProductCategoryId())) && !dateStartNow.isAfter(o.getCreateTime()) && !dateEndNow.isBefore(o.getCreateTime())).collect(Collectors.groupingBy(o -> {
                    if (HussarUtils.isNotEmpty((Object)o.getProductId())) {
                        return String.valueOf(o.getProductId());
                    }
                    return String.valueOf(o.getProductCategoryId());
                }));
                changeFlag = false;
                for (Map.Entry<String, List<OpportunityTrendSearchVo>> entry : map.entrySet()) {
                    if (entry.getValue().size() <= n) continue;
                    n = entry.getValue().size();
                    maxIdNow = entry.getKey();
                    String string = entry.getValue().get(0).getProductName();
                    changeFlag = true;
                }
                if (changeFlag) {
                    mostFrequentColor = map.get(maxIdNow).stream().map(OpportunityTrendSearchVo::getOpportunityFrom).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
                    maxSourceNow = (String)mostFrequentColor.get();
                }
            }
            if (otherCheckLast) {
                map = list.stream().filter(o -> (HussarUtils.isNotEmpty((Object)o.getProductId()) || HussarUtils.isNotEmpty((Object)o.getProductCategoryId())) && !dateStartLast.isAfter(o.getCreateTime()) && !dateEndLast.isBefore(o.getCreateTime())).collect(Collectors.groupingBy(o -> {
                    if (HussarUtils.isNotEmpty((Object)o.getProductId())) {
                        return String.valueOf(o.getProductId());
                    }
                    return String.valueOf(o.getProductCategoryId());
                }));
                changeFlag = false;
                for (Map.Entry entry : map.entrySet()) {
                    if (((List)entry.getValue()).size() <= maxCountLast) continue;
                    maxCountLast = ((List)entry.getValue()).size();
                    maxIdLast = (String)entry.getKey();
                    maxNameLast = ((OpportunityTrendSearchVo)((List)entry.getValue()).get(0)).getProductName();
                    changeFlag = true;
                }
                if (changeFlag) {
                    mostFrequentColor = map.get(maxIdLast).stream().map(OpportunityTrendSearchVo::getOpportunityFrom).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
                    maxSourceLast = mostFrequentColor.get();
                }
            }
            HashMap<String, Integer> nowMap = new HashMap<String, Integer>();
            HashMap<String, Integer> lastMap = new HashMap<String, Integer>();
            for (OpportunityTrendSearchVo opportunityTrendSearchVo : list) {
                String opportunityFrom = opportunityTrendSearchVo.getOpportunityFrom();
                if (dateStartLast.isAfter(opportunityTrendSearchVo.getCreateTime()) || dateEndNow.isBefore(opportunityTrendSearchVo.getCreateTime())) continue;
                if (!dateStartNow.isAfter(opportunityTrendSearchVo.getCreateTime()) && !dateEndNow.isBefore(opportunityTrendSearchVo.getCreateTime())) {
                    if ("2".equals(nowType) && maxIdNow.equals(String.valueOf(opportunityTrendSearchVo.getProductId()))) {
                        nowMap.merge(opportunityFrom, 1, Integer::sum);
                    } else if ("1".equals(nowType) && (maxIdNow.equals(String.valueOf(opportunityTrendSearchVo.getProductCategoryId())) || categoryMap.get(maxIdNow) != null && ((List)categoryMap.get(maxIdNow)).contains(opportunityTrendSearchVo.getProductCategoryId()))) {
                        nowMap.merge(opportunityFrom, 1, Integer::sum);
                    } else if ("0".equals(nowType)) {
                        if ("1".equals(dto.getOpportunityTrendDimension()) && !showProductIds.contains(opportunityTrendSearchVo.getProductCategoryId()) && !showProductIds.contains(opportunityTrendSearchVo.getProductId())) {
                            nowMap.merge(opportunityFrom, 1, Integer::sum);
                        }
                        if ("2".equals(dto.getOpportunityTrendDimension()) && !showOpportunityFromIds.contains(opportunityTrendSearchVo.getOpportunityFrom())) {
                            nowMap.merge(opportunityFrom, 1, Integer::sum);
                        }
                    }
                }
                if (dateStartLast.isAfter(opportunityTrendSearchVo.getCreateTime()) || dateEndLast.isBefore(opportunityTrendSearchVo.getCreateTime())) continue;
                if ("2".equals(lastType) && maxIdLast.equals(String.valueOf(opportunityTrendSearchVo.getProductId()))) {
                    lastMap.merge(opportunityFrom, 1, Integer::sum);
                    continue;
                }
                if ("1".equals(lastType) && (maxIdLast.equals(String.valueOf(opportunityTrendSearchVo.getProductCategoryId())) || categoryMap.get(maxIdLast) != null && ((List)categoryMap.get(maxIdLast)).contains(opportunityTrendSearchVo.getProductCategoryId()))) {
                    lastMap.merge(opportunityFrom, 1, Integer::sum);
                    continue;
                }
                if (!"0".equals(lastType)) continue;
                if ("1".equals(dto.getOpportunityTrendDimension()) && !showProductIds.contains(opportunityTrendSearchVo.getProductCategoryId()) && !showProductIds.contains(opportunityTrendSearchVo.getProductId())) {
                    lastMap.merge(opportunityFrom, 1, Integer::sum);
                }
                if (!"2".equals(dto.getOpportunityTrendDimension()) || showOpportunityFromIds.contains(opportunityTrendSearchVo.getOpportunityFrom())) continue;
                lastMap.merge(opportunityFrom, 1, Integer::sum);
            }
            int maxValue = Integer.MIN_VALUE;
            for (Map.Entry entry : nowMap.entrySet()) {
                if ((Integer)entry.getValue() <= maxValue) continue;
                maxValue = (Integer)entry.getValue();
                maxSourceNow = (String)entry.getKey();
            }
            if (maxSourceNow != null) {
                opportunityTrendVo.setOpportunityFrom(dicFromsMap.get(maxSourceNow).getLabel());
            }
            maxValue = Integer.MIN_VALUE;
            for (Map.Entry entry : lastMap.entrySet()) {
                if ((Integer)entry.getValue() <= maxValue) continue;
                maxValue = (Integer)entry.getValue();
                maxSourceLast = (String)entry.getKey();
            }
            if (maxSourceLast != null) {
                opportunityTrendVo.setLastOpportunityFrom(dicFromsMap.get(maxSourceLast).getLabel());
            }
        }
        opportunityTrendVo.setLastOpportunityCount(countLast);
        opportunityTrendVo.setLastMaxOpportunityCount(maxCountLast);
        opportunityTrendVo.setLastMaxName(maxNameLast);
        opportunityTrendVo.setMaxName((String)var18_54);
        opportunityTrendVo.setMaxOpportunityCount(n);
        opportunityTrendVo.setOpportunityCount(countNow);
        if (countNow != 0) {
            opportunityTrendVo.setProportion(String.format("%.2f", (double)n * 100.0 / (double)countNow) + "%");
        }
        if (countLast != 0) {
            opportunityTrendVo.setLastProportion(String.format("%.2f", (double)maxCountLast * 100.0 / (double)countLast) + "%");
        }
        opportunityTrendVo.setOpportunityTrendDateVoList(dateVoList);
        return ApiResponse.success((Object)opportunityTrendVo);
    }

    @Override
    public String selectOpportunityTrendExport(HttpServletResponse response, OpportunityTrendDto dto) {
        try {
            XSSFCell cell;
            XSSFRow row;
            List<OpportunityTrendDateVo> list = ((OpportunityTrendVo)this.selectOpportunityTrend(dto).getData()).getOpportunityTrendDateVoList();
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet("\u5e02\u573a\u6d3b\u52a8");
            XSSFCellStyle style = MarketingEvaluationServiceImpl.createCellStyle(wb);
            int rowNum = 0;
            XSSFRow row0 = sheet.createRow(rowNum++);
            row0.setHeight((short)600);
            ArrayList<String> header1 = new ArrayList<String>(Collections.singletonList("\u65e5\u671f/\u5546\u673a\u6570"));
            for (OpportunityTrendDateVo vo : list) {
                header1.add(vo.getColumnName());
            }
            for (int i = 0; i < header1.size(); ++i) {
                XSSFCell c00 = row0.createCell(i);
                c00.setCellValue((String)header1.get(i));
                c00.setCellStyle((CellStyle)style);
                int maxColumnWidth = 1280;
                for (int j = 0; j <= sheet.getLastRowNum(); ++j) {
                    int cellWidth;
                    row = sheet.getRow(j);
                    if (row == null || (cell = row.getCell(i)) == null || (cellWidth = cell.toString().getBytes("GBK").length * 256) <= maxColumnWidth) continue;
                    maxColumnWidth = cellWidth;
                }
                sheet.setColumnWidth(i, maxColumnWidth);
            }
            ArrayList<XSSFRow> rowList = new ArrayList<XSSFRow>();
            for (OpportunityTrendProductVo vo : list.get(0).getOpportunityTrendProductVoList()) {
                XSSFRow row2 = sheet.createRow(rowNum++);
                XSSFCell cell2 = row2.createCell(0);
                cell2.setCellValue(vo.getName());
                rowList.add(row2);
            }
            for (int i = 0; i < list.size(); ++i) {
                List<OpportunityTrendProductVo> productList = list.get(i).getOpportunityTrendProductVoList();
                for (int j = 0; j < productList.size(); ++j) {
                    row = (XSSFRow)rowList.get(j);
                    cell = row.createCell(1 + i);
                    cell.setCellValue((double)productList.get(j).getOpportunityCount().intValue());
                    cell.setCellStyle((CellStyle)style);
                }
            }
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode("\u5546\u673a\u8d8b\u52bf\u5206\u6790.xlsx", "UTF-8"));
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            return "\u5bfc\u51fa\u6210\u529f";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ApiResponse<Page<OpportunityVo>> selectOpportunityTrendList(OpportunityTrendDto dto) {
        List<Long> categoryIds;
        List departments = dto.getDeptIds().stream().map(String::valueOf).collect(Collectors.toList());
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty(departments) && !departments.isEmpty()) {
            for (String odpId : departments) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.isEmpty()) continue;
                odpIds.addAll(idsTemp);
            }
        }
        dto.setDeptIds(odpIds.stream().map(Long::parseLong).collect(Collectors.toList()));
        if ("1".equals(dto.getIdExclude()) && dto.getOpportunityTrendDimension().equals("1")) {
            List productTypeAIds = this.productTypeAService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{ProductTypeA::getProductId}).orderByAsc(ProductTypeA::getShowOrder), s -> Long.valueOf(s.toString()));
            List<ProductTreeVo> productTreeVoList = this.unifyPortalService.getProductTreeByProductIds(productTypeAIds, null);
            List<Long> showProductIds = this.unifyPortalService.getProductListByTree(productTreeVoList, productTypeAIds);
            for (ProductTreeVo productTreeVo : productTreeVoList) {
                showProductIds.add(productTreeVo.getId());
            }
            dto.setSearchOtherIds(new ArrayList<Long>(new HashSet<Long>(showProductIds)));
        }
        if ("1".equals(dto.getIdExclude()) && dto.getOpportunityTrendDimension().equals("2")) {
            dto.setExceptOpportunityFroms(Arrays.asList("5", "4", "6", "8", "10"));
        }
        if (HussarUtils.isEmpty(dto.getSearchOtherIds()) && CollectionUtil.isNotEmpty(categoryIds = dto.getCategoryIds())) {
            List categoryList = this.productCategoryService.list((Wrapper)new LambdaQueryWrapper().eq(ProductCategory::getDelFlag, (Object)"0"));
            HashSet<Long> searchCategoryIdSet = new HashSet<Long>();
            for (Long categoryId : categoryIds) {
                ArrayList<Long> childCategoryIds = new ArrayList<Long>();
                childCategoryIds.add(categoryId);
                this.getCategoryAllChildId(childCategoryIds, categoryList, categoryId);
                searchCategoryIdSet.addAll(childCategoryIds);
            }
            dto.setCategoryIds(new ArrayList<Long>(searchCategoryIdSet));
        }
        Page page = dto.getPage();
        dto.setSearchKey(dto.getSearchKey().replaceAll("%", "/%").replaceAll("_", "/_"));
        List<OpportunityVo> list = this.marketingEvaluationMapper.selectOpportunityTrendList(page, dto);
        page.setRecords(list);
        return ApiResponse.success((Object)page);
    }

    private static XSSFCellStyle createCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setFontHeightInPoints((short)10);
        font.setFontName("\u65b9\u6b63\u5c0f\u6807\u5b8b\u7b80\u4f53");
        XSSFCellStyle style = wb.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor((short)0);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor((short)0);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor((short)0);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor((short)0);
        style.setFont((Font)font);
        style.setWrapText(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    private List<OpportunityTrendDateVo> getOpportunityTrendDateVoList(OpportunityTrendDto dto) {
        ArrayList<OpportunityTrendDateVo> list = new ArrayList<OpportunityTrendDateVo>();
        LocalDate dateNow = LocalDate.now();
        ArrayList mapList = new ArrayList();
        switch (dto.getDateCondition()) {
            case "1": {
                List days = CrmDateUtils.getNearlyTenDays();
                for (LocalDate day : days) {
                    OpportunityTrendDateVo vo = new OpportunityTrendDateVo();
                    vo.setStartTime(day);
                    vo.setFinalTime(day);
                    vo.setColumnName(day.toString());
                    list.add(vo);
                }
                break;
            }
            case "2": {
                CrmDateUtils.getNearlyWeeks(mapList, (LocalDate)dateNow, (int)6);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                for (Map map : mapList) {
                    OpportunityTrendDateVo vo = new OpportunityTrendDateVo();
                    vo.setStartTime((LocalDate)map.get("startDate"));
                    vo.setFinalTime((LocalDate)map.get("endDate"));
                    vo.setColumnName(((LocalDate)map.get("startDate")).format(dateTimeFormatter) + "-" + ((LocalDate)map.get("endDate")).format(dateTimeFormatter));
                    list.add(vo);
                }
                break;
            }
            case "3": {
                CrmDateUtils.getNearlyMonths(mapList, (LocalDate)dateNow, (LocalDate)dateNow, (int)6);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMM");
                for (Map map : mapList) {
                    OpportunityTrendDateVo vo = new OpportunityTrendDateVo();
                    vo.setStartTime((LocalDate)map.get("startDate"));
                    vo.setFinalTime((LocalDate)map.get("endDate"));
                    vo.setColumnName(((LocalDate)map.get("startDate")).format(dateTimeFormatter));
                    list.add(vo);
                }
                break;
            }
            case "4": {
                CrmDateUtils.getNearlyQuarters(mapList, (LocalDate)dateNow, (LocalDate)dateNow, (int)4);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy");
                for (Map map : mapList) {
                    OpportunityTrendDateVo vo = new OpportunityTrendDateVo();
                    vo.setStartTime((LocalDate)map.get("startDate"));
                    vo.setFinalTime((LocalDate)map.get("endDate"));
                    String name = ((LocalDate)map.get("startDate")).format(dateTimeFormatter);
                    switch ((((LocalDate)map.get("startDate")).getMonthValue() + 2) / 3) {
                        case 1: {
                            name = name + "\u4e00\u5b63\u5ea6";
                            break;
                        }
                        case 2: {
                            name = name + "\u4e8c\u5b63\u5ea6";
                            break;
                        }
                        case 3: {
                            name = name + "\u4e09\u5b63\u5ea6";
                            break;
                        }
                        case 4: {
                            name = name + "\u56db\u5b63\u5ea6";
                        }
                    }
                    vo.setColumnName(name);
                    list.add(vo);
                }
                break;
            }
            case "5": {
                CrmDateUtils.getNearlyYears(mapList, (LocalDate)dateNow, (LocalDate)dateNow, (int)5);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy");
                for (Map map : mapList) {
                    OpportunityTrendDateVo vo = new OpportunityTrendDateVo();
                    vo.setStartTime((LocalDate)map.get("startDate"));
                    vo.setFinalTime((LocalDate)map.get("endDate"));
                    vo.setColumnName(((LocalDate)map.get("startDate")).format(dateTimeFormatter));
                    list.add(vo);
                }
                break;
            }
        }
        list.sort(Comparator.comparing(OpportunityTrendDateVo::getStartTime));
        return list;
    }

    private void getCategoryAllChildId(List<Long> childCategoryIds, List<ProductCategory> categoryList, Long categoryId) {
        for (ProductCategory pc : categoryList) {
            if (!Objects.equals(pc.getParentId(), categoryId)) continue;
            childCategoryIds.add(pc.getCategoryId());
            this.getCategoryAllChildId(childCategoryIds, categoryList, pc.getCategoryId());
        }
    }
}

