/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.common.CommonUtil;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.SalespersonAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalePersonAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonAnalysisContactDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonBehaviorDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonRankingDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.CrmSalesPersonDiligent;
import com.jxdinfo.crm.analysis.intelligentanalysis.model.SalesmanScoreEntity;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.CrmSalesPersonDiligentService;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.ISalesmanScoreService;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.SalespersonAnalysisService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalesPersonLatestDynamicVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalesPersonPortraitPieVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonAnalysisPopUpCusVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonAnalysisPopUpOppVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonAnalysisPopUpProVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonAnalysisPopUpRecVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonBehaviorVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonComprehensiveAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonPortraitRankVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonRankingVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.dataRightManage.vo.UserDepartmentVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.crm.sy.crmrecord1.service.CrmRecord1Service;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.intelligentanalysis.vo.ChargePersonVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.ExcelStyle;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class SalespersonAnalysisServiceImpl
implements SalespersonAnalysisService {
    @Resource
    private CrmRecord1Service crmRecord1Service;
    @Resource
    private CommonUtil commonUtil;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private SalespersonAnalysisMapper salespersonAnalysisMapper;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private CrmSalesPersonDiligentService crmSalesPersonDiligentService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private ILabelService labelApiService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISalesmanScoreService salesmanScoreService;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IDataRightBoService commonDataRightService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public List<SalespersonComprehensiveAnalysisVo> comprehensiveAnalysis(SalePersonAnalysisDto dto) {
        String[] sortStrings;
        List<Long> deptIds;
        String configValue;
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setCurrentUserId(user.getUserId());
        ArrayList userDepartmentVoList = new ArrayList();
        if (user.getRolesList().contains(Long.parseLong(this.crmProperties.getRoles().getAllOpportunity()))) {
            dto.setPermissionUserIds(this.dataRightBoService.getAllSalesUserList(null, userDepartmentVoList));
        } else {
            dto.setPermissionUserIds(this.dataRightBoService.getSalesUserList(null, userDepartmentVoList));
        }
        List<Long> permissionUserIds = dto.getPermissionUserIds();
        CrmBaseConfigVo baseConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("salesperson_com_ana_pro");
        if (ToolUtil.isNotEmpty((Object)baseConfig) && "0".equals(configValue = baseConfig.getConfigValue())) {
            Long salesGM = Long.parseLong(this.crmProperties.getRoles().getSalesGM());
            List<Long> salesGMUserIds = this.userRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)salesGM)).stream().map(SysUserRole::getUserId).collect(Collectors.toList());
            dto.setSalesGMUserIds(salesGMUserIds);
            permissionUserIds.removeAll(salesGMUserIds);
        }
        this.clearDateTime(dto);
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeFlag());
        if (ToolUtil.isNotEmpty((Object)dateConvertVo)) {
            dto.setStartTime(dateConvertVo.getStartDate());
            dto.setFinalTime(dateConvertVo.getEndDate());
        }
        dto.setEndTime(dto.getCreateTimeFlag());
        dto.setStartDate(dto.getStartTime());
        dto.setEndDate(dto.getFinalTime());
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo2 = CrmDateUtils.getCurrentTime((String)dto.getEndTime());
        if (ToolUtil.isNotEmpty((Object)dateConvertVo2)) {
            dto.setStartDate(dateConvertVo2.getStartDate());
            dto.setEndDate(dateConvertVo2.getEndDate());
        }
        List<Long> userIds = dto.getUserIds();
        ArrayList<Long> inputUserIds = new ArrayList<Long>(dto.getUserIds());
        if (ToolUtil.isEmpty(userIds)) {
            userIds = new ArrayList<Long>();
        }
        if (ToolUtil.isNotEmpty(deptIds = dto.getDeptIds())) {
            List deptUserList = this.organUserBoService.getUserListByDepartmentId(deptIds);
            List deptUserIds = deptUserList.stream().map(UserVo::getId).collect(Collectors.toList());
            userIds.addAll(deptUserIds);
        }
        dto.setUserIds(userIds);
        dto.getUserIds().retainAll(permissionUserIds);
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        dto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIdList = new ArrayList<Long>();
        stageIdList.addAll(winStageList);
        stageIdList.addAll(tqkgList);
        dto.setStageIdList(stageIdList);
        HashSet set = new HashSet();
        List<SalespersonComprehensiveAnalysisVo> list1 = this.salespersonAnalysisMapper.getSalespersonComprehensiveOne(dto);
        set.addAll(list1.stream().map(SalespersonComprehensiveAnalysisVo::getChargePersonId).collect(Collectors.toSet()));
        List<SalespersonComprehensiveAnalysisVo> list2 = this.salespersonAnalysisMapper.getSalespersonComprehensiveTwo(dto);
        set.addAll(list2.stream().map(SalespersonComprehensiveAnalysisVo::getChargePersonId).collect(Collectors.toSet()));
        List<SalespersonComprehensiveAnalysisVo> list3 = this.salespersonAnalysisMapper.getSalespersonComprehensiveThree(dto);
        set.addAll(list3.stream().map(SalespersonComprehensiveAnalysisVo::getChargePersonId).collect(Collectors.toSet()));
        List<SalespersonComprehensiveAnalysisVo> list4 = this.salespersonAnalysisMapper.getSalespersonComprehensiveFour(dto);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (SalespersonComprehensiveAnalysisVo vo : list4) {
            if (map.containsKey(vo.getChargePersonId())) {
                map.put(vo.getChargePersonId(), (Integer)map.get(vo.getChargePersonId()) + 1);
                continue;
            }
            map.put(vo.getChargePersonId(), 1);
        }
        for (int i = 0; i < list4.size(); ++i) {
            SalespersonComprehensiveAnalysisVo vo;
            vo = list4.get(i);
            Long chargePersonId = vo.getChargePersonId();
            if ((Integer)map.get(chargePersonId) <= 1) continue;
            list4.remove(i);
            list4.stream().filter(f -> f.getChargePersonId().equals(chargePersonId)).forEach(o -> o.setMaxProductName("-"));
        }
        set.addAll(list4.stream().map(SalespersonComprehensiveAnalysisVo::getChargePersonId).collect(Collectors.toSet()));
        List<Object> returnUserList = new ArrayList();
        if (ToolUtil.isNotEmpty(dto.getUserIds())) {
            returnUserList = this.salespersonAnalysisMapper.selectChargePersonList(dto.getUserIds());
        } else if (ToolUtil.isEmpty(deptIds) && ToolUtil.isEmpty(inputUserIds)) {
            returnUserList = this.salespersonAnalysisMapper.selectChargePersonList(permissionUserIds);
        } else {
            return new ArrayList<SalespersonComprehensiveAnalysisVo>();
        }
        List<SalespersonComprehensiveAnalysisVo> returnList = new ArrayList<SalespersonComprehensiveAnalysisVo>();
        if (CollectionUtil.isEmpty(returnUserList)) {
            return new ArrayList<SalespersonComprehensiveAnalysisVo>();
        }
        SalespersonComprehensiveAnalysisVo totalVo = this.initAnalysisVo((ChargePersonVo)returnUserList.get(0));
        HashSet<Long> proIds = new HashSet<Long>();
        for (ChargePersonVo chargePersonVo : returnUserList) {
            SalespersonComprehensiveAnalysisVo vo;
            int i;
            SalespersonComprehensiveAnalysisVo ana = this.initAnalysisVo(chargePersonVo);
            proIds.add(ana.getDeptId());
            for (i = 0; i < list1.size(); ++i) {
                vo = list1.get(i);
                if (!ana.getChargePersonId().equals(vo.getChargePersonId())) continue;
                ana.setCustTotal(vo.getCustTotal());
                ana.setContTotal(vo.getContTotal());
                ana.setOppoTotal(vo.getOppoTotal());
                totalVo.setCustTotal(totalVo.getCustTotal() + vo.getCustTotal());
                totalVo.setContTotal(totalVo.getContTotal() + vo.getContTotal());
                totalVo.setOppoTotal(totalVo.getOppoTotal() + vo.getOppoTotal());
                list1.remove(i);
                break;
            }
            for (i = 0; i < list2.size(); ++i) {
                vo = list2.get(i);
                if (!ana.getChargePersonId().equals(vo.getChargePersonId())) continue;
                ana.setWaitFollow(vo.getWaitFollow());
                ana.setFollowing(vo.getFollowing());
                totalVo.setWaitFollow(totalVo.getWaitFollow() + vo.getWaitFollow());
                totalVo.setFollowing(totalVo.getFollowing() + vo.getFollowing());
                list2.remove(i);
                break;
            }
            for (i = 0; i < list3.size(); ++i) {
                vo = list3.get(i);
                if (!ana.getChargePersonId().equals(vo.getChargePersonId())) continue;
                ana.setWinCount(vo.getWinCount());
                ana.setWinAmount(vo.getWinAmount());
                ana.setMaxAmount(vo.getMaxAmount());
                ana.setMinAmount(vo.getMinAmount());
                ana.setAvgAmount(vo.getAvgAmount());
                ana.setProductCount(vo.getProductCount());
                totalVo.setWinCount(totalVo.getWinCount() + vo.getWinCount());
                totalVo.setWinAmount(totalVo.getWinAmount() + vo.getWinAmount());
                totalVo.setMaxAmount(totalVo.getMaxAmount() + vo.getMaxAmount());
                totalVo.setMinAmount(totalVo.getMinAmount() + vo.getMinAmount());
                totalVo.setAvgAmount(totalVo.getAvgAmount() + vo.getAvgAmount());
                totalVo.setProductCount(totalVo.getProductCount() + vo.getProductCount());
                list3.remove(i);
                break;
            }
            for (i = 0; i < list4.size(); ++i) {
                vo = list4.get(i);
                if (!ana.getChargePersonId().equals(vo.getChargePersonId())) continue;
                ana.setMaxProductId(vo.getMaxProductId());
                ana.setMaxProductName(vo.getMaxProductName());
                ana.setMaxProductCount(vo.getMaxProductCount());
                totalVo.setMaxProductCount(totalVo.getMaxProductCount() + vo.getMaxProductCount());
                list4.remove(i);
                break;
            }
            returnList.add(ana);
        }
        totalVo.setChargePersonId(null);
        totalVo.setChargePersonName("\u5408\u8ba1" + returnList.size() + "\u4eba");
        totalVo.setDeptId(null);
        totalVo.setDeptName(proIds.size() + "\u4e2a\u90e8\u95e8");
        totalVo.setShortName(proIds.size() + "\u4e2a\u90e8\u95e8");
        if (ToolUtil.isEmpty((Object)dto.getSortString())) {
            List<SalespersonVo> salespersonVoList;
            List<Long> userIdList = returnList.stream().map(SalespersonComprehensiveAnalysisVo::getChargePersonId).collect(Collectors.toList());
            Map<Long, SalespersonComprehensiveAnalysisVo> map2 = returnList.stream().collect(Collectors.toMap(SalespersonComprehensiveAnalysisVo::getChargePersonId, salespersonComprehensiveAnalysisVo -> salespersonComprehensiveAnalysisVo));
            if (CollectionUtil.isNotEmpty(userIdList) && CollectionUtil.isNotEmpty(salespersonVoList = this.salespersonAnalysisMapper.selectUserList(userIdList))) {
                for (SalespersonVo tempBehaviorVo : salespersonVoList) {
                    Long userId = tempBehaviorVo.getUserId();
                    SalespersonComprehensiveAnalysisVo comprehensiveAnalysisVo = map2.get(userId);
                    if (comprehensiveAnalysisVo == null) continue;
                    comprehensiveAnalysisVo.setStaffPosition(tempBehaviorVo.getStaffPosition() == null ? "461" : tempBehaviorVo.getStaffPosition());
                    comprehensiveAnalysisVo.setUserOrder(tempBehaviorVo.getUserOrder() == null ? 100000 : tempBehaviorVo.getUserOrder());
                    comprehensiveAnalysisVo.setStruOrder(tempBehaviorVo.getStruOrder() == null ? 100000 : tempBehaviorVo.getStruOrder());
                }
            }
            returnList = returnList.stream().sorted(Comparator.comparing(SalespersonVo::getStruOrder).thenComparing(SalespersonComprehensiveAnalysisVo::getDeptId).thenComparing(SalespersonVo::getStaffPosition).thenComparingInt(SalespersonVo::getUserOrder)).collect(Collectors.toList());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSortString()) && (sortStrings = dto.getSortString().split(",")).length == 2) {
            String string = sortStrings[0];
            String sortSc = sortStrings[1];
            switch (string) {
                case "1": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getCustTotal)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getCustTotal).reversed()).collect(Collectors.toList());
                    break;
                }
                case "2": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getContTotal)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getContTotal).reversed()).collect(Collectors.toList());
                    break;
                }
                case "3": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getOppoTotal)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getOppoTotal).reversed()).collect(Collectors.toList());
                    break;
                }
                case "4": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWaitFollow)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWaitFollow).reversed()).collect(Collectors.toList());
                    break;
                }
                case "5": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getFollowing)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getFollowing).reversed()).collect(Collectors.toList());
                    break;
                }
                case "6": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWinCount)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWinCount).reversed()).collect(Collectors.toList());
                    break;
                }
                case "7": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWinAmount)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWinAmount).reversed()).collect(Collectors.toList());
                    break;
                }
                case "8": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getMaxAmount)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getMaxAmount).reversed()).collect(Collectors.toList());
                    break;
                }
                case "9": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getMinAmount)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getMinAmount).reversed()).collect(Collectors.toList());
                    break;
                }
                case "10": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getAvgAmount)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getAvgAmount).reversed()).collect(Collectors.toList());
                    break;
                }
                case "11": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getProductCount)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getProductCount).reversed()).collect(Collectors.toList());
                    break;
                }
                case "12": {
                    if ("0".equals(sortSc)) {
                        returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getDeptId)).collect(Collectors.toList());
                        break;
                    }
                    returnList = returnList.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getDeptId).reversed()).collect(Collectors.toList());
                    break;
                }
            }
        }
        returnList.add(totalVo);
        return returnList;
    }

    @Override
    public void comprehensiveAnalysisExport(HttpServletResponse response, SalePersonAnalysisDto dto) {
        List<SalespersonComprehensiveAnalysisVo> returnList = this.comprehensiveAnalysis(dto);
        String[] titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u5ba2\u6237\u603b\u6570", "\u8054\u7cfb\u4eba\u603b\u6570", "\u5546\u673a\u603b\u6570", "\u5f85\u8ddf\u8fdb\u5546\u673a", "\u8ddf\u8fdb\u4e2d\u5546\u673a", "\u6210\u4ea4\u5546\u673a\u6570", "\u6210\u4ea4\u5546\u673a\u91d1\u989d", "\u6700\u5927\u6210\u4ea4\u989d", "\u6700\u4f4e\u6210\u4ea4\u989d", "\u5e73\u5747\u6210\u4ea4\u989d", "\u4ea7\u54c1\u9500\u91cf", "\u9500\u91cf\u6700\u9ad8\u4ea7\u54c1"};
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            String lastFileName = "\u9500\u552e\u4eba\u5458\u7efc\u5408\u5206\u6790.xlsx";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            String sheetName = "Sheet1";
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
            Row dataRowTitle = sheet.createRow(0);
            for (int i = 0; i < titleStrings.length; ++i) {
                Cell titleCell = dataRowTitle.createCell(i);
                titleCell.setCellType(CellType.STRING);
                titleCell.setCellStyle(style);
                titleCell.setCellValue(titleStrings[i]);
            }
            if (returnList != null && returnList.size() > 0) {
                for (int index = 0; index < returnList.size(); ++index) {
                    SXSSFRow dataRow = workbook.getSheet(sheetName).createRow(index + 1);
                    SalespersonComprehensiveAnalysisVo cav = returnList.get(index);
                    block20: for (int i = 0; i < titleStrings.length; ++i) {
                        Cell cell = dataRow.createCell(i);
                        if (i == 0 || i == 1 || i == 13) {
                            cell.setCellType(CellType.STRING);
                        } else {
                            cell.setCellType(CellType.NUMERIC);
                        }
                        cell.setCellStyle(style);
                        switch (i) {
                            case 0: {
                                cell.setCellValue(cav.getChargePersonName());
                                continue block20;
                            }
                            case 1: {
                                cell.setCellValue(cav.getDeptName());
                                continue block20;
                            }
                            case 2: {
                                cell.setCellValue((double)cav.getCustTotal());
                                continue block20;
                            }
                            case 3: {
                                cell.setCellValue((double)cav.getContTotal());
                                continue block20;
                            }
                            case 4: {
                                cell.setCellValue((double)cav.getOppoTotal());
                                continue block20;
                            }
                            case 5: {
                                cell.setCellValue((double)cav.getWaitFollow());
                                continue block20;
                            }
                            case 6: {
                                cell.setCellValue((double)cav.getFollowing());
                                continue block20;
                            }
                            case 7: {
                                cell.setCellValue((double)cav.getWinCount());
                                continue block20;
                            }
                            case 8: {
                                cell.setCellValue(cav.getWinAmount());
                                continue block20;
                            }
                            case 9: {
                                cell.setCellValue(cav.getMaxAmount());
                                continue block20;
                            }
                            case 10: {
                                cell.setCellValue(cav.getMinAmount());
                                continue block20;
                            }
                            case 11: {
                                cell.setCellValue(cav.getAvgAmount());
                                continue block20;
                            }
                            case 12: {
                                cell.setCellValue((double)cav.getProductCount());
                                continue block20;
                            }
                            case 13: {
                                cell.setCellValue(cav.getMaxProductName());
                                continue block20;
                            }
                        }
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SalespersonComprehensiveAnalysisVo getSalesBasicInfo(SalePersonAnalysisDto dto) {
        SalesmanScoreEntity salesmanScoreEntity;
        CrmSalesPersonDiligent diligent;
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        List<ChargePersonVo> salePersonList = this.salespersonAnalysisMapper.selectChargePersonList(Arrays.asList(salePersonId));
        if (salePersonList.size() == 0) {
            return null;
        }
        ChargePersonVo salePerson = salePersonList.get(0);
        SalespersonComprehensiveAnalysisVo returnVo = this.initAnalysisVo(salePerson);
        dto.setEndTime(null);
        dto.setStartDate(null);
        dto.setEndDate(null);
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        dto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIdList = new ArrayList<Long>();
        stageIdList.addAll(winStageList);
        stageIdList.addAll(tqkgList);
        dto.setStageIdList(stageIdList);
        List<SalespersonComprehensiveAnalysisVo> list4 = this.salespersonAnalysisMapper.getSalespersonComprehensiveFour(dto);
        if (list4.size() == 1) {
            SalespersonComprehensiveAnalysisVo vo = list4.get(0);
            returnVo.setMaxProductId(vo.getMaxProductId());
            returnVo.setMaxProductName(vo.getMaxProductName());
            returnVo.setMaxProductCount(vo.getMaxProductCount());
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        dto.setPieType("track");
        List<Map<String, Object>> trackList = this.salespersonAnalysisMapper.selectSalesBasicInfoOppo(dto, stageWin);
        if (trackList.size() > 0) {
            Map<String, Object> map = trackList.get(0);
            returnVo.setLastTrackOppoId(map.get("OPPORTUNITY_ID").toString());
            returnVo.setLastTrackOppoName(map.get("OPPORTUNITY_NAME").toString());
        }
        dto.setPieType("win");
        List<Map<String, Object>> winList = this.salespersonAnalysisMapper.selectSalesBasicInfoOppo(dto, stageWin);
        if (winList.size() > 0) {
            Map<String, Object> map = winList.get(0);
            returnVo.setLastWinOppoId(map.get("OPPORTUNITY_ID").toString());
            returnVo.setLastWinOppoName(map.get("OPPORTUNITY_NAME").toString());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, -1);
        String diligentDate = format.format(cale.getTime());
        List diligentList = this.crmSalesPersonDiligentService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmSalesPersonDiligent::getSalesPersonId, (Object)salePerson.getUserId())).eq(CrmSalesPersonDiligent::getDiligentDate, (Object)diligentDate));
        if (diligentList.size() != 0 && (diligent = (CrmSalesPersonDiligent)diligentList.get(0)).getSalesPersonId().toString().equals(salePerson.getUserId())) {
            returnVo.setDiligentLevel(diligent.getDiligentLevel());
        }
        if (ToolUtil.isNotEmpty((Object)(salesmanScoreEntity = (SalesmanScoreEntity)this.salesmanScoreService.getOne((Wrapper)new LambdaQueryWrapper().eq(SalesmanScoreEntity::getUserId, (Object)returnVo.getChargePersonId()))))) {
            returnVo.setSex(salesmanScoreEntity.getUserSex());
            returnVo.setHeadPicture(salesmanScoreEntity.getUserProfilePicture());
        }
        return returnVo;
    }

    @Override
    public SalespersonComprehensiveAnalysisVo getSalesDataOverview(SalePersonAnalysisDto dto) {
        List<SalespersonComprehensiveAnalysisVo> list3;
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        ChargePersonVo chargePerson = new ChargePersonVo();
        chargePerson.setUserId(String.valueOf(salePersonId));
        SalespersonComprehensiveAnalysisVo returnVo = this.initAnalysisVo(chargePerson);
        this.clearDateTime(dto);
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeFlag());
        if (ToolUtil.isNotEmpty((Object)dateConvertVo)) {
            dto.setStartTime(dateConvertVo.getStartDate());
            dto.setFinalTime(dateConvertVo.getEndDate());
        }
        dto.setEndTime(dto.getCreateTimeFlag());
        dto.setStartDate(dto.getStartTime());
        dto.setEndDate(dto.getFinalTime());
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo2 = CrmDateUtils.getCurrentTime((String)dto.getEndTime());
        if (ToolUtil.isNotEmpty((Object)dateConvertVo2)) {
            dto.setStartDate(dateConvertVo2.getStartDate());
            dto.setEndDate(dateConvertVo2.getEndDate());
        }
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        dto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIdList = new ArrayList<Long>();
        stageIdList.addAll(winStageList);
        stageIdList.addAll(tqkgList);
        dto.setStageIdList(stageIdList);
        List<SalespersonComprehensiveAnalysisVo> list1 = this.salespersonAnalysisMapper.getSalespersonComprehensiveOne(dto);
        if (list1.size() > 0) {
            SalespersonComprehensiveAnalysisVo vo = list1.get(0);
            returnVo.setCustTotal(vo.getCustTotal());
            returnVo.setContTotal(vo.getContTotal());
            returnVo.setOppoTotal(vo.getOppoTotal());
        }
        if ((list3 = this.salespersonAnalysisMapper.getSalespersonComprehensiveThree(dto)).size() > 0) {
            SalespersonComprehensiveAnalysisVo vo = list3.get(0);
            returnVo.setWinCount(vo.getWinCount());
            returnVo.setProductCount(vo.getProductCount());
        }
        SalespersonBehaviorDto salespersonBehaviorDto = new SalespersonBehaviorDto();
        salespersonBehaviorDto.setCurrent(1);
        salespersonBehaviorDto.setSize(1);
        salespersonBehaviorDto.setPopUpSign("3");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(dto.getSalePersonId());
        salespersonBehaviorDto.setUserIds(userIds);
        salespersonBehaviorDto.setTimeRange(dto.getCreateTimeFlag());
        if (ToolUtil.isNotEmpty((Object)dto.getStartTime()) && ToolUtil.isNotEmpty((Object)dto.getFinalTime())) {
            DateTimeFormatter dtfor = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            salespersonBehaviorDto.setStartTime(LocalDate.parse(dto.getStartTime(), dtfor));
            salespersonBehaviorDto.setEndTime(LocalDate.parse(dto.getFinalTime(), dtfor));
        }
        Page page = this.behaviorPopUp(salespersonBehaviorDto);
        Long recordCount = page.getTotal();
        returnVo.setRecordCount(recordCount.intValue());
        return returnVo;
    }

    @Override
    public SalespersonPortraitRankVo getSalesPortraitRank(SalePersonAnalysisDto dto) {
        List collect3;
        List<SalespersonComprehensiveAnalysisVo> recordCountList;
        List collect1;
        List<SalespersonComprehensiveAnalysisVo> list1;
        String configValue;
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        SalespersonPortraitRankVo vo = new SalespersonPortraitRankVo();
        vo.setSalePersonId(salePersonId);
        if ("6".equals(dto.getCreateTimeFlag())) {
            dto.setStartDate(dto.getStartTime());
            dto.setEndDate(dto.getEndTime());
            dto.setFinalTime(dto.getEndTime());
        } else {
            this.clearDateTime(dto);
            com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeFlag());
            if (ToolUtil.isNotEmpty((Object)dateConvertVo)) {
                dto.setStartTime(dateConvertVo.getStartDate());
                dto.setFinalTime(dateConvertVo.getEndDate());
                dto.setStartDate(dateConvertVo.getStartDate());
                dto.setEndDate(dateConvertVo.getEndDate());
            }
        }
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        List<Long> salesPersonIds = userVoList.stream().map(UserVo::getId).collect(Collectors.toList());
        CrmBaseConfigVo baseConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("salesperson_com_ana_pro");
        if (ToolUtil.isNotEmpty((Object)baseConfig) && "0".equals(configValue = baseConfig.getConfigValue())) {
            Long salesGM = Long.parseLong(this.crmProperties.getRoles().getSalesGM());
            List salesGMUserIds = this.userRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)salesGM)).stream().map(SysUserRole::getUserId).collect(Collectors.toList());
            salesPersonIds.removeAll(salesGMUserIds);
        }
        vo.setSalesPersonCount(salesPersonIds.size());
        dto.setPermissionUserIds(salesPersonIds);
        dto.setSalePersonId(null);
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        dto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIdList = new ArrayList<Long>();
        stageIdList.addAll(winStageList);
        stageIdList.addAll(tqkgList);
        dto.setStageIdList(stageIdList);
        List<SalespersonComprehensiveAnalysisVo> list3 = this.salespersonAnalysisMapper.getSalespersonComprehensiveThree(dto);
        if (ToolUtil.isNotEmpty(list3)) {
            list3 = list3.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWinCount).reversed()).collect(Collectors.toList());
            int lastDataInt = 0;
            int ranking = 0;
            boolean dataExist = false;
            for (int i = 0; i < list3.size(); ++i) {
                SalespersonComprehensiveAnalysisVo thisVo = list3.get(i);
                if (i == 0 || thisVo.getWinCount() != lastDataInt) {
                    ranking = i + 1;
                }
                lastDataInt = thisVo.getWinCount();
                if (!salePersonId.equals(thisVo.getChargePersonId())) continue;
                vo.setWinCountRank(ranking);
                dataExist = true;
                break;
            }
            if (!dataExist) {
                vo.setWinCountRank(list3.size() + 1);
            }
            list3 = list3.stream().sorted(Comparator.comparing(SalespersonComprehensiveAnalysisVo::getWinAmount).reversed()).collect(Collectors.toList());
            double lastDataDouble = 0.0;
            ranking = 0;
            dataExist = false;
            for (int i = 0; i < list3.size(); ++i) {
                Iterator<SalespersonComprehensiveAnalysisVo> thisVo = list3.get(i);
                if (i == 0 || ((SalespersonComprehensiveAnalysisVo)((Object)thisVo)).getWinAmount() != lastDataDouble) {
                    ranking = i + 1;
                }
                lastDataDouble = ((SalespersonComprehensiveAnalysisVo)((Object)thisVo)).getWinAmount();
                if (!salePersonId.equals(((SalespersonComprehensiveAnalysisVo)((Object)thisVo)).getChargePersonId())) continue;
                vo.setWinAmountRank(ranking);
                dataExist = true;
                break;
            }
            if (!dataExist) {
                vo.setWinAmountRank(list3.size() + 1);
            }
        }
        if (ToolUtil.isNotEmpty(list1 = this.salespersonAnalysisMapper.getSalespersonComprehensiveOne(dto))) {
            List custTotalCollect = list1.stream().map(SalespersonComprehensiveAnalysisVo::getCustTotal).collect(Collectors.toList());
            HashSet custTotalSet = new HashSet(custTotalCollect);
            List custTotalInt = custTotalSet.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (SalespersonComprehensiveAnalysisVo salespersonComprehensiveAnalysisVo : list1) {
                for (Integer integer : custTotalSet) {
                    if (!salePersonId.equals(salespersonComprehensiveAnalysisVo.getChargePersonId()) || !integer.equals(salespersonComprehensiveAnalysisVo.getCustTotal())) continue;
                    vo.setCustCountRank(custTotalInt.indexOf(integer) + 1);
                }
            }
            if (vo.getCustCountRank() == 0) {
                int i = 0;
                if (ToolUtil.isNotEmpty(custTotalInt)) {
                    i = (Integer)custTotalInt.get(custTotalInt.size() - 1);
                }
                vo.setCustCountRank(i > 0 ? custTotalInt.size() + 1 : custTotalInt.size());
            }
        }
        if (ToolUtil.isNotEmpty(collect1 = list1.stream().map(SalespersonComprehensiveAnalysisVo::getOppoTotal).collect(Collectors.toList()))) {
            HashSet set = new HashSet(collect1);
            List collect = set.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (SalespersonComprehensiveAnalysisVo salespersonComprehensiveAnalysisVo : list1) {
                for (Integer integer : set) {
                    if (!salePersonId.equals(salespersonComprehensiveAnalysisVo.getChargePersonId()) || !integer.equals(salespersonComprehensiveAnalysisVo.getOppoTotal())) continue;
                    vo.setOppoCountRank(collect.indexOf(integer) + 1);
                }
            }
            if (vo.getOppoCountRank() == 0) {
                int i = 0;
                if (ToolUtil.isNotEmpty(collect)) {
                    i = (Integer)collect.get(collect.size() - 1);
                }
                vo.setOppoCountRank(i > 0 ? collect.size() + 1 : collect.size());
            }
        }
        if (ToolUtil.isNotEmpty(recordCountList = this.salespersonAnalysisMapper.getSalesPortraitRecordRank(dto))) {
            List recordCollect = recordCountList.stream().map(SalespersonComprehensiveAnalysisVo::getProductCount).collect(Collectors.toList());
            HashSet recordSet = new HashSet(recordCollect);
            List recordInt = recordSet.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (SalespersonComprehensiveAnalysisVo salespersonComprehensiveAnalysisVo : recordCountList) {
                for (Integer integer : recordSet) {
                    if (!salePersonId.equals(salespersonComprehensiveAnalysisVo.getChargePersonId()) || !integer.equals(salespersonComprehensiveAnalysisVo.getProductCount())) continue;
                    vo.setRecordCountRank(recordInt.indexOf(integer) + 1);
                }
            }
            if (vo.getRecordCountRank() == 0) {
                int i = 0;
                if (ToolUtil.isNotEmpty(recordInt)) {
                    i = (Integer)recordInt.get(recordInt.size() - 1);
                }
                vo.setRecordCountRank(i > 0 ? recordInt.size() + 1 : recordInt.size());
            }
        }
        if (ToolUtil.isNotEmpty(list3) && HussarUtils.isNotEmpty(collect3 = list3.stream().map(SalespersonComprehensiveAnalysisVo::getProductCount).collect(Collectors.toList()))) {
            HashSet set3 = new HashSet(collect3);
            List collect31 = set3.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (SalespersonComprehensiveAnalysisVo salespersonComprehensiveAnalysisVo : list3) {
                for (Integer integer : set3) {
                    if (!salePersonId.equals(salespersonComprehensiveAnalysisVo.getChargePersonId()) || !integer.equals(salespersonComprehensiveAnalysisVo.getProductCount())) continue;
                    vo.setProductCountRank(collect31.indexOf(integer) + 1);
                }
            }
            if (vo.getProductCountRank() == 0) {
                int i = 0;
                if (ToolUtil.isNotEmpty(collect31)) {
                    i = (Integer)collect31.get(collect31.size() - 1);
                }
                vo.setProductCountRank(i > 0 ? collect31.size() + 1 : collect31.size());
            }
        }
        return vo;
    }

    @Override
    public List<SalesPersonLatestDynamicVo> getSalesLatestDynamic(SalePersonAnalysisDto dto) {
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        Page page = new Page();
        page.setCurrent(1L);
        page.setSize(10L);
        return this.salespersonAnalysisMapper.getSalesLatestDynamic(salePersonId, (Page<SalesPersonLatestDynamicVo>)page);
    }

    @Override
    public List<SalesPersonPortraitPieVo> getSalesOppoFrom(SalePersonAnalysisDto dto) {
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        return this.salespersonAnalysisMapper.getSalesOppoFrom(dto);
    }

    @Override
    public List<SalesPersonPortraitPieVo> getSalesRecordTypePie(SalePersonAnalysisDto dto) {
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        return this.salespersonAnalysisMapper.getSalesRecordTypePie(salePersonId);
    }

    @Override
    public List<SalesPersonPortraitPieVo> getSalesCustomerPie(SalePersonAnalysisDto dto) {
        Long salePersonId = dto.getSalePersonId();
        if (!this.hasPermission(salePersonId)) {
            return null;
        }
        List<SalesPersonPortraitPieVo> returnList = this.salespersonAnalysisMapper.getSalesCustomerPie(dto);
        for (SalesPersonPortraitPieVo vo : returnList) {
            if (!ToolUtil.isEmpty((Object)vo.getTypeName())) continue;
            vo.setTypeName("\u672a\u77e5");
        }
        return returnList;
    }

    @Override
    public Page<ContactEntity> getSalesCustomerPopup(SalespersonAnalysisContactDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
        if (CommonUtil.OPPO_VIEW_SALES_ANALYSIS.equals(dto.getContactView())) {
            permissionDto = new SalesStatisticsDto();
        }
        List<SalespersonAnalysisContactDto> dtoList = this.getContactDtoList(dto);
        Page page = dto.getPage();
        DateConvertVo dateConvertVo = this.timeFlag(dto.getCreateTimeFlag());
        if (ToolUtil.isNotEmpty((Object)dateConvertVo)) {
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        List<ContactEntity> list = this.salespersonAnalysisMapper.selectContactList(dtoList, page, dto.getCurrentUserId(), dto.getTimeOrder(), permissionDto);
        page.setRecords(list);
        return page;
    }

    private List<SalespersonAnalysisContactDto> getContactDtoList(SalespersonAnalysisContactDto dto) {
        ArrayList<SalespersonAnalysisContactDto> queryDtoList = new ArrayList<SalespersonAnalysisContactDto>();
        String view = dto.getContactView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view) && !CommonUtil.OPPO_VIEW_SALES_ANALYSIS.equals(view)) {
            CrmScene crmScene;
            long contactView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)contactView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"contact");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        SalespersonAnalysisContactDto queryDto = (SalespersonAnalysisContactDto)((Object)JSONObject.parseObject((String)queryValue, SalespersonAnalysisContactDto.class));
                        queryDto.setContactView(String.valueOf(contactView));
                        queryDtoList.add(this.contactQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.contactQueryCondition(dto));
        return queryDtoList;
    }

    private SalespersonAnalysisContactDto contactQueryCondition(SalespersonAnalysisContactDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String contactView = dto.getContactView();
        if (ToolUtil.isNotEmpty((Object)dto.getContactScreening())) {
            dto.setContactScreening(dto.getContactScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        List chargerPersonIds = dto.getChargePersonIds();
        if (CollectionUtil.isNotEmpty((Collection)chargerPersonIds)) {
            for (String userId : chargerPersonIds) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        List departments = dto.getOwnDepartments();
        ArrayList odpIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)departments)) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (!CollectionUtil.isNotEmpty((Collection)idsTemp)) continue;
                odpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(contactView)) {
            dto.setChargePersonId(String.valueOf(user.getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }

    private boolean hasPermission(Long salePersonId) {
        if (ToolUtil.isEmpty((Object)salePersonId)) {
            return false;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        HashSet<Long> permissionSet = new HashSet<Long>();
        CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
        List userRoles = user.getRolesList();
        List provinceStruIdList = new ArrayList();
        List leadershipRoles = DataPermission.getLeadershipRoles();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
            List salesmanList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
            permissionSet.addAll(salesmanList.stream().map(UserVo::getId).collect(Collectors.toList()));
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
            List salesmanList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
            permissionSet.addAll(salesmanList.stream().map(UserVo::getId).collect(Collectors.toList()));
        } else if (DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) {
            provinceStruIdList = this.commonDataRightService.getChargeDepartmentList(user.getUserId(), null);
            if (HussarUtils.isNotEmpty(provinceStruIdList)) {
                List userList = this.organUserBoService.getUserListByDepartmentId(provinceStruIdList);
                permissionSet.addAll(userList.stream().map(UserVo::getId).collect(Collectors.toList()));
            }
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector()))) {
            provinceStruIdList = this.commonDataRightService.getChargeDepartmentList(user.getUserId(), null);
            if (HussarUtils.isNotEmpty(provinceStruIdList)) {
                List userList = this.organUserBoService.getUserListByDepartmentId(provinceStruIdList);
                permissionSet.addAll(userList.stream().map(UserVo::getId).collect(Collectors.toList()));
            }
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesman()))) {
            permissionSet.add(user.getUserId());
        }
        return permissionSet.contains(salePersonId);
    }

    private SalespersonComprehensiveAnalysisVo initAnalysisVo(ChargePersonVo person) {
        SalespersonComprehensiveAnalysisVo ana = new SalespersonComprehensiveAnalysisVo();
        ana.setChargePersonId(Long.valueOf(person.getUserId()));
        ana.setChargePersonName(person.getUserName());
        ana.setDeptId(Long.valueOf(person.getStruId() == null ? "0" : person.getStruId()));
        ana.setDeptName(person.getOrganAlias());
        ana.setShortName(person.getShortName());
        ana.setCustTotal(0);
        ana.setContTotal(0);
        ana.setOppoTotal(0);
        ana.setWaitFollow(0);
        ana.setFollowing(0);
        ana.setWinCount(0);
        ana.setWinAmount(0.0);
        ana.setMaxAmount(0.0);
        ana.setMinAmount(0.0);
        ana.setAvgAmount(0.0);
        ana.setProductCount(0);
        ana.setMaxProductId(null);
        ana.setMaxProductName("-");
        ana.setMaxProductCount(0);
        ana.setLastTrackOppoId(null);
        ana.setLastTrackOppoName("-");
        ana.setLastWinOppoId(null);
        ana.setLastWinOppoName("-");
        ana.setDiligentLevel(null);
        return ana;
    }

    private DateConvertVo timeFlag(String timeFlag) {
        if (StringUtil.isNotBlank((CharSequence)timeFlag) && !"3".equals(timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime((String)timeFlag);
            return dateConvertVo;
        }
        return null;
    }

    @Override
    public Page<CustomerEntity> getCustomerList(CustomerDto dto) {
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        SalesStatisticsDto permissionDto = this.customerOperate(dto);
        List<CustomerDto> customerDtoList = this.getCustomerDtoList(dto);
        Page page = dto.getPage();
        List<Long> sysStruList = null;
        List<CustomerEntity> list = this.salespersonAnalysisMapper.selectCustomerListCountOpportunity(customerDtoList, page, dto.getTimeOrder(), dto.getCurrentUserId(), sysStruList);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelApiService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
            list.forEach(customer -> {
                customer.setLabelName(CrmLabelUtil.getLabelName((List)labelList, (String)customer.getLabelId()));
                customer.setAiTagName(CrmLabelUtil.getLabelName((List)labelList, (String)customer.getAiTags()));
            });
        }
        page.setRecords(list);
        return page;
    }

    private SalesStatisticsDto customerOperate(CustomerDto dto) {
        String customerView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(customerView = dto.getCustomerView())) && !"2".equals(customerView) && !"4".equals(customerView) && !"0".equals(customerView)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    private List<CustomerDto> getCustomerDtoList(CustomerDto dto) {
        ArrayList<CustomerDto> queryDtoList = new ArrayList<CustomerDto>();
        String view = dto.getCustomerView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long customerView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)customerView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"customer");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        CustomerDto queryDto = (CustomerDto)JSONObject.parseObject((String)queryValue, CustomerDto.class);
                        queryDto.setCustomerView(String.valueOf(customerView));
                        queryDtoList.add(this.customerQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.customerQueryCondition(dto));
        return queryDtoList;
    }

    private CustomerDto customerQueryCondition(CustomerDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        String customerView = dto.getCustomerView();
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (Object userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List departments = dto.getOwnDepartments();
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(customerView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    @Override
    public List<SalespersonBehaviorVo> salespersonBehaviorAnalysis(SalespersonBehaviorDto salespersonBehaviorDto) {
        List customerNumber;
        List<SalespersonBehaviorVo> recordCountList;
        DateConvertVo currentTime;
        if (CollectionUtil.isNotEmpty(salespersonBehaviorDto.getDeptIds())) {
            salespersonBehaviorDto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(salespersonBehaviorDto.getDeptIds()));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<UserDepartmentVo> userDepartmentVoList = new ArrayList<UserDepartmentVo>();
        List<Object> userLists = new ArrayList();
        userLists = user.getRolesList().contains(Long.parseLong(this.crmProperties.getRoles().getAllOpportunity())) ? this.dataRightBoService.getAllSalesUserList(null, userDepartmentVoList) : this.dataRightBoService.getSalesUserList(null, userDepartmentVoList);
        CrmBaseConfigVo baseConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("salesperson_com_ana_pro");
        List<Object> salesGMUserIds = new ArrayList();
        String configValue = baseConfig.getConfigValue();
        if (ToolUtil.isNotEmpty((Object)baseConfig) && "0".equals(configValue)) {
            Long salesGM2 = Long.parseLong(this.crmProperties.getRoles().getSalesGM());
            List<Object> finalUserLists = salesGMUserIds = this.userRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)salesGM2)).stream().map(SysUserRole::getUserId).collect(Collectors.toList());
            userLists = userLists.stream().filter(f -> !finalUserLists.contains(f)).collect(Collectors.toList());
        }
        salespersonBehaviorDto.setPermissionUserId(userLists);
        ArrayList<Object> userIdsTemp = new ArrayList<Object>();
        if (ToolUtil.isNotEmpty(salespersonBehaviorDto.getDeptIds())) {
            List deptUserList = this.organUserBoService.getUserListByDepartmentId(salespersonBehaviorDto.getDeptIds());
            List deptUserIds = deptUserList.stream().map(UserVo::getId).collect(Collectors.toList());
            userIdsTemp.addAll(deptUserIds);
        }
        if (CollectionUtil.isNotEmpty(salespersonBehaviorDto.getUserIds())) {
            userIdsTemp.addAll(salespersonBehaviorDto.getUserIds());
        }
        userIdsTemp.retainAll(salespersonBehaviorDto.getPermissionUserId());
        if (!(CollectionUtil.isEmpty(salespersonBehaviorDto.getUserIds()) && CollectionUtil.isEmpty(salespersonBehaviorDto.getDeptIds()) || !CollectionUtil.isEmpty(userIdsTemp))) {
            return new ArrayList<SalespersonBehaviorVo>();
        }
        if (HussarUtils.isNotEmpty((Object)salespersonBehaviorDto.getTimeRange()) && !"3".equals(salespersonBehaviorDto.getTimeRange()) && (currentTime = IndexUtil.getCurrentTime((String)salespersonBehaviorDto.getTimeRange())) != null) {
            salespersonBehaviorDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            salespersonBehaviorDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        List<SalespersonBehaviorVo> selectAllStageNumber = this.salespersonAnalysisMapper.selectAllStageNumber(salespersonBehaviorDto);
        List userIds = selectAllStageNumber.stream().map(SalespersonVo::getUserId).collect(Collectors.toList());
        if (!userDepartmentVoList.isEmpty()) {
            if (CollectionUtil.isNotEmpty(userIdsTemp)) {
                userDepartmentVoList.removeIf(userDepartmentVo -> !userIdsTemp.contains(userDepartmentVo.getUserId()));
            }
            List listTemp = selectAllStageNumber.stream().map(SalespersonVo::getUserId).collect(Collectors.toList());
            for (UserDepartmentVo sysUser : userDepartmentVoList) {
                if (listTemp.contains(sysUser.getUserId())) continue;
                SalespersonBehaviorVo salespersonBehaviorVo2 = new SalespersonBehaviorVo();
                salespersonBehaviorVo2.setUserId(sysUser.getUserId());
                salespersonBehaviorVo2.setUserName(sysUser.getUserName());
                salespersonBehaviorVo2.setDeptId((Long)sysUser.getDepartmentIdList().get(0));
                salespersonBehaviorVo2.setDeptName(sysUser.getDepartmentNameList().stream().collect(Collectors.joining(",")));
                selectAllStageNumber.add(salespersonBehaviorVo2);
            }
        }
        if (CollectionUtil.isNotEmpty(recordCountList = this.selectSignificantRecordCount(salespersonBehaviorDto)) && CollectionUtil.isNotEmpty(selectAllStageNumber)) {
            block31: for (SalespersonBehaviorVo vo1 : selectAllStageNumber) {
                for (SalespersonBehaviorVo vo2 : recordCountList) {
                    if (!vo2.getUserId().equals(vo1.getUserId())) continue;
                    vo1.setSignificantRecordCount(vo2.getSignificantRecordCount());
                    vo1.setInsignificantRecordCount(vo2.getInsignificantRecordCount());
                    recordCountList.remove(vo2);
                    continue block31;
                }
            }
        }
        List<SalespersonBehaviorVo> selectCustomersNumber = this.salespersonAnalysisMapper.selectCustomersNumber(salespersonBehaviorDto);
        List<SalespersonBehaviorVo> selectOpportunityNumber = this.salespersonAnalysisMapper.selectOpportunityNumber(salespersonBehaviorDto);
        if (ToolUtil.isNotEmpty(selectAllStageNumber)) {
            for (SalespersonBehaviorVo salespersonBehaviorVo3 : selectAllStageNumber) {
                List opportunityNumber;
                customerNumber = selectCustomersNumber.stream().filter(f -> f.getUserId().equals(salespersonBehaviorVo3.getUserId())).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(customerNumber)) {
                    int cusNumber = ((SalespersonBehaviorVo)customerNumber.get(0)).getCustomersNumber();
                    salespersonBehaviorVo3.setCustomersNumber(cusNumber);
                }
                if (ToolUtil.isNotEmpty(opportunityNumber = selectOpportunityNumber.stream().filter(f -> f.getUserId().equals(salespersonBehaviorVo3.getUserId())).collect(Collectors.toList()))) {
                    int oppNumber = ((SalespersonBehaviorVo)opportunityNumber.get(0)).getOpportunityNumber();
                    salespersonBehaviorVo3.setOpportunityNumber(oppNumber);
                }
                int totalNum = salespersonBehaviorVo3.getPhone() + salespersonBehaviorVo3.getVisitCustomers() + salespersonBehaviorVo3.getOnlineConference() + salespersonBehaviorVo3.getMessage() + salespersonBehaviorVo3.getCustomerVisit() + salespersonBehaviorVo3.getOther() + salespersonBehaviorVo3.getDiscussion();
                salespersonBehaviorVo3.setTotalNumber(totalNum);
            }
        }
        List<SalespersonBehaviorVo> salespersonBehaviorVos = selectAllStageNumber.stream().sorted(Comparator.comparing(SalespersonVo::getUserId)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(salespersonBehaviorDto.getExclusionPersons())) {
            List<Long> exclusionPersons = salespersonBehaviorDto.getExclusionPersons();
            for (Long exclusionPerson : exclusionPersons) {
                customerNumber = salespersonBehaviorVos.stream().filter(f -> exclusionPerson.equals(f.getUserId())).collect(Collectors.toList());
            }
        }
        if (HussarUtils.isEmpty((Object)salespersonBehaviorDto.getSortFlags())) {
            List<SalespersonVo> salespersonVoList;
            List<Long> userIdList = salespersonBehaviorVos.stream().map(SalespersonVo::getUserId).collect(Collectors.toList());
            Map<Long, SalespersonBehaviorVo> salespersonBehaviorVoMap = salespersonBehaviorVos.stream().collect(Collectors.toMap(SalespersonVo::getUserId, salespersonBehaviorVo -> salespersonBehaviorVo));
            if (CollectionUtil.isNotEmpty(userIdList) && CollectionUtil.isNotEmpty(salespersonVoList = this.salespersonAnalysisMapper.selectUserList(userIdList))) {
                for (SalespersonVo tempBehaviorVo : salespersonVoList) {
                    Long userId = tempBehaviorVo.getUserId();
                    SalespersonBehaviorVo salespersonBehaviorVo4 = salespersonBehaviorVoMap.get(userId);
                    if (salespersonBehaviorVo4 == null) continue;
                    salespersonBehaviorVo4.setStaffPosition(tempBehaviorVo.getStaffPosition() == null ? "461" : tempBehaviorVo.getStaffPosition());
                    salespersonBehaviorVo4.setUserOrder(tempBehaviorVo.getUserOrder() == null ? 100000 : tempBehaviorVo.getUserOrder());
                    salespersonBehaviorVo4.setStruOrder(tempBehaviorVo.getStruOrder() == null ? 100000 : tempBehaviorVo.getStruOrder());
                }
            }
            salespersonBehaviorVos = salespersonBehaviorVos.stream().filter(f -> f.getDeptId() != null).sorted(Comparator.comparing(SalespersonVo::getStruOrder).thenComparing(SalespersonVo::getStaffPosition).thenComparing(SalespersonBehaviorVo::getDeptId).thenComparingInt(SalespersonVo::getUserOrder)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty((Object)salespersonBehaviorDto.getSortFlags())) {
            Comparator<SalespersonBehaviorVo> comparator;
            String sortFlags = salespersonBehaviorDto.getSortFlags();
            String[] split = sortFlags.split(",");
            String row = split[0];
            String sort = split[1];
            switch (row) {
                case "0": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getTotalNumber);
                    break;
                }
                case "1": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getCustomersNumber);
                    break;
                }
                case "2": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getOpportunityNumber);
                    break;
                }
                case "3": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getPhone);
                    break;
                }
                case "4": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getVisitCustomers);
                    break;
                }
                case "5": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getOnlineConference);
                    break;
                }
                case "6": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getMessage);
                    break;
                }
                case "7": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getCustomerVisit);
                    break;
                }
                case "8": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getOther);
                    break;
                }
                case "9": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getDiscussion);
                    break;
                }
                case "10": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getSignificantRecordCount);
                    break;
                }
                case "11": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getInsignificantRecordCount);
                    break;
                }
                case "12": {
                    comparator = this.getComparatorBehavior(sort, SalespersonBehaviorVo::getDeptId);
                    break;
                }
                default: {
                    return this.getSalespersonBehaviorTotal(salespersonBehaviorVos);
                }
            }
            List<SalespersonBehaviorVo> salespersonBehaviorVos1 = salespersonBehaviorVos.stream().sorted(comparator).collect(Collectors.toList());
            return this.getSalespersonBehaviorTotal(salespersonBehaviorVos1);
        }
        return this.getSalespersonBehaviorTotal(salespersonBehaviorVos);
    }

    private List<SalespersonBehaviorVo> getSalespersonBehaviorTotal(List<SalespersonBehaviorVo> salespersonBehaviorVos) {
        if (salespersonBehaviorVos.isEmpty()) {
            return new ArrayList<SalespersonBehaviorVo>();
        }
        int totalNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getTotalNumber).sum();
        int totalSignificantNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getSignificantRecordCount).sum();
        int totalInsignificantNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getInsignificantRecordCount).sum();
        int totalCustomersNumber = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getCustomersNumber).sum();
        int totalOpportunityNumber = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getOpportunityNumber).sum();
        int totalPhoneNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getPhone).sum();
        int totalVisitCustomersNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getVisitCustomers).sum();
        int totalOnlineConferenceNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getOnlineConference).sum();
        int totalMessageNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getMessage).sum();
        int totalCustomerVisitNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getCustomerVisit).sum();
        int totalOtherNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getOther).sum();
        int totalDiscussionNum = salespersonBehaviorVos.stream().mapToInt(SalespersonBehaviorVo::getDiscussion).sum();
        SalespersonBehaviorVo salespersonBehaviorVo = new SalespersonBehaviorVo();
        salespersonBehaviorVo.setTotalNumber(totalNum);
        salespersonBehaviorVo.setSignificantRecordCount(totalSignificantNum);
        salespersonBehaviorVo.setInsignificantRecordCount(totalInsignificantNum);
        salespersonBehaviorVo.setCustomersNumber(totalCustomersNumber);
        salespersonBehaviorVo.setOpportunityNumber(totalOpportunityNumber);
        salespersonBehaviorVo.setPhone(totalPhoneNum);
        salespersonBehaviorVo.setVisitCustomers(totalVisitCustomersNum);
        salespersonBehaviorVo.setOnlineConference(totalOnlineConferenceNum);
        salespersonBehaviorVo.setMessage(totalMessageNum);
        salespersonBehaviorVo.setCustomerVisit(totalCustomerVisitNum);
        salespersonBehaviorVo.setOther(totalOtherNum);
        salespersonBehaviorVo.setDiscussion(totalDiscussionNum);
        salespersonBehaviorVo.setUserName("\u5408\u8ba1" + salespersonBehaviorVos.size() + "\u4e2a\u4eba");
        salespersonBehaviorVo.setDeptName(salespersonBehaviorVos.stream().map(SalespersonBehaviorVo::getDeptId).collect(Collectors.toSet()).size() + "\u4e2a\u90e8\u95e8");
        salespersonBehaviorVos.add(salespersonBehaviorVo);
        return salespersonBehaviorVos;
    }

    @Override
    public List<SalespersonRankingVo> salespersonRankingAnalysis(SalespersonRankingDto salespersonRankingDto) {
        List<Object> salespersonRankingVoList;
        if (CollectionUtil.isNotEmpty(salespersonRankingDto.getDeptIds())) {
            salespersonRankingDto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(salespersonRankingDto.getDeptIds()));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Object> userDepartmentVoList = new ArrayList();
        List<Object> userLists = new ArrayList();
        userLists = user.getRolesList().contains(Long.parseLong(this.crmProperties.getRoles().getAllOpportunity())) ? this.dataRightBoService.getAllSalesUserList(null, userDepartmentVoList) : this.dataRightBoService.getSalesUserList(null, userDepartmentVoList);
        salespersonRankingDto.setPermissionUserId(userLists);
        ArrayList<Long> userIdsTemp = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty(salespersonRankingDto.getDeptIds())) {
            List deptUserList = this.organUserBoService.getUserListByDepartmentId(salespersonRankingDto.getDeptIds());
            List deptUserIds = deptUserList.stream().map(UserVo::getId).collect(Collectors.toList());
            userIdsTemp.addAll(deptUserIds);
        }
        if (CollectionUtil.isNotEmpty(salespersonRankingDto.getUserIds())) {
            userIdsTemp.addAll(salespersonRankingDto.getUserIds());
        }
        if (!userIdsTemp.isEmpty()) {
            userIdsTemp.retainAll(salespersonRankingDto.getPermissionUserId());
            if (CollectionUtil.isEmpty(userIdsTemp)) {
                return new ArrayList<SalespersonRankingVo>();
            }
            salespersonRankingDto.setUserIds(userIdsTemp);
        }
        CrmBaseConfigVo baseConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("salesperson_com_ana_pro");
        List<Object> salesGMUserIds = new ArrayList();
        String configValue = baseConfig.getConfigValue();
        if (ToolUtil.isNotEmpty((Object)baseConfig) && "0".equals(configValue)) {
            Long salesGM2 = Long.parseLong(this.crmProperties.getRoles().getSalesGM());
            salesGMUserIds = this.userRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)salesGM2)).stream().map(SysUserRole::getUserId).collect(Collectors.toList());
            ArrayList<Long> finalUserLists = userLists;
            userLists = userLists.stream().filter(f -> !finalUserLists.contains(f)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty((Object)salespersonRankingDto.getTimeRange())) {
            com.jxdinfo.crm.common.api.util.entity.DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)salespersonRankingDto.getTimeRange());
            salespersonRankingDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            salespersonRankingDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        List<Object> salespersonRankingVos = new ArrayList();
        int statisticalIndicators = salespersonRankingDto.getStatisticalIndicators();
        if (ToolUtil.isNotEmpty(salespersonRankingDto.getUserIds()) && ToolUtil.isEmpty(salespersonRankingDto.getDeptIds())) {
            salespersonRankingDto.setPermissionUserId(salespersonRankingDto.getUserIds());
        }
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        salespersonRankingDto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        salespersonRankingDto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIds = new ArrayList<Long>();
        stageIds.addAll(winStageList);
        stageIds.addAll(tqkgList);
        salespersonRankingDto.setStageIds(stageIds);
        List<Object> num = new ArrayList();
        List<Object> salespersonRankingAll = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)salespersonRankingDto.getStatisticalIndicators())) {
            switch (statisticalIndicators) {
                case 0: {
                    salespersonRankingVos = this.salespersonAnalysisMapper.getAmountStatistics(salespersonRankingDto);
                    SalespersonRankingDto salespersonRankingDto1 = new SalespersonRankingDto();
                    BeanUtil.copyProperties((Object)((Object)salespersonRankingDto), (Object)((Object)salespersonRankingDto1));
                    salespersonRankingDto1.setUserIds(userIdsTemp);
                    salespersonRankingDto1.setPermissionUserId(userLists);
                    salespersonRankingAll = this.salespersonAnalysisMapper.getAmountStatistics(salespersonRankingDto1);
                    if (!ToolUtil.isNotEmpty((Object)((Object)salespersonRankingDto))) break;
                    num = salespersonRankingAll.stream().sorted(Comparator.comparing(SalespersonRankingVo::getTransactionAmount).reversed()).map(SalespersonRankingVo::getTransactionAmount).distinct().collect(Collectors.toList());
                    for (Object salespersonRankingVo2 : salespersonRankingVos) {
                        int n = num.indexOf(((SalespersonRankingVo)salespersonRankingVo2).getTransactionAmount());
                        ((SalespersonRankingVo)salespersonRankingVo2).setRankNumber(n + 1);
                    }
                    break;
                }
                case 1: {
                    salespersonRankingVos = this.salespersonAnalysisMapper.getNumberStatistics(salespersonRankingDto);
                    SalespersonRankingDto salespersonRankingDto2 = new SalespersonRankingDto();
                    BeanUtil.copyProperties((Object)((Object)salespersonRankingDto), (Object)((Object)salespersonRankingDto2));
                    salespersonRankingDto2.setUserIds(userIdsTemp);
                    salespersonRankingDto2.setPermissionUserId(userLists);
                    salespersonRankingAll = this.salespersonAnalysisMapper.getNumberStatistics(salespersonRankingDto2);
                    if (!ToolUtil.isNotEmpty((Object)((Object)salespersonRankingDto))) break;
                    for (SalespersonRankingVo salespersonRankingVo2 : salespersonRankingVos) {
                        num = salespersonRankingAll.stream().sorted(Comparator.comparing(SalespersonRankingVo::getTransactionNumber).reversed()).map(SalespersonRankingVo::getTransactionNumber).distinct().collect(Collectors.toList());
                        int n = num.indexOf(salespersonRankingVo2.getTransactionNumber());
                        salespersonRankingVo2.setRankNumber(n + 1);
                    }
                    break;
                }
                case 2: {
                    salespersonRankingVos = this.salespersonAnalysisMapper.getNewOpportunityNum(salespersonRankingDto);
                    SalespersonRankingDto salespersonRankingDto3 = new SalespersonRankingDto();
                    BeanUtil.copyProperties((Object)((Object)salespersonRankingDto), (Object)((Object)salespersonRankingDto3));
                    salespersonRankingDto3.setUserIds(userIdsTemp);
                    salespersonRankingDto3.setPermissionUserId(userLists);
                    salespersonRankingAll = this.salespersonAnalysisMapper.getNewOpportunityNum(salespersonRankingDto3);
                    if (!ToolUtil.isNotEmpty((Object)((Object)salespersonRankingDto))) break;
                    for (SalespersonRankingVo salespersonRankingVo3 : salespersonRankingVos) {
                        num = salespersonRankingAll.stream().sorted(Comparator.comparing(SalespersonRankingVo::getStatisticalQuantity).reversed()).map(SalespersonRankingVo::getStatisticalQuantity).distinct().collect(Collectors.toList());
                        int n = num.indexOf(salespersonRankingVo3.getStatisticalQuantity());
                        salespersonRankingVo3.setRankNumber(n + 1);
                    }
                    break;
                }
                case 3: {
                    salespersonRankingVos = this.salespersonAnalysisMapper.getNewCustomerNum(salespersonRankingDto);
                    SalespersonRankingDto salespersonRankingDto2 = new SalespersonRankingDto();
                    BeanUtil.copyProperties((Object)((Object)salespersonRankingDto), (Object)((Object)salespersonRankingDto2));
                    salespersonRankingDto2.setUserIds(userIdsTemp);
                    salespersonRankingDto2.setPermissionUserId(userLists);
                    salespersonRankingAll = this.salespersonAnalysisMapper.getNewCustomerNum(salespersonRankingDto2);
                    if (!ToolUtil.isNotEmpty((Object)((Object)salespersonRankingDto))) break;
                    for (SalespersonRankingVo salespersonRankingVo4 : salespersonRankingVos) {
                        num = salespersonRankingAll.stream().sorted(Comparator.comparing(SalespersonRankingVo::getStatisticalQuantity).reversed()).map(SalespersonRankingVo::getStatisticalQuantity).distinct().collect(Collectors.toList());
                        int n = num.indexOf(salespersonRankingVo4.getStatisticalQuantity());
                        salespersonRankingVo4.setRankNumber(n + 1);
                    }
                    break;
                }
                case 4: {
                    salespersonRankingVos = this.salespersonAnalysisMapper.getFollowUpRecordsNum(salespersonRankingDto);
                    SalespersonRankingDto salespersonRankingDto3 = new SalespersonRankingDto();
                    BeanUtil.copyProperties((Object)((Object)salespersonRankingDto), (Object)((Object)salespersonRankingDto3));
                    salespersonRankingDto3.setUserIds(userIdsTemp);
                    salespersonRankingDto3.setPermissionUserId(userLists);
                    salespersonRankingAll = this.salespersonAnalysisMapper.getFollowUpRecordsNum(salespersonRankingDto3);
                    if (!ToolUtil.isNotEmpty((Object)((Object)salespersonRankingDto))) break;
                    for (SalespersonRankingVo salespersonRankingVo5 : salespersonRankingVos) {
                        num = salespersonRankingAll.stream().sorted(Comparator.comparing(SalespersonRankingVo::getStatisticalQuantity).reversed()).map(SalespersonRankingVo::getStatisticalQuantity).distinct().collect(Collectors.toList());
                        int n = num.indexOf(salespersonRankingVo5.getStatisticalQuantity());
                        salespersonRankingVo5.setRankNumber(n + 1);
                    }
                    break;
                }
                case 5: {
                    salespersonRankingVos = this.salespersonAnalysisMapper.getProductSales(salespersonRankingDto).stream().filter(f -> f.getStatisticalQuantity() != 0).collect(Collectors.toList());
                    SalespersonRankingDto salespersonRankingDto4 = new SalespersonRankingDto();
                    BeanUtil.copyProperties((Object)((Object)salespersonRankingDto), (Object)((Object)salespersonRankingDto4));
                    salespersonRankingDto4.setUserIds(userIdsTemp);
                    salespersonRankingDto4.setPermissionUserId(userLists);
                    salespersonRankingAll = this.salespersonAnalysisMapper.getProductSales(salespersonRankingDto4);
                    if (!ToolUtil.isNotEmpty((Object)((Object)salespersonRankingDto))) break;
                    for (SalespersonRankingVo salespersonRankingVo6 : salespersonRankingVos) {
                        num = salespersonRankingAll.stream().sorted(Comparator.comparing(SalespersonRankingVo::getStatisticalQuantity).reversed()).map(SalespersonRankingVo::getStatisticalQuantity).distinct().collect(Collectors.toList());
                        int i = num.indexOf(salespersonRankingVo6.getStatisticalQuantity());
                        salespersonRankingVo6.setRankNumber(i + 1);
                    }
                    break;
                }
            }
        }
        List userIds = salespersonRankingVos.stream().map(SalespersonVo::getUserId).collect(Collectors.toList());
        boolean flag = true;
        if (ToolUtil.isNotEmpty(salespersonRankingDto.getUserIds()) && ToolUtil.isEmpty(salespersonRankingDto.getDeptIds())) {
            flag = false;
            List<Long> list = salespersonRankingDto.getPermissionUserId();
            List list2 = list.stream().filter(f -> !userIds.contains(f)).collect(Collectors.toList());
            List list3 = userDepartmentVoList.stream().filter(f -> collect.contains(f.getUserId())).collect(Collectors.toList());
            for (UserDepartmentVo userDepartmentVo : list3) {
                SalespersonRankingVo salespersonRankingVo7 = new SalespersonRankingVo();
                salespersonRankingVo7.setUserId(userDepartmentVo.getUserId());
                salespersonRankingVo7.setUserName(userDepartmentVo.getUserName());
                salespersonRankingVo7.setDeptId((Long)userDepartmentVo.getDepartmentIdList().get(0));
                salespersonRankingVo7.setDeptName(userDepartmentVo.getDepartmentNameList().stream().collect(Collectors.joining(",")));
                salespersonRankingVo7.setRankNumber(num.size() + 1);
                salespersonRankingVos.add(salespersonRankingVo7);
            }
        } else {
            List<Long> deptIdList = salespersonRankingDto.getDeptIds();
            if (CollectionUtil.isNotEmpty(deptIdList)) {
                userDepartmentVoList = userDepartmentVoList.stream().filter(vo -> {
                    if (CollectionUtil.isEmpty((Collection)vo.getDepartmentIdList())) {
                        return false;
                    }
                    for (Long userDepartmentId : vo.getDepartmentIdList()) {
                        if (!deptIdList.contains(userDepartmentId)) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
            }
            if (CollectionUtil.isNotEmpty(salespersonRankingDto.getUserIds()) && CollectionUtil.isNotEmpty(userDepartmentVoList)) {
                userDepartmentVoList = userDepartmentVoList.stream().filter(vo -> salespersonRankingDto.getUserIds().contains(vo.getUserId())).collect(Collectors.toList());
            }
            if (CollectionUtil.isNotEmpty(userIds)) {
                userDepartmentVoList = userDepartmentVoList.stream().filter(vo -> !userIds.contains(vo.getUserId())).collect(Collectors.toList());
            }
            if ("0".equals(configValue)) {
                List<Object> list = salesGMUserIds;
                userDepartmentVoList = userDepartmentVoList.stream().filter(f -> !finalSalesGMUserIds1.contains(f.getUserId())).collect(Collectors.toList());
            }
            if (!userDepartmentVoList.isEmpty()) {
                for (UserDepartmentVo userDepartmentVo : userDepartmentVoList) {
                    SalespersonRankingVo salespersonRankingVo8 = new SalespersonRankingVo();
                    salespersonRankingVo8.setUserId(userDepartmentVo.getUserId());
                    salespersonRankingVo8.setUserName(userDepartmentVo.getUserName());
                    salespersonRankingVo8.setDeptId((Long)userDepartmentVo.getDepartmentIdList().get(0));
                    salespersonRankingVo8.setDeptName(userDepartmentVo.getDepartmentNameList().stream().collect(Collectors.joining(",")));
                    salespersonRankingVo8.setRankNumber(num.size() + 1);
                    salespersonRankingVos.add(salespersonRankingVo8);
                }
            }
        }
        if (HussarUtils.isEmpty((Object)salespersonRankingDto.getSortFlags()) && salespersonRankingVos.size() > 1) {
            List<SalespersonVo> list;
            List<Long> list4 = salespersonRankingVos.stream().map(SalespersonVo::getUserId).collect(Collectors.toList());
            Map<Long, SalespersonRankingVo> map = salespersonRankingVos.stream().collect(Collectors.toMap(SalespersonVo::getUserId, salespersonRankingVo -> salespersonRankingVo));
            if (CollectionUtil.isNotEmpty(list4) && CollectionUtil.isNotEmpty(list = this.salespersonAnalysisMapper.selectUserList(list4))) {
                for (SalespersonVo salespersonVo : list) {
                    Long userId = salespersonVo.getUserId();
                    Object salespersonRankingVo8 = map.get(userId);
                    if (salespersonRankingVo8 == null) continue;
                    ((SalespersonVo)salespersonRankingVo8).setStaffPosition(salespersonVo.getStaffPosition() == null ? "461" : salespersonVo.getStaffPosition());
                    ((SalespersonVo)salespersonRankingVo8).setUserOrder(salespersonVo.getUserOrder() == null ? 100000 : salespersonVo.getUserOrder());
                    ((SalespersonVo)salespersonRankingVo8).setStruOrder(salespersonVo.getStruOrder() == null ? 100000 : salespersonVo.getStruOrder());
                }
            }
            salespersonRankingVoList = salespersonRankingVos.stream().sorted(Comparator.comparing(SalespersonVo::getStruOrder).thenComparing(SalespersonVo::getStaffPosition).thenComparing(SalespersonRankingVo::getDeptId).thenComparingInt(SalespersonVo::getUserOrder)).collect(Collectors.toList());
        } else {
            salespersonRankingVoList = salespersonRankingVos;
        }
        ArrayList<Long> arrayList = userLists;
        salespersonRankingVoList.forEach(f -> f.setTotalUserLists(finalUserLists1.size()));
        if (HussarUtils.isNotEmpty((Object)salespersonRankingDto.getSortFlags()) && salespersonRankingVos.size() > 1) {
            Comparator<SalespersonRankingVo> comparator;
            String string = salespersonRankingDto.getSortFlags();
            String[] stringArray = string.split(",");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            switch (string2) {
                case "0": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getWinningAmount);
                    break;
                }
                case "1": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getEarlyStartAmount);
                    break;
                }
                case "2": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getTransactionAmount);
                    break;
                }
                case "3": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getWinningNumber);
                    break;
                }
                case "4": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getEarlyStartNumber);
                    break;
                }
                case "5": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getTransactionNumber);
                    break;
                }
                case "6": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getStatisticalQuantity);
                    break;
                }
                case "7": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getRankNumber);
                    break;
                }
                case "8": {
                    comparator = this.getComparatorRank(string3, SalespersonRankingVo::getDeptId);
                    break;
                }
                default: {
                    return this.getSalespersonRankingTotal(salespersonRankingVoList, salespersonRankingAll, statisticalIndicators, flag);
                }
            }
            List<SalespersonRankingVo> salespersonRankingTotal = this.getSalespersonRankingTotal(salespersonRankingVoList, salespersonRankingAll, statisticalIndicators, flag);
            List sortList = salespersonRankingTotal.stream().filter(f -> null != f.getUserId()).collect(Collectors.toList());
            List totalList = salespersonRankingTotal.stream().filter(f -> null == f.getUserId()).collect(Collectors.toList());
            List<SalespersonRankingVo> collect = sortList.stream().sorted(comparator).collect(Collectors.toList());
            collect.addAll(totalList);
            return collect;
        }
        return this.getSalespersonRankingTotal(salespersonRankingVoList, salespersonRankingAll, statisticalIndicators, flag);
    }

    private List<SalespersonRankingVo> getSalespersonRankingTotal(List<SalespersonRankingVo> salespersonRankingVos, List<SalespersonRankingVo> salespersonRankingAll, int statisticalIndicators, boolean flag) {
        if (salespersonRankingVos.isEmpty()) {
            return new ArrayList<SalespersonRankingVo>();
        }
        double winningAmountTotal = salespersonRankingVos.stream().mapToDouble(SalespersonRankingVo::getWinningAmount).sum();
        double earlyStartAmountTotal = salespersonRankingVos.stream().mapToDouble(SalespersonRankingVo::getEarlyStartAmount).sum();
        double transactionTotal = salespersonRankingVos.stream().mapToDouble(SalespersonRankingVo::getTransactionAmount).sum();
        int winningNumber = salespersonRankingVos.stream().mapToInt(SalespersonRankingVo::getWinningNumber).sum();
        int earlyStartNumber = salespersonRankingVos.stream().mapToInt(SalespersonRankingVo::getEarlyStartNumber).sum();
        int transactionNumber = salespersonRankingVos.stream().mapToInt(SalespersonRankingVo::getTransactionNumber).sum();
        int statisticalQuantity = salespersonRankingVos.stream().mapToInt(SalespersonRankingVo::getStatisticalQuantity).sum();
        SalespersonRankingVo salespersonRankingVo = new SalespersonRankingVo();
        salespersonRankingVo.setWinningAmount(winningAmountTotal);
        salespersonRankingVo.setEarlyStartAmount(earlyStartAmountTotal);
        salespersonRankingVo.setTransactionAmount(transactionTotal);
        salespersonRankingVo.setWinningNumber(winningNumber);
        salespersonRankingVo.setEarlyStartNumber(earlyStartNumber);
        salespersonRankingVo.setTransactionNumber(transactionNumber);
        salespersonRankingVo.setStatisticalQuantity(statisticalQuantity);
        salespersonRankingVo.setUserName("\u5408\u8ba1" + salespersonRankingVos.size() + "\u4e2a\u4eba");
        salespersonRankingVo.setDeptName(salespersonRankingVos.stream().map(SalespersonRankingVo::getDeptId).collect(Collectors.toSet()).size() + "\u4e2a\u90e8\u95e8");
        salespersonRankingVo.setRankNumber(0);
        salespersonRankingVos.add(salespersonRankingVo);
        return salespersonRankingVos;
    }

    private Comparator<SalespersonBehaviorVo> getComparatorBehavior(String sort, Function<SalespersonBehaviorVo, Comparable> keyExtractor) {
        switch (sort) {
            case "0": {
                return Comparator.comparing(keyExtractor);
            }
            case "1": {
                return Comparator.comparing(keyExtractor).reversed();
            }
        }
        throw new IllegalArgumentException("Invalid statisticalIndicators value: " + sort);
    }

    private Comparator<SalespersonRankingVo> getComparatorRank(String sort, Function<SalespersonRankingVo, Comparable> keyExtractor) {
        switch (sort) {
            case "0": {
                return Comparator.comparing(keyExtractor);
            }
            case "1": {
                return Comparator.comparing(keyExtractor).reversed();
            }
        }
        throw new IllegalArgumentException("Invalid statisticalIndicators value: " + sort);
    }

    @Override
    public Page behaviorPopUp(SalespersonBehaviorDto salespersonBehaviorDto) {
        String popUpSign;
        DateConvertVo currentTime;
        if (HussarUtils.isNotEmpty((Object)salespersonBehaviorDto.getTimeRange()) && !"3".equals(salespersonBehaviorDto.getTimeRange()) && (currentTime = IndexUtil.getCurrentTime((String)salespersonBehaviorDto.getTimeRange())) != null) {
            salespersonBehaviorDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            salespersonBehaviorDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        if (HussarUtils.isNotEmpty((Object)(popUpSign = salespersonBehaviorDto.getPopUpSign()))) {
            switch (popUpSign) {
                case "0": {
                    Page pageTotal = this.pageHandlingBehavior(salespersonBehaviorDto);
                    pageTotal.setRecords(this.salespersonAnalysisMapper.getFollowUpClassifyPopUp(salespersonBehaviorDto, (Page<SalespersonAnalysisPopUpRecVo>)pageTotal));
                    return pageTotal;
                }
                case "1": {
                    Page pageCus = this.pageHandlingBehavior(salespersonBehaviorDto);
                    pageCus.setRecords(this.salespersonAnalysisMapper.getFollowUpCusPopUp(salespersonBehaviorDto, (Page<SalespersonAnalysisPopUpCusVo>)pageCus));
                    return pageCus;
                }
                case "2": {
                    Page pageOpp = this.pageHandlingBehavior(salespersonBehaviorDto);
                    pageOpp.setRecords(this.salespersonAnalysisMapper.getFollowUpOppPopUp(salespersonBehaviorDto, (Page<SalespersonAnalysisPopUpOppVo>)pageOpp));
                    return pageOpp;
                }
                case "3": {
                    Page pageClassify = this.pageHandlingBehavior(salespersonBehaviorDto);
                    pageClassify.setRecords(this.salespersonAnalysisMapper.getFollowUpClassifyPopUp(salespersonBehaviorDto, (Page<SalespersonAnalysisPopUpRecVo>)pageClassify));
                    return pageClassify;
                }
                case "4": {
                    return this.getSignificantRecord(salespersonBehaviorDto, true);
                }
                case "5": {
                    return this.getSignificantRecord(salespersonBehaviorDto, false);
                }
            }
            return new Page();
        }
        return new Page();
    }

    Page<SalespersonAnalysisPopUpRecVo> getSignificantRecord(SalespersonBehaviorDto salespersonBehaviorDto, boolean isSignificant) {
        List<TrackRecordAPIVo> recordList = this.salespersonAnalysisMapper.selectRecordBySalePersonAnalysisDto(salespersonBehaviorDto);
        List dicSingleList = this.sysDicRefService.getDictByType("common_follow");
        Map<String, String> dicMap = dicSingleList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("insignificant_record");
        String keywords = crmBaseConfigVo.getConfigValue();
        ArrayList<SalespersonAnalysisPopUpRecVo> list = new ArrayList<SalespersonAnalysisPopUpRecVo>();
        for (TrackRecordAPIVo record : recordList) {
            SalespersonAnalysisPopUpRecVo vo;
            if (Pattern.matches("(?i).*" + keywords + ".*", record.getRecordContent())) {
                if (isSignificant) continue;
                vo = new SalespersonAnalysisPopUpRecVo(record.getRecordId(), record.getRecordContent(), record.getTypeId(), record.getBusinessName(), record.getBusinessType(), record.getRecordType(), dicMap.get(record.getRecordType()), record.getCreatePerson(), record.getCreatePersonName(), record.getDepartmentId(), record.getDepartmentName(), record.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                list.add(vo);
                continue;
            }
            if (!isSignificant) continue;
            vo = new SalespersonAnalysisPopUpRecVo(record.getRecordId(), record.getRecordContent(), record.getTypeId(), record.getBusinessName(), record.getBusinessType(), record.getRecordType(), dicMap.get(record.getRecordType()), record.getCreatePerson(), record.getCreatePersonName(), record.getDepartmentId(), record.getDepartmentName(), record.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            list.add(vo);
        }
        list.sort((o1, o2) -> o1.getChargePersonId().compareTo(o2.getChargePersonId()));
        Page page = this.pageHandlingBehavior(salespersonBehaviorDto);
        if ((long)list.size() <= page.getSize() * (page.getCurrent() - 1L)) {
            page.setCurrent(1L);
        }
        if ((long)list.size() > page.getCurrent() * page.getSize()) {
            page.setRecords(list.subList((int)((page.getCurrent() - 1L) * page.getSize()), (int)(page.getCurrent() * page.getSize())));
        } else {
            page.setRecords(list.subList((int)((page.getCurrent() - 1L) * page.getSize()), list.size()));
        }
        page.setTotal((long)list.size());
        return page;
    }

    @Override
    public Page rankingPopUp(SalespersonRankingDto salespersonRankingDto) {
        if (HussarUtils.isNotEmpty((Object)salespersonRankingDto.getTimeRange())) {
            com.jxdinfo.crm.common.api.util.entity.DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)salespersonRankingDto.getTimeRange());
            salespersonRankingDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            salespersonRankingDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        List<Long> winStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0")).stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        salespersonRankingDto.setSuccessStageList(winStageList);
        CrmBaseConfigVo tqkg = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        List<Long> tqkgList = Arrays.stream(tqkg.getConfigValue().split(",")).map(Long::parseLong).collect(Collectors.toList());
        salespersonRankingDto.setOtherWinStageList(tqkgList);
        ArrayList<Long> stageIds = new ArrayList<Long>();
        stageIds.addAll(winStageList);
        stageIds.addAll(tqkgList);
        salespersonRankingDto.setStageIds(stageIds);
        int statisticalIndicators = salespersonRankingDto.getStatisticalIndicators();
        if (HussarUtils.isNotEmpty((Object)statisticalIndicators)) {
            switch (statisticalIndicators) {
                case 0: 
                case 1: {
                    Page page0 = this.pageHandling(salespersonRankingDto);
                    page0.setRecords(this.salespersonAnalysisMapper.getRankingPopUpOppAmount(salespersonRankingDto, (Page<SalespersonAnalysisPopUpOppVo>)page0));
                    return page0;
                }
                case 2: {
                    Page page2 = this.pageHandling(salespersonRankingDto);
                    page2.setRecords(this.salespersonAnalysisMapper.getRankingPopUpOppNewNum(salespersonRankingDto, (Page<SalespersonAnalysisPopUpOppVo>)page2));
                    return page2;
                }
                case 3: {
                    Page page3 = this.pageHandling(salespersonRankingDto);
                    page3.setRecords(this.salespersonAnalysisMapper.getRankingPopUpCus(salespersonRankingDto, (Page<SalespersonAnalysisPopUpCusVo>)page3));
                    return page3;
                }
                case 4: {
                    Page page4 = this.pageHandling(salespersonRankingDto);
                    List<SalespersonAnalysisPopUpRecVo> rankingPopUprRec = this.salespersonAnalysisMapper.getRankingPopUprRec(salespersonRankingDto, (Page<SalespersonAnalysisPopUpRecVo>)page4);
                    if (!rankingPopUprRec.isEmpty()) {
                        rankingPopUprRec.forEach(f -> {
                            if ("1".equals(f.getBusinessType())) {
                                f.setBusinessName(null != f.getBusinessName() ? "\u3010\u5546\u673a\u3011 " + f.getBusinessName() : "\u3010\u5546\u673a\u3011");
                            } else if ("2".equals(f.getBusinessType())) {
                                f.setBusinessName(null != f.getBusinessName() ? "\u3010\u5ba2\u6237\u3011 " + f.getBusinessName() : "\u3010\u5ba2\u6237\u3011");
                            } else if ("3".equals(f.getBusinessType())) {
                                f.setBusinessName(null != f.getBusinessName() ? "\u3010\u8054\u7cfb\u4eba\u3011 " + f.getBusinessName() : "\u3010\u8054\u7cfb\u4eba\u3011");
                            }
                        });
                    }
                    page4.setRecords(rankingPopUprRec);
                    return page4;
                }
                case 5: {
                    Page page5 = this.pageHandling(salespersonRankingDto);
                    page5.setRecords(this.salespersonAnalysisMapper.getRankingPopUpPro(salespersonRankingDto, (Page<SalespersonAnalysisPopUpProVo>)page5));
                    return page5;
                }
            }
            return new Page();
        }
        return new Page();
    }

    private Page pageHandlingBehavior(SalespersonBehaviorDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        return page;
    }

    private Page pageHandling(SalespersonRankingDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        return page;
    }

    @Override
    public void salespersonBehaviorExport(HttpServletResponse response, SalespersonBehaviorDto dto) {
        List<SalespersonBehaviorVo> returnList = this.salespersonBehaviorAnalysis(dto);
        String[] titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u8ddf\u8fdb\u603b\u6b21\u6570", "\u8ddf\u8fdb\u5ba2\u6237\u6570", "\u8ddf\u8fdb\u5546\u673a\u6570", "\u6253\u7535\u8bdd\u6570", "\u62dc\u8bbf\u5ba2\u6237\u6570", "\u7ebf\u4e0a\u4f1a\u8bae\u6570", "\u53d1\u4fe1\u606f\u6570", "\u5ba2\u6237\u6765\u8bbf\u6570", "\u5176\u4ed6\u6570", "\u5185\u90e8\u7814\u8ba8\u6570"};
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            String lastFileName = "\u9500\u552e\u4eba\u5458\u884c\u4e3a\u5206\u6790.xlsx";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            String sheetName = "Sheet1";
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
            Row dataRowTitle = sheet.createRow(0);
            for (int i = 0; i < titleStrings.length; ++i) {
                Cell titleCell = dataRowTitle.createCell(i);
                titleCell.setCellType(CellType.STRING);
                titleCell.setCellStyle(style);
                titleCell.setCellValue(titleStrings[i]);
            }
            if (returnList != null && !returnList.isEmpty()) {
                for (int index = 0; index < returnList.size(); ++index) {
                    SXSSFRow dataRow = workbook.getSheet(sheetName).createRow(index + 1);
                    SalespersonBehaviorVo cav = returnList.get(index);
                    block18: for (int i = 0; i < titleStrings.length; ++i) {
                        Cell cell = dataRow.createCell(i);
                        if (i == 0 || i == 1 || i == 13) {
                            cell.setCellType(CellType.STRING);
                        } else {
                            cell.setCellType(CellType.NUMERIC);
                        }
                        cell.setCellStyle(style);
                        switch (i) {
                            case 0: {
                                cell.setCellValue(cav.getUserName());
                                continue block18;
                            }
                            case 1: {
                                cell.setCellValue(cav.getDeptName());
                                continue block18;
                            }
                            case 2: {
                                cell.setCellValue((double)cav.getTotalNumber());
                                continue block18;
                            }
                            case 3: {
                                cell.setCellValue((double)cav.getCustomersNumber());
                                continue block18;
                            }
                            case 4: {
                                cell.setCellValue((double)cav.getOpportunityNumber());
                                continue block18;
                            }
                            case 5: {
                                cell.setCellValue((double)cav.getPhone());
                                continue block18;
                            }
                            case 6: {
                                cell.setCellValue((double)cav.getVisitCustomers());
                                continue block18;
                            }
                            case 7: {
                                cell.setCellValue((double)cav.getOnlineConference());
                                continue block18;
                            }
                            case 8: {
                                cell.setCellValue((double)cav.getMessage());
                                continue block18;
                            }
                            case 9: {
                                cell.setCellValue((double)cav.getCustomerVisit());
                                continue block18;
                            }
                            case 10: {
                                cell.setCellValue((double)cav.getOther());
                                continue block18;
                            }
                            case 11: {
                                cell.setCellValue((double)cav.getDiscussion());
                                continue block18;
                            }
                        }
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void salespersonRankingExport(HttpServletResponse response, SalespersonRankingDto dto) {
        List<SalespersonRankingVo> returnList = this.salespersonRankingAnalysis(dto);
        int statisticalIndicators = dto.getStatisticalIndicators();
        String[] titleStrings = new String[]{};
        switch (statisticalIndicators) {
            case 0: {
                titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u8d62\u5355\u91d1\u989d", "\u63d0\u524d\u5f00\u5de5\u91d1\u989d", "\u6210\u4ea4\u91d1\u989d(\u8d62\u5355+\u63d0\u524d\u5f00\u5de5)", "\u6210\u4ea4\u5546\u673a\u91d1\u989d\u6392\u540d"};
                break;
            }
            case 1: {
                titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u8d62\u5355\u5546\u673a\u6570", "\u63d0\u524d\u5f00\u5de5\u5546\u673a\u6570", "\u6210\u4ea4\u5546\u673a\u6570(\u8d62\u5355+\u63d0\u524d\u5f00\u5de5)", "\u6210\u4ea4\u5546\u673a\u6570\u6392\u540d"};
                break;
            }
            case 2: {
                titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u65b0\u589e\u5546\u673a\u6570", "\u65b0\u589e\u5546\u673a\u6570\u6392\u540d"};
                break;
            }
            case 3: {
                titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u65b0\u589e\u5ba2\u6237\u6570", "\u65b0\u589e\u5ba2\u6237\u6570\u6392\u540d"};
                break;
            }
            case 4: {
                titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u65b0\u589e\u8ddf\u8fdb\u8bb0\u5f55\u6570", "\u65b0\u589e\u8ddf\u8fdb\u8bb0\u5f55\u6570\u6392\u540d"};
                break;
            }
            case 5: {
                titleStrings = new String[]{"\u9500\u552e\u4eba\u5458", "\u6240\u5c5e\u90e8\u95e8", "\u4ea7\u54c1\u9500\u91cf", "\u4ea7\u54c1\u9500\u91cf\u6392\u540d"};
                break;
            }
        }
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            String lastFileName = "\u9500\u552e\u4eba\u5458\u6392\u884c\u5206\u6790.xlsx";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            String sheetName = "Sheet1";
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
            Row dataRowTitle = sheet.createRow(0);
            for (int i = 0; i < titleStrings.length; ++i) {
                Cell titleCell = dataRowTitle.createCell(i);
                titleCell.setCellType(CellType.STRING);
                titleCell.setCellStyle(style);
                titleCell.setCellValue(titleStrings[i]);
            }
            if (returnList != null && !returnList.isEmpty()) {
                for (int index = 0; index < returnList.size(); ++index) {
                    SXSSFRow dataRow = workbook.getSheet(sheetName).createRow(index + 1);
                    SalespersonRankingVo cav = returnList.get(index);
                    block34: for (int i = 0; i < titleStrings.length; ++i) {
                        Cell cell = dataRow.createCell(i);
                        if (i == 0 || i == 1 || i == 13) {
                            cell.setCellType(CellType.STRING);
                        } else {
                            cell.setCellType(CellType.NUMERIC);
                        }
                        cell.setCellStyle(style);
                        if (statisticalIndicators == 0) {
                            switch (i) {
                                case 0: {
                                    cell.setCellValue(cav.getUserName());
                                    break;
                                }
                                case 1: {
                                    cell.setCellValue(cav.getDeptName());
                                    break;
                                }
                                case 2: {
                                    cell.setCellValue(cav.getWinningAmount());
                                    break;
                                }
                                case 3: {
                                    cell.setCellValue(cav.getEarlyStartAmount());
                                    break;
                                }
                                case 4: {
                                    cell.setCellValue(cav.getTransactionAmount());
                                    break;
                                }
                                case 5: {
                                    cell.setCellValue((double)cav.getRankNumber());
                                    break;
                                }
                            }
                            continue;
                        }
                        if (statisticalIndicators == 1) {
                            switch (i) {
                                case 0: {
                                    cell.setCellValue(cav.getUserName());
                                    break;
                                }
                                case 1: {
                                    cell.setCellValue(cav.getDeptName());
                                    break;
                                }
                                case 2: {
                                    cell.setCellValue((double)cav.getWinningNumber());
                                    break;
                                }
                                case 3: {
                                    cell.setCellValue((double)cav.getEarlyStartNumber());
                                    break;
                                }
                                case 4: {
                                    cell.setCellValue((double)cav.getTransactionNumber());
                                    break;
                                }
                                case 5: {
                                    cell.setCellValue((double)cav.getRankNumber());
                                    break;
                                }
                            }
                            continue;
                        }
                        switch (i) {
                            case 0: {
                                cell.setCellValue(cav.getUserName());
                                continue block34;
                            }
                            case 1: {
                                cell.setCellValue(cav.getDeptName());
                                continue block34;
                            }
                            case 2: {
                                cell.setCellValue((double)cav.getStatisticalQuantity());
                                continue block34;
                            }
                            case 3: {
                                cell.setCellValue((double)cav.getRankNumber());
                                continue block34;
                            }
                        }
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<SalespersonBehaviorVo> selectSignificantRecordCount(SalespersonBehaviorDto dto) {
        List<TrackRecordAPIVo> recordList = this.salespersonAnalysisMapper.selectRecordBySalePersonAnalysisDto(dto);
        Map<Long, List<TrackRecordAPIVo>> idRecordListMap = recordList.stream().collect(Collectors.groupingBy(TrackRecordAPIVo::getCreatePerson));
        ArrayList<SalespersonBehaviorVo> result = new ArrayList<SalespersonBehaviorVo>();
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("insignificant_record");
        String keywords = crmBaseConfigVo.getConfigValue();
        for (Map.Entry<Long, List<TrackRecordAPIVo>> listEntry : idRecordListMap.entrySet()) {
            int countSignificant = 0;
            int countInsignificant = 0;
            for (TrackRecordAPIVo record : listEntry.getValue()) {
                if (Pattern.matches("(?i).*" + keywords + ".*", record.getRecordContent())) {
                    ++countInsignificant;
                    continue;
                }
                ++countSignificant;
            }
            SalespersonBehaviorVo vo = new SalespersonBehaviorVo();
            vo.setUserId(listEntry.getKey());
            vo.setInsignificantRecordCount(countInsignificant);
            vo.setSignificantRecordCount(countSignificant);
            result.add(vo);
        }
        for (Long id : dto.getUserIds()) {
            if (idRecordListMap.containsKey(id)) continue;
            SalespersonBehaviorVo vo = new SalespersonBehaviorVo();
            vo.setUserId(id);
            vo.setSignificantRecordCount(0);
            vo.setInsignificantRecordCount(0);
            result.add(vo);
        }
        return result;
    }

    private void clearDateTime(SalesStatisticsDto salesStatisticsDto) {
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getStartTime())) {
            salesStatisticsDto.setStartTime(null);
        }
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getEndTime())) {
            salesStatisticsDto.setEndTime(null);
        }
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getSuccessStartDate())) {
            salesStatisticsDto.setSuccessStartDate(null);
        }
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getSuccessEndDate())) {
            salesStatisticsDto.setSuccessEndDate(null);
        }
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getSuccessEndDate())) {
            salesStatisticsDto.setSuccessEndDate(null);
        }
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getBeginTime())) {
            salesStatisticsDto.setBeginTime(null);
        }
        if (StringUtil.isEmpty((Object)salesStatisticsDto.getFinalTime())) {
            salesStatisticsDto.setFinalTime(null);
        }
    }

    private void clearDateTime(SalePersonAnalysisDto salePersonAnalysisDto) {
        if (StringUtil.isEmpty((Object)salePersonAnalysisDto.getStartTime())) {
            salePersonAnalysisDto.setStartTime(null);
        }
        if (StringUtil.isEmpty((Object)salePersonAnalysisDto.getFinalTime())) {
            salePersonAnalysisDto.setFinalTime(null);
        }
        if (StringUtil.isEmpty((Object)salePersonAnalysisDto.getStartDate())) {
            salePersonAnalysisDto.setStartDate(null);
        }
        if (StringUtil.isEmpty((Object)salePersonAnalysisDto.getEndDate())) {
            salePersonAnalysisDto.setEndDate(null);
        }
    }

    @Override
    public Page getRecordList(SalespersonBehaviorDto salespersonBehaviorDto) {
        DateConvertVo currentTime;
        if (HussarUtils.isNotEmpty((Object)salespersonBehaviorDto.getTimeRange()) && !"3".equals(salespersonBehaviorDto.getTimeRange()) && (currentTime = IndexUtil.getCurrentTime((String)salespersonBehaviorDto.getTimeRange())) != null) {
            salespersonBehaviorDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            salespersonBehaviorDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        Page pageClassify = this.pageHandlingBehavior(salespersonBehaviorDto);
        pageClassify.setRecords(this.salespersonAnalysisMapper.getRecordList(salespersonBehaviorDto, (Page<SalespersonAnalysisPopUpRecVo>)pageClassify));
        return pageClassify;
    }
}

