/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.common;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.analysis.common.vo.RolePermissionsVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.provincerole.dao.ProvinceRoleMapper;
import com.jxdinfo.crm.core.provincerole.model.ProvinceRole;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CommonUtil {
    @Resource
    private CrmCommonProperties crmProperties;
    public static String OPPO_VIEW_SALES_ANALYSIS = "salespersonAnalysis";

    public RolePermissionsVo getRolePermissions() {
        RolePermissionsVo dto = new RolePermissionsVo();
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        List struList = DataPermission.getStruCache();
        List leadershipRoles = DataPermission.getLeadershipRoles();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            dto.setPermissionDeptIds(null);
        } else if (DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) {
            List struIds = DataPermission.getLeadershipBGList((Long)user.getUserId());
            ArrayList deptIdList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)struIds)) {
                for (String struId : struIds) {
                    List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            List<Long> deptLongIds = deptIdList.stream().map(Long::valueOf).collect(Collectors.toList());
            ProvinceRoleMapper provinceRoleMapper = (ProvinceRoleMapper)SpringUtils.getBean(ProvinceRoleMapper.class);
            List provinceRoles = provinceRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().in(ProvinceRole::getRoleId, (Collection)userRoles));
            if (CollectionUtil.isNotEmpty((Collection)provinceRoles)) {
                dto.setPermissionProvinceIds(provinceRoles.stream().map(ProvinceRole::getProvinceId).collect(Collectors.toList()));
            }
            dto.setPermissionDeptIds(deptLongIds);
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader()))) {
            Long parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId());
            List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)parentId);
            List<Long> deptLongIds = deptIds.stream().map(Long::valueOf).collect(Collectors.toList());
            dto.setPermissionDeptIds(deptLongIds);
        }
        return dto;
    }
}

