/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.jxdinfo.crm.agent.api.service.IAgentDataRightModuleService;
import com.jxdinfo.crm.agent.dao.AgentPermissionMapper;
import com.jxdinfo.crm.agent.service.IAgentPermissionService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityDataRightModuleService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AgentPermissionServiceImpl
implements IAgentPermissionService {
    @Resource
    private AgentPermissionMapper agentPermissionMapper;
    @Resource
    private IAgentDataRightModuleService agentDataRightModuleService;
    @Resource
    private IMarketingActivityDataRightModuleService marketingActivityDataRightModuleService;

    @Override
    public List<Long> getAgentIdListByPermission(Long userId) {
        SecurityUser user;
        if (userId == null) {
            user = BaseSecurityUtil.getUser();
        } else {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(userId);
        }
        PermissionDto agentPermissionDto = this.agentDataRightModuleService.getUserRolePermission(user);
        PermissionDto campaignPermissionDto = this.marketingActivityDataRightModuleService.getUserRolePermission(user);
        if (agentPermissionDto.getPermissionDeptIds() == null && agentPermissionDto.getPermissionUserId() == null) {
            return null;
        }
        List<Long> agentIdList = this.agentPermissionMapper.getAgentIdList(agentPermissionDto, campaignPermissionDto);
        if (CollectionUtil.isEmpty(agentIdList)) {
            agentIdList.add(-1L);
        }
        return agentIdList;
    }
}

