/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.api.service.IAgentContactDataRightModuleService;
import com.jxdinfo.crm.agent.dao.AgentContactMapper;
import com.jxdinfo.crm.agent.dao.AgentMapper;
import com.jxdinfo.crm.agent.dto.AgentContactDto;
import com.jxdinfo.crm.agent.model.AgentContactEntity;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.agent.service.IAgentContactService;
import com.jxdinfo.crm.agent.service.IAgentService;
import com.jxdinfo.crm.agent.vo.AgentContactVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.fileInfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.model.BaseArea1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AgentContactServiceImpl
extends ServiceImpl<AgentContactMapper, AgentContactEntity>
implements IAgentContactService {
    @Resource
    private AgentContactMapper agentContactMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private BaseArea1Service area1Service;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private FocusService focusService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private IAgentService agentService;
    @Resource
    private AgentMapper agentMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private IAgentContactDataRightModuleService agentContactDataRightModuleService;
    @Resource
    private IHussarBaseResourceAdapter hussarBaseResourceAdapter;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;

    @Override
    public Page<AgentContactEntity> selectAgentContactList(AgentContactDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<Object> dtoList = new ArrayList();
        PermissionDto permissionDto = new PermissionDto();
        dtoList = this.agentContactMapper.selectAgentContactListNoPermission(dto, page, permissionDto);
        page.setRecords(dtoList);
        return page;
    }

    @Override
    public Page<AgentContactEntity> selectAgentContactListPermission(AgentContactDto dto) {
        PermissionDto permissionDto = this.agentContactOperate(dto);
        ArrayList<AgentContactDto> dtoList = new ArrayList<AgentContactDto>();
        dtoList.add(this.agentContactQueryCondition(dto));
        Page page = dto.getPage();
        List<AgentContactEntity> list = this.agentContactMapper.selectAgentContactList(dtoList, page, dto.getCurrentUserId(), dto.getTimeOrder(), permissionDto);
        page.setRecords(list);
        return page;
    }

    private AgentContactDto agentContactQueryCondition(AgentContactDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getContactScreening())) {
            dto.setContactScreening(dto.getContactScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        List<String> chargerPersonIds = dto.getChargePersonIds();
        if (CollectionUtil.isNotEmpty(chargerPersonIds)) {
            for (String userId : chargerPersonIds) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(departments)) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (!CollectionUtil.isNotEmpty((Collection)idsTemp)) continue;
                odpIds.addAll(idsTemp);
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }

    private PermissionDto agentContactOperate(AgentContactDto dto) {
        PermissionDto permissionDto = new PermissionDto();
        if (dto != null) {
            permissionDto = this.agentContactDataRightModuleService.getCurrentUserRolePermissions();
        }
        return permissionDto;
    }

    @Override
    public AgentContactVo getAgentContactDetailById(Long agentContactId) {
        List areaLabelList;
        if (!this.isOperate(agentContactId).getViewOperate().booleanValue()) {
            return null;
        }
        AgentContactEntity agentContactEntity = (AgentContactEntity)this.getById(agentContactId);
        if (agentContactEntity == null || "1".equals(agentContactEntity.getDelFlag())) {
            return null;
        }
        AgentContactVo agentContactVo = (AgentContactVo)BeanUtil.copy((Object)agentContactEntity, AgentContactVo.class);
        assert (agentContactVo != null);
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getSex())) {
            agentContactVo.setSex(this.sysDicRefService.getDictLabel("sex", agentContactVo.getSex()));
        }
        if (HussarUtils.isNotEmpty((Object)agentContactVo.getSecurityLevel()) && agentContactVo.getSecurityLevel() > 0) {
            agentContactVo.setSecurityLevelLabel(this.sysDicRefService.getDictLabel("security_level", String.valueOf(agentContactVo.getSecurityLevel())));
        } else {
            agentContactVo.setSecurityLevelLabel("");
        }
        ArrayList<String> areaList = new ArrayList<String>();
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getProvince())) {
            areaList.add(agentContactVo.getProvince());
        }
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getCity())) {
            areaList.add(agentContactVo.getCity());
        }
        if (StringUtil.isNotBlank((CharSequence)agentContactVo.getCounty())) {
            areaList.add(agentContactVo.getCounty());
        }
        if (areaList.size() > 0 && (areaLabelList = this.area1Service.list((Wrapper)new LambdaQueryWrapper().in(BaseArea1::getBaseAreaid, areaList))) != null) {
            for (BaseArea1 area : areaLabelList) {
                if (StringUtil.isNotBlank((CharSequence)agentContactVo.getProvince()) && String.valueOf(area.getBaseAreaid()).equals(agentContactVo.getProvince())) {
                    agentContactVo.setProvince(area.getName());
                }
                if (StringUtil.isNotBlank((CharSequence)agentContactVo.getCity()) && String.valueOf(area.getBaseAreaid()).equals(agentContactVo.getCity())) {
                    agentContactVo.setCity(area.getName());
                }
                if (!StringUtil.isNotBlank((CharSequence)agentContactVo.getCounty()) || !String.valueOf(area.getBaseAreaid()).equals(agentContactVo.getCounty())) continue;
                agentContactVo.setCounty(area.getName());
            }
        }
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(agentContactVo.getAgentContactId());
        List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(agentContactId);
        if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
            businessIds.addAll(fileRecordIds);
        }
        FileInfoAPIDto fileInfoDto = new FileInfoAPIDto();
        fileInfoDto.setBusinessIds(businessIds);
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
            fileInfoDto.setSecurityLevel(userSecurityLevel);
        }
        agentContactVo.setFileCount(this.fileInfoAPIService.countFile(fileInfoDto));
        agentContactVo.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentContactVo.getAgentContactId())).eq(TeamMeberEntity::getBusinessType, (Object)"18")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        SecurityUser user = BaseSecurityUtil.getUser();
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)agentContactVo.getAgentContactId())).eq(FocusEntity::getBusinessType, (Object)"18")).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        agentContactVo.setFocus(focusCount > 0L);
        agentContactVo.setTaskAmount(this.taskAPIService.selectTaskCount("18", agentContactId));
        return agentContactVo;
    }

    @Override
    public OperateVo isOperate(Long agentContactId) {
        OperateVo operateVo = new OperateVo();
        if (agentContactId == null) {
            return operateVo;
        }
        AgentContactEntity agentContactEntity = (AgentContactEntity)this.getById(agentContactId);
        if (agentContactEntity == null || "1".equals(agentContactEntity.getDelFlag())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < agentContactEntity.getSecurityLevel()) {
            return new OperateVo();
        }
        if (Objects.equals(agentContactEntity.getChargePersonId(), user.getUserId())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(1));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(agentContactId, user, operateVo, "18");
        if (!operateVo.getViewOperate().booleanValue()) {
            Integer count = this.agentMapper.getProductManagerByAgentId(agentContactEntity.getAgentId(), "0", user.getUserId());
            if (count > 0) {
                operateVo.setViewOperate(Boolean.valueOf(true));
            } else {
                PermissionDto agentContactPermissionDto = this.agentContactDataRightModuleService.getUserRolePermission(user);
                if (agentContactPermissionDto.getPermissionDeptIds() == null || agentContactPermissionDto.getPermissionDeptIds().contains(agentContactEntity.getOwnDepartment())) {
                    operateVo.setViewOperate(Boolean.valueOf(true));
                }
            }
        }
        return operateVo;
    }

    @Override
    public Map<Long, Boolean> agentContactOperateBatch(SecurityUser user, List<AgentContactEntity> agentContactEntityList, String resourcePath) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>();
        List<Long> agentContactIdList = agentContactEntityList.stream().map(AgentContactEntity::getAgentContactId).collect(Collectors.toList());
        PermissionDto agentContactPermissionDto = this.agentContactDataRightModuleService.getUserRolePermission(user);
        List<Long> operateAgentContactIdList = this.agentContactMapper.selectAgentContactIdOperate(agentContactPermissionDto, agentContactIdList);
        agentContactIdList.forEach(id -> resultMap.put((Long)id, false));
        agentContactIdList.retainAll(operateAgentContactIdList);
        if (CollectionUtil.isNotEmpty(agentContactIdList)) {
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TeamMeberEntity::getBusinessId, agentContactIdList)).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"18"));
            HashSet existingContactIds = new HashSet();
            if (CollectionUtil.isNotEmpty((Collection)teamList)) {
                teamList.forEach(team -> {
                    existingContactIds.add(team.getBusinessId());
                    resultMap.put(team.getBusinessId(), "1".equals(team.getModifyPower()));
                });
                agentContactIdList.removeAll(existingContactIds);
            }
        }
        if (!agentContactIdList.isEmpty()) {
            List elementResourceVos = this.hussarBaseResourceAdapter.elementResources("/crm/agent/agentList", user.getRolesList());
            Set<Object> resourceSet = new HashSet();
            if (CollectionUtil.isNotEmpty((Collection)elementResourceVos) && ((ElementResourceVo)elementResourceVos.get(0)).getPermission() != null) {
                resourceSet = Arrays.stream(((ElementResourceVo)elementResourceVos.get(0)).getPermission().split(",")).collect(Collectors.toSet());
            }
            for (Long contactId : agentContactIdList) {
                try {
                    if (resourceSet.contains(resourcePath)) {
                        resultMap.put(contactId, true);
                        continue;
                    }
                    resultMap.put(contactId, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    resultMap.put(contactId, false);
                }
            }
        }
        return resultMap;
    }

    @Override
    @HussarTransactional
    public Map<String, String> updateAgentContact(AgentContactDto agentContactDto) {
        try {
            OperateRecordAPIVo trackRecord;
            List list;
            LocalDateTime date = LocalDateTime.now();
            HashMap<String, String> result = new HashMap<String, String>();
            AgentContactEntity agentContactEntity = (AgentContactEntity)this.getById(agentContactDto.getAgentContactId());
            if (!agentContactEntity.getAgentContactName().equals(agentContactDto.getAgentContactName()) || !agentContactEntity.getMobilePhone().equals(agentContactDto.getMobilePhone())) {
                AgentEntity agentEntity = (AgentEntity)this.agentService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)agentContactDto.getAgentContactName())).eq(AgentEntity::getAgentNature, (Object)"2")).eq(AgentEntity::getTelephone, (Object)agentContactDto.getMobilePhone()));
                if (ToolUtil.isNotEmpty((Object)agentEntity)) {
                    result.put("result", "1");
                    return result;
                }
                list = this.agentMapper.selectAgentByContact(agentContactDto);
                if (ToolUtil.isNotEmpty(list)) {
                    result.put("result", "2");
                    result.put("agentName", list.get(0).getAgentName());
                    return result;
                }
            }
            agentContactDto.setMobilePhone(agentContactDto.getMobilePhone().replace(" ", ""));
            agentContactDto.setTelephone(agentContactDto.getTelephone().replace(" ", ""));
            agentContactDto.setEmail(agentContactDto.getEmail().replace(" ", ""));
            agentContactDto.setTrackTime(null);
            AgentContactEntity oldAgentContact = (AgentContactEntity)this.getById(agentContactDto.getAgentContactId());
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getAgentContactName()) && ToolUtil.isEmpty((Object)oldAgentContact.getAgentContactName()) || agentContactDto.getAgentContactName().equals(oldAgentContact.getAgentContactName()))) {
                trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getAgentContactName(), agentContactDto.getAgentContactName(), "\u59d3\u540d");
                this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getMobilePhone()) && ToolUtil.isEmpty((Object)oldAgentContact.getMobilePhone()) || agentContactDto.getMobilePhone().equals(oldAgentContact.getMobilePhone()))) {
                trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getMobilePhone(), agentContactDto.getMobilePhone(), "\u624b\u673a");
                this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getTelephone()) && ToolUtil.isEmpty((Object)oldAgentContact.getTelephone()) || agentContactDto.getTelephone().equals(oldAgentContact.getTelephone()))) {
                trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getTelephone(), agentContactDto.getTelephone(), "\u7535\u8bdd");
                this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getEmail()) && ToolUtil.isEmpty((Object)oldAgentContact.getEmail()) || agentContactDto.getEmail().equals(oldAgentContact.getEmail()))) {
                trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldAgentContact.getEmail(), agentContactDto.getEmail(), "\u90ae\u7bb1");
                this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            if (!(ToolUtil.isEmpty((Object)agentContactDto.getSecurityLevel()) && ToolUtil.isEmpty((Object)oldAgentContact.getSecurityLevel()) || agentContactDto.getSecurityLevel().equals(oldAgentContact.getSecurityLevel()))) {
                list = this.sysDicRefService.getDictByType("security_level");
                Integer oldSecurityLevel = oldAgentContact.getSecurityLevel();
                Integer newSecurityLevel = agentContactDto.getSecurityLevel();
                String oldLabel = "";
                String newLabel = "";
                for (DicSingle dicSingle : list) {
                    if (!dicSingle.getValue().equals(oldSecurityLevel.toString())) continue;
                    oldLabel = dicSingle.getLabel();
                    break;
                }
                for (DicSingle dicSingle : list) {
                    if (!dicSingle.getValue().equals(newSecurityLevel.toString())) continue;
                    newLabel = dicSingle.getLabel();
                    break;
                }
                OperateRecordAPIVo trackRecord2 = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldLabel, newLabel, "\u6570\u636e\u5bc6\u7ea7");
                this.operateRecordAPIService.saveOperateLog(trackRecord2, CrmBusinessTypeEnum.AGENT_CONTACT, agentContactDto.getAgentContactId(), agentContactDto.getAgentContactName(), date, false, Arrays.asList(agentContactDto.getAgentId(), agentContactDto.getAgentContactId()));
            }
            AgentContactEntity agentContactEntity2 = new AgentContactEntity();
            BeanUtils.copyProperties((Object)((Object)agentContactDto), (Object)agentContactEntity2);
            this.saveOrUpdate(agentContactEntity2);
            this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(agentContactEntity2.getAgentContactId(), agentContactEntity2.getSecurityLevel());
            this.taskAPIService.updateTaskSecurityLevel(agentContactEntity2.getAgentContactId(), agentContactEntity2.getSecurityLevel());
            this.fileInfoAPIService.updateTrackFileInfoSecurityLevel(agentContactEntity2.getAgentContactId(), agentContactEntity2.getSecurityLevel());
            result.put("result", "success");
            return result;
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public boolean deleteAgentContactByAgentContactId(Long agentContactId) {
        Long recCount = this.trackRecordAPIService.countContact(Collections.singletonList(String.valueOf(agentContactId)), "0");
        if (recCount > 0L) {
            throw new BaseException("\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.agentContactMapper.deleteAgentContactByAgentContactId(agentContactId, "1");
        ArrayList<String> agentContactIds = new ArrayList<String>();
        agentContactIds.add(String.valueOf(agentContactId));
        this.teamMeberMapper.updateDelFlagByIds(null, "1", agentContactIds);
        List trackRecordList = this.trackRecordAPIService.list(agentContactIds, null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(agentContactIds, CrmBusinessTypeEnum.AGENT_CONTACT.getId(), "1");
        List lids = agentContactIds.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoAPIService.deleteFileInfoByIds(null, lids);
        return true;
    }

    @Override
    public TransferBatchResultVo agentContactTransferBatch(List<AgentContactDto> dtos) {
        Object teamMeberEntity;
        ArrayList<Object> teamMeberEntityList;
        ArrayList<Object> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId((String)dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName((String)newChargePersonId);
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List agentContactIdList = dtos.stream().map(AgentContactDto::getAgentContactId).collect(Collectors.toList());
        List agentContactEntityList = this.listByIds(agentContactIdList);
        ArrayList<Long> excludeContactIdList = new ArrayList<Long>();
        Map<Long, Boolean> operateMap = this.agentContactOperateBatch(user, agentContactEntityList, "agent_contact_edit");
        for (Map.Entry<Long, Boolean> entry : operateMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            excludeContactIdList.add(entry.getKey());
            ++noPermissionNum;
        }
        for (Long excludeContactId : excludeContactIdList) {
            dtos = dtos.stream().filter(agentContactDto -> !agentContactDto.getAgentContactId().equals(excludeContactId)).collect(Collectors.toList());
        }
        agentContactIdList = dtos.stream().map(AgentContactDto::getAgentContactId).collect(Collectors.toList());
        agentContactEntityList = ToolUtil.isNotEmpty(agentContactIdList) ? this.listByIds(agentContactIdList) : new ArrayList();
        ArrayList<AgentContactDto> dtoList = new ArrayList<AgentContactDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (AgentContactDto dto : dtos) {
            AgentContactEntity agentContactEntity = agentContactEntityList.stream().filter(object -> Objects.equals(object.getAgentContactId(), dto.getAgentContactId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String string = dto.getOldChargePersonId();
            if (newChargePersonId.equals(string) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setAgentContactName(agentContactEntity.getAgentContactName());
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(dto.getAgentContactId());
            teamMeberDto.setPersonId(Long.valueOf(Long.parseLong(newChargePersonId)));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(Boolean.valueOf(true));
            msgList = new ArrayList<Object>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(Boolean.valueOf(false));
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                Object msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg = msg + "\u65e0\u6743\u9650";
                }
                msgList.add(msg);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        this.agentContactMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<Object>();
            for (AgentContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getAgentContactId());
                teamMeberEntity.setDelFlag("1");
                teamMeberEntity.setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (AgentContactDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getAgentContactId());
                teamMeberEntity.setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntity.setIsCharge("0");
                teamMeberEntity.setMemberRole("6");
                teamMeberEntity.setModifyPower(null);
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<AgentContactDto> insertMemberDtoList = new ArrayList<AgentContactDto>();
        ArrayList<AgentContactDto> updateChargeDtoList = new ArrayList<AgentContactDto>();
        for (AgentContactDto agentContactDto2 : dtoList) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(agentContactDto2.getAgentContactId())) continue;
                updateChargeDtoList.add(agentContactDto2);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(agentContactDto2);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (AgentContactDto agentContactDto3 : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(agentContactDto3.getAgentContactId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.valueOf(Long.parseLong(newChargePersonId)), insertMemberDtoList.stream().map(AgentContactDto::getAgentContactId).collect(Collectors.toList()), "1", "1", ((AgentContactDto)((Object)insertMemberDtoList.get(0))).getChangeTime(), "18");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AgentContactDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (AgentContactDto dto : dtoList) {
            String agentName = dto.getAgentName();
            String contactName = dto.getAgentContactName();
            Long agentContactId = dto.getAgentContactId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60";
            String content = "\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)"/crm/sy/yddsy", (String)dto.getAgentContactId().toString(), Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contactAgentDetails?row=" + "\"" + dto.getAgentContactId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60\uff0c\u8054\u7cfb\u4eba\u3010" + contactName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)date, (SecurityUser)user, (String)dto.getNewChargePersonId(), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
            String oldTitle = user.getUserName() + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u4ee3\u7406\u5546\u8054\u7cfb\u4eba";
            String oldContent = "\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u540d\u79f0\u3010" + contactName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage((String)oldTitle, (String)oldContent, (String)"/crm/sy/yddsy", (String)agentContactId.toString(), Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\u3010" + contactName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage((AddSysMessageType)oldAddSysMessageType, (String)oldContentUnify, (LocalDateTime)date, (SecurityUser)user, (String)oldChargePersonId, (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            UnifyUtil.sendMessage((AddSysMessageType)oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("18");
            crmTeamAdminInfoDto.setBusinessId(agentContactId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    public void addTrackRecordBatch(List<AgentContactDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            AgentContactDto dto = dtoList.get(i);
            OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
            trackRecord.setContactId(Long.valueOf(newChargePersonId));
            trackRecord.setContactName(newChargePersonName);
            trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                trackRecord.setOldContactId(oldContactPersonIdList.get(i));
            }
            trackRecord.setOldContactName(oldContactPersonNameList.get(i));
            trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            trackRecord.setBusinessType(CrmBusinessTypeEnum.AGENT_CONTACT.getId());
            trackRecord.setTypeId(dto.getAgentContactId());
            trackRecord.setBusinessName(dto.getAgentContactName());
            trackRecord.setCreatePerson(user.getUserId());
            trackRecord.setCreatePersonName(user.getUserName());
            trackRecord.setCreateTime(date);
            trackRecord.setChangePerson(user.getUserId());
            trackRecord.setChangeTime(date);
            trackRecord.setChangePersonName(user.getUserName());
            trackRecord.setDelflag("0");
            if (trackRecord.getProduceType() == null) {
                trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(trackRecord);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
    }

    @Override
    public List<AgentContactEntity> selectAgentContactListPermissionNoPage(AgentContactDto dto) {
        PermissionDto permissionDto = this.agentContactOperate(dto);
        ArrayList<AgentContactDto> dtoList = new ArrayList<AgentContactDto>();
        dtoList.add(this.agentContactQueryCondition(dto));
        List<AgentContactEntity> list = this.agentContactMapper.selectAgentContactList(dtoList, null, dto.getCurrentUserId(), dto.getTimeOrder(), permissionDto);
        return list;
    }
}

