/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.extral.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.agent.api.dto.AgentApiDto;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.agent.dto.AgentDto;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.agent.service.IAgentContactService;
import com.jxdinfo.crm.agent.service.IAgentPermissionService;
import com.jxdinfo.crm.agent.service.IAgentService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AgentApiServiceImpl
implements IAgentApiService {
    @Resource
    private IAgentContactService agentContactService;
    @Resource
    private IAgentService agentService;
    @Resource
    private IAgentPermissionService agentPermissionService;

    public AgentApiVo getById(Serializable id) {
        AgentEntity agent = (AgentEntity)this.agentService.getById(id);
        return (AgentApiVo)BeanUtil.copy((Object)agent, AgentApiVo.class);
    }

    public boolean updateById(AgentApiVo agent) {
        AgentEntity entity = (AgentEntity)BeanUtil.copy((Object)agent, AgentEntity.class);
        return this.agentService.updateById(entity);
    }

    public List<Long> getAgentIdList(Long userId) {
        return this.agentPermissionService.getAgentIdListByPermission(userId);
    }

    public List<Long> getAgentIdList() {
        return this.agentPermissionService.getAgentIdListByPermission(null);
    }

    public Page<AgentApiVo> getAgentPageList(AgentApiDto dto) {
        AgentDto agentDto = new AgentDto();
        agentDto.setAgentScreeningAgentName(dto.getAgentName());
        agentDto.setSize(dto.getSize());
        agentDto.setCurrent(dto.getCurrent());
        Page<AgentEntity> agentEntityPage = this.agentService.selectAgentPageList(agentDto);
        Page page = new Page(agentEntityPage.getCurrent(), agentEntityPage.getSize(), agentEntityPage.getTotal());
        page.setRecords(BeanUtil.copy((Collection)agentEntityPage.getRecords(), AgentApiVo.class));
        return page;
    }

    public long getCountAgentByName(String name, String alias) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(AgentEntity::getDelFlag, (Object)"0")).like(AgentEntity::getAgentName, (Object)name);
        if (StringUtil.isNotBlank((CharSequence)alias)) {
            ((LambdaQueryWrapper)wrapper.or()).like(AgentEntity::getAgentName, (Object)alias);
        }
        long countAgent = this.agentService.count((Wrapper)wrapper);
        return countAgent;
    }

    public long getCountAgentByMobilePhone(String mobilePhone) {
        long repeatCountAgent = this.agentService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getTelephone, (Object)mobilePhone)).eq(AgentEntity::getDelFlag, (Object)"0"));
        return repeatCountAgent;
    }

    public List<AgentApiVo> selectAgentListByNames(List<String> agentNameList) {
        return this.agentService.selectAgentListByNames(agentNameList);
    }
}

