/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.job;

import com.jxdinfo.crm.agent.dao.AgentMapper;
import com.jxdinfo.crm.agent.job.AgentSigningTimeOutService;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AgentSigningTimeOutServiceImpl
implements AgentSigningTimeOutService {
    @Resource
    private AgentMapper agentMapper;
    @Resource
    private IMessageTemplateService messageTemplateService;
    @Resource
    private UnifyProperties unifyProperties;

    @Override
    public ProcessResult CheckSigningTimeOut() {
        List pushList;
        LocalDateTime date = LocalDateTime.now();
        List<AgentEntity> todayTimeoutList = this.agentMapper.selectSigningTimeoutList(date, 2);
        List<AgentEntity> fiveDayTimeoutList = this.agentMapper.selectSigningTimeoutList(date.plusDays(5L), 3);
        if (CollectionUtil.isNotEmpty(todayTimeoutList)) {
            pushList = this.messageTemplateService.getMessagePushList("2");
            this.timeoutMessagePush(pushList, todayTimeoutList, date);
        }
        if (CollectionUtil.isNotEmpty(fiveDayTimeoutList)) {
            pushList = this.messageTemplateService.getMessagePushList("3");
            this.timeoutMessagePush(pushList, fiveDayTimeoutList, date);
        }
        return new ProcessResult(true);
    }

    private void timeoutMessagePush(List<MessagePushVo> pushList, List<AgentEntity> timeoutList, LocalDateTime date) {
        Map<String, List<MessagePushVo>> pushListMap = pushList.stream().collect(Collectors.groupingBy(MessagePushVo::getBusinessType));
        if (pushListMap.containsKey("4")) {
            List<MessagePushVo> chargeMessageList = pushListMap.get("4");
            for (MessagePushVo vo : chargeMessageList) {
                for (AgentEntity entity : timeoutList) {
                    String content;
                    Long chargePerson = entity.getChargePerson();
                    String agentName = entity.getAgentName();
                    if ("1".equals(vo.getPushDirection())) {
                        content = vo.getMessageContent().replace("${agentName}", agentName);
                        AddSysMessageType addSysMessageType = new AddSysMessageType();
                        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/agentDetails?row=" + "\"" + entity.getAgentId() + "\"";
                        addSysMessageType.setMessageContent(content);
                        addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                        addSysMessageType.setBusinessAddress(unifyWebUrl);
                        addSysMessageType.setUserId(String.valueOf(chargePerson));
                        addSysMessageType.setOpenWay("1");
                        UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
                        continue;
                    }
                    if (!"2".equals(vo.getPushDirection())) continue;
                    content = vo.getMessageContent().replace("${agentName}", agentName);
                    String title = vo.getMessageTitle();
                    EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)"/crm/sy/yddsy", null, Collections.singletonList(String.valueOf(chargePerson)));
                }
            }
        }
        if (pushListMap.containsKey("1")) {
            List<MessagePushVo> personMessageList = pushListMap.get("1");
            for (MessagePushVo vo : personMessageList) {
                for (AgentEntity entity : timeoutList) {
                    String content;
                    String agentName = entity.getAgentName();
                    if ("1".equals(vo.getPushDirection())) {
                        content = vo.getMessageContent().replace("${agentName}", agentName);
                        AddSysMessageType addSysMessageType = new AddSysMessageType();
                        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/agentDetails?row=" + "\"" + entity.getAgentId() + "\"";
                        addSysMessageType.setMessageContent(content);
                        addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                        addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                        addSysMessageType.setBusinessAddress(unifyWebUrl);
                        addSysMessageType.setUserId(String.valueOf(vo.getBusinessId()));
                        addSysMessageType.setOpenWay("1");
                        UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
                        continue;
                    }
                    if (!"2".equals(vo.getPushDirection())) continue;
                    content = vo.getMessageContent().replace("${agentName}", agentName);
                    String title = vo.getMessageTitle();
                    EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)"/crm/sy/yddsy", null, Collections.singletonList(String.valueOf(vo.getBusinessId())));
                }
            }
        }
    }
}

