/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.jxdinfo.crm.agent.dto.AgentAssociativeQueryDto;
import com.jxdinfo.crm.agent.dto.AgentDto;
import com.jxdinfo.crm.agent.service.IAgentAssociativeQueryService;
import com.jxdinfo.crm.agent.vo.AgentAssociativeQueryEnum;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityAPIService;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AgentAssociativeQueryServiceImpl
implements IAgentAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private IMarketingActivityAPIService marketingActivityAPIService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        AgentAssociativeQueryDto agentAssociativeQueryDto = null;
        if (associativeQueryDto instanceof AgentAssociativeQueryDto) {
            agentAssociativeQueryDto = (AgentAssociativeQueryDto)associativeQueryDto;
        }
        assert (agentAssociativeQueryDto != null);
        AgentDto agentDto = agentAssociativeQueryDto.getDto();
        List<String> labelIdList = null;
        String createTimeFlag = null;
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        List<String> agentNatures = null;
        List<String> agentTypes = null;
        List<String> agentOrigins = null;
        List<String> agentLevels = null;
        List<String> cooperativeNatures = null;
        List<String> signingStatusList = null;
        List<String> tradeList = null;
        List<String> teamMemberIdList = null;
        List<String> campaignIds = null;
        if (agentDto != null) {
            labelIdList = agentDto.getLabelIds();
            tradeList = agentDto.getTrades();
            createTimeFlag = agentDto.getCreateTimeFlag();
            ownDepartmentList = agentDto.getOwnDepartments();
            chargePersonIdList = agentDto.getChargePersonIds();
            agentNatures = agentDto.getAgentNatures();
            agentTypes = agentDto.getAgentTypes();
            agentOrigins = agentDto.getAgentOrigins();
            agentLevels = agentDto.getAgentLevels();
            cooperativeNatures = agentDto.getCooperativeNatures();
            signingStatusList = agentDto.getSigningStatusList();
            teamMemberIdList = agentDto.getTeamMemberIds();
            campaignIds = agentDto.getCampaignIds();
        }
        String moduleId = LabelModuleEnum.AGENT.getModuleId();
        List selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryAPIService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelIdList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List selectedAgentLevels = excludeInfoMap.get("selectedAgentLevels");
        selectedAgentLevels = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedAgentLevels, agentLevels, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_LEVELS));
        excludeInfoMap.put("selectedAgentLevels", selectedAgentLevels);
        List selectedAgentOrigins = excludeInfoMap.get("selectedAgentOrigins");
        selectedAgentOrigins = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedAgentOrigins, agentOrigins, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_SOURCE));
        excludeInfoMap.put("selectedAgentOrigins", selectedAgentOrigins);
        List selectedCooperativeNatures = excludeInfoMap.get("selectedCooperativeNatures");
        selectedCooperativeNatures = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCooperativeNatures, cooperativeNatures, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_COOPERATIVE_NATURES));
        excludeInfoMap.put("selectedCooperativeNatures", selectedCooperativeNatures);
        List selectedTrades = excludeInfoMap.get("selectedTrades");
        selectedTrades = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedTrades, tradeList, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.CUSTOMER_INDUSTRY));
        excludeInfoMap.put("selectedTrades", selectedTrades);
        List selectSigningStatusList = excludeInfoMap.get("selectSigningStatusList");
        selectSigningStatusList = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectSigningStatusList, signingStatusList, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_SIGN_STATUS));
        excludeInfoMap.put("selectSigningStatusList", selectSigningStatusList);
        List selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeFlag, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List selectedAgentNatures = excludeInfoMap.get("selectedAgentNatures");
        selectedAgentNatures = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedAgentNatures, agentNatures, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_NATURES));
        excludeInfoMap.put("selectedAgentNatures", selectedAgentNatures);
        List selectedAgentTypes = excludeInfoMap.get("selectedAgentTypes");
        selectedAgentTypes = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedAgentTypes, agentTypes, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_TYPES));
        excludeInfoMap.put("selectedAgentTypes", selectedAgentTypes);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_OWN_DEPARTMENTS));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedTeamMemberIds = excludeInfoMap.get("selectedTeamMemberIds");
        selectedTeamMemberIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedTeamMemberIds, teamMemberIdList, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_TEAM_MEMBER));
        excludeInfoMap.put("selectedTeamMemberIds", selectedTeamMemberIds);
        List<String> selectedCampaignIds = excludeInfoMap.get("selectedCampaignIds");
        List<Long> campaignIdList = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty(campaignIds)) {
            campaignIdList = campaignIds.stream().map(Long::valueOf).collect(Collectors.toList());
        }
        selectedCampaignIds = this.getCampaignIdAssociativeQuery(associativeQueryVoList, keyword, selectedCampaignIds, campaignIdList, this.getAssociateLabelVoByEnum(AgentAssociativeQueryEnum.AGENT_CAMPAIGN));
        excludeInfoMap.put("selectedCampaignIds", selectedCampaignIds);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(AgentAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }

    public List<String> getCampaignIdAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCampaignIds, List<Long> campaignIds, AssociativeLabelVo associativeLabelVo) {
        if (ToolUtil.isNotEmpty(campaignIds)) {
            campaignIds.addAll(campaignIds);
        }
        if (CollectionUtil.isEmpty(selectedCampaignIds)) {
            selectedCampaignIds = new ArrayList<String>();
        } else {
            List selectedCampaignIdList = selectedCampaignIds.stream().map(Long::parseLong).collect(Collectors.toList());
            campaignIds.addAll(selectedCampaignIdList);
        }
        List activityList = this.marketingActivityAPIService.getMarketingActivityList(keyword, campaignIds);
        if (ToolUtil.isNotEmpty((Object)activityList)) {
            for (MarketingActivityAPIVo marketingActivityAPIVo : activityList) {
                AssociativeQueryVo activityAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associativeLabelVo, marketingActivityAPIVo.getCampaignName(), String.valueOf(marketingActivityAPIVo.getCampaignId()));
                associativeQueryVoList.add(activityAssociative);
                selectedCampaignIds.add(String.valueOf(marketingActivityAPIVo.getCampaignId()));
            }
        }
        return selectedCampaignIds;
    }
}

