/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.agent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.constant.AgentEditConstant;
import com.jxdinfo.crm.agent.dao.AgentContactMapper;
import com.jxdinfo.crm.agent.dao.AgentMapper;
import com.jxdinfo.crm.agent.dto.AgentAssociativeQueryDto;
import com.jxdinfo.crm.agent.dto.AgentContactDto;
import com.jxdinfo.crm.agent.dto.AgentDto;
import com.jxdinfo.crm.agent.dto.AgentFinancialInfoDto;
import com.jxdinfo.crm.agent.dto.CheckAgentCompanyDto;
import com.jxdinfo.crm.agent.dto.CheckDuplicateAgentDto;
import com.jxdinfo.crm.agent.model.AgentAuthorizationEntity;
import com.jxdinfo.crm.agent.model.AgentContactEntity;
import com.jxdinfo.crm.agent.model.AgentEntity;
import com.jxdinfo.crm.agent.service.IAgentAssociativeQueryService;
import com.jxdinfo.crm.agent.service.IAgentAuthorizationService;
import com.jxdinfo.crm.agent.service.IAgentContactService;
import com.jxdinfo.crm.agent.service.IAgentService;
import com.jxdinfo.crm.agent.vo.AgentVo;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.util.CrmLabelUtil;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.customer.vo.CheckRepeat;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.financialinfo.entity.FinancialInfoEntity;
import com.jxdinfo.crm.core.financialinfo.service.IFinancialInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.GlobalOpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AgentServiceImpl
extends ServiceImpl<AgentMapper, AgentEntity>
implements IAgentService {
    @Resource
    private AgentMapper agentMapper;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IAgentContactService agentContactService;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private AgentContactMapper agentContactMapper;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private FocusService focusService;
    @Resource
    private GlobalOpportunityService globalOpportunityService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private IAgentAuthorizationService agentAuthorizationService;
    @Resource
    private IAgentAssociativeQueryService agentAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private CustomerService customerService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ILabelService labelService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private IFinancialInfoService financialInfoService;

    @Override
    public Page<AgentEntity> selectAgentPageList(AgentDto dto) {
        if (StringUtil.isEmpty((Object)dto.getAgentView())) {
            dto.setAgentView("1");
        }
        SalesStatisticsDto permissionDto = this.agentOperate(dto);
        List<AgentDto> agentDtoList = this.getAgentDtoList(dto);
        Page page = dto.getPage();
        List<AgentEntity> list = this.agentMapper.selectAgentListCountAgent(agentDtoList, (Page<AgentEntity>)page, dto.getTimeOrder(), dto.getCurrentUserId(), permissionDto);
        page.setRecords(list);
        if (CollectionUtil.isNotEmpty(list)) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.AGENT.getModuleId());
            list.forEach(agentEntity -> agentEntity.setLabelName(CrmLabelUtil.getLabelName((List)labelList, (String)agentEntity.getLabelId())));
        }
        return page;
    }

    @Override
    public AgentVo agentDetails(Long agentId) {
        List fileRecordIds;
        if (CommonConstant.noPermission.equals(this.isOperate(agentId))) {
            return null;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmCommonProperties);
        if (agentId == null) {
            throw new BaseException("\u5ba2\u6237id\u4e3a\u7a7a");
        }
        AgentEntity agentEntity = (AgentEntity)this.getById(agentId);
        if (agentEntity == null || "1".equals(agentEntity.getDelFlag())) {
            return null;
        }
        AgentVo agentVo = (AgentVo)BeanUtil.copy((Object)agentEntity, AgentVo.class);
        assert (agentVo != null);
        agentVo.setSigningStartTime(agentEntity.getSigningStartTime());
        agentVo.setSigningEndTime(agentEntity.getSigningEndTime());
        if ("1".equals(agentEntity.getAgentNature())) {
            long agentContactAmount = this.agentContactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentContactEntity::getAgentId, (Object)agentId)).eq(AgentContactEntity::getDelFlag, (Object)"0"));
            agentVo.setContactAmount(agentContactAmount);
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmCommonProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        long totalOpportunity = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getAgentId, (Object)agentId)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
        agentVo.setOpportunityTotalAmount(totalOpportunity);
        long totalCustomer = this.customerService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getAgentId, (Object)agentId)).eq(CustomerEntity::getDelFlag, (Object)"0"));
        agentVo.setCustomerTotalAmount(totalCustomer);
        agentVo.setOpportunityUnfinishedAmount(0L);
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(agentVo.getAgentId().toString()), Collections.singletonList("17"), null, "0");
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(agentVo.getAgentId());
        if (CollectionUtil.isNotEmpty((Collection)recordList)) {
            for (TrackRecordAPIVo record : recordList) {
                businessIds.add(record.getRecordId());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(agentId)))) {
            businessIds.addAll(fileRecordIds);
        }
        agentVo.setFileInfoAmount(this.fileInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1")));
        agentVo.setTeamMemberAmount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentVo.getAgentId())).eq(TeamMeberEntity::getBusinessType, (Object)"17")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        agentVo.setCharacterAmount(this.taskAPIService.selectTaskCount("17", agentId));
        agentVo.setScheduleAmount(0L);
        long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)agentVo.getAgentId())).eq(FocusEntity::getBusinessType, (Object)"17")).eq(FocusEntity::getCreatePersion, (Object)user.getUserId()));
        agentVo.setFocus(focusCount > 0L);
        FinancialInfoEntity financialInfoEntity = (FinancialInfoEntity)this.financialInfoService.getOne((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FinancialInfoEntity::getBusinessId, (Object)agentId)).eq(FinancialInfoEntity::getBusinessType, (Object)"2"));
        agentVo.setFinancialInfoEntity(financialInfoEntity);
        return agentVo;
    }

    private void setCustomerDic(AgentVo agentVo) {
        if (StringUtil.isNotBlank((CharSequence)agentVo.getAgentLevel())) {
            agentVo.setAgentLevel(this.sysDicRefService.getDictLabel("agent_rank", agentVo.getAgentLevel()));
        }
        if (StringUtil.isNotBlank((CharSequence)agentVo.getAgentOrigin())) {
            agentVo.setAgentOrigin(this.sysDicRefService.getDictLabel("customer_source", agentVo.getAgentOrigin()));
        }
        if (StringUtil.isNotBlank((CharSequence)agentVo.getAgentTrade())) {
            agentVo.setAgentTrade(this.sysDicRefService.getDictLabel("industry", agentVo.getAgentTrade()));
        }
        if (StringUtil.isNotBlank((CharSequence)agentVo.getAgentNature())) {
            agentVo.setAgentNature(this.sysDicRefService.getDictLabel("agent_nature", agentVo.getAgentNature()));
        }
        if (StringUtil.isNotBlank((CharSequence)agentVo.getCooperativeNature())) {
            agentVo.setCooperativeNature(this.sysDicRefService.getDictLabel("agent_cooperative_attribute", agentVo.getCooperativeNature()));
        }
        if (StringUtil.isNotBlank((CharSequence)agentVo.getSigningStatus())) {
            agentVo.setSigningStatus(this.sysDicRefService.getDictLabel("agent_sign_status", agentVo.getSigningStatus()));
        }
        if (StringUtil.isNotBlank((CharSequence)agentVo.getAgentType())) {
            agentVo.setAgentType(this.sysDicRefService.getDictLabel("agent_type", agentVo.getAgentType()));
        }
    }

    private SalesStatisticsDto agentOperate(AgentDto dto) {
        String agentView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(agentView = dto.getAgentView())) && !"2".equals(agentView) && !"10".equals(agentView) && !"0".equals(agentView)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmCommonProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user.getRolesList().contains(Long.valueOf(this.crmCommonProperties.getRoles().getAllAgent()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    @Override
    public Integer isOperate(Long agentId) {
        if (agentId == null) {
            return CommonConstant.noPermission;
        }
        AgentEntity agentEntity = (AgentEntity)this.getById(agentId);
        if (agentEntity == null || "1".equals(agentEntity.getDelFlag())) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        return this.agentOperate(agentEntity, user);
    }

    @Override
    public Integer agentOperate(AgentEntity agentEntity, SecurityUser user) {
        Object parentId;
        List deptIds;
        List deptIds2;
        List struList;
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getAllAgent()))) {
            return CommonConstant.companyLeader;
        }
        List leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List struIds = DataPermission.getLeadershipBGList((Long)user.getUserId());
            ArrayList deptIdList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)struIds)) {
                for (String struId : struIds) {
                    deptIds2 = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty((Collection)(deptIds = DataPermission.getAllDeptIdByParentId((List)(struList = DataPermission.getStruCache()), (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId()))))) && deptIds.contains(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(agentEntity.getChargePerson() == null ? "" : agentEntity.getChargePerson().toString())) {
            return CommonConstant.salesman;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentEntity.getAgentId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"17"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                Long parentId2;
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                List struList2 = DataPermission.getStruCache();
                deptIds2 = DataPermission.getAllDeptIdByParentId((List)struList2, (Long)(parentId2 = DataPermission.getParentIdByDeptId((List)struList2, (Long)user.getDeptId())));
                if (CollectionUtil.isNotEmpty((Collection)deptIds2) && deptIds2.contains(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString())) {
                    return CommonConstant.salesman;
                }
                return CommonConstant.otherRole;
            }
            return CommonConstant.readOnly;
        }
        Integer count = this.agentMapper.getProductManagerByAgentId(agentEntity.getAgentId(), "0", user.getUserId());
        if (count > 0) {
            return CommonConstant.readOnly;
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getMarketingManager()))) {
            return CommonConstant.readOnly;
        }
        return CommonConstant.noPermission;
    }

    @Override
    public List<Integer> agentOperateBatch(List<AgentEntity> agentEntityList) {
        int i;
        List deptIds;
        List struList;
        AgentEntity agentEntity;
        int i2;
        ArrayList<Integer> permissionFlagList = new ArrayList<Integer>();
        for (AgentEntity agentEntity2 : agentEntityList) {
            permissionFlagList.add(CommonConstant.unconfirmedPermission);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getCompanyLeader())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getAllAgent()))) {
            for (int i3 = 0; i3 < permissionFlagList.size(); ++i3) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i3))) continue;
                permissionFlagList.set(i3, CommonConstant.companyLeader);
            }
        }
        List leadershipRoles = DataPermission.getLeadershipRoles();
        for (i2 = 0; i2 < agentEntityList.size(); ++i2) {
            agentEntity = agentEntityList.get(i2);
            if (!DataPermission.isLeadship((List)userRoles, (List)leadershipRoles)) continue;
            struList = DataPermission.getStruCache();
            List struIds = DataPermission.getLeadershipBGList((Long)user.getUserId());
            ArrayList deptIdList = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)struIds)) {
                for (String struId : struIds) {
                    deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            if (!CollectionUtil.isNotEmpty(deptIdList) || !deptIdList.contains(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i2, CommonConstant.leadership);
        }
        for (i2 = 0; i2 < agentEntityList.size(); ++i2) {
            Object parentId;
            List deptIds2;
            agentEntity = agentEntityList.get(i2);
            if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader())) || !CollectionUtil.isNotEmpty((Collection)(deptIds2 = DataPermission.getAllDeptIdByParentId((List)(struList = DataPermission.getStruCache()), (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId()))))) || !deptIds2.contains(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i2, CommonConstant.bgLeader);
        }
        for (i2 = 0; i2 < agentEntityList.size(); ++i2) {
            agentEntity = agentEntityList.get(i2);
            if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) || !user.getDeptId().toString().equals(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i2, CommonConstant.salesGM);
        }
        for (i2 = 0; i2 < agentEntityList.size(); ++i2) {
            agentEntity = agentEntityList.get(i2);
            if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector())) || !user.getDeptId().toString().equals(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString()) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i2, CommonConstant.salesDirector);
        }
        for (i2 = 0; i2 < agentEntityList.size(); ++i2) {
            agentEntity = agentEntityList.get(i2);
            if (!user.getUserId().toString().equals(agentEntity.getChargePerson() == null ? "" : agentEntity.getChargePerson().toString()) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i2, CommonConstant.salesman);
        }
        for (i2 = 0; i2 < agentEntityList.size(); ++i2) {
            agentEntity = agentEntityList.get(i2);
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)agentEntity.getAgentId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"17"));
            if (!CollectionUtil.isNotEmpty((Collection)teamList)) continue;
            for (TeamMeberEntity teamMeberEntity : teamList) {
                Long parentId;
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                List struList2 = DataPermission.getStruCache();
                deptIds = DataPermission.getAllDeptIdByParentId((List)struList2, (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList2, (Long)user.getDeptId())));
                if (CollectionUtil.isNotEmpty((Collection)deptIds) && deptIds.contains(agentEntity.getOwnDepartment() == null ? "" : agentEntity.getOwnDepartment().toString()) && ((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) {
                    permissionFlagList.set(i2, CommonConstant.salesman);
                }
                if (!((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i2, CommonConstant.otherRole);
            }
            if (!((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
            permissionFlagList.set(i2, CommonConstant.readOnly);
        }
        List<Long> agentIdList = agentEntityList.stream().map(AgentEntity::getAgentId).collect(Collectors.toList());
        List<Map<String, Long>> isManagerList = this.agentMapper.getProductManagerByAgentIdBatch(agentIdList, "0", user.getUserId());
        for (i = 0; i < agentEntityList.size(); ++i) {
            AgentEntity agentEntity3 = agentEntityList.get(i);
            for (Map<String, Long> stringLongMap : isManagerList) {
                if (!stringLongMap.get("partnerId").equals(agentEntity3.getAgentId()) || stringLongMap.get("isManager") <= 0L || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i, CommonConstant.readOnly);
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getMarketingManager()))) {
            for (i = 0; i < permissionFlagList.size(); ++i) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
                permissionFlagList.set(i, CommonConstant.readOnly);
            }
        }
        for (i = 0; i < permissionFlagList.size(); ++i) {
            if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
            permissionFlagList.set(i, CommonConstant.noPermission);
        }
        return permissionFlagList;
    }

    private List<AgentDto> getAgentDtoList(AgentDto dto) {
        ArrayList<AgentDto> queryDtoList = new ArrayList<AgentDto>();
        String view = dto.getAgentView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long agentView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)agentView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"agent");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        AgentDto queryDto = (AgentDto)((Object)JSONObject.parseObject((String)queryValue, AgentDto.class));
                        queryDto.setAgentView(String.valueOf(agentView));
                        queryDtoList.add(this.agentQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.agentQueryCondition(dto));
        return queryDtoList;
    }

    private AgentDto agentQueryCondition(AgentDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isEmpty((Object)dto.getAgentView())) {
            dto.setAgentView("1");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getAgentScreening())) {
            dto.setAgentScreening(dto.getAgentScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        String agentView = dto.getAgentView();
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String string : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)string));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List<String> list = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(list) && list.size() > 0) {
            for (String odpId : list) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add((String)idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(agentView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    @Override
    @Transactional
    public String addAgent(AgentEntity agentEntity) {
        if (this.agentNameExists(agentEntity.getAgentName().replace(" ", ""))) {
            throw new BaseException("\u4ee3\u7406\u5546\u540d\u79f0\u5df2\u5b58\u5728");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long agentId = agentEntity.getAgentId();
        agentEntity.setOwnDepartment(user.getDeptId());
        agentEntity.setOwnDepartmentName(user.getDeptName());
        if (org.springframework.util.StringUtils.isEmpty((Object)agentId)) {
            agentId = Long.valueOf(CommonUtills.generateAssignId());
            agentEntity.setAgentId(agentId);
            agentEntity.setTelephone(agentEntity.getTelephone().replaceAll(" ", ""));
            agentEntity.setCreatePerson(user.getUserId());
            agentEntity.setCreatePersonName(user.getUserName());
            agentEntity.setCreateTime(date);
            agentEntity.setDelFlag("0");
            agentEntity.setChargePerson(user.getUserId());
            agentEntity.setChargePersonName(user.getUserName());
            agentEntity.setOwnDepartment(user.getDeptId());
            agentEntity.setOwnDepartmentName(user.getDeptName());
            agentEntity.setCreateDepartment(user.getDeptId());
            agentEntity.setCreateDepartmentName(user.getDeptName());
            agentEntity.setProductAuthorizationType(agentEntity.getProductAuthorizationType() == null ? "1" : agentEntity.getProductAuthorizationType());
            agentEntity.setCustomerAuthorizationType(agentEntity.getCustomerAuthorizationType() == null ? "1" : agentEntity.getCustomerAuthorizationType());
            agentEntity.setAreaAuthorizationType(agentEntity.getAreaAuthorizationType() == null ? "1" : agentEntity.getAreaAuthorizationType());
            agentEntity.setIndustryAuthorizationType(agentEntity.getIndustryAuthorizationType() == null ? "1" : agentEntity.getIndustryAuthorizationType());
        }
        agentEntity.setChangePerson(user.getUserId());
        agentEntity.setChangePersonName(user.getUserName());
        agentEntity.setChangeTime(date);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)agentEntity.getProvince())) {
            agentEntity.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(agentEntity.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)agentEntity.getCity())) {
            agentEntity.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(agentEntity.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)agentEntity.getCounty())) {
            agentEntity.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(agentEntity.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        agentEntity.setRegionLabel(sb.toString());
        this.saveOrUpdate(agentEntity);
        FinancialInfoEntity financialInfo = new FinancialInfoEntity();
        financialInfo.setBusinessType("2");
        financialInfo.setFinancialInfoId(Long.valueOf(Long.parseLong(CommonUtills.generateAssignId())));
        financialInfo.setBusinessId(agentId);
        this.financialInfoService.save((Object)financialInfo);
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.AGENT, agentId, agentEntity.getAgentName(), date, false, Arrays.asList(agentId));
        this.teamMeberService.insertTeamMember(agentEntity.getChargePersonName(), agentEntity.getChargePerson(), agentId, "1", "1", date, "17");
        return agentId.toString();
    }

    @Override
    @Transactional
    public ApiResponse<String> updateAgent(AgentEntity agentEntity) {
        AgentEntity oldAgent = (AgentEntity)this.getById(agentEntity.getAgentId());
        if ("1".equals(oldAgent.getAgentNature()) && "2".equals(agentEntity.getAgentNature())) {
            agentEntity.setAgentNature("1");
        }
        LocalDateTime date = LocalDateTime.now();
        try {
            agentEntity.setTelephone(agentEntity.getTelephone().replace(" ", ""));
            agentEntity.setTrackTime(null);
            StringBuilder sb = new StringBuilder();
            if (ToolUtil.isEmpty((Object)agentEntity.getProvince())) {
                agentEntity.setProvince(null);
            } else {
                SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(agentEntity.getProvince()));
                if (ToolUtil.isNotEmpty((Object)province)) {
                    sb.append(province.getName());
                }
            }
            if (ToolUtil.isEmpty((Object)agentEntity.getCity())) {
                agentEntity.setCity(null);
            } else {
                SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(agentEntity.getCity()));
                if (ToolUtil.isNotEmpty((Object)city)) {
                    sb.append("/").append(city.getName());
                }
            }
            if (ToolUtil.isEmpty((Object)agentEntity.getCounty())) {
                agentEntity.setCounty(null);
            } else {
                SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(agentEntity.getCounty()));
                if (ToolUtil.isNotEmpty((Object)county)) {
                    sb.append("/").append(county.getName());
                }
            }
            agentEntity.setRegionLabel(sb.toString());
            this.agentSaveTrackRecord(oldAgent, agentEntity);
            agentEntity.setRegionLabel(sb.toString());
            this.saveOrUpdate(agentEntity);
            return ApiResponse.success((Object)String.valueOf(agentEntity.getAgentId()), (String)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    @Transactional
    public Boolean deleteAgentByIds(List<String> agentIds) {
        Long optCount = 0L;
        Long conCount = 0L;
        if (CollectionUtil.isNotEmpty(agentIds)) {
            optCount = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getPartner, agentIds)).eq(OpportunityEntity::getDelFlag, (Object)"0"));
            conCount = this.agentContactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(AgentContactEntity::getAgentId, agentIds)).eq(AgentContactEntity::getDelFlag, (Object)"0"));
        }
        if (optCount > 0L || conCount > 0L) {
            throw new BaseException("\u4ee3\u7406\u5546\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(AgentEntity::getAgentId, agentIds)).set(AgentEntity::getDelFlag, (Object)"1"));
        this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessType, (Object)"17")).in(TeamMeberEntity::getBusinessId, agentIds)).set(TeamMeberEntity::getDelFlag, (Object)"1"));
        List trackRecordList = this.trackRecordAPIService.list(agentIds, Collections.singletonList("17"), Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(agentIds, CrmBusinessTypeEnum.AGENT.getId(), "1");
        List lids = agentIds.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    private void agentSaveTrackRecord(AgentEntity oldAgent, AgentEntity newAgent) {
        HashMap<String, String> field;
        List list;
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList changeField = new ArrayList();
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        String oldAgentName = oldAgent.getAgentName();
        String newAgentName = newAgent.getAgentName();
        if (!(ToolUtil.isEmpty((Object)oldAgentName) && ToolUtil.isEmpty((Object)newAgentName) || !ToolUtil.isEmpty((Object)oldAgentName) && oldAgentName.equals(newAgentName))) {
            HashMap<String, String> field2 = new HashMap<String, String>();
            field2.put("field", AgentEditConstant.AGENT_NAME.getField());
            field2.put("fieldName", AgentEditConstant.AGENT_NAME.getName());
            changeField.add(field2);
            before.put(AgentEditConstant.AGENT_NAME.getField(), oldAgentName);
            after.put(AgentEditConstant.AGENT_NAME.getField(), newAgentName);
            changeFlag = true;
        }
        if ("2".equals(newAgent.getAgentNature())) {
            String oldAgentCompany = oldAgent.getAgentNature();
            String newAgentCompany = newAgent.getAgentNature();
            if (!(ToolUtil.isEmpty((Object)oldAgentCompany) && ToolUtil.isEmpty((Object)newAgentCompany) || !ToolUtil.isEmpty((Object)oldAgentCompany) && oldAgentCompany.equals(newAgentCompany))) {
                HashMap<String, String> field3 = new HashMap<String, String>();
                field3.put("field", AgentEditConstant.AGENT_COMPANY.getField());
                field3.put("fieldName", AgentEditConstant.AGENT_COMPANY.getName());
                changeField.add(field3);
                before.put(AgentEditConstant.AGENT_COMPANY.getField(), oldAgentCompany);
                after.put(AgentEditConstant.AGENT_COMPANY.getField(), newAgentCompany);
                changeFlag = true;
            }
        }
        String oldAgentNature = oldAgent.getAgentNature();
        String newAgentNature = newAgent.getAgentNature();
        if (!(ToolUtil.isEmpty((Object)oldAgentNature) && ToolUtil.isEmpty((Object)newAgentNature) || !ToolUtil.isEmpty((Object)oldAgentNature) && oldAgentNature.equals(newAgentNature))) {
            List list2 = this.sysDicRefService.getDictByType("agent_nature");
            String oldNature = "";
            String newNature = "";
            boolean dicFlag1 = true;
            boolean dicFlag2 = true;
            for (DicSingle dicSingle : list2) {
                if (dicFlag1 && dicSingle.getValue().equals(oldAgentNature)) {
                    oldNature = dicSingle.getLabel();
                    dicFlag1 = false;
                    continue;
                }
                if (dicFlag2 && dicSingle.getValue().equals(newAgentNature)) {
                    newNature = dicSingle.getLabel();
                    dicFlag2 = false;
                }
                if (dicFlag1 || dicFlag2) continue;
                break;
            }
            HashMap<String, String> field4 = new HashMap<String, String>();
            field4.put("field", AgentEditConstant.AGENT_NATURE.getField());
            field4.put("fieldName", AgentEditConstant.AGENT_NATURE.getName());
            changeField.add(field4);
            before.put(AgentEditConstant.AGENT_NATURE.getField(), oldNature);
            after.put(AgentEditConstant.AGENT_NATURE.getField(), newNature);
            changeFlag = true;
        }
        String oldAgentType = oldAgent.getAgentType();
        String newAgentType = newAgent.getAgentType();
        if (!(ToolUtil.isEmpty((Object)oldAgentType) && ToolUtil.isEmpty((Object)newAgentType) || !ToolUtil.isEmpty((Object)oldAgentType) && oldAgentType.equals(newAgentType))) {
            List list3 = this.sysDicRefService.getDictByType("agent_type");
            String oldType = "";
            String newType = "";
            boolean dicFlag1 = true;
            boolean dicFlag2 = true;
            for (DicSingle dicSingle : list3) {
                if (dicFlag1 && dicSingle.getValue().equals(oldAgentType)) {
                    oldType = dicSingle.getLabel();
                    dicFlag1 = false;
                    continue;
                }
                if (dicFlag2 && dicSingle.getValue().equals(newAgentType)) {
                    newType = dicSingle.getLabel();
                    dicFlag2 = false;
                }
                if (dicFlag1 || dicFlag2) continue;
                break;
            }
            HashMap<String, String> field5 = new HashMap<String, String>();
            field5.put("field", AgentEditConstant.AGENT_TYPE.getField());
            field5.put("fieldName", AgentEditConstant.AGENT_TYPE.getName());
            changeField.add(field5);
            before.put(AgentEditConstant.AGENT_TYPE.getField(), oldType);
            after.put(AgentEditConstant.AGENT_TYPE.getField(), newType);
            changeFlag = true;
        }
        String oldCooperativeNature = oldAgent.getCooperativeNature();
        String newCooperativeNature = newAgent.getCooperativeNature();
        if (!(ToolUtil.isEmpty((Object)oldCooperativeNature) && ToolUtil.isEmpty((Object)newCooperativeNature) || !ToolUtil.isEmpty((Object)oldCooperativeNature) && oldCooperativeNature.equals(newCooperativeNature))) {
            List<Object> newCooperativeNatureList = new ArrayList();
            List<Object> oldCooperativeNatureList = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)oldCooperativeNature)) {
                oldCooperativeNatureList = Arrays.asList(oldCooperativeNature.split(","));
            }
            if (ToolUtil.isNotEmpty((Object)newCooperativeNature)) {
                newCooperativeNatureList = Arrays.asList(newCooperativeNature.split(","));
            }
            list = this.sysDicRefService.getDictByType("agent_cooperative_attribute");
            StringBuilder oldCN = new StringBuilder();
            StringBuilder newCN = new StringBuilder();
            for (DicSingle dicSingle : list) {
                if (oldCooperativeNatureList.contains(dicSingle.getValue())) {
                    if (oldCN.length() > 0) {
                        oldCN.append("\uff0c");
                    }
                    oldCN.append(dicSingle.getLabel());
                }
                if (!newCooperativeNatureList.contains(dicSingle.getValue())) continue;
                if (newCN.length() > 0) {
                    newCN.append("\uff0c");
                }
                newCN.append(dicSingle.getLabel());
            }
            HashMap<String, String> field6 = new HashMap<String, String>();
            field6.put("field", AgentEditConstant.COOPERATIVE_NATURE.getField());
            field6.put("fieldName", AgentEditConstant.COOPERATIVE_NATURE.getName());
            changeField.add(field6);
            before.put(AgentEditConstant.COOPERATIVE_NATURE.getField(), oldCN.toString());
            after.put(AgentEditConstant.COOPERATIVE_NATURE.getField(), newCN.toString());
            changeFlag = true;
        }
        String oldAgentTrade = oldAgent.getAgentTrade();
        String newAgentTrade = newAgent.getAgentTrade();
        if (!(ToolUtil.isEmpty((Object)oldAgentTrade) && ToolUtil.isEmpty((Object)newAgentTrade) || !ToolUtil.isEmpty((Object)oldAgentTrade) && oldAgentTrade.equals(newAgentTrade))) {
            list = this.sysDicRefService.getDictByType("industry");
            String oldTrade = "";
            String newTrade = "";
            boolean dicFlag1 = true;
            boolean dicFlag2 = true;
            for (DicSingle dicSingle : list) {
                if (dicFlag1 && dicSingle.getValue().equals(oldAgentTrade)) {
                    oldTrade = dicSingle.getLabel();
                    dicFlag1 = false;
                    continue;
                }
                if (dicFlag2 && dicSingle.getValue().equals(newAgentTrade)) {
                    newTrade = dicSingle.getLabel();
                    dicFlag2 = false;
                }
                if (dicFlag1 || dicFlag2) continue;
                break;
            }
            HashMap<String, String> field7 = new HashMap<String, String>();
            field7.put("field", AgentEditConstant.AGENT_TRADE.getField());
            field7.put("fieldName", AgentEditConstant.AGENT_TRADE.getName());
            changeField.add(field7);
            before.put(AgentEditConstant.AGENT_TRADE.getField(), oldTrade);
            after.put(AgentEditConstant.AGENT_TRADE.getField(), newTrade);
            changeFlag = true;
        }
        String oldAgentLevel = oldAgent.getAgentLevel();
        String newAgentLevel = newAgent.getAgentLevel();
        if (!(ToolUtil.isEmpty((Object)oldAgentLevel) && ToolUtil.isEmpty((Object)newAgentLevel) || !ToolUtil.isEmpty((Object)oldAgentLevel) && oldAgentLevel.equals(newAgentLevel))) {
            List list4 = this.sysDicRefService.getDictByType("agent_rank");
            String oldLevel = "";
            String newLevel = "";
            boolean dicFlag1 = true;
            boolean dicFlag2 = true;
            for (DicSingle dicSingle : list4) {
                if (dicFlag1 && dicSingle.getValue().equals(oldAgentLevel)) {
                    oldLevel = dicSingle.getLabel();
                    dicFlag1 = false;
                    continue;
                }
                if (dicFlag2 && dicSingle.getValue().equals(newAgentLevel)) {
                    newLevel = dicSingle.getLabel();
                    dicFlag2 = false;
                }
                if (dicFlag1 || dicFlag2) continue;
                break;
            }
            HashMap<String, String> field8 = new HashMap<String, String>();
            field8.put("field", AgentEditConstant.AGENT_LEVEL.getField());
            field8.put("fieldName", AgentEditConstant.AGENT_LEVEL.getName());
            changeField.add(field8);
            before.put(AgentEditConstant.AGENT_LEVEL.getField(), oldLevel);
            after.put(AgentEditConstant.AGENT_LEVEL.getField(), newLevel);
            changeFlag = true;
        }
        String oldAgentOrigin = oldAgent.getAgentOrigin();
        String newAgentOrigin = newAgent.getAgentOrigin();
        if (!(ToolUtil.isEmpty((Object)oldAgentOrigin) && ToolUtil.isEmpty((Object)newAgentOrigin) || !ToolUtil.isEmpty((Object)oldAgentOrigin) && oldAgentOrigin.equals(newAgentOrigin))) {
            List list5 = this.sysDicRefService.getDictByType("customer_source");
            String oldOrigin = "";
            String newOrigin = "";
            boolean dicFlag1 = true;
            boolean dicFlag2 = true;
            for (DicSingle dicSingle : list5) {
                if (dicFlag1 && dicSingle.getValue().equals(oldAgentOrigin)) {
                    oldOrigin = dicSingle.getLabel();
                    dicFlag1 = false;
                    continue;
                }
                if (dicFlag2 && dicSingle.getValue().equals(newAgentOrigin)) {
                    newOrigin = dicSingle.getLabel();
                    dicFlag2 = false;
                }
                if (dicFlag1 || dicFlag2) continue;
                break;
            }
            HashMap<String, String> field9 = new HashMap<String, String>();
            field9.put("field", AgentEditConstant.AGENT_ORIGIN.getField());
            field9.put("fieldName", AgentEditConstant.AGENT_ORIGIN.getName());
            changeField.add(field9);
            before.put(AgentEditConstant.AGENT_ORIGIN.getField(), oldOrigin);
            after.put(AgentEditConstant.AGENT_ORIGIN.getField(), newOrigin);
            changeFlag = true;
        }
        String oldCampaignId = String.valueOf(oldAgent.getCampaignId());
        String newCampaignId = String.valueOf(newAgent.getCampaignId());
        String oldCampaignName = oldAgent.getCampaignName();
        String newCampaignName = newAgent.getCampaignName();
        if (!((ToolUtil.isEmpty((Object)oldCampaignId) && ToolUtil.isEmpty((Object)newCampaignId) || !ToolUtil.isEmpty((Object)oldCampaignId) && oldCampaignId.equals(newCampaignId)) && (ToolUtil.isEmpty((Object)oldCampaignName) && ToolUtil.isEmpty((Object)newCampaignName) || !ToolUtil.isEmpty((Object)oldCampaignName) && oldCampaignName.equals(newCampaignName)))) {
            HashMap<String, String> field10 = new HashMap<String, String>();
            field10.put("field", AgentEditConstant.CAMPAIGN_NAME.getField());
            field10.put("fieldName", AgentEditConstant.CAMPAIGN_NAME.getName());
            changeField.add(field10);
            before.put(AgentEditConstant.CAMPAIGN_NAME.getField(), oldCampaignName);
            after.put(AgentEditConstant.CAMPAIGN_NAME.getField(), newCampaignName);
            before.put(AgentEditConstant.CAMPAIGN_ID.getField(), oldCampaignId);
            after.put(AgentEditConstant.CAMPAIGN_ID.getField(), newCampaignId);
            changeFlag = true;
        }
        String oldSigningStatus = oldAgent.getSigningStatus();
        String newSigningStatus = newAgent.getSigningStatus();
        if (!(ToolUtil.isEmpty((Object)oldSigningStatus) && ToolUtil.isEmpty((Object)newSigningStatus) || !ToolUtil.isEmpty((Object)oldSigningStatus) && oldSigningStatus.equals(newSigningStatus))) {
            List list6 = this.sysDicRefService.getDictByType("agent_sign_status");
            String oldStatus = "";
            String newStatus = "";
            boolean dicFlag1 = true;
            boolean dicFlag2 = true;
            for (DicSingle dicSingle : list6) {
                if (dicFlag1 && dicSingle.getValue().equals(oldSigningStatus)) {
                    oldStatus = dicSingle.getLabel();
                    dicFlag1 = false;
                    continue;
                }
                if (dicFlag2 && dicSingle.getValue().equals(newSigningStatus)) {
                    newStatus = dicSingle.getLabel();
                    dicFlag2 = false;
                }
                if (dicFlag1 || dicFlag2) continue;
                break;
            }
            field = new HashMap<String, String>();
            field.put("field", AgentEditConstant.SIGNING_STATUS.getField());
            field.put("fieldName", AgentEditConstant.SIGNING_STATUS.getName());
            changeField.add(field);
            before.put(AgentEditConstant.SIGNING_STATUS.getField(), oldStatus);
            after.put(AgentEditConstant.SIGNING_STATUS.getField(), newStatus);
            changeFlag = true;
        }
        String oldTelephone = oldAgent.getTelephone();
        String newTelephone = newAgent.getTelephone();
        if (!(ToolUtil.isEmpty((Object)oldTelephone) && ToolUtil.isEmpty((Object)newTelephone) || !ToolUtil.isEmpty((Object)oldTelephone) && oldTelephone.equals(newTelephone))) {
            HashMap<String, String> field11 = new HashMap<String, String>();
            field11.put("field", AgentEditConstant.PHONE_NUMBER.getField());
            field11.put("fieldName", AgentEditConstant.PHONE_NUMBER.getName());
            changeField.add(field11);
            before.put(AgentEditConstant.PHONE_NUMBER.getField(), oldTelephone);
            after.put(AgentEditConstant.PHONE_NUMBER.getField(), newTelephone);
            changeFlag = true;
        }
        String oldSigningStartTime = null;
        String newSigningStartTime = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (ToolUtil.isNotEmpty((Object)oldAgent.getSigningStartTime())) {
            oldSigningStartTime = df.format(oldAgent.getSigningStartTime());
        }
        if (ToolUtil.isNotEmpty((Object)newAgent.getSigningStartTime())) {
            newSigningStartTime = df.format(newAgent.getSigningStartTime());
        }
        if (!(ToolUtil.isEmpty((Object)oldSigningStartTime) && ToolUtil.isEmpty((Object)newSigningStartTime) || !ToolUtil.isEmpty((Object)oldSigningStartTime) && oldSigningStartTime.equals(newSigningStartTime))) {
            field = new HashMap();
            field.put("field", AgentEditConstant.SIGNING_START_TIME.getField());
            field.put("fieldName", AgentEditConstant.SIGNING_START_TIME.getName());
            changeField.add(field);
            before.put(AgentEditConstant.SIGNING_START_TIME.getField(), oldSigningStartTime);
            after.put(AgentEditConstant.SIGNING_START_TIME.getField(), newSigningStartTime);
            changeFlag = true;
        }
        String oldSigningEndTime = null;
        String newSigningEndTime = null;
        if (ToolUtil.isNotEmpty((Object)oldAgent.getSigningEndTime())) {
            oldSigningEndTime = df.format(oldAgent.getSigningEndTime());
        }
        if (ToolUtil.isNotEmpty((Object)newAgent.getSigningEndTime())) {
            newSigningEndTime = df.format(newAgent.getSigningEndTime());
        }
        if (!(ToolUtil.isEmpty((Object)oldSigningEndTime) && ToolUtil.isEmpty((Object)newSigningEndTime) || !ToolUtil.isEmpty((Object)oldSigningEndTime) && oldSigningEndTime.equals(newSigningEndTime))) {
            HashMap<String, String> field12 = new HashMap<String, String>();
            field12.put("field", AgentEditConstant.SIGNING_END_TIME.getField());
            field12.put("fieldName", AgentEditConstant.SIGNING_END_TIME.getName());
            changeField.add(field12);
            before.put(AgentEditConstant.SIGNING_END_TIME.getField(), oldSigningEndTime);
            after.put(AgentEditConstant.SIGNING_END_TIME.getField(), newSigningEndTime);
            changeFlag = true;
        }
        String oldRegionLabel = oldAgent.getRegionLabel();
        String newRegionLabel = newAgent.getRegionLabel();
        if (!(ToolUtil.isEmpty((Object)oldRegionLabel) && ToolUtil.isEmpty((Object)newRegionLabel) || !ToolUtil.isEmpty((Object)oldRegionLabel) && oldRegionLabel.equals(newRegionLabel))) {
            HashMap<String, String> field13 = new HashMap<String, String>();
            field13.put("field", AgentEditConstant.REGION_LABEL.getField());
            field13.put("fieldName", AgentEditConstant.REGION_LABEL.getName());
            changeField.add(field13);
            before.put(AgentEditConstant.REGION_LABEL.getField(), oldRegionLabel);
            after.put(AgentEditConstant.REGION_LABEL.getField(), newRegionLabel);
            changeFlag = true;
        }
        String oldAddressDetail = oldAgent.getAddressDetail();
        String newAddressDetail = newAgent.getAddressDetail();
        if (!(ToolUtil.isEmpty((Object)oldAddressDetail) && ToolUtil.isEmpty((Object)newAddressDetail) || !ToolUtil.isEmpty((Object)oldAddressDetail) && oldAddressDetail.equals(newAddressDetail))) {
            HashMap<String, String> field14 = new HashMap<String, String>();
            field14.put("field", AgentEditConstant.ADDRESS_DETAIL.getField());
            field14.put("fieldName", AgentEditConstant.ADDRESS_DETAIL.getName());
            changeField.add(field14);
            before.put(AgentEditConstant.ADDRESS_DETAIL.getField(), oldAddressDetail);
            after.put(AgentEditConstant.ADDRESS_DETAIL.getField(), newAddressDetail);
            changeFlag = true;
        }
        String oldRemark = oldAgent.getRemark();
        String newRemark = newAgent.getRemark();
        if (!(ToolUtil.isEmpty((Object)oldRemark) && ToolUtil.isEmpty((Object)newRemark) || !ToolUtil.isEmpty((Object)oldRemark) && oldRemark.equals(newRemark))) {
            HashMap<String, String> field15 = new HashMap<String, String>();
            field15.put("field", AgentEditConstant.REMARK.getField());
            field15.put("fieldName", AgentEditConstant.REMARK.getName());
            changeField.add(field15);
            before.put(AgentEditConstant.REMARK.getField(), oldRemark);
            after.put(AgentEditConstant.REMARK.getField(), newRemark);
            changeFlag = true;
        }
        if (changeFlag) {
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            trackRecord.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.AGENT, newAgent.getAgentId(), newAgent.getAgentName(), date, false, Arrays.asList(newAgent.getAgentId()));
        }
    }

    @Override
    @Transactional
    public TransferBatchResultVo agentTransferBatch(List<AgentDto> dtos) {
        Object teamMeberEntity;
        ArrayList<Object> teamMeberEntityList;
        List agentContactEntityList;
        ArrayList<String> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId((String)dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName((String)newChargePersonId);
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List agentIdList = dtos.stream().map(AgentDto::getAgentId).collect(Collectors.toList());
        List agentEntityList = this.listByIds(agentIdList);
        ArrayList<Long> excludeAgentIdList = new ArrayList<Long>();
        List<Integer> operateFlagList = this.agentOperateBatch(agentEntityList);
        for (int i = 0; i < operateFlagList.size(); ++i) {
            if (operateFlagList.get(i) >= 0) continue;
            excludeAgentIdList.add(((AgentEntity)agentEntityList.get(i)).getAgentId());
            ++noPermissionNum;
        }
        for (Long excludeAgentId : excludeAgentIdList) {
            dtos = dtos.stream().filter(agent -> !agent.getAgentId().equals(excludeAgentId)).collect(Collectors.toList());
        }
        agentIdList = dtos.stream().map(AgentDto::getAgentId).collect(Collectors.toList());
        agentEntityList = ToolUtil.isNotEmpty(agentIdList) ? this.listByIds(agentIdList) : new ArrayList();
        ArrayList<AgentDto> dtoList = new ArrayList<AgentDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (AgentDto dto : dtos) {
            AgentEntity agentEntity = agentEntityList.stream().filter(object -> Objects.equals(object.getAgentId(), dto.getAgentId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String oldChargePersonId = dto.getOldChargePersonId();
            if (newChargePersonId.equals(oldChargePersonId) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(newOwnDepartment);
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(dto.getAgentId());
            teamMeberDto.setPersonId(Long.valueOf(Long.parseLong(newChargePersonId)));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(Boolean.valueOf(true));
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(Boolean.valueOf(false));
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                String msg2 = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg2 = msg2 + "\u65e0\u6743\u9650";
                }
                msgList.add(msg2);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        String contactFlag = ((AgentDto)((Object)dtoList.get(0))).getContactFlag();
        String keepContactFlag = ((AgentDto)((Object)dtoList.get(0))).getKeepContactFlag();
        agentIdList = dtoList.stream().map(AgentDto::getAgentId).collect(Collectors.toList());
        if ("1".equals(contactFlag) && CollectionUtil.isNotEmpty((Collection)(agentContactEntityList = this.agentContactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(AgentContactEntity::getAgentId, agentIdList)).eq(AgentContactEntity::getDelFlag, (Object)"0"))))) {
            ArrayList transferAgentContactList = new ArrayList();
            for (AgentContactEntity agentContactEntity : agentContactEntityList) {
                Long l = agentContactEntity.getAgentContactId();
                AgentContactDto agentContactDto = new AgentContactDto();
                agentContactDto.setAgentContactId(l);
                agentContactDto.setAgentContactName(agentContactEntity.getAgentContactName());
                agentContactDto.setOldChargePersonId(agentContactEntity.getChargePersonId() == null ? null : agentContactEntity.getChargePersonId().toString());
                agentContactDto.setOldChargePersonName(agentContactEntity.getChargePersonName());
                agentContactDto.setNewChargePersonId(newChargePersonId);
                agentContactDto.setNewChargePersonName(newChargePersonName);
                agentContactDto.setKeepFlag(keepContactFlag);
                transferAgentContactList.add(agentContactDto);
            }
            if (CollectionUtil.isNotEmpty((Collection)transferAgentContactList)) {
                TransferBatchResultVo agentContactResultVo = this.agentContactService.agentContactTransferBatch(transferAgentContactList);
                if (ToolUtil.isNotEmpty((Object)agentContactResultVo) && !agentContactResultVo.getTransferResult().booleanValue()) {
                    resultVo.setTransferResult(Boolean.valueOf(false));
                    if (CollectionUtil.isNotEmpty((Collection)resultVo.getMsgList())) {
                        resultVo.setMsgList(resultVo.getMsgList().stream().map(msg -> "\u4ee3\u7406\u5546\uff1a" + msg).collect(Collectors.toList()));
                    }
                    if (CollectionUtil.isNotEmpty((Collection)agentContactResultVo.getMsgList())) {
                        resultVo.getMsgList().addAll(agentContactResultVo.getMsgList().stream().map(msg -> "\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\uff1a" + msg).collect(Collectors.toList()));
                    }
                } else {
                    String msg3 = "\u4ee3\u7406\u5546\u8054\u7cfb\u4eba\uff1a\u8f6c\u79fb\u6210\u529f";
                    resultVo.getMsgList().add(msg3);
                }
            }
        }
        this.agentMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<Object>();
            for (AgentDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getAgentId());
                teamMeberEntity.setDelFlag("1");
                teamMeberEntity.setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (AgentDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                teamMeberEntity.setBusinessId(dto.getAgentId());
                teamMeberEntity.setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntity.setIsCharge("0");
                teamMeberEntity.setMemberRole("6");
                teamMeberEntity.setModifyPower(null);
                teamMeberEntityList.add(teamMeberEntity);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<AgentDto> insertMemberDtoList = new ArrayList<AgentDto>();
        ArrayList<AgentDto> updateChargeDtoList = new ArrayList<AgentDto>();
        for (AgentDto agentDto : dtoList) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(agentDto.getAgentId())) continue;
                updateChargeDtoList.add(agentDto);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(agentDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (AgentDto agentDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(agentDto.getAgentId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.valueOf(Long.parseLong(newChargePersonId)), insertMemberDtoList.stream().map(AgentDto::getAgentId).collect(Collectors.toList()), "1", "1", ((AgentDto)((Object)insertMemberDtoList.get(0))).getChangeTime(), "17");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AgentDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (AgentDto dto : dtoList) {
            String agentName = dto.getAgentName();
            Long agentId = dto.getAgentId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u4ee3\u7406\u5546\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60";
            String content = "\u4ee3\u7406\u5546\u3010" + agentName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
            EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)"/crm/sy/yddsy", null, Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/agentDetails?row=" + "\"" + dto.getAgentId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u4ee3\u7406\u5546\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u4f60\uff0c\u4ee3\u7406\u5546\u3010" + agentName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)date, (SecurityUser)user, (String)dto.getNewChargePersonId(), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
            String oldTitle = userName + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u4ee3\u7406\u5546";
            String oldContent = "\u4ee3\u7406\u5546\u540d\u79f0\u3010" + agentName + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage((String)oldTitle, (String)oldContent, (String)"/crm/sy/yddsy", null, Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u4ee3\u7406\u5546\u3010" + agentName + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage((AddSysMessageType)oldAddSysMessageType, (String)oldContentUnify, (LocalDateTime)date, (SecurityUser)user, (String)oldChargePersonId, (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            UnifyUtil.sendMessage((AddSysMessageType)oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("17");
            crmTeamAdminInfoDto.setBusinessId(agentId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    @Override
    public void addTrackRecordBatch(List<AgentDto> dtoList, List<Long> oldChargePersonIdList, List<String> oldChargePersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            AgentDto dto = dtoList.get(i);
            OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
            trackRecord.setContactId(Long.valueOf(newChargePersonId));
            trackRecord.setContactName(newChargePersonName);
            trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldChargePersonIdList.get(i))) {
                trackRecord.setOldContactId(oldChargePersonIdList.get(i));
            }
            trackRecord.setOldContactName(oldChargePersonNameList.get(i));
            trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            trackRecord.setBusinessType(CrmBusinessTypeEnum.AGENT.getId());
            trackRecord.setTypeId(dto.getAgentId());
            trackRecord.setBusinessName(dto.getAgentName());
            trackRecord.setCreatePerson(user.getUserId());
            trackRecord.setCreatePersonName(user.getUserName());
            trackRecord.setCreateTime(date);
            trackRecord.setChangePerson(user.getUserId());
            trackRecord.setChangeTime(date);
            trackRecord.setChangePersonName(user.getUserName());
            trackRecord.setDelflag("0");
            if (trackRecord.getProduceType() == null) {
                trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(trackRecord);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
    }

    @Override
    public Map<String, String> saveAgentContact(AgentContactDto agentContactDto) {
        if (ToolUtil.isEmpty((Object)agentContactDto.getAgentId())) {
            throw new HussarException("\u65b0\u5efa\u5931\u8d25");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        AgentEntity agentEntity = (AgentEntity)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)agentContactDto.getAgentContactName())).eq(AgentEntity::getAgentNature, (Object)"2")).eq(AgentEntity::getTelephone, (Object)agentContactDto.getMobilePhone()));
        if (ToolUtil.isNotEmpty((Object)agentEntity)) {
            result.put("result", "1");
            return result;
        }
        List<AgentEntity> list = this.agentMapper.selectAgentByContact(agentContactDto);
        if (ToolUtil.isNotEmpty(list)) {
            result.put("result", "2");
            result.put("agentName", list.get(0).getAgentName());
            return result;
        }
        LocalDateTime date = LocalDateTime.now();
        AgentContactEntity agentContactEntity = new AgentContactEntity();
        BeanUtils.copyProperties((Object)((Object)agentContactDto), (Object)agentContactEntity);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (StringUtils.isEmpty((CharSequence)agentContactEntity.getOwnUnit())) {
            agentContactEntity.setOwnUnit(null);
        }
        if (StringUtils.isEmpty((CharSequence)agentContactEntity.getOrderNumber())) {
            agentContactEntity.setOrderNumber(null);
        }
        Long contactId = agentContactEntity.getAgentContactId();
        agentContactEntity.setOwnDepartment(user.getDeptId());
        agentContactEntity.setOwnDepartmentName(user.getDeptName());
        if (ToolUtil.isEmpty((Object)contactId)) {
            contactId = Long.valueOf(CommonUtills.generateAssignId());
            agentContactEntity.setAgentContactId(contactId);
            agentContactEntity.setDelFlag("0");
            agentContactEntity.setMobilePhone(agentContactEntity.getMobilePhone().replace(" ", ""));
            if (ToolUtil.isNotEmpty((Object)agentContactEntity.getTelephone())) {
                agentContactEntity.setTelephone(agentContactEntity.getTelephone().replace(" ", ""));
            }
            agentContactEntity.setCreatePerson(user.getUserId());
            agentContactEntity.setCreatePersonName(user.getUserName());
            agentContactEntity.setCreateTime(date);
            agentContactEntity.setChargePersonId(user.getUserId());
            agentContactEntity.setChargePersonName(user.getUserName());
            agentContactEntity.setOwnDepartment(user.getDeptId());
            agentContactEntity.setOwnDepartmentName(user.getDeptName());
        }
        agentContactEntity.setChangePerson(user.getUserId());
        agentContactEntity.setChangePersonName(user.getUserName());
        agentContactEntity.setChangeTime(date);
        this.agentContactService.saveOrUpdate(agentContactEntity);
        this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.AGENT_CONTACT, contactId, agentContactEntity.getAgentContactName(), date, false, Arrays.asList(contactId, agentContactEntity.getAgentId()));
        this.teamMeberService.insertTeamMember(agentContactEntity.getChargePersonName(), agentContactEntity.getChargePersonId(), contactId, "1", "1", date, "18");
        result.put("result", "success");
        return result;
    }

    @Override
    public Page<AgentEntity> selectMyAgentList(AgentDto dto) {
        if (StringUtil.isEmpty((Object)dto.getAgentView())) {
            dto.setAgentView("1");
        }
        SalesStatisticsDto permissionDto = this.agentOperate(dto);
        List<AgentDto> agentDtoList = this.getAgentDtoList(dto);
        Page page = dto.getPage();
        List<AgentEntity> list = this.agentMapper.selectMyAgentList(agentDtoList, page, dto.getTimeOrder(), dto.getCurrentUserId(), permissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public String agentExport(HttpServletResponse response, AgentDto dto) {
        SalesStatisticsDto permissionDto = this.agentOperate(dto);
        List<AgentDto> dtoList = this.getAgentDtoList(dto);
        List<AgentEntity> list = this.agentMapper.selectMyAgentList(dtoList, null, dto.getTimeOrder(), dto.getCurrentUserId(), permissionDto);
        List<AgentEntity> agentEntityList = this.dictionaryTranslate(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, agentEntityList, "\u4ee3\u7406\u5546", AgentEntity.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    public List<AgentEntity> dictionaryTranslate(List<AgentEntity> agentEntityList) {
        List agentTypes = this.sysDicRefService.getDicListByType("agent_type");
        List agentOrigins = this.sysDicRefService.getDicListByType("customer_source");
        List trades = this.sysDicRefService.getDicListByType("industry");
        List natures = this.sysDicRefService.getDicListByType("agent_nature");
        List cooperativeAttributeList = this.sysDicRefService.getDicListByType("agent_cooperative_attribute");
        List signStatusList = this.sysDicRefService.getDicListByType("agent_sign_status");
        for (AgentEntity agent : agentEntityList) {
            TrackRecordAPIVo trackRecord;
            Object agentType;
            Object typeArray;
            if (ToolUtil.isNotEmpty((Object)agent.getAgentType())) {
                typeArray = agent.getAgentType().split(",");
                List<String> typeList = Arrays.asList(typeArray);
                LinkedList<String> translateTypes = new LinkedList<String>();
                for (DicVo dicVo : agentTypes) {
                    if (!typeList.contains(dicVo.getValue())) continue;
                    translateTypes.add(dicVo.getLabel());
                }
                agentType = StringUtil.join(translateTypes, (String)",");
                agent.setAgentType((String)agentType);
            }
            if (ToolUtil.isNotEmpty((Object)agent.getAgentNature())) {
                typeArray = agent.getAgentNature().split(",");
                List<String> natureList = Arrays.asList(typeArray);
                LinkedList<String> translateNatures = new LinkedList<String>();
                for (DicVo dicVo : natures) {
                    if (!natureList.contains(dicVo.getValue())) continue;
                    translateNatures.add(dicVo.getLabel());
                }
                String agentNatures = StringUtil.join(translateNatures, (String)",");
                agent.setAgentNature(agentNatures);
            }
            if (ToolUtil.isNotEmpty((Object)agent.getCooperativeNature())) {
                typeArray = agent.getCooperativeNature().split(",");
                List<String> cnList = Arrays.asList(typeArray);
                LinkedList<String> translateCNList = new LinkedList<String>();
                for (DicVo dicVo : cooperativeAttributeList) {
                    if (!cnList.contains(dicVo.getValue())) continue;
                    translateCNList.add(dicVo.getLabel());
                }
                agentType = StringUtil.join(translateCNList, (String)",");
                agent.setCooperativeNature((String)agentType);
            }
            if (ToolUtil.isNotEmpty((Object)agent.getSigningStatus())) {
                typeArray = agent.getSigningStatus().split(",");
                List<String> statusList = Arrays.asList(typeArray);
                LinkedList<String> translateStatus = new LinkedList<String>();
                for (DicVo dicVo : signStatusList) {
                    if (!statusList.contains(dicVo.getValue())) continue;
                    translateStatus.add(dicVo.getLabel());
                }
                String signStatus = StringUtil.join(translateStatus, (String)",");
                agent.setSigningStatus(signStatus);
            }
            if (ToolUtil.isNotEmpty((Object)agent.getAgentOrigin())) {
                for (DicVo dicVo : agentOrigins) {
                    if (!agent.getAgentOrigin().equals(dicVo.getValue())) continue;
                    agent.setAgentOrigin(dicVo.getLabel());
                }
            }
            agent.setCreateDate(agent.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            if (ToolUtil.isNotEmpty((Object)agent.getAgentTrade())) {
                for (DicVo dicVo : trades) {
                    if (!agent.getAgentTrade().equals(dicVo.getValue())) continue;
                    agent.setAgentTrade(dicVo.getLabel());
                }
            }
            if (!ToolUtil.isNotEmpty((Object)(trackRecord = this.trackRecordAPIService.selectTrackRecordContentByTypeId(agent.getAgentId())))) continue;
            agent.setLastTrackTime(trackRecord.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            agent.setLastTrackRecord(trackRecord.getRecordContent());
        }
        return agentEntityList;
    }

    @Override
    public ApiResponse<CheckRepeat> selectAgentRepeat(CheckDuplicateAgentDto dto) {
        if (HussarUtils.isEmpty((Object)dto.getAgentName())) {
            return ApiResponse.success((Object)new CheckRepeat(){
                {
                    this.setToastMsg("");
                    this.setAllowSaving(true);
                }
            });
        }
        if ("1".equals(dto.getAgentNature())) {
            long countFuzzy;
            long countAccurate = HussarUtils.isNotEmpty((Object)dto.getAgentId()) ? this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getDelFlag, (Object)"0")).eq(AgentEntity::getAgentNature, (Object)dto.getAgentNature())).ne(AgentEntity::getAgentId, (Object)dto.getAgentId())) : this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getAgentNature, (Object)dto.getAgentNature())).eq(AgentEntity::getDelFlag, (Object)"0"));
            if (countAccurate > 0L) {
                return ApiResponse.success((Object)new CheckRepeat(){
                    {
                        this.setToastMsg("\u8be5\u4ee3\u7406\u5546\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5f55\u5165");
                        this.setRepeatType("1");
                        this.setAllowSaving(false);
                    }
                });
            }
            if (dto.getManualInput() != null && dto.getManualInput().booleanValue() && (countFuzzy = HussarUtils.isNotEmpty((Object)dto.getAgentId()) ? this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getDelFlag, (Object)"0")).eq(AgentEntity::getAgentNature, (Object)dto.getAgentNature())).ne(AgentEntity::getAgentId, (Object)dto.getAgentId())) : this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getAgentNature, (Object)dto.getAgentNature())).eq(AgentEntity::getDelFlag, (Object)"0"))) > 0L) {
                return ApiResponse.success((Object)new CheckRepeat(){
                    {
                        this.setToastMsg("\u8be5\u4ee3\u7406\u5546\u7591\u4f3c\u5b58\u5728");
                        this.setRepeatType("2");
                        this.setAllowSaving(true);
                    }
                });
            }
        } else if ("2".equals(dto.getAgentNature())) {
            List agentContactList = this.agentContactService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentContactEntity::getAgentContactName, (Object)dto.getAgentName())).eq(AgentContactEntity::getMobilePhone, (Object)dto.getMobilePhone())).eq(AgentContactEntity::getDelFlag, (Object)"0"));
            if (!agentContactList.isEmpty()) {
                final String agentName = ((AgentContactEntity)agentContactList.get(0)).getAgentName();
                return ApiResponse.success((Object)new CheckRepeat(){
                    {
                        this.setToastMsg("\u8be5\u4eba\u5458\u5df2\u5728\u3010" + agentName + "\u3011\u4ee3\u7406\u5546\u7684\u8054\u7cfb\u4eba\u4e2d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d");
                        this.setRepeatType("1");
                        this.setAllowSaving(false);
                    }
                });
            }
            long countAgent = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getDelFlag, (Object)"0")).eq(AgentEntity::getAgentNature, (Object)dto.getAgentNature())).eq(AgentEntity::getTelephone, (Object)dto.getMobilePhone())).ne(AgentEntity::getAgentId, (Object)dto.getAgentId()));
            if (countAgent > 0L) {
                return ApiResponse.success((Object)new CheckRepeat(){
                    {
                        this.setToastMsg("\u8be5\u4eba\u5458\u5df2\u662f\u4e2a\u4eba\u4ee3\u7406\u5546\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d");
                        this.setRepeatType("1");
                        this.setAllowSaving(false);
                    }
                });
            }
        }
        return ApiResponse.success((Object)new CheckRepeat(){
            {
                this.setToastMsg("");
                this.setAllowSaving(true);
            }
        });
    }

    @Override
    public ApiResponse<CheckRepeat> selectAgentCompanyRepeat(CheckAgentCompanyDto dto) {
        long count;
        if (HussarUtils.isEmpty((Object)dto.getCompanyName())) {
            return ApiResponse.success((Object)new CheckRepeat(){
                {
                    this.setToastMsg("");
                    this.setAllowSaving(true);
                }
            });
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)dto.getCompanyName())).eq(AgentEntity::getAgentNature, (Object)"1")).eq(AgentEntity::getDelFlag, (Object)"0");
        if (HussarUtils.isNotEmpty((Object)dto.getAgentId())) {
            wrapper.ne(AgentEntity::getAgentId, (Object)dto.getAgentId());
        }
        if ((count = this.count((Wrapper)wrapper)) > 0L) {
            return ApiResponse.success((Object)new CheckRepeat(){
                {
                    this.setToastMsg("\u8be5\u4f01\u4e1a\u5df2\u662f\u4f01\u4e1a\u4ee3\u7406\u5546\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa");
                    this.setRepeatType("1");
                    this.setAllowSaving(false);
                }
            });
        }
        return ApiResponse.success((Object)new CheckRepeat(){
            {
                this.setToastMsg("");
                this.setAllowSaving(true);
            }
        });
    }

    @Override
    public ApiResponse<List<AgentEntity>> selectAgentRepeatList(CheckDuplicateAgentDto dto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getAgentNature, (Object)"1")).eq(AgentEntity::getDelFlag, (Object)"0")).orderByDesc(AgentEntity::getCreateTime);
        if (HussarUtils.isNotEmpty((Object)dto.getAgentId())) {
            wrapper.ne(AgentEntity::getAgentId, (Object)dto.getAgentId());
        }
        List listFuzzy = this.list((Wrapper)wrapper);
        if ("1".equals(dto.getRepeatType())) {
            LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)dto.getAgentName())).eq(AgentEntity::getAgentNature, (Object)"1")).eq(AgentEntity::getDelFlag, (Object)"0")).orderByDesc(AgentEntity::getCreateTime);
            if (HussarUtils.isNotEmpty((Object)dto.getAgentId())) {
                wrapper2.ne(AgentEntity::getAgentId, (Object)dto.getAgentId());
            }
            List listAccurate = this.list((Wrapper)wrapper2);
            listFuzzy.removeIf(e -> listAccurate.stream().map(AgentEntity::getAgentId).collect(Collectors.toList()).contains(e.getAgentId()));
            listAccurate.addAll(listFuzzy);
            return ApiResponse.success((Object)listAccurate);
        }
        return ApiResponse.success((Object)listFuzzy);
    }

    @Override
    @Transactional
    public ApiResponse<String> updateAuthorizationType(AgentDto dto) {
        AgentEntity oldAgent;
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AgentEntity::getAgentId, (Object)dto.getAgentId());
        LambdaUpdateWrapper updateAuthorizationWrapper = (LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(AgentAuthorizationEntity::getAgentId, (Object)dto.getAgentId());
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList changeField = new ArrayList();
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        HashMap<String, String> field = new HashMap<String, String>();
        oldAgent.setProductAuthorizationType((oldAgent = (AgentEntity)this.getById(dto.getAgentId())).getProductAuthorizationType() == null ? "1" : oldAgent.getProductAuthorizationType());
        oldAgent.setCustomerAuthorizationType(oldAgent.getCustomerAuthorizationType() == null ? "1" : oldAgent.getCustomerAuthorizationType());
        oldAgent.setAreaAuthorizationType(oldAgent.getAreaAuthorizationType() == null ? "1" : oldAgent.getAreaAuthorizationType());
        oldAgent.setIndustryAuthorizationType(oldAgent.getIndustryAuthorizationType() == null ? "1" : oldAgent.getIndustryAuthorizationType());
        if ("1".equals(dto.getAuthorizationItem()) && !dto.getAuthorizationType().equals(oldAgent.getProductAuthorizationType())) {
            String newAuthorizationName;
            String oldAuthorizationName;
            updateWrapper.set(AgentEntity::getProductAuthorizationType, (Object)dto.getAuthorizationType());
            if ("1".equals(dto.getAuthorizationType())) {
                ((LambdaUpdateWrapper)updateAuthorizationWrapper.eq(AgentAuthorizationEntity::getAuthorizationType, (Object)"1")).set(AgentAuthorizationEntity::getDelFlag, (Object)"1");
            }
            field.put("field", AgentEditConstant.PRODUCT_AUTHORIZATION_TYPE.getField());
            field.put("fieldName", AgentEditConstant.PRODUCT_AUTHORIZATION_TYPE.getName());
            changeField.add(field);
            if ("1".equals(dto.getAuthorizationType())) {
                oldAuthorizationName = "\u90e8\u5206\u6388\u6743";
                newAuthorizationName = "\u5168\u90e8\u6388\u6743";
            } else {
                oldAuthorizationName = "\u5168\u90e8\u6388\u6743";
                newAuthorizationName = "\u90e8\u5206\u6388\u6743";
            }
            before.put(AgentEditConstant.PRODUCT_AUTHORIZATION_TYPE.getField(), oldAuthorizationName);
            after.put(AgentEditConstant.PRODUCT_AUTHORIZATION_TYPE.getField(), newAuthorizationName);
            changeFlag = true;
        } else if ("2".equals(dto.getAuthorizationItem()) && !dto.getAuthorizationType().equals(oldAgent.getCustomerAuthorizationType())) {
            String newAuthorizationName;
            String oldAuthorizationName;
            updateWrapper.set(AgentEntity::getCustomerAuthorizationType, (Object)dto.getAuthorizationType());
            if ("1".equals(dto.getAuthorizationType())) {
                ((LambdaUpdateWrapper)updateAuthorizationWrapper.eq(AgentAuthorizationEntity::getAuthorizationType, (Object)"2")).set(AgentAuthorizationEntity::getDelFlag, (Object)"1");
            }
            field.put("field", AgentEditConstant.CUSTOMER_AUTHORIZATION_TYPE.getField());
            field.put("fieldName", AgentEditConstant.CUSTOMER_AUTHORIZATION_TYPE.getName());
            changeField.add(field);
            if ("1".equals(dto.getAuthorizationType())) {
                oldAuthorizationName = "\u90e8\u5206\u6388\u6743";
                newAuthorizationName = "\u5168\u90e8\u6388\u6743";
            } else {
                oldAuthorizationName = "\u5168\u90e8\u6388\u6743";
                newAuthorizationName = "\u90e8\u5206\u6388\u6743";
            }
            before.put(AgentEditConstant.CUSTOMER_AUTHORIZATION_TYPE.getField(), oldAuthorizationName);
            after.put(AgentEditConstant.CUSTOMER_AUTHORIZATION_TYPE.getField(), newAuthorizationName);
            changeFlag = true;
        } else if ("3".equals(dto.getAuthorizationItem()) && !dto.getAuthorizationType().equals(oldAgent.getAreaAuthorizationType())) {
            String newAuthorizationName;
            String oldAuthorizationName;
            updateWrapper.set(AgentEntity::getAreaAuthorizationType, (Object)dto.getAuthorizationType());
            if ("1".equals(dto.getAuthorizationType())) {
                ((LambdaUpdateWrapper)updateAuthorizationWrapper.eq(AgentAuthorizationEntity::getAuthorizationType, (Object)"3")).set(AgentAuthorizationEntity::getDelFlag, (Object)"1");
            }
            field.put("field", AgentEditConstant.AREA_AUTHORIZATION_TYPE.getField());
            field.put("fieldName", AgentEditConstant.AREA_AUTHORIZATION_TYPE.getName());
            changeField.add(field);
            if ("1".equals(dto.getAuthorizationType())) {
                oldAuthorizationName = "\u90e8\u5206\u6388\u6743";
                newAuthorizationName = "\u5168\u90e8\u6388\u6743";
            } else {
                oldAuthorizationName = "\u5168\u90e8\u6388\u6743";
                newAuthorizationName = "\u90e8\u5206\u6388\u6743";
            }
            before.put(AgentEditConstant.AREA_AUTHORIZATION_TYPE.getField(), oldAuthorizationName);
            after.put(AgentEditConstant.AREA_AUTHORIZATION_TYPE.getField(), newAuthorizationName);
            changeFlag = true;
        } else if ("4".equals(dto.getAuthorizationItem()) && !dto.getAuthorizationType().equals(oldAgent.getIndustryAuthorizationType())) {
            String newAuthorizationName;
            String oldAuthorizationName;
            updateWrapper.set(AgentEntity::getIndustryAuthorizationType, (Object)dto.getAuthorizationType());
            if ("1".equals(dto.getAuthorizationType())) {
                ((LambdaUpdateWrapper)updateAuthorizationWrapper.eq(AgentAuthorizationEntity::getAuthorizationType, (Object)"4")).set(AgentAuthorizationEntity::getDelFlag, (Object)"1");
            }
            field.put("field", AgentEditConstant.INDUSTRY_AUTHORIZATION_TYPE.getField());
            field.put("fieldName", AgentEditConstant.INDUSTRY_AUTHORIZATION_TYPE.getName());
            changeField.add(field);
            if ("1".equals(dto.getAuthorizationType())) {
                oldAuthorizationName = "\u90e8\u5206\u6388\u6743";
                newAuthorizationName = "\u5168\u90e8\u6388\u6743";
            } else {
                oldAuthorizationName = "\u5168\u90e8\u6388\u6743";
                newAuthorizationName = "\u90e8\u5206\u6388\u6743";
            }
            before.put(AgentEditConstant.INDUSTRY_AUTHORIZATION_TYPE.getField(), oldAuthorizationName);
            after.put(AgentEditConstant.INDUSTRY_AUTHORIZATION_TYPE.getField(), newAuthorizationName);
            changeFlag = true;
        }
        if (changeFlag) {
            this.update((Wrapper)updateWrapper);
            if ("1".equals(dto.getAuthorizationType())) {
                this.agentAuthorizationService.update((Wrapper)updateAuthorizationWrapper);
            }
        }
        if (changeFlag) {
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            trackRecord.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.AGENT, oldAgent.getAgentId(), oldAgent.getAgentName(), date, false, Arrays.asList(oldAgent.getAgentId()));
        }
        return ApiResponse.success();
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(AgentAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getAgentScreening();
        }
        IAgentAssociativeQueryService adapterService = this.agentAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("jxd_29Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    public boolean agentNameExists(String name) {
        IAgentService agentService;
        long count;
        Long parentId;
        if (StringUtil.isEmpty((Object)name)) {
            return false;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List struList = DataPermission.getStruCache();
        List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)(parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId())));
        if (CollectionUtil.isEmpty((Collection)deptIds)) {
            deptIds.add(user.getDeptId().toString());
        }
        return (count = (agentService = (IAgentService)SpringUtils.getBean(IAgentService.class)).count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AgentEntity::getAgentName, (Object)name)).eq(AgentEntity::getDelFlag, (Object)"0")).in(AgentEntity::getOwnDepartment, (Collection)deptIds))) > 0L;
    }

    @Override
    public ApiResponse<String> agentChangeDeptBatch(DeptChangeBatchDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getOwnDepartment()) && CollectionUtil.isNotEmpty((Collection)dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List agentList = this.list((Wrapper)new LambdaQueryWrapper().in(AgentEntity::getAgentId, (Collection)dto.getObjectIdList()));
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            String newOwnDeptName = dto.getOwnDepartmentName();
            Long newOwnDeptId = dto.getOwnDepartment();
            boolean changeFlag = false;
            for (AgentEntity agent : agentList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                if (dto.getOwnDepartmentName().equals(agent.getOwnDepartmentName())) continue;
                String oldOwnDeptName = agent.getOwnDepartmentName();
                Long oldOwnDeptId = agent.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = agent.getAgentName();
                typeEnum = CrmBusinessTypeEnum.AGENT;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(agent.getAgentId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
            }
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(AgentEntity::getAgentId, (Collection)dto.getObjectIdList())).set(AgentEntity::getOwnDepartment, (Object)dto.getOwnDepartment())).set(AgentEntity::getOwnDepartmentName, (Object)dto.getOwnDepartmentName())).set(AgentEntity::getChangeTime, (Object)date)).set(AgentEntity::getChangePerson, (Object)user.getUserId())).set(AgentEntity::getChangePersonName, (Object)user.getUserName()));
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public ApiResponse<String> agentChangeDeptByChargePersonBatch(DeptChangeBatchDto dto) {
        if (CollectionUtil.isNotEmpty((Collection)dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List agentList = this.list((Wrapper)new LambdaQueryWrapper().in(AgentEntity::getAgentId, (Collection)dto.getObjectIdList()));
            for (AgentEntity agent : agentList) {
                if (!ToolUtil.isEmpty((Object)agent.getChargePerson())) continue;
                throw new HussarException("\u4ee3\u7406\u5546\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff01");
            }
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            List userInfoList = this.commonMapper.getDeptInfosByUserIdList(agentList.stream().map(AgentEntity::getChargePerson).collect(Collectors.toList()));
            boolean changeFlag = false;
            for (AgentEntity agentEntity : agentList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                Map userMap = (Map)userInfoList.stream().filter(map -> map.get("USER_ID").equals(agentEntity.getChargePerson())).collect(Collectors.toList()).get(0);
                Long newOwnDeptId = (Long)userMap.get("DEPARTMENT_ID");
                String newOwnDeptName = (String)userMap.get("ORGAN_ALIAS");
                if (newOwnDeptName.equals(agentEntity.getOwnDepartmentName())) continue;
                String oldOwnDeptName = agentEntity.getOwnDepartmentName();
                Long oldOwnDeptId = agentEntity.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = agentEntity.getAgentName();
                typeEnum = CrmBusinessTypeEnum.AGENT;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(agentEntity.getAgentId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
                agentEntity.setOwnDepartment(newOwnDeptId);
                agentEntity.setOwnDepartmentName(newOwnDeptName);
                agentEntity.setChangeTime(date);
                agentEntity.setChangePerson(user.getUserId());
                agentEntity.setChangePersonName(user.getUserName());
            }
            this.updateBatchById(agentList);
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    @Transactional
    public ApiResponse<String> updateAgentFinancialInfo(AgentFinancialInfoDto dto) {
        FinancialInfoEntity oldFinancialInfo = (FinancialInfoEntity)this.financialInfoService.getOne((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(FinancialInfoEntity::getBusinessId, (Object)dto.getAgentId())).eq(FinancialInfoEntity::getBusinessType, (Object)"2"));
        AgentEntity oldAgent = (AgentEntity)this.getById(dto.getAgentId());
        FinancialInfoEntity newFinancialInfo = new FinancialInfoEntity();
        if (oldFinancialInfo == null) {
            oldFinancialInfo = new FinancialInfoEntity();
            newFinancialInfo.setFinancialInfoId(Long.valueOf(Long.parseLong(CommonUtills.generateAssignId())));
        } else {
            newFinancialInfo.setFinancialInfoId(oldFinancialInfo.getFinancialInfoId());
        }
        newFinancialInfo.setBusinessType("2");
        newFinancialInfo.setBusinessId(dto.getAgentId());
        newFinancialInfo.setTin(dto.getTin());
        newFinancialInfo.setBankName(dto.getBankName());
        newFinancialInfo.setBankAccount(dto.getBankAccount());
        newFinancialInfo.setBillingAddress(dto.getBillingAddress());
        LocalDateTime date = LocalDateTime.now();
        boolean agentChangeFlag = false;
        boolean financialInfoChangeFlag = false;
        ArrayList changeField = new ArrayList();
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        String oldTelephone = oldAgent.getTelephone();
        String newTelephone = dto.getTelephone();
        if (!(ToolUtil.isEmpty((Object)oldTelephone) && ToolUtil.isEmpty((Object)newTelephone) || !ToolUtil.isEmpty((Object)oldTelephone) && oldTelephone.equals(newTelephone))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", AgentEditConstant.PHONE_NUMBER.getField());
            field.put("fieldName", AgentEditConstant.PHONE_NUMBER.getName());
            changeField.add(field);
            before.put(AgentEditConstant.PHONE_NUMBER.getField(), oldTelephone);
            after.put(AgentEditConstant.PHONE_NUMBER.getField(), newTelephone);
            agentChangeFlag = true;
        }
        String oldBillingAddress = oldFinancialInfo.getBillingAddress();
        String newBillingAddress = newFinancialInfo.getBillingAddress();
        if (!(ToolUtil.isEmpty((Object)oldBillingAddress) && ToolUtil.isEmpty((Object)newBillingAddress) || !ToolUtil.isEmpty((Object)oldBillingAddress) && oldBillingAddress.equals(newBillingAddress))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", AgentEditConstant.AGENT_BILLING_ADDRESS.getField());
            field.put("fieldName", AgentEditConstant.AGENT_BILLING_ADDRESS.getName());
            changeField.add(field);
            before.put(AgentEditConstant.AGENT_BILLING_ADDRESS.getField(), oldBillingAddress);
            after.put(AgentEditConstant.AGENT_BILLING_ADDRESS.getField(), newBillingAddress);
            financialInfoChangeFlag = true;
        }
        String oldTIN = oldFinancialInfo.getTin();
        String newTIN = newFinancialInfo.getTin();
        if (!(ToolUtil.isEmpty((Object)oldTIN) && ToolUtil.isEmpty((Object)newTIN) || !ToolUtil.isEmpty((Object)oldTIN) && oldTIN.equals(newTIN))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", AgentEditConstant.AGENT_TIN.getField());
            field.put("fieldName", AgentEditConstant.AGENT_TIN.getName());
            changeField.add(field);
            before.put(AgentEditConstant.AGENT_TIN.getField(), oldTIN);
            after.put(AgentEditConstant.AGENT_TIN.getField(), newTIN);
            financialInfoChangeFlag = true;
        }
        String oldBank = oldFinancialInfo.getBankName();
        String newBank = newFinancialInfo.getBankName();
        if (!(ToolUtil.isEmpty((Object)oldBank) && ToolUtil.isEmpty((Object)newBank) || !ToolUtil.isEmpty((Object)oldBank) && oldBank.equals(newBank))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", AgentEditConstant.AGENT_BANK.getField());
            field.put("fieldName", AgentEditConstant.AGENT_BANK.getName());
            changeField.add(field);
            before.put(AgentEditConstant.AGENT_BANK.getField(), oldBank);
            after.put(AgentEditConstant.AGENT_BANK.getField(), newBank);
            financialInfoChangeFlag = true;
        }
        String oldBankAccount = oldFinancialInfo.getBankAccount();
        String newBankAccount = newFinancialInfo.getBankAccount();
        if (!(ToolUtil.isEmpty((Object)oldBankAccount) && ToolUtil.isEmpty((Object)newBankAccount) || !ToolUtil.isEmpty((Object)oldBankAccount) && oldBankAccount.equals(newBankAccount))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", AgentEditConstant.AGENT_BANK_ACCOUNT.getField());
            field.put("fieldName", AgentEditConstant.AGENT_BANK_ACCOUNT.getName());
            changeField.add(field);
            before.put(AgentEditConstant.AGENT_BANK_ACCOUNT.getField(), oldBankAccount);
            after.put(AgentEditConstant.AGENT_BANK_ACCOUNT.getField(), newBankAccount);
            financialInfoChangeFlag = true;
        }
        if (agentChangeFlag || financialInfoChangeFlag) {
            if (agentChangeFlag) {
                oldAgent.setTelephone(dto.getTelephone());
                this.updateById(oldAgent);
            }
            if (financialInfoChangeFlag) {
                this.financialInfoService.saveOrUpdate((Object)newFinancialInfo);
            }
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo operateRecordDO = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            operateRecordDO.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.AGENT, dto.getAgentId(), oldAgent.getAgentName(), date, false, Collections.singletonList(dto.getAgentId()));
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

