/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dto.CrmSlaDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.service.ICrmSlaRuleService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dao.WorkOrderMobileMapper;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderMobileParamDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderQueryParamDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.CrmWorkOrderService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.IWorkOrderMobileService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.CrmWorkOrderDetailVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.WorkOrderMobileVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktacceptrecords.model.CrmTktAcceptRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktacceptrecords.service.CrmTktAcceptRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktevaluaterecords.model.CrmTktEvaluateRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktevaluaterecords.service.CrmTktEvaluateRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktworkorders.model.CrmTktWorkOrders;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.core.api.customer.dto.CustomerAPIDto;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderMobileServiceImpl
extends HussarServiceImpl<WorkOrderMobileMapper, CrmTktWorkOrders>
implements IWorkOrderMobileService {
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICrmSlaRuleService crmSlaRuleService;
    @Resource
    private CrmWorkOrderService crmWorkOrderService;
    @Resource
    private CrmTktAcceptRecordsService crmTktAcceptRecordsService;
    @Resource
    private CrmTktEvaluateRecordsService crmTktEvaluateRecordsService;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private ICrmTktFlowService crmTktFlowService;

    @Override
    public IPage<WorkOrderMobileVO> getWorkOrderPage(WorkOrderMobileParamDto param) {
        IPage<WorkOrderMobileVO> dataPage = new IPage<WorkOrderMobileVO>();
        if (HussarUtils.isNotEmpty((Object)param.getServiceTopic())) {
            param.setServiceTopic(param.getServiceTopic().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if ("my".equals(param.getType())) {
            dataPage = this.getMyWorkOrderPage(param);
        } else if ("todo".equals(param.getType())) {
            dataPage = this.getWorkOrderToDoPage(param);
        }
        return dataPage;
    }

    private IPage<WorkOrderMobileVO> getMyWorkOrderPage(WorkOrderMobileParamDto param) {
        Long userId = BaseSecurityUtil.getUser().getUserId();
        List departmentList = this.dataRightBoService.getChargeDepartmentHasDivisions();
        CustomerAPIDto dto = new CustomerAPIDto();
        List customerList = this.customerAPIService.getCustomerList(dto);
        ArrayList<Long> custIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)customerList)) {
            custIdList = customerList.stream().map(CustomerAPIVo::getCustomerId).collect(Collectors.toList());
        }
        param.setUserId(userId);
        param.setDepartmentList(departmentList);
        param.setCustIdList(custIdList);
        LocalDateTime currentTime = LocalDateTime.now();
        param.setCurrentTime(currentTime);
        Page pages = param.getPage();
        IPage<WorkOrderMobileVO> workOrderPage = ((WorkOrderMobileMapper)this.baseMapper).getMyWorkOrderPage(pages, param);
        if (HussarUtils.isEmpty((Object)workOrderPage.getRecords())) {
            return workOrderPage;
        }
        LinkedHashMap businessTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_BUSINESS_TYPE.getValue());
        LinkedHashMap urgencyLevelMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.URGENCY_LEVEL.getValue());
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LinkedHashMap auditStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_AUDIT_STATUS.getValue());
        List<Long> flowIdList = workOrderPage.getRecords().stream().map(WorkOrderMobileVO::getFlowId).collect(Collectors.toList());
        Map<String, CrmSlaDto> slaMap = this.crmSlaRuleService.getDwellTimeByFlowIds(flowIdList);
        CommonUtils.initAlertLevelByMobile(workOrderPage.getRecords());
        Iterator iterator = workOrderPage.getRecords().iterator();
        while (iterator.hasNext()) {
            LocalDateTime time;
            WorkOrderMobileVO record;
            record.setServiceStatusName(serviceStatusMap.get((record = (WorkOrderMobileVO)iterator.next()).getServiceStatus()) == null ? "" : serviceStatusMap.get(record.getServiceStatus()).toString());
            record.setAuditStatusName(auditStatusMap.get(record.getIsReview()) == null ? "" : auditStatusMap.get(record.getIsReview()).toString());
            record.setBusinessTypeName(businessTypeMap.get(record.getBusinessType()) == null ? "" : businessTypeMap.get(record.getBusinessType()).toString());
            record.setUrgencyLevelName(urgencyLevelMap.get(record.getUrgencyLevel()) == null ? "" : urgencyLevelMap.get(record.getUrgencyLevel()).toString());
            String nodeCode = record.getNodeCode();
            if ("1".equals(record.getIsNext())) {
                CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(record.getFlowId(), record.getNodeNow());
                String string = nodeCode = nextNode == null ? null : nextNode.getNodeCode();
            }
            if (nodeCode == null) continue;
            CrmSlaDto crmSlaDto = slaMap.get(record.getFlowId() + "&" + nodeCode);
            LocalDateTime localDateTime = time = "1".equals(record.getIsNext()) ? record.getServiceTimeliness() : record.getLastTime();
            if (crmSlaDto == null || crmSlaDto.getDwellTime() == null || time == null) continue;
            record.setSurplusTime(CommonUtils.calcTimeDiffStr(time, currentTime, crmSlaDto.getDwellTime()));
        }
        return workOrderPage;
    }

    private IPage<WorkOrderMobileVO> getWorkOrderToDoPage(WorkOrderMobileParamDto param) {
        Page pages = param.getPage();
        LocalDateTime currentTime = LocalDateTime.now();
        param.setCurrentTime(currentTime);
        param.setUserId(BaseSecurityUtil.getUser().getUserId());
        IPage<WorkOrderMobileVO> workOrderPage = ((WorkOrderMobileMapper)this.baseMapper).getWorkOrderToDoPage(pages, param);
        LinkedHashMap businessTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_BUSINESS_TYPE.getValue());
        LinkedHashMap urgencyLevelMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.URGENCY_LEVEL.getValue());
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LinkedHashMap auditStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_AUDIT_STATUS.getValue());
        List<Long> flowIdList = workOrderPage.getRecords().stream().map(WorkOrderMobileVO::getFlowId).collect(Collectors.toList());
        Map<String, CrmSlaDto> slaMap = this.crmSlaRuleService.getDwellTimeByFlowIds(flowIdList);
        CommonUtils.initAlertLevelByMobile(workOrderPage.getRecords());
        Iterator iterator = workOrderPage.getRecords().iterator();
        while (iterator.hasNext()) {
            LocalDateTime time;
            WorkOrderMobileVO record;
            record.setServiceStatusName(serviceStatusMap.get((record = (WorkOrderMobileVO)iterator.next()).getServiceStatus()) == null ? "" : serviceStatusMap.get(record.getServiceStatus()).toString());
            record.setAuditStatusName(auditStatusMap.get(record.getIsReview()) == null ? "" : auditStatusMap.get(record.getIsReview()).toString());
            record.setBusinessTypeName(businessTypeMap.get(record.getBusinessType()) == null ? "" : businessTypeMap.get(record.getBusinessType()).toString());
            record.setUrgencyLevelName(urgencyLevelMap.get(record.getUrgencyLevel()) == null ? "" : urgencyLevelMap.get(record.getUrgencyLevel()).toString());
            String nodeCode = record.getNodeCode();
            if ("1".equals(record.getIsNext())) {
                CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(record.getFlowId(), record.getNodeNow());
                String string = nodeCode = nextNode == null ? null : nextNode.getNodeCode();
            }
            if (nodeCode == null) continue;
            CrmSlaDto crmSlaDto = slaMap.get(record.getFlowId() + "&" + nodeCode);
            LocalDateTime localDateTime = time = "1".equals(record.getIsNext()) ? record.getServiceTimeliness() : record.getLastTime();
            if (crmSlaDto == null || crmSlaDto.getDwellTime() == null || time == null) continue;
            record.setSurplusTime(CommonUtils.calcTimeDiffStr(time, currentTime, crmSlaDto.getDwellTime()));
        }
        return workOrderPage;
    }

    @Override
    public CrmWorkOrderDetailVO getDetail(WorkOrderQueryParamDto paramDto) {
        CrmWorkOrderDetailVO crmTktWorkOrders = this.crmWorkOrderService.getDetail(paramDto);
        if (crmTktWorkOrders == null) {
            return null;
        }
        QueryWrapper acceptQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)acceptQueryWrapper.lambda().eq(CrmTktAcceptRecords::getWoId, (Object)crmTktWorkOrders.getWoId())).eq(CrmTktAcceptRecords::getCorrectionCount, (Object)crmTktWorkOrders.getCorrectionCount());
        List acceptRecordList = this.crmTktAcceptRecordsService.list((Wrapper)acceptQueryWrapper);
        crmTktWorkOrders.setAcceptRecord(HussarUtils.isEmpty((Object)acceptRecordList) ? new CrmTktAcceptRecords() : (CrmTktAcceptRecords)acceptRecordList.get(0));
        if (HussarUtils.isNotEmpty((Object)acceptRecordList) && HussarUtils.isNotEmpty((Object)((CrmTktAcceptRecords)acceptRecordList.get(0)).getAcceptId())) {
            crmTktWorkOrders.setAcceptFileIdList(((WorkOrderMobileMapper)this.baseMapper).getFileIdListByBusinessId(((CrmTktAcceptRecords)acceptRecordList.get(0)).getAcceptId()));
        }
        QueryWrapper evaluateQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)evaluateQueryWrapper.lambda().eq(CrmTktEvaluateRecords::getWoId, (Object)crmTktWorkOrders.getWoId())).eq(CrmTktEvaluateRecords::getCorrectionCount, (Object)crmTktWorkOrders.getCorrectionCount());
        List evaluateRecordList = this.crmTktEvaluateRecordsService.list((Wrapper)evaluateQueryWrapper);
        crmTktWorkOrders.setEvaluateRecord(HussarUtils.isEmpty((Object)evaluateRecordList) ? new CrmTktEvaluateRecords() : (CrmTktEvaluateRecords)evaluateRecordList.get(0));
        return crmTktWorkOrders;
    }
}

