/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dao.CrmTktNodeMapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFunctionDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktNode;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktNodeService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmTktNodeServiceImpl
extends HussarBaseServiceImpl<CrmTktNodeMapper, CrmTktNode>
implements ICrmTktNodeService {
    @Resource
    private CrmTktNodeMapper crmTktNodeMapper;

    @Override
    public List<CrmTktNodeDto> getDefaultNodeListByServiceType(String serviceType) {
        List<CrmTktNodeDto> list = this.crmTktNodeMapper.getDefaultNodeListByServiceType(serviceType);
        for (CrmTktNodeDto crmTktNodeDto : list) {
            crmTktNodeDto.setNodeId(null);
            if (crmTktNodeDto.getFunctionList() == null) continue;
            for (CrmTktFunctionDto crmTktFunctionDto : crmTktNodeDto.getFunctionList()) {
                crmTktFunctionDto.setNodeId(null);
            }
        }
        return list;
    }

    @Override
    @HussarTransactional
    public boolean deleteFlowtNodeByFlowIdAndNotInId(Long flowId, List<Long> nodeIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktNode::getFlowId, (Object)flowId)).notIn(HussarUtils.isNotEmpty(nodeIdList), CrmTktNode::getNodeId, nodeIdList);
        return this.remove((Wrapper)queryWrapper);
    }

    @Override
    @HussarTransactional
    public boolean deleteFlowNodeByFlowIdList(List<Long> flowIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(CrmTktNode::getFlowId, flowIdList);
        return this.remove((Wrapper)queryWrapper);
    }
}

