/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.dao.CrmCsatTemplateMapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.dto.CrmCsatQuestionDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.dto.CrmCsatTemplateDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.dto.CrmCsatTemplateParamDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.model.CrmCsatOption;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.model.CrmCsatQuestion;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.model.CrmCsatTemplate;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.service.ICrmCsatOptionService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.service.ICrmCsatQuestionService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.service.ICrmCsatTemplateService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.vo.CrmCsatTemplateDetailVO;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.vo.CrmCsatTemplatePageVO;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmCsatTemplateServiceImpl
extends HussarBaseServiceImpl<CrmCsatTemplateMapper, CrmCsatTemplate>
implements ICrmCsatTemplateService {
    @Resource
    private ICrmCsatQuestionService crmCsatQuestionService;
    @Resource
    private ICrmCsatOptionService crmCsatOptionService;

    @Override
    public IPage<CrmCsatTemplatePageVO> getCrmCsatTemplateList(CrmCsatTemplateParamDto dto) {
        Page pages = dto.getPage();
        if (HussarUtils.isNotEmpty((Object)dto.getTemplateName())) {
            dto.setTemplateName(dto.getTemplateName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().like(HussarUtils.isNotEmpty((Object)dto.getTemplateName()), CrmCsatTemplate::getTemplateName, (Object)dto.getTemplateName())).orderByDesc(HussarBaseEntity::getCreateTime);
        IPage iPage = ((CrmCsatTemplateMapper)this.baseMapper).selectPage((IPage)pages, (Wrapper)queryWrapper);
        Page result = new Page();
        result.setCurrent(iPage.getCurrent());
        result.setSize(iPage.getSize());
        if (HussarUtils.isNotEmpty((Object)iPage.getRecords())) {
            List list = BeanUtil.copy((Collection)iPage.getRecords(), CrmCsatTemplatePageVO.class);
            result.setTotal(iPage.getTotal());
            result.setRecords(list);
            result.setPages(iPage.getPages());
        }
        return result;
    }

    @Override
    @DSTransactional
    public Boolean addCrmCsatTemplate(CrmCsatTemplateDto dto) {
        CrmCsatTemplate template = (CrmCsatTemplate)((Object)BeanUtil.copy((Object)dto, CrmCsatTemplate.class));
        template.setTemplateId(CommonUtils.generateAssignId());
        ArrayList optionAllList = new ArrayList();
        int order = 1;
        int templateScore = 0;
        for (CrmCsatQuestionDto questionDto : dto.getQuestionList()) {
            questionDto.setQuestionId(CommonUtils.generateAssignId());
            questionDto.setTemplateId(template.getTemplateId());
            questionDto.setQuestionOrder(order++);
            List optionList = BeanUtil.copy(questionDto.getOptionList(), CrmCsatOption.class);
            int questionScore = 0;
            for (int i = 0; i < optionList.size(); ++i) {
                ((CrmCsatOption)((Object)optionList.get(i))).setOptionId(CommonUtils.generateAssignId());
                ((CrmCsatOption)((Object)optionList.get(i))).setQuestionId(questionDto.getQuestionId());
                ((CrmCsatOption)((Object)optionList.get(i))).setOptionOrder(i + 1);
                int optionScore = ((CrmCsatOption)((Object)optionList.get(i))).getOptionScore() == null ? 0 : ((CrmCsatOption)((Object)optionList.get(i))).getOptionScore();
                questionScore = Math.max(questionScore, optionScore);
            }
            templateScore += questionScore;
            questionDto.setQuestionScore(questionScore);
            optionAllList.addAll(optionList);
        }
        List questionList = BeanUtil.copy(dto.getQuestionList(), CrmCsatQuestion.class);
        template.setTemplateScore(templateScore);
        boolean flag = this.save((BaseEntity)template);
        if (flag) {
            this.crmCsatQuestionService.saveBatch(questionList);
            this.crmCsatOptionService.saveBatch(optionAllList);
        }
        return flag;
    }

    @Override
    public CrmCsatTemplateDetailVO getCrmCsatTemplateByTemplateId(Long templateId) {
        AssertUtil.isNotNull((Object)templateId, (String)"\u6ee1\u610f\u5ea6\u8c03\u67e5\u6a21\u677fID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmCsatTemplateDto crmCsatTemplateDto = ((CrmCsatTemplateMapper)this.baseMapper).getCrmCsatTemplateByTemplateId(templateId);
        if (crmCsatTemplateDto == null) {
            return new CrmCsatTemplateDetailVO();
        }
        if (crmCsatTemplateDto.getQuestionList() != null) {
            Integer totalScore = crmCsatTemplateDto.getQuestionList().stream().mapToInt(CrmCsatQuestionDto::getQuestionScore).sum();
            crmCsatTemplateDto.setTotalScore(totalScore);
        }
        CrmCsatTemplateDetailVO crmCsatTemplateDetailVO = new CrmCsatTemplateDetailVO();
        BeanUtil.copyProperties((Object)crmCsatTemplateDto, (Object)crmCsatTemplateDetailVO);
        return crmCsatTemplateDetailVO;
    }

    @Override
    @DSTransactional
    public Boolean editCrmCsatTemplate(CrmCsatTemplateDto dto) {
        Long templateId = dto.getTemplateId();
        AssertUtil.isNotNull((Object)templateId, (String)"\u6ee1\u610f\u5ea6\u8c03\u67e5\u6a21\u677fID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmCsatTemplate template = new CrmCsatTemplate();
        BeanUtil.copyProperties((Object)dto, (Object)((Object)template));
        ArrayList optionAllList = new ArrayList();
        ArrayList<Long> optionIdList = new ArrayList<Long>();
        ArrayList<Long> questionIdList = new ArrayList<Long>();
        int order = 1;
        int templateScore = 0;
        for (CrmCsatQuestionDto questionDto : dto.getQuestionList()) {
            if (HussarUtils.isEmpty((Object)questionDto.getQuestionId())) {
                questionDto.setQuestionId(CommonUtils.generateAssignId());
            } else {
                questionIdList.add(questionDto.getQuestionId());
            }
            questionDto.setTemplateId(template.getTemplateId());
            questionDto.setQuestionOrder(order++);
            int questionScore = 0;
            List optionList = BeanUtil.copy(questionDto.getOptionList(), CrmCsatOption.class);
            for (int i = 0; i < optionList.size(); ++i) {
                if (HussarUtils.isEmpty((Object)((CrmCsatOption)((Object)optionList.get(i))).getOptionId())) {
                    ((CrmCsatOption)((Object)optionList.get(i))).setOptionId(CommonUtils.generateAssignId());
                } else {
                    optionIdList.add(((CrmCsatOption)((Object)optionList.get(i))).getOptionId());
                }
                ((CrmCsatOption)((Object)optionList.get(i))).setQuestionId(questionDto.getQuestionId());
                ((CrmCsatOption)((Object)optionList.get(i))).setOptionOrder(i + 1);
                int optionScore = ((CrmCsatOption)((Object)optionList.get(i))).getOptionScore() == null ? 0 : ((CrmCsatOption)((Object)optionList.get(i))).getOptionScore();
                questionScore = Math.max(questionScore, optionScore);
            }
            templateScore += questionScore;
            questionDto.setQuestionScore(questionScore);
            optionAllList.addAll(optionList);
        }
        List questionList = BeanUtil.copy(dto.getQuestionList(), CrmCsatQuestion.class);
        template.setTemplateScore(templateScore);
        boolean flag = this.updateById((BaseEntity)template);
        if (flag) {
            this.crmCsatOptionService.deleteOptionByTemplateIdAndNotInId(templateId, optionIdList);
            this.crmCsatQuestionService.deleteQuestionByTemplateIdAndNotInId(templateId, questionIdList);
            this.crmCsatQuestionService.saveOrUpdateBatch(questionList);
            this.crmCsatOptionService.saveOrUpdateBatch(optionAllList);
        }
        return flag;
    }

    @Override
    @DSTransactional
    public Boolean deleteCrmCsatTemplate(List<Long> templateIdList) {
        if (HussarUtils.isEmpty(templateIdList)) {
            return false;
        }
        List templateList = ((CrmCsatTemplateMapper)this.baseMapper).selectBatchIds(templateIdList);
        List<Long> enableIdList = templateList.stream().filter(template -> "1".equals(template.getTemplateStatus())).map(CrmCsatTemplate::getTemplateId).collect(Collectors.toList());
        List<Long> notEnableIdList = templateList.stream().filter(template -> "0".equals(template.getTemplateStatus())).map(CrmCsatTemplate::getTemplateId).collect(Collectors.toList());
        boolean flag = false;
        if (HussarUtils.isNotEmpty(enableIdList)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(HussarDelflagEntity::getDelFlag, (Object)"1")).set(HussarBaseEntity::getLastEditor, (Object)BaseSecurityUtil.getUser().getId())).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).in(CrmCsatTemplate::getTemplateId, enableIdList);
            flag = this.update((Wrapper)updateWrapper);
            if (flag) {
                this.crmCsatOptionService.deleteFlagOptionByTemplateIdList(enableIdList);
                this.crmCsatQuestionService.deleteFlagQuestionByTemplateIdList(enableIdList);
            }
        }
        if (HussarUtils.isNotEmpty(notEnableIdList) && (flag = ((CrmCsatTemplateMapper)this.baseMapper).deleteTemplateByTemplateIdList(notEnableIdList))) {
            this.crmCsatOptionService.deleteOptionByTemplateIdList(notEnableIdList);
            this.crmCsatQuestionService.deleteQuestionByTemplateIdList(notEnableIdList);
        }
        return flag;
    }

    @Override
    @DSTransactional
    public Boolean enableCrmCsatTemplate(List<Long> templateIdList) {
        if (HussarUtils.isEmpty(templateIdList)) {
            return false;
        }
        List flowList = ((CrmCsatTemplateMapper)this.baseMapper).selectBatchIds(templateIdList);
        long count = flowList.stream().filter(crmTktFlow -> "1".equals(crmTktFlow.getTemplateStatus())).count();
        AssertUtil.isTrue((count == 0L ? 1 : 0) != 0, (String)(templateIdList.size() == 1 ? "\u6b64\u6ee1\u610f\u5ea6\u8c03\u67e5\u6a21\u677f\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u91cd\u590d\u542f\u7528" : "\u5b58\u5728\u5df2\u542f\u7528\u7684\u6ee1\u610f\u5ea6\u8c03\u67e5\u6a21\u677f\uff0c\u4e0d\u53ef\u91cd\u590d\u542f\u7528"));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmCsatTemplate::getTemplateStatus, (Object)"1")).set(HussarBaseEntity::getLastEditor, (Object)BaseSecurityUtil.getUser().getId())).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).in(CrmCsatTemplate::getTemplateId, templateIdList);
        return this.update((Wrapper)updateWrapper);
    }
}

