/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.analysis.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.analysis.dao.CrmAfterServerAnalysisMapper;
import com.jxdinfo.crm.afterservice.crm.analysis.dto.CrmAfterServerParamDto;
import com.jxdinfo.crm.afterservice.crm.analysis.dto.CrmSurveyParamDto;
import com.jxdinfo.crm.afterservice.crm.analysis.dto.DateParamDto;
import com.jxdinfo.crm.afterservice.crm.analysis.enums.CrmSurveyTypeEnum;
import com.jxdinfo.crm.afterservice.crm.analysis.enums.CrmWorkOrderCountTypeEnum;
import com.jxdinfo.crm.afterservice.crm.analysis.external.service.ICrmAnalysisAPIService;
import com.jxdinfo.crm.afterservice.crm.analysis.external.vo.CrmWorkOrderCountVo;
import com.jxdinfo.crm.afterservice.crm.analysis.vo.CrmAfterServerAnalysisVo;
import com.jxdinfo.crm.afterservice.crm.analysis.vo.CrmCsatSurveyAnalysisVo;
import com.jxdinfo.crm.afterservice.crm.analysis.vo.CrmWorkOrderAnalysisVo;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceStatusEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktworkorders.dao.CrmTktWorkOrdersMapper;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktworkorders.model.CrmTktWorkOrders;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ICrmAnalysisAPIServiceImpl
implements ICrmAnalysisAPIService {
    @Resource
    private CrmTktWorkOrdersMapper crmTktWorkOrdersMapper;
    @Resource
    private CrmAfterServerAnalysisMapper crmAfterServerAnalysisMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    @Override
    public CrmWorkOrderCountVo getCrmWorkOrderCount(CrmAfterServerParamDto paramDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal());
        long totalNum = this.crmTktWorkOrdersMapper.selectCount((Wrapper)queryWrapper);
        DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)"2");
        LocalDateTime startDateTime = LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00");
        LocalDateTime endDateTime = LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59");
        queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).ge(CrmTktWorkOrders::getCreateTime, (Object)startDateTime)).le(CrmTktWorkOrders::getCreateTime, (Object)endDateTime);
        long addNumMonthly = this.crmTktWorkOrdersMapper.selectCount((Wrapper)queryWrapper);
        queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.CONFIRMED.getStatusVal());
        long progressNum = this.crmTktWorkOrdersMapper.selectCount((Wrapper)queryWrapper);
        queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.CONFIRMED.getStatusVal())).lt(CrmTktWorkOrders::getExpectedTime, (Object)LocalDateTime.now());
        long overdueNum = this.crmTktWorkOrdersMapper.selectCount((Wrapper)queryWrapper);
        CrmWorkOrderCountVo crmWorkOrderCountVO = new CrmWorkOrderCountVo();
        crmWorkOrderCountVO.setTotalNum((int)totalNum);
        crmWorkOrderCountVO.setAddNumMonthly((int)addNumMonthly);
        crmWorkOrderCountVO.setProgressNum((int)progressNum);
        crmWorkOrderCountVO.setOverdueNum((int)overdueNum);
        return crmWorkOrderCountVO;
    }

    @Override
    public Page<CrmWorkOrderAnalysisVo> getWorkOrderCountPage(CrmAfterServerParamDto paramDto) {
        if (HussarUtils.isNotEmpty((Object)paramDto.getServiceTopic())) {
            paramDto.setServiceTopic(paramDto.getServiceTopic().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CrmWorkOrderCountTypeEnum.TOTAL.getValue().equals(paramDto.getType())) {
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal());
        } else if (CrmWorkOrderCountTypeEnum.ADD_NUM_MONTHLY.getValue().equals(paramDto.getType())) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime startDateTime = now.minusMonths(5L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
            LocalDateTime endDateTime = YearMonth.from(now).atEndOfMonth().atTime(23, 59, 59);
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).ge(CrmTktWorkOrders::getCreateTime, (Object)startDateTime)).le(CrmTktWorkOrders::getCreateTime, (Object)endDateTime);
        } else if (CrmWorkOrderCountTypeEnum.PROGRESS.getValue().equals(paramDto.getType())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.CONFIRMED.getStatusVal());
        } else if (CrmWorkOrderCountTypeEnum.OVERDUE.getValue().equals(paramDto.getType())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.CONFIRMED.getStatusVal())).lt(CrmTktWorkOrders::getExpectedTime, (Object)LocalDateTime.now());
        } else {
            return new Page();
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().like(HussarUtils.isNotEmpty((Object)paramDto.getServiceTopic()), CrmTktWorkOrders::getServiceTopic, (Object)paramDto.getServiceTopic())).orderByDesc(CrmTktWorkOrders::getCreateTime);
        Page pages = new Page((long)paramDto.getCurrent().intValue(), (long)paramDto.getSize().intValue());
        Page workOrderPage = (Page)this.crmTktWorkOrdersMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
        return this.convertPage((Page<CrmTktWorkOrders>)workOrderPage);
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getSurvryAnalysis(CrmSurveyParamDto paramDto) {
        CrmBaseConfigVo crmBaseConfigVo;
        List dictList = this.sysDicRefService.getDicListByType(AfterServiceDictEnum.SURVEY_SATISFACTION.getValue());
        if (!CrmSurveyTypeEnum.ALL.getValue().equals(paramDto.getType())) {
            Page page = new Page(1L, 1L);
            Long surveyId = this.crmAfterServerAnalysisMapper.getLastCsatSurvry(page, paramDto);
            if (surveyId == null) {
                ArrayList<CrmAfterServerAnalysisVo> result = new ArrayList<CrmAfterServerAnalysisVo>();
                for (DicVo dicVo : dictList) {
                    result.add(new CrmAfterServerAnalysisVo(dicVo.getValue(), dicVo.getLabel(), 0));
                }
                return result;
            }
            paramDto.setSurveyId(surveyId);
        }
        if ((crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("survey_satisfaction_rate")) == null) {
            paramDto.setSatisfactionRate("0.8");
            paramDto.setCommonRate("0.6");
        } else {
            String[] rate = crmBaseConfigVo.getConfigValue().split("\\|");
            paramDto.setSatisfactionRate(rate[0]);
            paramDto.setCommonRate(rate[1]);
        }
        List<CrmAfterServerAnalysisVo> list = this.crmAfterServerAnalysisMapper.getCsatSurvryStatistics(paramDto);
        Map<String, String> satisfactionMap = dictList.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        for (CrmAfterServerAnalysisVo analysisVo : list) {
            analysisVo.setName(satisfactionMap.get(analysisVo.getCode()));
            if (!HussarUtils.isEmpty((Object)analysisVo.getBusinessId())) continue;
            analysisVo.setBusinessId(null);
        }
        return list;
    }

    @Override
    public Page<CrmCsatSurveyAnalysisVo> getSurvryAnalysisPage(CrmSurveyParamDto paramDto) {
        if (HussarUtils.isNotEmpty((Object)paramDto.getSurveyName())) {
            paramDto.setSurveyName(paramDto.getSurveyName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        Page pages = paramDto.getPage();
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("survey_satisfaction_rate");
        if (crmBaseConfigVo == null) {
            paramDto.setSatisfactionRate("0.8");
            paramDto.setCommonRate("0.6");
        } else {
            String[] rate = crmBaseConfigVo.getConfigValue().split("\\|");
            paramDto.setSatisfactionRate(rate[0]);
            paramDto.setCommonRate(rate[1]);
        }
        List<CrmCsatSurveyAnalysisVo> list = this.crmAfterServerAnalysisMapper.getSurvryAnalysisPage(pages, paramDto);
        pages.setRecords(list);
        return pages;
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getAddWorkOrderTrend(CrmAfterServerParamDto paramDto) {
        ArrayList<DateParamDto> dtoList = new ArrayList<DateParamDto>();
        ArrayList mapList = new ArrayList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        CrmDateUtils.getNearlyMonths(mapList, (LocalDate)LocalDate.now(), (LocalDate)LocalDate.now(), (int)6);
        for (Map localDateMap : mapList) {
            LocalDateTime firstDayOfMonth = ((LocalDate)localDateMap.get("startDate")).atTime(0, 0, 0);
            LocalDateTime lastDayOfMonth = ((LocalDate)localDateMap.get("endDate")).atTime(23, 59, 59);
            String month = firstDayOfMonth.format(formatter);
            dtoList.add(new DateParamDto(firstDayOfMonth, lastDayOfMonth, month));
        }
        return this.crmAfterServerAnalysisMapper.getWorkOrderCountMonthly(paramDto.getCustomerId(), dtoList);
    }

    @Override
    public Page<CrmWorkOrderAnalysisVo> getAddWorkOrderTrendPage(CrmAfterServerParamDto paramDto) {
        if (HussarUtils.isEmpty((Object)paramDto.getMonth())) {
            return new Page();
        }
        if (HussarUtils.isNotEmpty((Object)paramDto.getServiceTopic())) {
            paramDto.setServiceTopic(paramDto.getServiceTopic().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        YearMonth yearMonth = YearMonth.parse(paramDto.getMonth());
        LocalDateTime firstDay = yearMonth.atDay(1).atTime(0, 0, 0);
        LocalDateTime lastDay = yearMonth.atEndOfMonth().atTime(23, 59, 59);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().ne(CrmTktWorkOrders::getServiceStatus, (Object)ServiceStatusEnum.NOT_SUBMIT.getStatusVal())).eq(CrmTktWorkOrders::getCustId, (Object)paramDto.getCustomerId())).ge(CrmTktWorkOrders::getCreateTime, (Object)firstDay)).le(CrmTktWorkOrders::getCreateTime, (Object)lastDay)).like(HussarUtils.isNotEmpty((Object)paramDto.getServiceTopic()), CrmTktWorkOrders::getServiceTopic, (Object)paramDto.getServiceTopic())).orderByDesc(CrmTktWorkOrders::getCreateTime);
        Page pages = new Page((long)paramDto.getCurrent().intValue(), (long)paramDto.getSize().intValue());
        Page workOrderPage = (Page)this.crmTktWorkOrdersMapper.selectPage((IPage)pages, (Wrapper)queryWrapper);
        return this.convertPage((Page<CrmTktWorkOrders>)workOrderPage);
    }

    private Page<CrmWorkOrderAnalysisVo> convertPage(Page<CrmTktWorkOrders> pages) {
        Page newPage = new Page();
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LocalDateTime currentTime = LocalDateTime.now();
        for (CrmTktWorkOrders analysisVo : pages.getRecords()) {
            String serviceStatus = analysisVo.getServiceStatus();
            if (ServiceStatusEnum.TO_DO_EVALUATION.getStatusVal().equals(serviceStatus) && HussarUtils.isNotEmpty((Object)analysisVo.getServiceTimeliness()) && analysisVo.getServiceTimeliness().isBefore(currentTime)) {
                serviceStatus = ServiceStatusEnum.TO_DO_CONFIRM.getStatusVal();
            }
            analysisVo.setServiceStatus(serviceStatusMap.get(serviceStatus) == null ? "" : serviceStatusMap.get(serviceStatus).toString());
        }
        List list = BeanUtil.copy((Collection)pages.getRecords(), CrmWorkOrderAnalysisVo.class);
        newPage.setRecords(list);
        newPage.setCurrent(pages.getCurrent());
        newPage.setSize(pages.getSize());
        newPage.setTotal(pages.getTotal());
        return newPage;
    }
}

