/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.enums.CrmNodeMemberTypeEnum;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktNodeMember;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktNodeMemberService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dto.CrmSlaDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dao.CrmWorkOrderJobMapper;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.CrmWorkOrderDto;
import com.jxdinfo.crm.afterservice.crm.job.service.CrmWorkOrderJobService;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.notice.util.FunctionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmWorkOrderJobServiceImpl
implements CrmWorkOrderJobService {
    @Resource
    private CrmWorkOrderJobMapper crmWorkOrderJobMapper;
    @Resource
    private ICrmTktNodeMemberService crmTktNodeMemberService;
    @Resource
    private ICrmTktFlowService crmTktFlowService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;

    @Override
    public ProcessResult sendMessage() {
        LocalDateTime currentTime = LocalDateTime.now();
        List<CrmSlaDto> slaList = this.crmWorkOrderJobMapper.getSlaList();
        Map<String, CrmSlaDto> slaMap = slaList.stream().collect(Collectors.toMap(s -> s.getFlowId() + "&" + s.getFixedNode(), s -> s, (s1, s2) -> s1));
        List slaFlowNodeList = this.sysDicRefService.getDicListByType(AfterServiceDictEnum.SLA_FLOW_NODE.getValue());
        List nodeCodeList = slaFlowNodeList.stream().map(DicVo::getValue).collect(Collectors.toList());
        List<CrmWorkOrderDto> workOrderList = this.crmWorkOrderJobMapper.getWorkOrderList(currentTime);
        List nodeIdList = workOrderList.stream().map(CrmWorkOrderDto::getNodeNow).filter(HussarUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map<Object, Object> memberMap = new HashMap();
        if (HussarUtils.isNotEmpty(nodeIdList)) {
            List memberList = this.crmTktNodeMemberService.list((Wrapper)new QueryWrapper().lambda().in(CrmTktNodeMember::getNodeId, nodeIdList));
            memberMap = memberList.stream().collect(Collectors.groupingBy(CrmTktNodeMember::getNodeId));
        }
        for (CrmWorkOrderDto workOrder : workOrderList) {
            CrmSlaDto slaDto;
            String nodeCode = workOrder.getNodeCode();
            if ("1".equals(workOrder.getIsNext())) {
                CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
                String string = nodeCode = nextNode == null ? null : nextNode.getNodeCode();
            }
            if (nodeCode == null || !nodeCodeList.contains(nodeCode) || (slaDto = slaMap.get(workOrder.getFlowId() + "&" + nodeCode)) == null || slaDto.getDwellTime() == null) continue;
            LocalDateTime time = "1".equals(workOrder.getIsNext()) ? workOrder.getServiceTimeliness().plusHours(slaDto.getDwellTime().intValue()) : workOrder.getLastTime().plusHours(slaDto.getDwellTime().intValue());
            if (!LocalDateTime.now().isAfter(time)) continue;
            List<String> messageUserIdList = new ArrayList<String>();
            List<Object> messageOrgIdList = new ArrayList();
            List<Object> messagRoleIdList = new ArrayList();
            List<String> userIdList = new ArrayList<String>();
            if (workOrder.getAssigneeId() != null) {
                userIdList.add(workOrder.getAssigneeId().toString());
                messageUserIdList.add(workOrder.getAssigneeId().toString());
            } else {
                List members = (List)memberMap.get(workOrder.getNodeNow());
                if (HussarUtils.isEmpty((Object)members)) continue;
                List userList = members.stream().filter(member -> CrmNodeMemberTypeEnum.USER.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
                messageUserIdList = userList.stream().map(String::valueOf).collect(Collectors.toList());
                List orgList = members.stream().filter(member -> CrmNodeMemberTypeEnum.DEPARTMENT.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
                messageOrgIdList = orgList.stream().map(String::valueOf).collect(Collectors.toList());
                List roleList = members.stream().filter(member -> CrmNodeMemberTypeEnum.ROLE.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
                messagRoleIdList = roleList.stream().map(String::valueOf).collect(Collectors.toList());
                List userVoList = this.hussarBaseUserBoService.getUsersByOrganUser(orgList, userList);
                if (HussarUtils.isNotEmpty(roleList)) {
                    userVoList.addAll(this.hussarBaseUserBoService.getUserInfoByRoleId(roleList));
                }
                userIdList = userVoList.stream().filter(FunctionUtil.distinctByKey(UserVo::getId)).map(UserVo::getId).map(String::valueOf).collect(Collectors.toList());
            }
            if (!HussarUtils.isNotEmpty(userIdList)) continue;
            String title = "\u670d\u52a1\u5de5\u5355\u8d85\u65f6\u63d0\u9192";
            String content = "\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u7684\u5f85\u5904\u7406\u5de5\u5355\u5df2\u8d85\u65f6\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a" + workOrder.getServiceTopic() + "\u3002";
            String url = "/crm/fwgd/workOrderInfo?businessId=" + workOrder.getWoId();
            EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)url, (String)workOrder.getWoId().toString(), userIdList);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/workListDetail?row=\"" + workOrder.getWoId() + "\"";
            String contentUnify = "\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u7684\u5f85\u5904\u7406\u5de5\u5355\u5df2\u8d85\u65f6\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a" + workOrder.getServiceTopic() + "\u3002";
            addSysMessageType.setBusinessAddress(unifyWebUrl);
            SecurityUser user = new SecurityUser();
            user.setUserId(CommonConstant.SUPER_ADMIN);
            user.setUserName("\u8d85\u7ea7\u7ba1\u7406\u5458");
            user.setDeptId(Long.valueOf(0L));
            UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)currentTime, (SecurityUser)user, (String)StringUtil.join(messageUserIdList, (String)","), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
            addSysMessageType.setDepartmentId(StringUtil.join(messageOrgIdList, (String)","));
            addSysMessageType.setRoleId(StringUtil.join(messagRoleIdList, (String)","));
            UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
        }
        return new ProcessResult(true, "success");
    }
}

