/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.utils;

import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderNumberDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceTypeEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.CrmWorkOrderService;
import com.jxdinfo.crm.afterservice.crm.utils.idGenerator.DefaultIdGenerator;
import com.jxdinfo.crm.afterservice.crm.utils.idGenerator.IdGenerator;
import com.jxdinfo.crm.afterservice.crm.utils.idGenerator.IdGeneratorConfig;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class WorkOrderNumberUtil
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(WorkOrderNumberUtil.class);
    @Resource
    private CrmWorkOrderService crmWorkOrderService;
    private static Map<String, IdGenerator> idGeneratorMap = new HashMap<String, IdGenerator>();

    public void init() {
        logger.info("\u670d\u52a1\u5de5\u5355\u7f16\u53f7\u751f\u6210\u5668\u521d\u59cb\u5316");
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List<String> prefixList = Arrays.asList("", "TS", "TX", "JY", "QT");
        ArrayList<String> prefixTimeList = new ArrayList<String>();
        for (String prefix : prefixList) {
            prefixTimeList.add(prefix + time);
        }
        List<WorkOrderNumberDto> numberList = this.crmWorkOrderService.getMaxOrderNumberList(prefixTimeList);
        Map<String, String> numberMap = numberList.stream().collect(Collectors.toMap(WorkOrderNumberDto::getPrefix, w -> w.getMaxNumber() == null ? "0" : w.getMaxNumber()));
        for (final String prefix : prefixList) {
            String number = numberMap.get(prefix + time);
            final int initialNumber = new BigDecimal(number).add(BigDecimal.ONE).intValue();
            IdGeneratorConfig config = new IdGeneratorConfig(){

                @Override
                public String getSplitString() {
                    return "";
                }

                @Override
                public int getInitial() {
                    return initialNumber;
                }

                @Override
                public String getPrefix() {
                    return prefix;
                }

                @Override
                public int getRollingInterval() {
                    return 0;
                }
            };
            DefaultIdGenerator idGenerator = new DefaultIdGenerator(config);
            idGeneratorMap.put(prefix, idGenerator);
        }
    }

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        this.init();
    }

    public static String getOrderNumber(String serviceType) {
        String prefix = ServiceTypeEnum.getLetterByStatus(serviceType);
        return idGeneratorMap.get(prefix == null ? "" : prefix).next();
    }
}

