/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurvey.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.dto.CrmCsatTemplateDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.model.CrmCsatTemplate;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.service.ICrmCsatTemplateService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.vo.CrmCsatTemplateDetailVO;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatanswer.model.CrmCsatAnswer;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatanswer.service.CrmCsatAnswerService;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurvey.dao.CrmSurveyMapper;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurvey.service.CrmSurveyService;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurvey.vo.CrmCsatSurveyDetailVO;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveymaster.model.CrmCsatSurveyCust;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveymaster.model.CrmCsatSurveyMasterMaster;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveymaster.service.CrmCsatSurveyCustService;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveymaster.service.CrmCsatSurveyMasterMasterService;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveysingle.model.CrmCsatSurveySingle;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmSurveyServiceImpl
implements CrmSurveyService {
    @Resource
    private CrmSurveyMapper crmSurveyMapper;
    @Resource
    private CrmCsatSurveyMasterMasterService crmCsatSurveyMasterService;
    @Resource
    private CrmCsatSurveyCustService crmCsatSurveyCustService;
    @Resource
    private CrmCsatAnswerService crmCsatAnswerService;
    @Resource
    private ICrmCsatTemplateService crmCsatTemplateService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    @Override
    public List<CrmCsatSurveySingle> handleDataToNum(List<CrmCsatSurveySingle> list) {
        if (HussarUtils.isEmpty(list)) {
            return list;
        }
        List<Long> surveyIdList = list.stream().map(CrmCsatSurveySingle::getSurveyId).collect(Collectors.toList());
        List<CrmCsatSurveySingle> numList = this.crmSurveyMapper.getIssueAndAnswerNumber(surveyIdList);
        Map<Long, CrmCsatSurveySingle> numMap = numList.stream().collect(Collectors.toMap(CrmCsatSurveySingle::getSurveyId, crmCsatSurvey -> crmCsatSurvey));
        Iterator<CrmCsatSurveySingle> iterator = list.iterator();
        while (iterator.hasNext()) {
            CrmCsatSurveySingle crmCsatSurvey2;
            CrmCsatSurveySingle numEntity = numMap.get((crmCsatSurvey2 = iterator.next()).getSurveyId());
            crmCsatSurvey2.setIssueNum(numEntity == null ? 0 : numEntity.getIssueNum());
            crmCsatSurvey2.setAnswerNum(numEntity == null ? 0 : numEntity.getAnswerNum());
        }
        return list;
    }

    @Override
    @HussarTransactional
    public Boolean publish(List<Long> surveyIdList) {
        AssertUtil.isNotEmpty(surveyIdList, (String)"\u6ee1\u610f\u5ea6\u56de\u8bbfID\u4e0d\u53ef\u4e3a\u7a7a");
        List list = this.crmCsatSurveyMasterService.listByIds(surveyIdList);
        long count = list.stream().filter(survey -> !"0".equals(survey.getSurveyStatus())).count();
        AssertUtil.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5b58\u5728\u5df2\u53d1\u5e03\u7684\u6570\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u5e03");
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime currentTime = LocalDateTime.now();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmCsatSurveyMasterMaster::getSurveyStatus, (Object)"1")).set(CrmCsatSurveyMasterMaster::getPublishId, (Object)user.getId())).set(CrmCsatSurveyMasterMaster::getPublishName, (Object)user.getUserName())).set(CrmCsatSurveyMasterMaster::getPublishTime, (Object)currentTime)).set(CrmCsatSurveyMasterMaster::getLastEditor, (Object)user.getId())).set(CrmCsatSurveyMasterMaster::getLastTime, (Object)currentTime)).in(CrmCsatSurveyMasterMaster::getSurveyId, surveyIdList);
        return this.crmCsatSurveyMasterService.update((Wrapper)updateWrapper);
    }

    @Override
    @HussarTransactional
    public Boolean delete(List<Long> surveyIdList) {
        AssertUtil.isNotEmpty(surveyIdList, (String)"\u6ee1\u610f\u5ea6\u56de\u8bbfID\u4e0d\u53ef\u4e3a\u7a7a");
        List list = this.crmCsatSurveyMasterService.listByIds(surveyIdList);
        long count = list.stream().filter(survey -> !"0".equals(survey.getSurveyStatus())).count();
        AssertUtil.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u5b58\u5728\u5df2\u53d1\u5e03\u7684\u6570\u636e\uff0c\u4e0d\u53ef\u5220\u9664");
        boolean flag = this.crmCsatSurveyMasterService.removeByIds(surveyIdList);
        if (flag) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(CrmCsatSurveyCust::getSurveyCustId, surveyIdList);
            this.crmCsatSurveyCustService.remove((Wrapper)queryWrapper);
        }
        return flag;
    }

    @Override
    public CrmCsatSurveyDetailVO getSurveyDetail(Long surveyId) {
        AssertUtil.isNotNull((Object)surveyId, (String)"\u6ee1\u610f\u5ea6\u56de\u8bbfID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmCsatSurveyMasterMaster surveyMaster = (CrmCsatSurveyMasterMaster)this.crmCsatSurveyMasterService.getById(surveyId);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmCsatAnswer::getSurveyId, (Object)surveyId);
        List answerList = this.crmCsatAnswerService.list((Wrapper)queryWrapper);
        CrmCsatTemplate crmCsatTemplate = (CrmCsatTemplate)((Object)this.crmCsatTemplateService.getById(surveyMaster.getTemplateId()));
        CrmCsatSurveyDetailVO surveyDetailVO = new CrmCsatSurveyDetailVO();
        BeanUtil.copyProperties((Object)surveyMaster, (Object)surveyDetailVO);
        int templateScore = crmCsatTemplate.getTemplateScore();
        surveyDetailVO.setTemplateScore(templateScore);
        surveyDetailVO.setAnswerNumber(answerList == null ? 0 : answerList.size());
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("survey_satisfaction_rate");
        String satisfactionRate = "0.8";
        String commonRate = "0.6";
        if (crmBaseConfigVo != null) {
            String[] rate = crmBaseConfigVo.getConfigValue().split("\\|");
            satisfactionRate = rate[0];
            commonRate = rate[1];
        }
        if (templateScore == 0) {
            surveyDetailVO.setSatisfiedNum(surveyDetailVO.getAnswerNumber());
            surveyDetailVO.setAverageNum(0);
            surveyDetailVO.setDissatisfiedNum(0);
        } else {
            int satisfiedNum = 0;
            int averageNum = 0;
            int dissatisfiedNum = 0;
            if (answerList != null) {
                for (CrmCsatAnswer answer : answerList) {
                    BigDecimal rate = CommonUtils.emptyToZero(answer.getSurveyScoring()).divide(new BigDecimal("" + templateScore), 2, 4);
                    if (rate.compareTo(new BigDecimal(satisfactionRate)) >= 0) {
                        ++satisfiedNum;
                        continue;
                    }
                    if (rate.compareTo(new BigDecimal(commonRate)) < 0) {
                        ++dissatisfiedNum;
                        continue;
                    }
                    ++averageNum;
                }
            }
            surveyDetailVO.setSatisfiedNum(satisfiedNum);
            surveyDetailVO.setAverageNum(averageNum);
            surveyDetailVO.setDissatisfiedNum(dissatisfiedNum);
        }
        surveyDetailVO.setAnswerList(answerList);
        if (HussarUtils.isEmpty((Object)answerList)) {
            surveyDetailVO.setAvgScore(BigDecimal.ZERO.toString());
        } else {
            BigDecimal allScore = answerList.stream().map(CrmCsatAnswer::getSurveyScoring).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal avgScore = allScore.divide(new BigDecimal(surveyDetailVO.getAnswerNumber().toString()), 2, 4);
            surveyDetailVO.setAvgScore(avgScore.stripTrailingZeros().toPlainString());
        }
        return surveyDetailVO;
    }

    @Override
    public CrmCsatTemplateDetailVO getSurveyAnswerDetail(Long templateId, Long answerId) {
        AssertUtil.isNotNull((Object)templateId, (String)"\u6ee1\u610f\u5ea6\u8c03\u67e5\u6a21\u677fID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmCsatTemplateDto surveyAnswerDetail = this.crmSurveyMapper.getSurveyAnswerDetail(templateId, answerId);
        CrmCsatTemplateDetailVO crmCsatTemplateDetailVO = new CrmCsatTemplateDetailVO();
        BeanUtil.copyProperties((Object)surveyAnswerDetail, (Object)crmCsatTemplateDetailVO);
        return crmCsatTemplateDetailVO;
    }
}

