/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFlowDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFunctionDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.enums.CrmNodeMemberTypeEnum;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktFunction;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktNode;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.model.CrmTktNodeMember;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFunctionService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktNodeMemberService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktNodeService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.service.ICrmSlaRuleService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.warnRule.model.CrmWarnRule;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.warnRule.service.ICrmWarnRuleService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dao.CrmWorkOrderMapper;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.CrmTktAcceptRecordsDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.CrmTktReceiveRecordsDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.CrmWorkOrderDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.CrmWorkOrderParamDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.UserInfoDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderAssociativeQueryDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderNodeDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderNumberDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dto.WorkOrderQueryParamDto;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.FlowFunctionEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ReceiveTypeEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceStatusEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceTypeEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.WorkOrderEditConstant;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.WorkOrderEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.CrmWorkOrderService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.IWorkOrderAssociativeQueryService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.ProcessingRecordService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.CrmWorkOrderDetailVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.CrmWorkOrderPageVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.CrmWorkOrderVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.vo.WorkOrderCountVO;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktacceptrecords.model.CrmTktAcceptRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktacceptrecords.service.CrmTktAcceptRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktauditrecords.model.CrmTktAuditRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktauditrecords.service.CrmTktAuditRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktchildrecords.model.CrmTktChildRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktchildrecords.service.CrmTktChildRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktdispatchrecords.model.CrmTktDispatchRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktdispatchrecords.service.CrmTktDispatchRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktprocessingrecord.model.CrmTktProcessingRecord;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktreceiverecords.model.CrmTktReceiveRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktreceiverecords.service.CrmTktReceiveRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktworkorders.dto.CrmTktWorkOrdersCrmtktworkordersdataset1;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktworkorders.model.CrmTktWorkOrders;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceConstants;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.crm.afterservice.crm.utils.WorkOrderNumberUtil;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.customer.dto.CustomerAPIDto;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.notice.util.FunctionUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class CrmWorkOrderServiceImpl
extends HussarServiceImpl<CrmWorkOrderMapper, CrmTktWorkOrders>
implements CrmWorkOrderService {
    @Resource
    private ICrmTktFlowService crmTktFlowService;
    @Resource
    private ICrmTktNodeService crmTktNodeService;
    @Resource
    private ICrmTktFunctionService crmTktFunctionService;
    @Resource
    private ICrmWarnRuleService crmWarnRuleService;
    @Resource
    private ICrmSlaRuleService crmSlaRuleService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private CrmTktDispatchRecordsService crmTktDispatchRecordsService;
    @Resource
    private CrmTktChildRecordsService crmTktChildRecordsService;
    @Resource
    private CrmTktReceiveRecordsService crmTktReceiveRecordsService;
    @Resource
    private CrmTktAcceptRecordsService crmTktAcceptRecordsService;
    @Resource
    private CrmTktAuditRecordsService crmTktAuditRecordsService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private ProcessingRecordService processingRecordService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IWorkOrderAssociativeQueryService workOrderAssociativeQueryService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private ICrmTktNodeMemberService crmTktNodeMemberService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    private static DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static List<String> CUST_CHARGE_PERSON_NODE = Arrays.asList("pd", "jgqr");
    private static List<String> ACCEPT_PERSON_NODE = Arrays.asList("jd", "slz");

    @Override
    public List<WorkOrderCountVO> getWorkOrderCount(CrmWorkOrderParamDto param) {
        param.setUserId(BaseSecurityUtil.getUser().getUserId());
        param.setCurrentTime(LocalDateTime.now());
        List<WorkOrderCountVO> list = ((CrmWorkOrderMapper)this.baseMapper).getWorkOrderCount(param);
        Map<String, Integer> numberMap = list.stream().collect(Collectors.toMap(WorkOrderCountVO::getServiceStatus, WorkOrderCountVO::getNumber));
        ArrayList<WorkOrderCountVO> result = new ArrayList<WorkOrderCountVO>();
        WorkOrderEnum.getStatusNodeNameMap().forEach((node, name) -> {
            Integer number = numberMap.get(node) == null ? Integer.valueOf(0) : (Integer)numberMap.get(node);
            result.add(new WorkOrderCountVO((String)node, (String)name, number));
        });
        return result;
    }

    @Override
    public List<AssociativeQueryVo> associativeQueryNew(WorkOrderAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getKeyword();
        }
        IWorkOrderAssociativeQueryService adapterService = this.workOrderAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyword");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public CrmWorkOrderPageVO hussarQuerycrmTktWorkOrdersCondition_1Page(CrmTktWorkOrdersCrmtktworkordersdataset1 dataset) {
        String expectedTimeFlag;
        String createTimeFlag;
        if (HussarUtils.isNotEmpty((Object)dataset.getKeyword())) {
            dataset.setKeyword(dataset.getKeyword().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        }
        if (StringUtil.isNotEmpty((Object)(createTimeFlag = dataset.getCreateTimeFlag())) && !"6".equals(createTimeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)createTimeFlag);
            dataset.setCreateTimeStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            dataset.setCreateTimeEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        if (StringUtil.isNotEmpty((Object)(expectedTimeFlag = dataset.getExpectedTimeFlag())) && !"6".equals(expectedTimeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)expectedTimeFlag);
            dataset.setExpectedTimeStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            dataset.setExpectedTimeEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        String timeOrder = "lastTime_1";
        if (HussarUtils.isNotEmpty(dataset.getOrders())) {
            timeOrder = this.getTimeOrderSort(dataset.getOrders().get(0));
        }
        CrmWorkOrderPageVO crmWorkOrderPageVO = new CrmWorkOrderPageVO();
        WorkOrderQueryParamDto paramDto = new WorkOrderQueryParamDto();
        BeanUtil.copyProperties((Object)dataset, (Object)paramDto);
        paramDto.setTimeOrder(timeOrder);
        IPage<CrmWorkOrderVO> dataPage = new IPage<CrmWorkOrderVO>();
        if ("all".equals(dataset.getType())) {
            dataPage = this.getAllWorkOrderPage(paramDto);
        } else if ("my".equals(dataset.getType())) {
            dataPage = this.getMyWorkOrderPage(paramDto);
        } else {
            paramDto.setServiceStatus(dataset.getType());
            dataPage = this.getWorkOrderPage(paramDto);
        }
        crmWorkOrderPageVO.setData(dataPage.getRecords());
        crmWorkOrderPageVO.setCount(dataPage.getTotal());
        crmWorkOrderPageVO.setCode("0");
        return crmWorkOrderPageVO;
    }

    private IPage<CrmWorkOrderVO> getAllWorkOrderPage(WorkOrderQueryParamDto dto) {
        Page pages = dto.getPage();
        LocalDateTime currentTime = LocalDateTime.now();
        dto.setCurrentTime(currentTime);
        List<CrmWorkOrderVO> list = ((CrmWorkOrderMapper)this.baseMapper).getAllWorkOrderPage(pages, dto);
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LinkedHashMap auditStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_AUDIT_STATUS.getValue());
        for (CrmWorkOrderVO record : list) {
            record.setServiceStatusName(serviceStatusMap.get(record.getServiceStatus()) == null ? "" : serviceStatusMap.get(record.getServiceStatus()).toString());
            record.setAuditStatusName(auditStatusMap.get(record.getIsReview()) == null ? "" : auditStatusMap.get(record.getIsReview()).toString());
        }
        pages.setRecords(list);
        return pages;
    }

    private IPage<CrmWorkOrderVO> getMyWorkOrderPage(WorkOrderQueryParamDto param) {
        Long userId = BaseSecurityUtil.getUser().getUserId();
        List departmentList = this.dataRightBoService.getChargeDepartmentHasDivisions();
        CustomerAPIDto dto = new CustomerAPIDto();
        List customerList = this.customerAPIService.getCustomerList(dto);
        List<Long> custIdList = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)customerList)) {
            custIdList = customerList.stream().map(CustomerAPIVo::getCustomerId).collect(Collectors.toList());
        }
        param.setDepartmentList(departmentList);
        param.setCustIdList(custIdList);
        LocalDateTime currentTime = LocalDateTime.now();
        param.setCurrentTime(currentTime);
        param.setUserId(BaseSecurityUtil.getUser().getUserId());
        Page pages = param.getPage();
        List<CrmWorkOrderVO> list = ((CrmWorkOrderMapper)this.baseMapper).getMyWorkOrderPage(pages, param);
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LinkedHashMap auditStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_AUDIT_STATUS.getValue());
        for (CrmWorkOrderVO record : list) {
            record.setServiceStatusName(serviceStatusMap.get(record.getServiceStatus()) == null ? "" : serviceStatusMap.get(record.getServiceStatus()).toString());
            record.setAuditStatusName(auditStatusMap.get(record.getIsReview()) == null ? "" : auditStatusMap.get(record.getIsReview()).toString());
        }
        pages.setRecords(list);
        return pages;
    }

    private IPage<CrmWorkOrderVO> getWorkOrderPage(WorkOrderQueryParamDto dto) {
        Page pages = dto.getPage();
        dto.setUserId(BaseSecurityUtil.getUser().getUserId());
        dto.setCurrentTime(LocalDateTime.now());
        List<CrmWorkOrderVO> list = ((CrmWorkOrderMapper)this.baseMapper).getWorkOrderList(pages, dto);
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LinkedHashMap auditStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_AUDIT_STATUS.getValue());
        for (CrmWorkOrderVO record : list) {
            record.setServiceStatusName(serviceStatusMap.get(record.getServiceStatus()) == null ? "" : serviceStatusMap.get(record.getServiceStatus()).toString());
            record.setAuditStatusName(auditStatusMap.get(record.getIsReview()) == null ? "" : auditStatusMap.get(record.getIsReview()).toString());
        }
        pages.setRecords(list);
        return pages;
    }

    @Override
    public String workOrderExport(HttpServletResponse response, CrmTktWorkOrdersCrmtktworkordersdataset1 dataset) {
        boolean review;
        String expectedTimeFlag;
        String createTimeFlag = dataset.getCreateTimeFlag();
        if (StringUtil.isNotEmpty((Object)createTimeFlag) && !"6".equals(createTimeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)createTimeFlag);
            dataset.setCreateTimeStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            dataset.setCreateTimeEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        if (StringUtil.isNotEmpty((Object)(expectedTimeFlag = dataset.getExpectedTimeFlag())) && !"6".equals(expectedTimeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)expectedTimeFlag);
            dataset.setExpectedTimeStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            dataset.setExpectedTimeEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        String timeOrder = "lastTime_1";
        if (HussarUtils.isNotEmpty(dataset.getOrders())) {
            timeOrder = dataset.getOrders().get(0).getColumn();
            timeOrder = this.getTimeOrderSort(dataset.getOrders().get(0));
        }
        WorkOrderQueryParamDto paramDto = new WorkOrderQueryParamDto();
        BeanUtil.copyProperties((Object)dataset, (Object)paramDto);
        paramDto.setTimeOrder(timeOrder);
        List<CrmWorkOrderVO> list = null;
        if ("all".equals(dataset.getType())) {
            paramDto.setCurrentTime(LocalDateTime.now());
            list = ((CrmWorkOrderMapper)this.baseMapper).getAllWorkOrderPage(null, paramDto);
            review = false;
        } else if ("my".equals(dataset.getType())) {
            Long userId = BaseSecurityUtil.getUser().getUserId();
            List departmentList = this.dataRightBoService.getChargeDepartmentHasDivisions();
            CustomerAPIDto dto = new CustomerAPIDto();
            List customerList = this.customerAPIService.getCustomerList(dto);
            List<Long> custIdList = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty((Object)customerList)) {
                custIdList = customerList.stream().map(CustomerAPIVo::getCustomerId).collect(Collectors.toList());
            }
            paramDto.setDepartmentList(departmentList);
            paramDto.setCustIdList(custIdList);
            paramDto.setCurrentTime(LocalDateTime.now());
            paramDto.setUserId(userId);
            list = ((CrmWorkOrderMapper)this.baseMapper).getMyWorkOrderPage(null, paramDto);
            review = false;
        } else {
            paramDto.setServiceStatus(dataset.getType());
            paramDto.setUserId(BaseSecurityUtil.getUser().getUserId());
            paramDto.setCurrentTime(LocalDateTime.now());
            list = ((CrmWorkOrderMapper)this.baseMapper).getWorkOrderList(null, paramDto);
            review = true;
        }
        this.dictionaryTranslate(list, review);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u670d\u52a1\u5de5\u5355", CrmWorkOrderVO.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    private String getTimeOrderSort(OrderItem orderItem) {
        if ("createTime".equals(orderItem.getColumn()) && orderItem.isAsc()) {
            return "createTime_0";
        }
        if ("createTime".equals(orderItem.getColumn()) && !orderItem.isAsc()) {
            return "createTime_1";
        }
        if ("lastTime".equals(orderItem.getColumn()) && orderItem.isAsc()) {
            return "lastTime_0";
        }
        if ("lastTime".equals(orderItem.getColumn()) && !orderItem.isAsc()) {
            return "lastTime_1";
        }
        if ("expectedTime".equals(orderItem.getColumn()) && orderItem.isAsc()) {
            return "expectedTime_0";
        }
        if ("expectedTime".equals(orderItem.getColumn()) && !orderItem.isAsc()) {
            return "expectedTime_1";
        }
        return orderItem.getColumn();
    }

    private void dictionaryTranslate(List<CrmWorkOrderVO> list, boolean review) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        LinkedHashMap serviceTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.SERVICE_TYPE.getValue());
        LinkedHashMap businessTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_BUSINESS_TYPE.getValue());
        LinkedHashMap yesNoMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.YES_NO.getValue());
        LinkedHashMap urgencyLevelMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.URGENCY_LEVEL.getValue());
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        LinkedHashMap auditStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_AUDIT_STATUS.getValue());
        List customerIdList = list.stream().map(CrmWorkOrderVO::getCustId).distinct().collect(Collectors.toList());
        if (HussarUtils.isEmpty(customerIdList)) {
            return;
        }
        for (CrmWorkOrderVO workOrderVO : list) {
            workOrderVO.setServiceStatusName(serviceStatusMap.get(workOrderVO.getServiceStatus()) == null ? "" : serviceStatusMap.get(workOrderVO.getServiceStatus()).toString());
            workOrderVO.setAuditStatusName(auditStatusMap.get(workOrderVO.getIsReview()) == null ? "" : auditStatusMap.get(workOrderVO.getIsReview()).toString());
            workOrderVO.setServiceType(serviceTypeMap.get(workOrderVO.getServiceType()) == null ? "" : serviceTypeMap.get(workOrderVO.getServiceType()).toString());
            workOrderVO.setBusinessType(businessTypeMap.get(workOrderVO.getBusinessType()) == null ? "" : businessTypeMap.get(workOrderVO.getBusinessType()).toString());
            workOrderVO.setIsOnsite(yesNoMap.get(workOrderVO.getIsOnsite()) == null ? "" : yesNoMap.get(workOrderVO.getIsOnsite()).toString());
            workOrderVO.setUrgencyLevel(urgencyLevelMap.get(workOrderVO.getUrgencyLevel()) == null ? "" : urgencyLevelMap.get(workOrderVO.getUrgencyLevel()).toString());
            workOrderVO.setCreateTimeStr(workOrderVO.getCreateTime() == null ? null : workOrderVO.getCreateTime().format(YYYY_MM_DD_HH_MM_SS));
            workOrderVO.setLastTimeStr(workOrderVO.getLastTime() == null ? null : workOrderVO.getLastTime().format(YYYY_MM_DD_HH_MM_SS));
            workOrderVO.setExpectedTimeStr(workOrderVO.getExpectedTime() == null ? null : workOrderVO.getExpectedTime().format(YYYY_MM_DD));
        }
    }

    @Override
    public CrmWorkOrderDetailVO getByWoId(Long woId) {
        AssertUtil.isNotNull((Object)woId, (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders crmTktWorkOrders = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(woId);
        AssertUtil.isNotNull((Object)crmTktWorkOrders, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        CrmWorkOrderDetailVO crmWorkOrderDetailVO = new CrmWorkOrderDetailVO();
        BeanUtil.copy((Object)crmTktWorkOrders, (Object)crmWorkOrderDetailVO);
        crmWorkOrderDetailVO.setFileIdList(((CrmWorkOrderMapper)this.baseMapper).getFileIdListByBusinessId((long)woId));
        String fileIds = "";
        if (HussarUtils.isNotEmpty(crmWorkOrderDetailVO.getFileIdList())) {
            fileIds = crmWorkOrderDetailVO.getFileIdList().stream().map(Object::toString).collect(Collectors.joining(","));
        }
        crmWorkOrderDetailVO.setFileIds(fileIds);
        return crmWorkOrderDetailVO;
    }

    @Override
    public CrmWorkOrderDetailVO getDetail(WorkOrderQueryParamDto paramDto) {
        Integer dwellTime;
        Long woId = paramDto.getWoId();
        AssertUtil.isNotNull((Object)woId, (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders record = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(woId);
        if (record == null || AfterServiceConstants.NO_VIEW_PERMISSION.equals(this.isOperate(record))) {
            return null;
        }
        CrmWorkOrderDetailVO workOrder = new CrmWorkOrderDetailVO();
        BeanUtil.copyProperties((Object)record, (Object)workOrder);
        LinkedHashMap serviceTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.SERVICE_TYPE.getValue());
        workOrder.setServiceTypeName(serviceTypeMap.get(workOrder.getServiceType()) == null ? "" : serviceTypeMap.get(workOrder.getServiceType()).toString());
        LinkedHashMap businessTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_BUSINESS_TYPE.getValue());
        workOrder.setBusinessTypeName(businessTypeMap.get(workOrder.getBusinessType()) == null ? "" : businessTypeMap.get(workOrder.getBusinessType()).toString());
        LinkedHashMap yesNoMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.YES_NO.getValue());
        workOrder.setIsOnsiteName(yesNoMap.get(workOrder.getIsOnsite()) == null ? "" : yesNoMap.get(workOrder.getIsOnsite()).toString());
        LinkedHashMap urgencyLevelMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.URGENCY_LEVEL.getValue());
        workOrder.setUrgencyLevelName(urgencyLevelMap.get(workOrder.getUrgencyLevel()) == null ? "" : urgencyLevelMap.get(workOrder.getUrgencyLevel()).toString());
        LocalDateTime currentTime = LocalDateTime.now();
        boolean isNext = "4".equals(workOrder.getServiceStatus()) && workOrder.getServiceTimeliness() != null && currentTime.compareTo(workOrder.getServiceTimeliness()) > 0;
        workOrder.setIsNext(isNext ? "1" : "0");
        if (!ServiceStatusEnum.CONFIRMED.getStatusVal().equals(workOrder.getServiceStatus()) && workOrder.getExpectedTime() != null) {
            CustomerAPIVo customerAPIVo;
            List<CrmWarnRule> warnRuleList;
            Duration duration = Duration.between(workOrder.getExpectedTime(), currentTime);
            long overdueDuration = duration.toHours();
            workOrder.setOverdueDuration(overdueDuration < 0L ? null : Integer.valueOf((int)overdueDuration));
            List customerAPIVoList = this.customerAPIService.getCustomerListByIds(Collections.singletonList(workOrder.getCustId()));
            if (HussarUtils.isNotEmpty((Object)customerAPIVoList) && HussarUtils.isNotEmpty(warnRuleList = this.crmWarnRuleService.getWarnRuleByLevel((customerAPIVo = (CustomerAPIVo)customerAPIVoList.get(0)).getCustLevel()))) {
                String alertLevel = warnRuleList.stream().filter(r -> overdueDuration >= (long)r.getOverdueDuration().intValue() && workOrder.getCorrectionCount() >= r.getRectCount()).map(CrmWarnRule::getAlertLevel).max(Comparator.comparingInt(Integer::parseInt)).orElse(null);
                workOrder.setAlertLevel(alertLevel);
            }
        }
        if ((dwellTime = this.crmSlaRuleService.getDwellTimeByNodeId(workOrder.getFlowId(), workOrder.getNodeNow(), isNext ? "1" : "0")) != null) {
            LocalDateTime time = isNext ? workOrder.getServiceTimeliness() : workOrder.getLastTime();
            workOrder.setSurplusTime(CommonUtils.calcTimeDiffStr(time, currentTime, dwellTime));
        }
        workOrder.setFileIdList(((CrmWorkOrderMapper)this.baseMapper).getFileIdListByBusinessId(woId));
        Long currentNodeId = workOrder.getNodeNow();
        if (currentNodeId != null) {
            if (isNext) {
                CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
                currentNodeId = nextNode.getNodeId();
            }
            List<CrmTktFunctionDto> functionList = this.getFunctionListByNodeId(record, currentNodeId);
            workOrder.setFunctionList(functionList);
        }
        List<WorkOrderNodeDto> nodeList = ((CrmWorkOrderMapper)this.baseMapper).getNodeListByFlowId(workOrder.getFlowId());
        String nodeCode = WorkOrderEnum.getNodeCodeByStatus(workOrder.getServiceStatus());
        int isFinished = 1;
        for (WorkOrderNodeDto workOrderNodeDto : nodeList) {
            if (HussarUtils.isNotEmpty((Object)nodeCode) && nodeCode.equals(workOrderNodeDto.getNodeCode())) {
                isFinished = 0;
            }
            workOrderNodeDto.setIsFinished(isFinished);
            workOrderNodeDto.setStatus(WorkOrderEnum.getStatusByNodeCode(workOrderNodeDto.getNodeCode()));
        }
        workOrder.setNodeList(nodeList);
        workOrder.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)woId)).eq(TeamMeberEntity::getBusinessType, (Object)"23")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        return workOrder;
    }

    @Override
    public Integer isOperate(Long woId) {
        if (woId == null) {
            return AfterServiceConstants.NO_VIEW_PERMISSION;
        }
        CrmTktWorkOrders workOrders = (CrmTktWorkOrders)this.getById(woId);
        if (workOrders == null) {
            return AfterServiceConstants.NO_VIEW_PERMISSION;
        }
        return this.isOperate(workOrders);
    }

    private Integer isOperate(CrmTktWorkOrders workOrders) {
        List departmentList;
        List recordList;
        List recordUserIdList;
        SecurityUser user = BaseSecurityUtil.getUser();
        Integer operate = AfterServiceConstants.NO_VIEW_PERMISSION;
        List permissions = (List)user.getExtendUserMap("permissions");
        if (permissions.contains("all_work_order")) {
            operate = AfterServiceConstants.READONLY;
        }
        if (operate < AfterServiceConstants.READONLY && !ServiceStatusEnum.CONFIRMED.getStatusVal().equals(workOrders.getServiceStatus())) {
            Long nodeId = workOrders.getNodeNow();
            if (ServiceTypeEnum.COMPLAIN.getStatus().equals(workOrders.getServiceType()) && WorkOrderEnum.TO_DO_EVALUATION.getStatus().equals(workOrders.getServiceStatus()) && HussarUtils.isNotEmpty((Object)workOrders.getServiceTimeliness()) && LocalDateTime.now().isAfter(workOrders.getServiceTimeliness())) {
                CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrders.getFlowId(), workOrders.getNodeNow());
                nodeId = nextNode == null ? null : nextNode.getNodeId();
            }
            List<Long> assigneeUserIdList = new ArrayList<Long>();
            if (workOrders.getAssigneeId() != null) {
                assigneeUserIdList.add(workOrders.getAssigneeId());
            } else if (HussarUtils.isNotEmpty((Object)nodeId)) {
                List memberList = this.crmTktNodeMemberService.list((Wrapper)new QueryWrapper().lambda().eq(CrmTktNodeMember::getNodeId, (Object)nodeId));
                List userList = memberList.stream().filter(member -> CrmNodeMemberTypeEnum.USER.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
                List orgList = memberList.stream().filter(member -> CrmNodeMemberTypeEnum.DEPARTMENT.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
                List roleList = memberList.stream().filter(member -> CrmNodeMemberTypeEnum.ROLE.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
                List userVoList = this.hussarBaseUserBoService.getUsersByOrganUser(orgList, userList);
                if (HussarUtils.isNotEmpty(roleList)) {
                    userVoList.addAll(this.hussarBaseUserBoService.getUserInfoByRoleId(roleList));
                }
                assigneeUserIdList = userVoList.stream().filter(FunctionUtil.distinctByKey(UserVo::getId)).map(UserVo::getId).collect(Collectors.toList());
            }
            if (assigneeUserIdList.contains(user.getId())) {
                operate = AfterServiceConstants.READONLY;
            }
        }
        if ((operate < AfterServiceConstants.READONLY && !ServiceStatusEnum.NOT_SUBMIT.getStatusVal().equals(workOrders.getServiceStatus()) || "1".equals(workOrders.getIsReview())) && (recordUserIdList = (recordList = this.processingRecordService.list((Wrapper)new QueryWrapper().lambda().eq(CrmTktProcessingRecord::getWoId, (Object)workOrders.getWoId()))).stream().map(CrmTktProcessingRecord::getCreator).collect(Collectors.toList())).contains(user.getId())) {
            operate = AfterServiceConstants.READONLY;
        }
        if (operate < AfterServiceConstants.READONLY) {
            CustomerAPIDto dto = new CustomerAPIDto();
            List customerList = this.customerAPIService.getCustomerList(dto);
            List<Object> custIdList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)customerList)) {
                custIdList = customerList.stream().map(CustomerAPIVo::getCustomerId).collect(Collectors.toList());
            }
            if (custIdList.contains(workOrders.getCustId())) {
                operate = AfterServiceConstants.READONLY;
            }
        }
        if ((departmentList = this.dataRightBoService.getChargeDepartmentHasDivisions()) != null && departmentList.contains(workOrders.getPrincipalDeptId())) {
            operate = AfterServiceConstants.CAN_EDIT;
            return operate;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(TeamMeberEntity::getBusinessId, (Object)workOrders.getWoId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"23");
        List teamList = this.teamMeberService.list((Wrapper)lambdaQueryWrapper);
        if (HussarUtils.isEmpty((Object)teamList)) {
            return operate;
        }
        long editCount = teamList.stream().filter(teamMeberEntity -> "1".equals(teamMeberEntity.getModifyPower())).count();
        operate = editCount > 0L ? AfterServiceConstants.CAN_EDIT : AfterServiceConstants.READONLY;
        return operate;
    }

    @Override
    public boolean isOperateBtn(Long woId, String functionCode, Long nodeNow) {
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(woId);
        AssertUtil.isNotNull((Object)workOrder, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        AssertUtil.isTrue((workOrder.getNodeNow() != null && workOrder.getNodeNow().equals(nodeNow) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u5de5\u5355\u5df2\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        AssertUtil.isTrue(("0".equals(workOrder.getIsReview()) || FlowFunctionEnum.AUDIT_NODE_FUNCTION.contains(functionCode) ? 1 : 0) != 0, (String)"\u5f85\u5ba1\u6838\u5de5\u5355\u8bf7\u6253\u5f00\u8be6\u60c5\u8fdb\u884c\u5ba1\u6838");
        boolean flag = !"qr".equals(functionCode) || ServiceTypeEnum.REMIND.getStatus().equals(workOrder.getServiceType()) || ServiceTypeEnum.SUGGEST.getStatus().equals(workOrder.getServiceType());
        AssertUtil.isTrue((boolean)flag, (String)"\u4ec5\u5efa\u8bae\u3001\u63d0\u9192\u7c7b\u5de5\u5355\u53ef\u786e\u8ba4");
        flag = !FlowFunctionEnum.ACCEPT_NODE_FUNCTION.contains(functionCode) || ServiceTypeEnum.COMPLAIN.getStatus().equals(workOrder.getServiceType()) || ServiceTypeEnum.OTHER.getStatus().equals(workOrder.getServiceType());
        String noPermission = String.format("\u4ec5\u6295\u8bc9\u3001\u5176\u4ed6\u7c7b\u5de5\u5355\u53ef\u8fdb\u884c%s", FlowFunctionEnum.getLabelByValue(functionCode));
        AssertUtil.isTrue((boolean)flag, (String)noPermission);
        CrmTktFunction function = null;
        if (ServiceTypeEnum.COMPLAIN.getStatus().equals(workOrder.getServiceType()) && WorkOrderEnum.TO_DO_EVALUATION.getStatus().equals(workOrder.getServiceStatus()) && HussarUtils.isNotEmpty((Object)workOrder.getServiceTimeliness()) && LocalDateTime.now().isAfter(workOrder.getServiceTimeliness())) {
            if ("qrgb".equals(functionCode) || "cq".equals(functionCode)) {
                CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
                function = ((CrmWorkOrderMapper)this.baseMapper).getAuthByNodeId(nextNode.getNodeId(), functionCode);
            }
        } else {
            function = ((CrmWorkOrderMapper)this.baseMapper).getAuthByNodeId(workOrder.getNodeNow(), functionCode);
        }
        noPermission = String.format("\u6839\u636e\u6d41\u7a0b\u8bbe\u7f6e\uff0c\u5f53\u524d\u5ba2\u6237\u5de5\u5355\u4e0d\u53ef\u8fdb\u884c%s\u64cd\u4f5c", FlowFunctionEnum.getLabelByValue(functionCode));
        AssertUtil.isTrue((function != null && "1".equals(function.getIsEnabled()) ? 1 : 0) != 0, (String)noPermission);
        if ("xg".equals(functionCode) || "sc".equals(functionCode)) {
            int canEdit = this.isOperate(workOrder);
            AssertUtil.isTrue((canEdit >= AfterServiceConstants.CAN_EDIT ? 1 : 0) != 0, (String)"\u65e0\u6b64\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        }
        return true;
    }

    @Override
    public boolean checkPermission(Long woId, Long nodeNow) {
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(woId);
        AssertUtil.isNotNull((Object)workOrder, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        AssertUtil.isTrue((workOrder.getNodeNow() == null || workOrder.getNodeNow().equals(nodeNow) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u5de5\u5355\u5df2\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        return true;
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(CrmWorkOrderDto crmTktWorkOrders) {
        if (crmTktWorkOrders.getWoId() == null) {
            crmTktWorkOrders.setWoId(CommonUtils.generateAssignId());
            this.addWorkOrder(crmTktWorkOrders);
        } else {
            this.editWorkOrder(crmTktWorkOrders);
        }
        return ApiResponse.success((Object)String.valueOf(crmTktWorkOrders.getWoId()), (String)"");
    }

    @HussarTransactional
    private boolean addWorkOrder(CrmWorkOrderDto dto) {
        AssertUtil.isNotEmpty((String)dto.getServiceType(), (String)"\u670d\u52a1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)dto.getCustId(), (String)"\u5ba2\u6237\u4e0d\u53ef\u4e3a\u7a7a");
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktFlowDto crmTktFlowDto = this.crmTktFlowService.getCrmFlowByServiceTypeAndCust(dto.getServiceType(), dto.getCustId());
        AssertUtil.isNotNull((Object)crmTktFlowDto, (String)"\u6682\u65e0\u6743\u9650");
        CrmTktWorkOrders workOrder = new CrmTktWorkOrders();
        BeanUtil.copyProperties((Object)dto, (Object)workOrder);
        if (workOrder.getExpectedTime() != null) {
            workOrder.setExpectedTime(LocalDateTime.parse(workOrder.getExpectedTime().format(YYYY_MM_DD) + "T23:59:59"));
        }
        if (HussarUtils.isEmpty((Object)workOrder.getWoId())) {
            workOrder.setWoId(CommonUtils.generateAssignId());
        }
        workOrder.setFlowId(crmTktFlowDto.getFlowId());
        workOrder.setNodeNow(crmTktFlowDto.getNodeList().get(0).getNodeId());
        String nextNodeCode = crmTktFlowDto.getNodeList().get(0).getNodeCode();
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        workOrder.setPrincipalId(user.getId());
        workOrder.setPrincipalName(user.getUserName());
        workOrder.setPrincipalDeptId(user.getDeptId());
        workOrder.setPrincipalDept(user.getDeptName());
        boolean isSubmit = false;
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        if (HussarUtils.isEmpty((Object)workOrder.getServiceStatus()) || "0".equals(workOrder.getServiceStatus())) {
            workOrder.setAssigneeId(user.getId());
            workOrder.setAssigneeName(user.getUserName());
            workOrder.setAssigneeDept(user.getDeptName());
        } else {
            isSubmit = true;
            CrmTktNodeDto nextNode = crmTktFlowDto.getNodeList().get(1);
            nextNodeCode = nextNode.getNodeCode();
            workOrder.setNodeNow(nextNode.getNodeId());
            if ("0".equals(nextNode.getIsFixed())) {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setIsReview("1");
                workOrder.setServiceStatus("0");
            } else {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setIsReview("0");
                workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            }
            workOrder.setServiceNumber(WorkOrderNumberUtil.getOrderNumber(workOrder.getServiceType()));
        }
        workOrder.setCorrectionCount(0);
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setCreator(user.getId());
        workOrder.setCreatorName(user.getUserName());
        workOrder.setCreatorDept(user.getDeptName());
        workOrder.setCreateTime(currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        boolean flag = this.save(workOrder);
        if (flag) {
            List<Long> fileIdList = this.getListByStr(dto.getFileIds());
            if (HussarUtils.isNotEmpty(fileIdList)) {
                ((CrmWorkOrderMapper)this.baseMapper).updateBusinessIdByFileIdList(fileIdList, workOrder.getWoId());
            }
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "xj", workOrder.getCorrectionCount());
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), workOrder.getWoId(), "1", "1", currentTime, "23");
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_AUTOMATIC, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            if (isSubmit) {
                this.saveOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE, workOrder.getServiceTopic(), workOrder.getWoId(), "\u4ee3\u5ba2\u63d0\u4ea4", LocalDateTime.now().plusSeconds(1L));
            }
            this.sendMessage(workOrder, nextNodeCode, null, user);
        }
        return flag;
    }

    @HussarTransactional
    private boolean editWorkOrder(CrmWorkOrderDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)dto.getServiceType(), (String)"\u670d\u52a1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)dto.getCustId(), (String)"\u5ba2\u6237\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders oldWorkOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        AssertUtil.isNotNull((Object)oldWorkOrder, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        AssertUtil.isTrue((oldWorkOrder.getNodeNow() == null || oldWorkOrder.getNodeNow().equals(dto.getNodeNow()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktWorkOrders workOrder = new CrmTktWorkOrders();
        BeanUtil.copyProperties((Object)dto, (Object)workOrder);
        if (HussarUtils.isNotEmpty((Object)workOrder.getServiceNumber())) {
            CrmTktWorkOrders oldData = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
            AssertUtil.isTrue((boolean)oldData.getServiceType().equals(dto.getServiceType()), (String)"\u64a4\u56de\u540e\u670d\u52a1\u7c7b\u578b\u4e0d\u53ef\u4fee\u6539");
        }
        if (workOrder.getExpectedTime() != null) {
            workOrder.setExpectedTime(LocalDateTime.parse(workOrder.getExpectedTime().format(YYYY_MM_DD) + "T23:59:59"));
        }
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        boolean isSubmit = false;
        String nextNodeCode = null;
        if (HussarUtils.isEmpty((Object)workOrder.getServiceStatus()) || "0".equals(workOrder.getServiceStatus())) {
            workOrder.setAssigneeId(user.getId());
            workOrder.setAssigneeName(user.getUserName());
            workOrder.setAssigneeDept(user.getDeptName());
        } else {
            isSubmit = true;
            CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
            workOrder.setNodeNow(nextNode.getNodeId());
            nextNodeCode = nextNode.getNodeCode();
            if ("0".equals(nextNode.getIsFixed())) {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setIsReview("1");
                workOrder.setServiceStatus("0");
            } else {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setIsReview("0");
                workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            }
            if (HussarUtils.isEmpty((Object)workOrder.getServiceNumber())) {
                workOrder.setServiceNumber(WorkOrderNumberUtil.getOrderNumber(workOrder.getServiceType()));
            }
        }
        workOrder.setIsReject("0");
        workOrder.setCorrectionCount(oldWorkOrder.getCorrectionCount());
        workOrder.setLastEditor(user.getId());
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setLastTime(currentTime);
        boolean flag = this.updateById(workOrder);
        if (flag) {
            List<Long> oldFileIdList = ((CrmWorkOrderMapper)this.baseMapper).getFileIdListByBusinessId(dto.getWoId());
            List<Long> fileIdList = this.getListByStr(dto.getFileIds());
            this.deleteFile(workOrder.getWoId(), fileIdList);
            if (HussarUtils.isNotEmpty(fileIdList)) {
                ((CrmWorkOrderMapper)this.baseMapper).updateBusinessIdByFileIdList(fileIdList, workOrder.getWoId());
            }
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), workOrder.getWoId(), "1", "0", currentTime, "23");
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "xg", oldWorkOrder.getCorrectionCount());
            this.workOrderSaveTrackRecord(oldWorkOrder, workOrder, oldFileIdList, fileIdList);
            if (isSubmit) {
                this.saveOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE, workOrder.getServiceTopic(), workOrder.getWoId(), "\u4ee3\u5ba2\u63d0\u4ea4", LocalDateTime.now().plusSeconds(1L));
            }
            this.sendMessage(workOrder, nextNodeCode, null, user);
        }
        return flag;
    }

    @Override
    public List<WorkOrderNumberDto> getMaxOrderNumberList(List<String> prefixTimeList) {
        return ((CrmWorkOrderMapper)this.baseMapper).getMaxOrderNumberList(prefixTimeList);
    }

    @Override
    @HussarTransactional
    public boolean deleteWorkOrder(CrmWorkOrderParamDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        AssertUtil.isNotNull((Object)workOrder, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        AssertUtil.isTrue(("0".equals(workOrder.getServiceStatus()) && "0".equals(workOrder.getIsReview()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u5de5\u5355\u5df2\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        CrmTktProcessingRecord latestProcessRecord = this.processingRecordService.getLatestProcessRecord(workOrder.getWoId(), workOrder.getCorrectionCount());
        AssertUtil.isFalse((latestProcessRecord != null && "btg".equals(latestProcessRecord.getFunctionCode()) ? 1 : 0) != 0, (String)"\u5df2\u5ba1\u6838\u7684\u5de5\u5355\u4e0d\u53ef\u5220\u9664");
        AssertUtil.isEmpty((String)workOrder.getServiceNumber(), (String)"\u64a4\u56de\u7684\u5de5\u5355\u4e0d\u53ef\u5220\u9664");
        CrmTktFunction function = ((CrmWorkOrderMapper)this.baseMapper).getAuthByNodeId(workOrder.getNodeNow(), "sc");
        AssertUtil.isTrue((boolean)"1".equals(function.getIsEnabled()), (String)"\u65e0\u6b64\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        boolean flag = this.removeById(dto.getWoId());
        if (flag) {
            this.deleteFileByBusinessId(dto.getWoId());
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean withdraw(CrmWorkOrderParamDto dto) {
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        this.permission(workOrder, user, "ch", workOrder.getNodeNow(), dto.getNodeNow());
        AssertUtil.isTrue((workOrder.getCorrectionCount() == 0 ? 1 : 0) != 0, (String)"\u91cd\u542f\u7684\u5de5\u5355\u4e0d\u53ef\u64a4\u56de");
        workOrder.setAssigneeId(workOrder.getCreator());
        workOrder.setAssigneeName(workOrder.getCreatorName());
        workOrder.setAssigneeDept(workOrder.getCreatorDept());
        CrmTktNodeDto prevNode = this.crmTktFlowService.getPrevFixedNode(workOrder.getFlowId(), workOrder.getNodeNow());
        workOrder.setNodeNow(prevNode.getNodeId());
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        workOrder.setServiceStatus("0");
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(LocalDateTime.now());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmTktDispatchRecords::getDelFlag, (Object)"1")).eq(CrmTktDispatchRecords::getWoId, (Object)workOrder.getWoId())).eq(CrmTktDispatchRecords::getCorrectionCount, (Object)workOrder.getCorrectionCount());
            this.crmTktDispatchRecordsService.update((Wrapper)updateWrapper);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "ch", workOrder.getCorrectionCount());
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_WITHDRAW, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            this.sendMessage(workOrder, "ch", null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean dispatchOrders(UserInfoDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)dto.getUserId(), (String)"\u7528\u6237ID\u4e0d\u53ef\u4e3a\u7a7a");
        LocalDateTime currentTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        this.permission(workOrder, user, "pd", workOrder.getNodeNow(), dto.getNodeNow());
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        workOrder.setNodeNow(nextNode == null ? null : nextNode.getNodeId());
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        if (nextNode == null) {
            workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(""));
            workOrder.setAssigneeId(null);
            workOrder.setAssigneeName(null);
            workOrder.setAssigneeDept(null);
        } else if ("1".equals(nextNode.getIsFixed())) {
            workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            workOrder.setIsReview("0");
            workOrder.setIsReject("0");
            workOrder.setAssigneeId(dto.getUserId());
            workOrder.setAssigneeName(dto.getUserName());
            workOrder.setAssigneeDept(dto.getDeptName());
        } else {
            workOrder.setIsReview("1");
            workOrder.setIsReject("0");
            workOrder.setAssigneeId(null);
            workOrder.setAssigneeName(null);
            workOrder.setAssigneeDept(null);
        }
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        CrmTktDispatchRecords record = new CrmTktDispatchRecords();
        record.setDispatcherId(user.getId());
        record.setDispatcher(user.getUserName());
        record.setDispatcherDept(user.getDeptName());
        record.setDispatchTime(currentTime);
        record.setToReceiverId(dto.getUserId());
        record.setToReceiver(dto.getUserName());
        record.setToReceiverDept(dto.getDeptName());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        record.setDispatchId(CommonUtils.generateAssignId());
        record.setWoId(dto.getWoId());
        record.setDelFlag("0");
        boolean flag = this.updateById(workOrder);
        if (flag) {
            CrmTktDispatchRecords crmTktDispatchRecords = this.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
            if (crmTktDispatchRecords != null) {
                crmTktDispatchRecords.setDispatchTime(currentTime);
                crmTktDispatchRecords.setToReceiverId(dto.getUserId());
                crmTktDispatchRecords.setToReceiver(dto.getUserName());
                crmTktDispatchRecords.setToReceiverDept(dto.getDeptName());
                this.crmTktDispatchRecordsService.updateById(crmTktDispatchRecords);
            } else {
                this.crmTktDispatchRecordsService.save(record);
            }
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "pd", workOrder.getCorrectionCount());
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), workOrder.getWoId(), "0", "0", currentTime, "23");
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_DISPATCH, workOrder.getServiceTopic(), workOrder.getWoId(), dto.getUserName());
            this.sendMessage(workOrder, nextNode == null ? null : nextNode.getNodeCode(), null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean pass(CrmWorkOrderParamDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        LocalDateTime currentTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        this.permission(workOrder, user, "tg", workOrder.getNodeNow(), dto.getNodeNow());
        CrmTktNode currentNode = (CrmTktNode)((Object)this.crmTktNodeService.getById(workOrder.getNodeNow()));
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        this.updateNextNodeWorkOrderInfo(workOrder, nextNode, currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        CrmTktChildRecords crmTktChildRecords = new CrmTktChildRecords();
        crmTktChildRecords.setChildId(CommonUtils.generateAssignId());
        crmTktChildRecords.setReviewStatus("1");
        crmTktChildRecords.setReviewTime(currentTime);
        crmTktChildRecords.setReviewerId(workOrder.getAssigneeId());
        crmTktChildRecords.setReviewerName(workOrder.getAssigneeName());
        crmTktChildRecords.setReviewerDept(workOrder.getAssigneeDept());
        crmTktChildRecords.setFixedNode(currentNode.getFixedNodeId());
        crmTktChildRecords.setReviewSubnode(currentNode.getNodeId());
        crmTktChildRecords.setInitiatorId(workOrder.getResponsibleId());
        crmTktChildRecords.setWoId(workOrder.getWoId());
        crmTktChildRecords.setCorrectionCount(workOrder.getCorrectionCount());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktChildRecordsService.save(crmTktChildRecords);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "tg", workOrder.getCorrectionCount());
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), workOrder.getWoId(), "0", "0", currentTime, "23");
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_PASSED, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            this.sendMessage(workOrder, nextNode == null ? null : nextNode.getNodeCode(), null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean notPass(CrmWorkOrderParamDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        LocalDateTime currentTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        this.permission(workOrder, user, "btg", workOrder.getNodeNow(), dto.getNodeNow());
        CrmTktNode currentNode = (CrmTktNode)((Object)this.crmTktNodeService.getById(workOrder.getNodeNow()));
        CrmTktNodeDto prevFixedNode = this.crmTktFlowService.getPrevFixedNode(workOrder.getFlowId(), workOrder.getNodeNow());
        this.updateNextNodeWorkOrderInfo(workOrder, prevFixedNode, currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        CrmTktChildRecords crmTktChildRecords = new CrmTktChildRecords();
        crmTktChildRecords.setChildId(CommonUtils.generateAssignId());
        crmTktChildRecords.setReviewStatus("0");
        crmTktChildRecords.setReviewTime(currentTime);
        crmTktChildRecords.setReviewerId(user.getId());
        crmTktChildRecords.setReviewerName(user.getUserName());
        crmTktChildRecords.setReviewerDept(user.getDeptName());
        crmTktChildRecords.setFixedNode(currentNode.getFixedNodeId());
        crmTktChildRecords.setReviewSubnode(currentNode.getNodeId());
        crmTktChildRecords.setInitiatorId(workOrder.getResponsibleId());
        crmTktChildRecords.setWoId(workOrder.getWoId());
        crmTktChildRecords.setCorrectionCount(workOrder.getCorrectionCount());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktChildRecordsService.save(crmTktChildRecords);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "btg", workOrder.getCorrectionCount());
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), workOrder.getWoId(), "0", "0", currentTime, "23");
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_NOT_PASSED, workOrder.getServiceTopic(), workOrder.getWoId(), dto.getReason());
            this.sendMessage(workOrder, "btg", dto.getReason(), user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean close(CrmTktReceiveRecordsDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        this.permission(workOrder, user, "gb", workOrder.getNodeNow(), dto.getNodeNow());
        CrmTktDispatchRecords crmTktDispatchRecords = this.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
        workOrder.setAssigneeId(crmTktDispatchRecords.getDispatcherId());
        workOrder.setAssigneeName(crmTktDispatchRecords.getDispatcher());
        workOrder.setAssigneeDept(crmTktDispatchRecords.getDispatcherDept());
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNodeByNodeCode(workOrder.getFlowId(), "jgqr");
        workOrder.setNodeNow(nextNode.getNodeId());
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        workOrder.setPrincipalId(user.getId());
        workOrder.setPrincipalName(user.getUserName());
        workOrder.setPrincipalDeptId(user.getDeptId());
        workOrder.setPrincipalDept(user.getDeptName());
        CrmTktReceiveRecords record = new CrmTktReceiveRecords();
        BeanUtil.copyProperties((Object)dto, (Object)record);
        record.setReceiveId(CommonUtils.generateAssignId());
        record.setReceiverId(user.getId());
        record.setReceiver(user.getUserName());
        record.setReceiverDept(user.getDeptName());
        record.setReceiveTime(currentTime);
        record.setReceiveType(ReceiveTypeEnum.CLOSE.getStatus());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktReceiveRecordsService.save(record);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "gb", workOrder.getCorrectionCount());
            this.changeTeamCharge(workOrder.getWoId(), user);
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_CLOSE, workOrder.getServiceTopic(), workOrder.getWoId(), record.getReason());
            this.sendMessage(workOrder, nextNode.getNodeCode(), null, user);
        }
        return flag;
    }

    @Override
    public boolean getIsApplyMaterial(Long woId, Long nodeNow) {
        AssertUtil.isNotNull((Object)woId, (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(woId);
        AssertUtil.isTrue((nodeNow == null || nodeNow.equals(workOrder.getNodeNow()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u5de5\u5355\u5df2\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        if (ServiceTypeEnum.REMIND.getStatus().equals(workOrder.getServiceType()) || ServiceTypeEnum.SUGGEST.getStatus().equals(workOrder.getServiceType())) {
            return true;
        }
        CrmTktFunction function = ((CrmWorkOrderMapper)this.baseMapper).getAuthByNodeId(workOrder.getNodeNow(), "wzsl");
        return "1".equals(function.getIsEnabled());
    }

    @Override
    @HussarTransactional
    public boolean accept(CrmTktReceiveRecordsDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        this.permission(workOrder, user, "js", workOrder.getNodeNow(), dto.getNodeNow());
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setAssigneeId(user.getUserId());
        workOrder.setAssigneeName(user.getUserName());
        workOrder.setAssigneeDept(user.getDeptName());
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        this.updateNextNodeWorkOrderInfo(workOrder, nextNode, currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        CrmTktReceiveRecords record = new CrmTktReceiveRecords();
        BeanUtil.copyProperties((Object)dto, (Object)record);
        record.setReceiveId(CommonUtils.generateAssignId());
        record.setReceiverId(user.getId());
        record.setReceiver(user.getUserName());
        record.setReceiverDept(user.getDeptName());
        record.setReceiveTime(currentTime);
        record.setReceiveType(ReceiveTypeEnum.ACCEPT.getStatus());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        workOrder.setPrincipalId(user.getId());
        workOrder.setPrincipalName(user.getUserName());
        workOrder.setPrincipalDeptId(user.getDeptId());
        workOrder.setPrincipalDept(user.getDeptName());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktReceiveRecordsService.save(record);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "js", workOrder.getCorrectionCount());
            this.changeTeamCharge(workOrder.getWoId(), user);
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_ACCEPT, workOrder.getServiceTopic(), workOrder.getWoId(), null);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean reject(CrmTktReceiveRecordsDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        this.permission(workOrder, user, "jj", workOrder.getNodeNow(), dto.getNodeNow());
        CrmTktDispatchRecords crmTktDispatchRecords = this.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
        workOrder.setAssigneeId(crmTktDispatchRecords.getDispatcherId());
        workOrder.setAssigneeName(crmTktDispatchRecords.getDispatcher());
        workOrder.setAssigneeDept(crmTktDispatchRecords.getDispatcherDept());
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNodeByNodeCode(workOrder.getFlowId(), "pd");
        workOrder.setNodeNow(nextNode.getNodeId());
        workOrder.setIsReview("0");
        workOrder.setIsReject("1");
        workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
        workOrder.setLastEditor(user.getId());
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setLastTime(currentTime);
        CrmTktReceiveRecords record = new CrmTktReceiveRecords();
        BeanUtil.copyProperties((Object)dto, (Object)record);
        record.setReceiveId(CommonUtils.generateAssignId());
        record.setReceiverId(user.getId());
        record.setReceiver(user.getUserName());
        record.setReceiverDept(user.getDeptName());
        record.setReceiveTime(currentTime);
        record.setReceiveType(ReceiveTypeEnum.REJECT.getStatus());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktReceiveRecordsService.save(record);
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_REJECT, workOrder.getServiceTopic(), workOrder.getWoId(), dto.getReason());
            this.sendMessage(workOrder, "jj", dto.getReason(), user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean transfer(UserInfoDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)dto.getUserId(), (String)"\u8f6c\u6d3e\u4ebaID\u4e0d\u53ef\u4e3a\u7a7a");
        LocalDateTime currentTime = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        this.permission(workOrder, user, "zp", workOrder.getNodeNow(), dto.getNodeNow());
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        workOrder.setAssigneeId(dto.getUserId());
        workOrder.setAssigneeName(dto.getUserName());
        workOrder.setAssigneeDept(dto.getDeptName());
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        boolean flag = this.updateById(workOrder);
        if (flag) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(CrmTktDispatchRecords::getToReceiverId, (Object)dto.getUserId())).set(CrmTktDispatchRecords::getToReceiver, (Object)dto.getUserName())).set(CrmTktDispatchRecords::getToReceiverDept, (Object)dto.getDeptName())).eq(CrmTktDispatchRecords::getWoId, (Object)dto.getWoId())).eq(CrmTktDispatchRecords::getCorrectionCount, (Object)workOrder.getCorrectionCount());
            this.crmTktDispatchRecordsService.update((Wrapper)updateWrapper);
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_TRANSFER, workOrder.getServiceTopic(), workOrder.getWoId(), dto.getUserName());
            this.sendMessage(workOrder, "zp", null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean resultUpload(CrmTktAcceptRecordsDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(dto.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        this.permission(workOrder, user, "jgsc", workOrder.getNodeNow(), dto.getNodeNow());
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        this.updateNextNodeWorkOrderInfo(workOrder, nextNode, currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        CrmTktAcceptRecords record = new CrmTktAcceptRecords();
        record.setAcceptId(CommonUtils.generateAssignId());
        record.setAcceptorId(user.getId());
        record.setAcceptor(user.getUserName());
        record.setAcceptorDept(user.getDeptName());
        record.setAcceptTime(currentTime);
        record.setIsAccept(dto.getIsAccept());
        record.setAcceptNotes(dto.getAcceptNotes());
        record.setWoId(dto.getWoId());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            boolean recordFlag = this.crmTktAcceptRecordsService.save(record);
            List<Long> fileIdList = this.getListByStr(dto.getFileIds());
            if (recordFlag && HussarUtils.isNotEmpty(fileIdList)) {
                ((CrmWorkOrderMapper)this.baseMapper).updateBusinessIdByFileIdList(fileIdList, record.getAcceptId());
            }
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "jgsc", workOrder.getCorrectionCount());
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_RESULT_UPLOAD, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            this.sendMessage(workOrder, nextNode == null ? null : nextNode.getNodeCode(), null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean restart(CrmWorkOrderParamDto param) {
        AssertUtil.isNotNull((Object)param.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(param.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        if (WorkOrderEnum.TO_DO_EVALUATION.getStatus().equals(workOrder.getServiceStatus()) && HussarUtils.isNotEmpty((Object)workOrder.getServiceTimeliness()) && LocalDateTime.now().isAfter(workOrder.getServiceTimeliness())) {
            this.permission(workOrder, user, "cq", nextNode.getNodeId(), param.getNodeNow());
        } else {
            this.permission(workOrder, user, "cq", workOrder.getNodeNow(), param.getNodeNow());
        }
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        CrmTktNodeDto dispatchNode = this.crmTktFlowService.getNodeByNodeCode(workOrder.getFlowId(), "pd");
        workOrder.setNodeNow(dispatchNode.getNodeId());
        CrmTktDispatchRecords crmTktDispatchRecords = this.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
        workOrder.setAssigneeId(crmTktDispatchRecords.getDispatcherId());
        workOrder.setAssigneeName(crmTktDispatchRecords.getDispatcher());
        workOrder.setAssigneeDept(crmTktDispatchRecords.getDispatcherDept());
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        workOrder.setCorrectionCount(workOrder.getCorrectionCount() + 1);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(LocalDateTime.now());
        workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(dispatchNode.getNodeCode()));
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "cq", workOrder.getCorrectionCount());
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_RESTART, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            this.sendMessage(workOrder, dispatchNode.getNodeCode(), null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean confirm(CrmWorkOrderParamDto param) {
        boolean flag;
        AssertUtil.isNotNull((Object)param.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(param.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        this.permission(workOrder, user, "qr", workOrder.getNodeNow(), param.getNodeNow());
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        LocalDateTime currentTime = LocalDateTime.now();
        this.updateNextNodeWorkOrderInfo(workOrder, nextNode, currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(LocalDateTime.now());
        CrmTktReceiveRecords record = new CrmTktReceiveRecords();
        record.setReceiveId(CommonUtils.generateAssignId());
        record.setReceiverId(user.getId());
        record.setReceiver(user.getUserName());
        record.setReceiverDept(user.getDeptName());
        record.setReceiveTime(currentTime);
        record.setReceiveType(ReceiveTypeEnum.CONFIRM.getStatus());
        record.setWoId(workOrder.getWoId());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        if (workOrder.getCreator() == null && workOrder.getCorrectionCount() == 0) {
            workOrder.setPrincipalId(user.getId());
            workOrder.setPrincipalName(user.getUserName());
            workOrder.setPrincipalDeptId(user.getDeptId());
            workOrder.setPrincipalDept(user.getDeptName());
        }
        if (flag = this.updateById(workOrder)) {
            this.crmTktReceiveRecordsService.save(record);
            this.changeTeamCharge(workOrder.getWoId(), user);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "qrgb", workOrder.getCorrectionCount());
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_CONFIRM, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            this.sendMessage(workOrder, nextNode == null ? null : nextNode.getNodeCode(), null, user);
        }
        return flag;
    }

    @Override
    @HussarTransactional
    public boolean confirmClose(CrmWorkOrderParamDto param) {
        AssertUtil.isNotNull((Object)param.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((CrmWorkOrderMapper)this.baseMapper).selectById(param.getWoId());
        SecurityUser user = BaseSecurityUtil.getUser();
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        if (WorkOrderEnum.TO_DO_EVALUATION.getStatus().equals(workOrder.getServiceStatus()) && HussarUtils.isNotEmpty((Object)workOrder.getServiceTimeliness()) && LocalDateTime.now().isAfter(workOrder.getServiceTimeliness())) {
            this.permission(workOrder, user, "qrgb", nextNode.getNodeId(), param.getNodeNow());
            nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), nextNode.getNodeId());
        } else {
            this.permission(workOrder, user, "qrgb", workOrder.getNodeNow(), param.getNodeNow());
        }
        workOrder.setResponsibleId(user.getId());
        workOrder.setResponsibleName(user.getUserName());
        workOrder.setResponsibleDeptId(user.getDeptId());
        workOrder.setResponsibleDept(user.getDeptName());
        LocalDateTime currentTime = LocalDateTime.now();
        this.updateNextNodeWorkOrderInfo(workOrder, nextNode, currentTime);
        workOrder.setLastEditor(user.getId());
        workOrder.setLastTime(currentTime);
        CrmTktAuditRecords record = new CrmTktAuditRecords();
        record.setAuditId(CommonUtils.generateAssignId());
        record.setApproverId(user.getId());
        record.setAuditApprover(user.getUserName());
        record.setApproverDept(user.getDeptName());
        record.setAuditTime(currentTime);
        record.setWoId(param.getWoId());
        record.setCorrectionCount(workOrder.getCorrectionCount());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktAuditRecordsService.save(record);
            this.processingRecordService.saveProcessingRecord(workOrder.getWoId(), "qrgb", workOrder.getCorrectionCount());
            this.saveOperateLog(RecordProductTypeEnum.PRODUCE_WORK_ORDER_CONFIRM_CLOSE, workOrder.getServiceTopic(), workOrder.getWoId(), null);
            this.sendMessage(workOrder, nextNode == null ? null : nextNode.getNodeCode(), null, user);
        }
        return flag;
    }

    private void saveOperateLog(RecordProductTypeEnum productTypeEnum, String serviceTopic, Long woId, String recordContent) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(productTypeEnum.getId());
        operateRecordDO.setRecordContent(recordContent);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(woId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.AFTER_SERVICE, woId, serviceTopic, LocalDateTime.now(), false, businessIds);
    }

    private void saveOperateLog(RecordProductTypeEnum productTypeEnum, String serviceTopic, Long woId, String recordContent, LocalDateTime currentTime) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(productTypeEnum.getId());
        operateRecordDO.setRecordContent(recordContent);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(woId);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.AFTER_SERVICE, woId, serviceTopic, currentTime, false, businessIds);
    }

    public boolean permission(CrmTktWorkOrders workOrder, SecurityUser user, String functionCode, Long nodeId, Long nodeNow) {
        AssertUtil.isTrue((nodeNow == null || nodeNow.equals(nodeId) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u5de5\u5355\u5df2\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        CrmTktFunction function = ((CrmWorkOrderMapper)this.baseMapper).getAuthByNodeId(nodeId, functionCode);
        AssertUtil.isTrue((function != null && "1".equals(function.getIsEnabled()) ? 1 : 0) != 0, (String)"\u65e0\u6b64\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        List<Object> userIdList = new ArrayList<Long>();
        if (workOrder.getAssigneeId() == null) {
            userIdList = ((CrmWorkOrderMapper)this.baseMapper).selectAuditUserIdByNodeId(nodeId);
        } else {
            userIdList.add(workOrder.getAssigneeId());
        }
        AssertUtil.isTrue((boolean)userIdList.contains(user.getId()), (String)"\u65e0\u6b64\u529f\u80fd\u64cd\u4f5c\u6743\u9650");
        return true;
    }

    private List<CrmTktFunctionDto> getFunctionListByNodeId(CrmTktWorkOrders workOrder, Long nodeId) {
        List<CrmTktFunctionDto> functionList = new ArrayList<CrmTktFunctionDto>();
        List<Object> userIdList = new ArrayList<Long>();
        if (workOrder.getAssigneeId() == null) {
            userIdList = ((CrmWorkOrderMapper)this.baseMapper).selectAuditUserIdByNodeId(nodeId);
        } else {
            userIdList.add(workOrder.getAssigneeId());
        }
        if (ServiceStatusEnum.NOT_SUBMIT.getStatusVal().equals(workOrder.getServiceStatus()) && "0".equals(workOrder.getIsReview())) {
            functionList = this.crmTktFunctionService.getFunctionListByNodeId(nodeId);
            int canEdit = this.isOperate(workOrder);
            if (canEdit < AfterServiceConstants.CAN_EDIT) {
                functionList = functionList.stream().filter(f -> !"xg".equals(f.getFunctionCode()) && !"sc".equals(f.getFunctionCode())).collect(Collectors.toList());
            }
        } else if (userIdList.contains(BaseSecurityUtil.getUser().getId()) && nodeId != null) {
            functionList = this.crmTktFunctionService.getFunctionListByNodeId(nodeId);
        }
        return functionList;
    }

    private void updateNextNodeWorkOrderInfo(CrmTktWorkOrders workOrder, CrmTktNodeDto nextNode, LocalDateTime currentTime) {
        workOrder.setNodeNow(nextNode == null ? null : nextNode.getNodeId());
        if (nextNode == null) {
            workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(""));
            workOrder.setAssigneeId(null);
            workOrder.setAssigneeName(null);
            workOrder.setAssigneeDept(null);
            workOrder.setIsReview("0");
            workOrder.setIsReject("0");
        } else if ("1".equals(nextNode.getIsFixed())) {
            workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            workOrder.setIsReview("0");
            workOrder.setIsReject("0");
            if ("td".equals(nextNode.getNodeCode())) {
                workOrder.setAssigneeId(workOrder.getCreator());
                workOrder.setAssigneeName(workOrder.getCreatorName());
                workOrder.setAssigneeDept(workOrder.getCreatorDept());
            } else if (CUST_CHARGE_PERSON_NODE.contains(nextNode.getNodeCode())) {
                CrmTktDispatchRecords crmTktDispatchRecords = this.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
                if (crmTktDispatchRecords != null) {
                    workOrder.setAssigneeId(crmTktDispatchRecords.getDispatcherId());
                    workOrder.setAssigneeName(crmTktDispatchRecords.getDispatcher());
                    workOrder.setAssigneeDept(crmTktDispatchRecords.getDispatcherDept());
                } else {
                    workOrder.setAssigneeId(null);
                    workOrder.setAssigneeName(null);
                    workOrder.setAssigneeDept(null);
                }
            } else if ("fwpj".equals(nextNode.getNodeCode())) {
                CrmTktReceiveRecords crmTktReceptRecords = this.getReceptRecord(workOrder.getWoId(), workOrder.getCorrectionCount(), ReceiveTypeEnum.ACCEPT.getStatus());
                workOrder.setAssigneeId(crmTktReceptRecords == null ? null : crmTktReceptRecords.getReceiverId());
                workOrder.setAssigneeName(crmTktReceptRecords == null ? null : crmTktReceptRecords.getReceiver());
                workOrder.setAssigneeDept(crmTktReceptRecords == null ? null : crmTktReceptRecords.getReceiverDept());
                CrmTktFunction function = ((CrmWorkOrderMapper)this.baseMapper).getAuthByNodeId(workOrder.getNodeNow(), "sxsz");
                if (function != null && "1".equals(function.getIsEnabled()) && HussarUtils.isNotEmpty((Object)function.getUniqueData())) {
                    int hours = Integer.parseInt(function.getUniqueData());
                    workOrder.setServiceTimeliness(currentTime.plusHours(hours));
                }
            } else if (ACCEPT_PERSON_NODE.contains(nextNode.getNodeCode())) {
                if (ServiceTypeEnum.COMPLAIN.getStatus().equals(workOrder.getServiceType()) || ServiceTypeEnum.OTHER.getStatus().equals(workOrder.getServiceType())) {
                    CrmTktDispatchRecords crmTktDispatchRecords = this.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
                    workOrder.setAssigneeId(crmTktDispatchRecords.getToReceiverId());
                    workOrder.setAssigneeName(crmTktDispatchRecords.getToReceiver());
                    workOrder.setAssigneeDept(crmTktDispatchRecords.getToReceiverDept());
                } else {
                    CrmTktReceiveRecords crmTktReceptRecords = this.getReceptRecord(workOrder.getWoId(), workOrder.getCorrectionCount(), ReceiveTypeEnum.CONFIRM.getStatus());
                    SecurityUser user = BaseSecurityUtil.getUser();
                    workOrder.setAssigneeId(crmTktReceptRecords == null ? user.getUserId() : crmTktReceptRecords.getReceiverId());
                    workOrder.setAssigneeName(crmTktReceptRecords == null ? user.getUserName() : crmTktReceptRecords.getReceiver());
                    workOrder.setAssigneeDept(crmTktReceptRecords == null ? user.getDeptName() : crmTktReceptRecords.getReceiverDept());
                }
            }
        } else {
            workOrder.setIsReview("1");
            workOrder.setIsReject("0");
            workOrder.setAssigneeId(null);
            workOrder.setAssigneeName(null);
            workOrder.setAssigneeDept(null);
        }
    }

    private void changeTeamCharge(Long woId, SecurityUser user) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(TeamMeberEntity::getIsCharge, (Object)"0")).set(TeamMeberEntity::getMemberRole, (Object)"6")).eq(TeamMeberEntity::getBusinessId, (Object)woId)).eq(TeamMeberEntity::getBusinessType, (Object)"23")).eq(TeamMeberEntity::getIsCharge, (Object)"1")).ne(TeamMeberEntity::getPersonId, (Object)user.getId())).ne(TeamMeberEntity::getDelFlag, (Object)"1");
        this.teamMeberService.update((Wrapper)updateWrapper);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(TeamMeberEntity::getBusinessId, (Object)woId)).eq(TeamMeberEntity::getBusinessType, (Object)"23")).eq(TeamMeberEntity::getPersonId, (Object)user.getId())).ne(TeamMeberEntity::getDelFlag, (Object)"1");
        List teamMemberist = this.teamMeberService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)teamMemberist)) {
            TeamMeberEntity teamMeberEntity = (TeamMeberEntity)teamMemberist.get(0);
            teamMeberEntity.setIsCharge("1");
            this.teamMeberService.updateById((Object)teamMeberEntity);
        } else {
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), woId, "1", "1", LocalDateTime.now(), "23");
        }
    }

    private void deleteFile(Long businessId, List<Long> fileIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AttachmentManagerModel::getBusinessId, (Object)businessId)).notIn(HussarUtils.isNotEmpty(fileIdList), AttachmentManagerModel::getId, fileIdList);
        this.attachmentManagerService.remove((Wrapper)queryWrapper);
    }

    private void deleteFileByBusinessId(Long businessId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AttachmentManagerModel::getBusinessId, (Object)businessId);
        this.attachmentManagerService.remove((Wrapper)queryWrapper);
    }

    private void deleteFileByBusinessIds(List<Long> businessIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(AttachmentManagerModel::getBusinessId, businessIdList);
        this.attachmentManagerService.remove((Wrapper)queryWrapper);
    }

    private List<Long> getListByStr(String str) {
        if (HussarUtils.isEmpty((Object)str)) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(str.split(",")).filter(HussarUtils::isNotEmpty).map(Long::new).collect(Collectors.toList());
    }

    @Override
    public CrmTktDispatchRecords getDispatcher(Long woId, Integer correctionCount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktDispatchRecords::getWoId, (Object)woId)).eq(CrmTktDispatchRecords::getCorrectionCount, (Object)correctionCount)).eq(CrmTktDispatchRecords::getDelFlag, (Object)"0");
        return (CrmTktDispatchRecords)this.crmTktDispatchRecordsService.getOne((Wrapper)queryWrapper);
    }

    private CrmTktReceiveRecords getReceptRecord(Long woId, Integer correctionCount, String receiveType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktReceiveRecords::getWoId, (Object)woId)).eq(CrmTktReceiveRecords::getCorrectionCount, (Object)correctionCount)).eq(CrmTktReceiveRecords::getReceiveType, (Object)receiveType)).orderByDesc(CrmTktReceiveRecords::getReceiveTime);
        List list = this.crmTktReceiveRecordsService.list((Wrapper)queryWrapper);
        return HussarUtils.isNotEmpty((Object)list) ? (CrmTktReceiveRecords)list.get(0) : null;
    }

    @Override
    public void sendMessage(CrmTktWorkOrders workOrder, String code, String reason, SecurityUser user) {
        if (user == null) {
            user = BaseSecurityUtil.getUser();
        }
        String content = "";
        if ("1".equals(workOrder.getIsReview())) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u6709\u4e00\u6761\u5de5\u5355\u5f85\u5ba1\u6838\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", workOrder.getServiceTopic());
        } else if ("pd".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u6709\u4e00\u6761\u5de5\u5355\u5f85\u6d3e\u53d1\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", workOrder.getServiceTopic());
        } else if ("jd".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u6709\u4e00\u6761\u5de5\u5355\u5f85\u63a5\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", workOrder.getServiceTopic());
        } else if ("jgqr".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u6709\u4e00\u6761\u5de5\u5355\u5f85\u786e\u8ba4\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", workOrder.getServiceTopic());
        } else if ("ch".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u6709\u4e00\u6761\u5de5\u5355\u88ab\u64a4\u56de\uff0c\u8bf7\u77e5\u6089\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", workOrder.getServiceTopic());
        } else if ("jj".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011%s\u62d2\u7edd\u4e86\u60a8\u6d3e\u53d1\u7684\u5de5\u5355\uff0c\u8bf7\u91cd\u65b0\u6d3e\u5355\uff0c\u62d2\u7edd\u7406\u7531\uff1a%s\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", user.getUserName(), reason, workOrder.getServiceTopic());
        } else if ("zp".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011%s\u8f6c\u6d3e\u5de5\u5355\u7ed9\u60a8\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", user.getUserName(), workOrder.getServiceTopic());
        } else if ("btg".equals(code)) {
            content = String.format("\u3010\u670d\u52a1\u5de5\u5355\u3011\u60a8\u7684\u5de5\u5355%s\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff0c\u4e0d\u901a\u8fc7\u539f\u56e0\uff1a%s\u3002\u670d\u52a1\u4e3b\u9898\uff1a%s\u3002", user.getUserName(), reason, workOrder.getServiceTopic());
        } else {
            return;
        }
        List<String> messageUserIdList = new ArrayList<String>();
        List<Object> messageOrgIdList = new ArrayList();
        List<Object> messagRoleIdList = new ArrayList();
        List<String> userIdList = new ArrayList<String>();
        if (workOrder.getAssigneeId() != null) {
            userIdList.add(workOrder.getAssigneeId().toString());
            messageUserIdList.add(workOrder.getAssigneeId().toString());
        } else if (HussarUtils.isNotEmpty((Object)workOrder.getNodeNow())) {
            List memberList = this.crmTktNodeMemberService.list((Wrapper)new QueryWrapper().lambda().eq(CrmTktNodeMember::getNodeId, (Object)workOrder.getNodeNow()));
            List userList = memberList.stream().filter(member -> CrmNodeMemberTypeEnum.USER.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
            messageUserIdList = userList.stream().map(String::valueOf).collect(Collectors.toList());
            List orgList = memberList.stream().filter(member -> CrmNodeMemberTypeEnum.DEPARTMENT.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
            messageOrgIdList = orgList.stream().map(String::valueOf).collect(Collectors.toList());
            List roleList = memberList.stream().filter(member -> CrmNodeMemberTypeEnum.ROLE.getStatus().equals(member.getMemberType())).map(CrmTktNodeMember::getMemberId).collect(Collectors.toList());
            messagRoleIdList = roleList.stream().map(String::valueOf).collect(Collectors.toList());
            List userVoList = this.hussarBaseUserBoService.getUsersByOrganUser(orgList, userList);
            if (HussarUtils.isNotEmpty(roleList)) {
                userVoList.addAll(this.hussarBaseUserBoService.getUserInfoByRoleId(roleList));
            }
            userIdList = userVoList.stream().filter(FunctionUtil.distinctByKey(UserVo::getId)).map(UserVo::getId).map(String::valueOf).collect(Collectors.toList());
        }
        if (HussarUtils.isEmpty(userIdList)) {
            return;
        }
        String title = "\u670d\u52a1\u5de5\u5355\u5f85\u529e\u63d0\u9192";
        String url = "/crm/fwgd/workOrderInfo?businessId=" + workOrder.getWoId();
        EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)url, (String)workOrder.getWoId().toString(), userIdList);
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/workListDetail?row=\"" + workOrder.getWoId() + "\"";
        addSysMessageType.setBusinessAddress(unifyWebUrl);
        UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)content, (LocalDateTime)LocalDateTime.now(), (SecurityUser)user, (String)StringUtil.join(messageUserIdList, (String)","), (String)user.getUserName(), (String)unifyWebUrl, (String)"");
        addSysMessageType.setDepartmentId(StringUtil.join(messageOrgIdList, (String)","));
        addSysMessageType.setRoleId(StringUtil.join(messagRoleIdList, (String)","));
        if (addSysMessageType.getCreatoeDepartmentId() == null) {
            addSysMessageType.setCreatoeDepartmentId("0");
        }
        UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
    }

    private void workOrderSaveTrackRecord(CrmTktWorkOrders oldWorkOrder, CrmTktWorkOrders newWorkOrder, List<Long> oldFileIdList, List<Long> fileIdList) {
        HashMap<String, String> field;
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList<Map<String, Object>> changeField = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> before = new HashMap<String, Object>();
        HashMap<String, Object> after = new HashMap<String, Object>();
        changeFlag = this.compareField(WorkOrderEditConstant.SERVICE_TOPIC, oldWorkOrder.getServiceTopic(), newWorkOrder.getServiceTopic(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.CUST_NAME, oldWorkOrder.getCustName(), newWorkOrder.getCustName(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.BO_NAME, oldWorkOrder.getBoName(), newWorkOrder.getBoName(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.CONTACT_PERSON, oldWorkOrder.getContactPerson(), newWorkOrder.getContactPerson(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.CONTACT_TEL, oldWorkOrder.getContactTel(), newWorkOrder.getContactTel(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.SERVICE_TYPE, AfterServiceDictEnum.SERVICE_TYPE, oldWorkOrder.getServiceType(), newWorkOrder.getServiceType(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.BUSINESS_TYPE, AfterServiceDictEnum.WORK_BUSINESS_TYPE, oldWorkOrder.getBusinessType(), newWorkOrder.getBusinessType(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.URGENCY_LEVEL, AfterServiceDictEnum.URGENCY_LEVEL, oldWorkOrder.getUrgencyLevel(), newWorkOrder.getUrgencyLevel(), changeField, before, after, changeFlag);
        changeFlag = this.compareField(WorkOrderEditConstant.IS_ONSITE, AfterServiceDictEnum.YES_NO, oldWorkOrder.getIsOnsite(), newWorkOrder.getIsOnsite(), changeField, before, after, changeFlag);
        LocalDateTime oldExpectedTime = oldWorkOrder.getExpectedTime();
        LocalDateTime newExpectedTime = newWorkOrder.getExpectedTime();
        if (!(ToolUtil.isEmpty((Object)oldExpectedTime) && ToolUtil.isEmpty((Object)newExpectedTime) || !ToolUtil.isEmpty((Object)oldExpectedTime) && oldExpectedTime.compareTo(newExpectedTime) == 0)) {
            field = new HashMap<String, String>();
            field.put("field", WorkOrderEditConstant.EXPECTED_TIME.getField());
            field.put("fieldName", WorkOrderEditConstant.EXPECTED_TIME.getName());
            changeField.add(field);
            before.put(WorkOrderEditConstant.EXPECTED_TIME.getField(), oldExpectedTime.format(YYYY_MM_DD));
            after.put(WorkOrderEditConstant.EXPECTED_TIME.getField(), newExpectedTime.format(YYYY_MM_DD));
            changeFlag = true;
        }
        changeFlag = this.compareField(WorkOrderEditConstant.DETAIL_CONTENT, oldWorkOrder.getDetailContent(), newWorkOrder.getDetailContent(), changeField, before, after, changeFlag);
        if (!(ToolUtil.isEmpty(oldFileIdList) && ToolUtil.isEmpty(fileIdList) || !ToolUtil.isEmpty(oldFileIdList) && CollectionUtils.isEqualCollection(oldFileIdList, fileIdList))) {
            field = new HashMap();
            field.put("field", WorkOrderEditConstant.ATTACHMENT.getField());
            field.put("fieldName", WorkOrderEditConstant.ATTACHMENT.getName());
            changeField.add(field);
            before.put(WorkOrderEditConstant.ATTACHMENT.getField(), null);
            after.put(WorkOrderEditConstant.ATTACHMENT.getField(), null);
            changeFlag = true;
        }
        if (changeFlag) {
            String s = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo operateRecordDO = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), s, newJson, changeFieldStr);
            operateRecordDO.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.AFTER_SERVICE, newWorkOrder.getWoId(), newWorkOrder.getServiceTopic(), date, false, Arrays.asList(newWorkOrder.getWoId()));
        }
    }

    private boolean compareField(WorkOrderEditConstant workOrderEditConstant, String oldField, String newField, List<Map<String, Object>> changeField, Map<String, Object> before, Map<String, Object> after, boolean changeFlag) {
        if (!(ToolUtil.isEmpty((Object)oldField) && ToolUtil.isEmpty((Object)newField) || !ToolUtil.isEmpty((Object)oldField) && oldField.equals(newField))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", workOrderEditConstant.getField());
            field.put("fieldName", workOrderEditConstant.getName());
            changeField.add(field);
            before.put(workOrderEditConstant.getField(), oldField);
            after.put(workOrderEditConstant.getField(), newField);
            changeFlag = true;
        }
        return changeFlag;
    }

    private boolean compareField(WorkOrderEditConstant workOrderEditConstant, AfterServiceDictEnum afterServiceDictEnum, String oldField, String newField, List<Map<String, Object>> changeField, Map<String, Object> before, Map<String, Object> after, boolean changeFlag) {
        if (!(ToolUtil.isEmpty((Object)oldField) && ToolUtil.isEmpty((Object)newField) || !ToolUtil.isEmpty((Object)oldField) && oldField.equals(newField))) {
            LinkedHashMap serviceTypeMap = this.sysDicRefService.getDictMapByType(afterServiceDictEnum.getValue());
            String oldFieldName = serviceTypeMap.get(oldField) == null ? "" : serviceTypeMap.get(oldField).toString();
            String newFieldName = serviceTypeMap.get(newField) == null ? "" : serviceTypeMap.get(newField).toString();
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", workOrderEditConstant.getField());
            field.put("fieldName", workOrderEditConstant.getName());
            changeField.add(field);
            before.put(workOrderEditConstant.getField(), oldFieldName);
            after.put(workOrderEditConstant.getField(), newFieldName);
            changeFlag = true;
        }
        return changeFlag;
    }
}

