/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dao.CrmSlaRuleMapper;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dto.CrmSlaDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dto.CrmSlaFlowDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dto.CrmSlaRuleDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.dto.CrmSlaRuleParamDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.model.CrmSlaFlow;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.model.CrmSlaRule;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.service.ICrmSlaFlowService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.service.ICrmSlaRuleService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.vo.CrmSlaRuleDetailVO;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.sla.vo.CrmSlaRulePageVO;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmSlaRuleServiceImpl
extends HussarBaseServiceImpl<CrmSlaRuleMapper, CrmSlaRule>
implements ICrmSlaRuleService {
    @Resource
    private ICrmSlaFlowService crmSlaFlowService;
    @Resource
    private ICrmTktFlowService crmTktFlowService;

    @Override
    public IPage<CrmSlaRulePageVO> getSlaRuleList(CrmSlaRuleParamDto dto) {
        Page pages = dto.getPage();
        if (HussarUtils.isNotEmpty((Object)dto.getSlaName())) {
            dto.setSlaName(dto.getSlaName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(HussarUtils.isNotEmpty((Object)dto.getFixedNode()), CrmSlaRule::getFixedNode, (Object)dto.getFixedNode())).like(HussarUtils.isNotEmpty((Object)dto.getSlaName()), CrmSlaRule::getSlaName, (Object)dto.getSlaName())).orderByDesc(HussarBaseEntity::getCreateTime);
        IPage iPage = ((CrmSlaRuleMapper)this.baseMapper).selectPage((IPage)pages, (Wrapper)queryWrapper);
        Page result = new Page();
        result.setCurrent(iPage.getCurrent());
        result.setSize(iPage.getSize());
        if (HussarUtils.isNotEmpty((Object)iPage.getRecords())) {
            List list = BeanUtil.copy((Collection)iPage.getRecords(), CrmSlaRulePageVO.class);
            List<Long> slaIdList = iPage.getRecords().stream().map(CrmSlaRule::getSlaId).collect(Collectors.toList());
            List<CrmSlaFlowDto> slaFlowList = this.crmSlaFlowService.getCrmSlaFlowListBySlaIdList(slaIdList);
            Map<Long, String> flowNameMap = slaFlowList.stream().filter(sla -> HussarUtils.isNotEmpty((Object)sla.getFlowId())).collect(Collectors.groupingBy(CrmSlaFlowDto::getSlaId, Collectors.mapping(CrmSlaFlowDto::getFlowName, Collectors.joining(","))));
            for (CrmSlaRulePageVO crmSlaRulePageVO : list) {
                crmSlaRulePageVO.setApplicableFlow(flowNameMap.get(crmSlaRulePageVO.getSlaId()));
            }
            result.setTotal(iPage.getTotal());
            result.setRecords(list);
            result.setPages(iPage.getPages());
        }
        return result;
    }

    @Override
    @DSTransactional
    public Boolean addCrmSlaRule(CrmSlaRuleDto dto) {
        CrmSlaRule crmSlaRule = (CrmSlaRule)((Object)BeanUtil.copy((Object)dto, CrmSlaRule.class));
        Long slaId = CommonUtils.generateAssignId();
        crmSlaRule.setSlaId(slaId);
        List flowList = BeanUtil.copy(dto.getFlowList(), CrmSlaFlow.class);
        for (CrmSlaFlow crmSlaFlow : flowList) {
            crmSlaFlow.setSlaFlowId(CommonUtils.generateAssignId());
            crmSlaFlow.setSlaId(slaId);
        }
        boolean flag = this.save((BaseEntity)crmSlaRule);
        if (flag) {
            this.crmSlaFlowService.saveBatch(flowList);
        }
        return flag;
    }

    @Override
    public CrmSlaRuleDetailVO getCrmSlaRuleBySlaId(Long slaId) {
        CrmSlaRule crmSlaRule = (CrmSlaRule)((Object)this.getById(slaId));
        CrmSlaRuleDetailVO crmSlaRuleDetailVO = new CrmSlaRuleDetailVO();
        BeanUtil.copyProperties((Object)((Object)crmSlaRule), (Object)crmSlaRuleDetailVO);
        List<CrmSlaFlowDto> slaFlowList = this.crmSlaFlowService.getCrmSlaFlowListBySlaIdList(Collections.singletonList(slaId));
        crmSlaRuleDetailVO.setFlowList(slaFlowList);
        return crmSlaRuleDetailVO;
    }

    @Override
    @DSTransactional
    public Boolean editCrmSlaRule(CrmSlaRuleDto dto) {
        Long slaId = dto.getSlaId();
        AssertUtil.isNotNull((Object)slaId, (String)"SLA\u914d\u7f6eID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmSlaRule crmSlaRule = (CrmSlaRule)((Object)BeanUtil.copy((Object)dto, CrmSlaRule.class));
        List flowList = BeanUtil.copy(dto.getFlowList(), CrmSlaFlow.class);
        ArrayList<Long> slaFlowIdList = new ArrayList<Long>();
        for (CrmSlaFlow crmSlaFlow : flowList) {
            if (HussarUtils.isEmpty((Object)crmSlaFlow.getSlaFlowId())) {
                crmSlaFlow.setSlaFlowId(CommonUtils.generateAssignId());
            } else {
                slaFlowIdList.add(crmSlaFlow.getSlaFlowId());
            }
            crmSlaFlow.setSlaId(slaId);
        }
        boolean flag = this.updateById((BaseEntity)crmSlaRule);
        if (flag) {
            this.crmSlaFlowService.deleteSlaFlowBySlaIdAndNotInId(slaId, slaFlowIdList);
            this.crmSlaFlowService.saveOrUpdateBatch(flowList);
        }
        return flag;
    }

    @Override
    @DSTransactional
    public Boolean deleteCrmSlaRule(List<Long> slaIdList) {
        boolean flag = this.removeByIds(slaIdList);
        if (flag) {
            this.crmSlaFlowService.deleteSlaFlowBySlaIdList(slaIdList);
        }
        return flag;
    }

    @Override
    public Integer getDwellTimeByNodeId(Long flowId, Long nodeId, String isNext) {
        if ("1".equals(isNext)) {
            CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(flowId, nodeId);
            nodeId = nextNode.getNodeId();
        }
        if (nodeId == null) {
            return null;
        }
        Page page = new Page(1L, 1L);
        List<Integer> list = ((CrmSlaRuleMapper)this.baseMapper).getDwellTimeByNodeId(page, flowId, nodeId);
        return HussarUtils.isNotEmpty(list) ? list.get(0) : null;
    }

    @Override
    public Map<String, CrmSlaDto> getDwellTimeByFlowIds(List<Long> flowIdList) {
        if (HussarUtils.isEmpty(flowIdList)) {
            return new HashMap<String, CrmSlaDto>();
        }
        List<CrmSlaDto> list = ((CrmSlaRuleMapper)this.baseMapper).getDwellTimeByFlowIds(flowIdList);
        Map<String, CrmSlaDto> result = list.stream().collect(Collectors.groupingBy(s -> s.getFlowId() + "&" + s.getFixedNode(), Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(CrmSlaDto::getCreateTime)), Optional::get)));
        return result;
    }
}

