/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.analysis.dao.CrmAfterServerAnalysisMapper;
import com.jxdinfo.crm.afterservice.crm.analysis.dto.CrmAfterServerParamDto;
import com.jxdinfo.crm.afterservice.crm.analysis.dto.CrmSurveyParamDto;
import com.jxdinfo.crm.afterservice.crm.analysis.dto.DateParamDto;
import com.jxdinfo.crm.afterservice.crm.analysis.service.CrmAfterServerAnalysisService;
import com.jxdinfo.crm.afterservice.crm.analysis.vo.CrmAfterServerAnalysisVo;
import com.jxdinfo.crm.afterservice.crm.analysis.vo.CrmCsatSurveyAnalysisVo;
import com.jxdinfo.crm.afterservice.crm.analysis.vo.CrmWorkOrderAnalysisVo;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.WorkOrderEnum;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveysingle.model.CrmCsatSurveySingle;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurveysingle.service.CrmCsatSurveySingleService;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmAfterServerAnalysisServiceImpl
implements CrmAfterServerAnalysisService {
    @Resource
    private CrmAfterServerAnalysisMapper crmAfterServerAnalysisMapper;
    @Resource
    private CrmCsatSurveySingleService crmCsatSurveySingleService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    @Override
    public List<CrmAfterServerAnalysisVo> getAddWorkOrderCount(CrmAfterServerParamDto paramDto) {
        String timeFlag = paramDto.getTimeFlag();
        if (HussarUtils.isNotEmpty((Object)timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)timeFlag);
            paramDto.setStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            paramDto.setEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        List<CrmAfterServerAnalysisVo> list = this.crmAfterServerAnalysisMapper.getAddWorkOrderCount(paramDto);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(CrmAfterServerAnalysisVo::getName, CrmAfterServerAnalysisVo::getValue));
        ArrayList<CrmAfterServerAnalysisVo> result = new ArrayList<CrmAfterServerAnalysisVo>();
        List serviceTypeList = this.sysDicRefService.getDicListByType(AfterServiceDictEnum.SERVICE_TYPE.getValue());
        for (DicVo dicVo : serviceTypeList) {
            Integer num = countMap.get(dicVo.getValue()) == null ? Integer.valueOf(0) : countMap.get(dicVo.getValue());
            result.add(new CrmAfterServerAnalysisVo(dicVo.getValue(), dicVo.getLabel() + "\u5de5\u5355", num));
        }
        return result;
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getWorkOrderProportion(CrmAfterServerParamDto paramDto) {
        List<CrmAfterServerAnalysisVo> list = this.crmAfterServerAnalysisMapper.getAddWorkOrderCount(paramDto);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(CrmAfterServerAnalysisVo::getName, CrmAfterServerAnalysisVo::getValue));
        ArrayList<CrmAfterServerAnalysisVo> result = new ArrayList<CrmAfterServerAnalysisVo>();
        List serviceTypeList = this.sysDicRefService.getDicListByType(AfterServiceDictEnum.SERVICE_TYPE.getValue());
        for (DicVo dicVo : serviceTypeList) {
            Integer num = countMap.get(dicVo.getValue()) == null ? Integer.valueOf(0) : countMap.get(dicVo.getValue());
            result.add(new CrmAfterServerAnalysisVo(dicVo.getValue(), dicVo.getLabel(), num));
        }
        return result;
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getWorkOrderStatusAnalysis(CrmAfterServerParamDto paramDto) {
        paramDto.setCurrentTime(LocalDateTime.now());
        List<CrmAfterServerAnalysisVo> list = this.crmAfterServerAnalysisMapper.getWorkOrderToDoCount(paramDto);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(CrmAfterServerAnalysisVo::getName, CrmAfterServerAnalysisVo::getValue));
        List<WorkOrderEnum> nodeList = WorkOrderEnum.getAnalysisNodeList();
        ArrayList<CrmAfterServerAnalysisVo> result = new ArrayList<CrmAfterServerAnalysisVo>();
        for (WorkOrderEnum workOrderEnum : nodeList) {
            Integer num = countMap.get(workOrderEnum.getStatus()) == null ? Integer.valueOf(0) : countMap.get(workOrderEnum.getStatus());
            result.add(new CrmAfterServerAnalysisVo(workOrderEnum.getStatus(), workOrderEnum.getNodeName(), num));
        }
        return result;
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getCsatSurvryStatistics(CrmSurveyParamDto paramDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmCsatSurveySingle::getSurveyStatus, (Object)"1")).orderByDesc(CrmCsatSurveySingle::getPublishTime);
        Page page = new Page(1L, 1L);
        Page datePage = (Page)this.crmCsatSurveySingleService.page((IPage)page, (Wrapper)queryWrapper);
        List list = datePage.getRecords();
        List<CrmAfterServerAnalysisVo> result = new ArrayList<CrmAfterServerAnalysisVo>();
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("survey_satisfaction_rate");
        if (crmBaseConfigVo == null) {
            paramDto.setSatisfactionRate("0.8");
            paramDto.setCommonRate("0.6");
        } else {
            String[] rate = crmBaseConfigVo.getConfigValue().split("\\|");
            paramDto.setSatisfactionRate(rate[0]);
            paramDto.setCommonRate(rate[1]);
        }
        List dictList = this.sysDicRefService.getDicListByType(AfterServiceDictEnum.SURVEY_SATISFACTION.getValue());
        if (HussarUtils.isNotEmpty((Object)list)) {
            paramDto.setSurveyId(((CrmCsatSurveySingle)list.get(0)).getSurveyId());
            result = this.crmAfterServerAnalysisMapper.getCsatSurvryStatistics(paramDto);
            Map<String, String> satisfactionMap = dictList.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            for (CrmAfterServerAnalysisVo analysisVo : result) {
                analysisVo.setName(satisfactionMap.get(analysisVo.getCode()));
            }
        } else {
            for (DicVo dicVo : dictList) {
                result.add(new CrmAfterServerAnalysisVo(dicVo.getValue(), dicVo.getLabel(), 0));
            }
        }
        return result;
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getCustomerWorkOrderCount(CrmAfterServerParamDto paramDto) {
        String timeFlag = paramDto.getTimeFlag();
        if (HussarUtils.isNotEmpty((Object)timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)timeFlag);
            paramDto.setStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            paramDto.setEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        Page page = new Page(1L, 5L);
        return this.crmAfterServerAnalysisMapper.getCustomerWorkOrderCount(page, paramDto);
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getWorkOrderCountMonthly(CrmAfterServerParamDto paramDto) {
        ArrayList<DateParamDto> dtoList = new ArrayList<DateParamDto>();
        ArrayList mapList = new ArrayList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        CrmDateUtils.getNearlyMonths(mapList, (LocalDate)LocalDate.now(), (LocalDate)LocalDate.now(), (int)6);
        for (Map localDateMap : mapList) {
            LocalDateTime firstDayOfMonth = ((LocalDate)localDateMap.get("startDate")).atTime(0, 0, 0);
            LocalDateTime lastDayOfMonth = ((LocalDate)localDateMap.get("endDate")).atTime(23, 59, 59);
            String month = firstDayOfMonth.format(formatter);
            dtoList.add(new DateParamDto(firstDayOfMonth, lastDayOfMonth, month));
        }
        return this.crmAfterServerAnalysisMapper.getWorkOrderCountMonthly(null, dtoList);
    }

    @Override
    public List<CrmAfterServerAnalysisVo> getEngineerBusyStatusRanking(CrmAfterServerParamDto paramDto) {
        String timeFlag = paramDto.getTimeFlag();
        if (HussarUtils.isNotEmpty((Object)timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)timeFlag);
            paramDto.setStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            paramDto.setEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        Page page = new Page(1L, 5L);
        return this.crmAfterServerAnalysisMapper.getEngineerBusyStatusRanking(page, paramDto);
    }

    @Override
    public Page<CrmWorkOrderAnalysisVo> getWorkOrderAnalysis(CrmAfterServerParamDto paramDto) {
        String timeFlag = paramDto.getTimeFlag();
        if (HussarUtils.isNotEmpty((Object)timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)timeFlag);
            paramDto.setStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            paramDto.setEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        if (StringUtil.isNotEmpty((Object)paramDto.getMonth())) {
            YearMonth yearMonth = YearMonth.parse(paramDto.getMonth());
            LocalDateTime firstDay = yearMonth.atDay(1).atTime(0, 0, 0);
            LocalDateTime lastDay = yearMonth.atEndOfMonth().atTime(23, 59, 59);
            paramDto.setStartDate(firstDay);
            paramDto.setEndDate(lastDay);
        }
        Page pages = paramDto.getPage();
        paramDto.setCurrentTime(LocalDateTime.now());
        if (HussarUtils.isNotEmpty((Object)paramDto.getServiceTopic())) {
            paramDto.setServiceTopic(paramDto.getServiceTopic().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        }
        List<CrmWorkOrderAnalysisVo> list = this.crmAfterServerAnalysisMapper.getWorkOrderAnalysis(pages, paramDto);
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        for (CrmWorkOrderAnalysisVo analysisVo : list) {
            analysisVo.setServiceStatus(serviceStatusMap.get(analysisVo.getServiceStatus()) == null ? "" : serviceStatusMap.get(analysisVo.getServiceStatus()).toString());
        }
        pages.setRecords(list);
        return pages;
    }

    @Override
    public Page<CrmWorkOrderAnalysisVo> getEngineerWorkOrderAnalysis(CrmAfterServerParamDto paramDto) {
        String timeFlag = paramDto.getTimeFlag();
        if (HussarUtils.isNotEmpty((Object)timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)timeFlag);
            paramDto.setStartDate(LocalDateTime.parse(currentTime.getStartDate() + "T00:00:00"));
            paramDto.setEndDate(LocalDateTime.parse(currentTime.getEndDate() + "T23:59:59"));
        }
        paramDto.setCurrentTime(LocalDateTime.now());
        Page pages = paramDto.getPage();
        List<CrmWorkOrderAnalysisVo> list = this.crmAfterServerAnalysisMapper.getEngineerWorkOrderAnalysis(pages, paramDto);
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS.getValue());
        for (CrmWorkOrderAnalysisVo analysisVo : list) {
            analysisVo.setServiceStatus(serviceStatusMap.get(analysisVo.getServiceStatus()) == null ? "" : serviceStatusMap.get(analysisVo.getServiceStatus()).toString());
        }
        pages.setRecords(list);
        return pages;
    }

    @Override
    public Page<CrmCsatSurveyAnalysisVo> getCsatSurvryAnalysis(CrmSurveyParamDto paramDto) {
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("survey_satisfaction_rate");
        if (crmBaseConfigVo == null) {
            paramDto.setSatisfactionRate("0.8");
            paramDto.setCommonRate("0.6");
        } else {
            String[] rate = crmBaseConfigVo.getConfigValue().split("\\|");
            paramDto.setSatisfactionRate(rate[0]);
            paramDto.setCommonRate(rate[1]);
        }
        Page pages = paramDto.getPage();
        List<CrmCsatSurveyAnalysisVo> list = this.crmAfterServerAnalysisMapper.getCsatSurvryAnalysis(pages, paramDto);
        pages.setRecords(list);
        return pages;
    }
}

