/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.productcustomermark.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.label.model.LabelEntity;
import com.jxdinfo.crm.core.label.service.LabelService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.model.ProductCustomerLabel;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.service.ProductCustomerLabelService;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.dao.ProductCustomerMarkMapper;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.model.ProductCustomerMark;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.service.ProductCustomerMarkService;
import com.jxdinfo.crm.knowledgegraph.province.model.Province;
import com.jxdinfo.crm.knowledgegraph.province.service.ProvinceService;
import com.jxdinfo.crm.knowledgegraph.weightrule.enums.WeightRuleEnum;
import com.jxdinfo.crm.knowledgegraph.weightrule.model.CustomerWeightRule;
import com.jxdinfo.crm.knowledgegraph.weightrule.model.ProductWeight;
import com.jxdinfo.crm.knowledgegraph.weightrule.service.CustomerWeightRuleService;
import com.jxdinfo.crm.knowledgegraph.weightrule.service.ProductWeightService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProductCustomerMarkServiceImpl
extends ServiceImpl<ProductCustomerMarkMapper, ProductCustomerMark>
implements ProductCustomerMarkService {
    @Resource
    CustomerService customerService;
    @Resource
    ProductService productService;
    @Resource
    OpportunityService opportunityService;
    @Resource
    OpportunityProductService opportunityProductService;
    @Resource
    ProductCustomerLabelService productCustomerLabelService;
    @Resource
    ProductWeightService productWeightService;
    @Resource
    CustomerWeightRuleService customerWeightRuleService;
    @Resource
    private ISysDicSingleService iSysDicSingleService;
    @Resource
    private LabelService labelService;
    @Resource
    private ProvinceService provinceService;

    @Override
    public void calculateMark() {
        try {
            List dicSingles = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548815204545470464"));
            HashMap<String, String> industryMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty((Collection)dicSingles)) {
                for (DicSingle dicSingle : dicSingles) {
                    industryMap.put(dicSingle.getValue(), dicSingle.getLabel());
                }
            }
            List dicSingleList = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548455363687751680"));
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty((Collection)dicSingleList)) {
                for (DicSingle dicSingle : dicSingleList) {
                    attributeMap.put(dicSingle.getValue(), dicSingle.getLabel());
                }
            }
            List provinces = this.provinceService.list();
            HashMap<String, String> provinceMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty((Collection)provinces)) {
                for (Province province : provinces) {
                    provinceMap.put(province.getProvinceId().toString(), province.getProvinceName());
                }
            }
            List labelEntities = this.labelService.list();
            HashMap<String, String> labelMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty((Collection)labelEntities)) {
                for (LabelEntity labelEntity : labelEntities) {
                    labelMap.put(labelEntity.getLabelId().toString(), labelEntity.getLabelName());
                }
            }
            List customers = this.customerService.list((Wrapper)new LambdaQueryWrapper().eq(CustomerEntity::getDelFlag, (Object)Character.valueOf('0')));
            List products = this.productService.list((Wrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)Character.valueOf('0')));
            List opportunityProducts = this.opportunityProductService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getDelFlag, (Object)Character.valueOf('0')));
            HashMap productOpportunity = new HashMap();
            for (OpportunityProduct opportunityProduct : opportunityProducts) {
                Set<Long> ids = new HashSet<Long>();
                if (productOpportunity.containsKey(opportunityProduct.getProductId())) {
                    ids = (Set)productOpportunity.get(opportunityProduct.getProductId());
                    ids.add(opportunityProduct.getOpportunityId());
                } else {
                    ids.add(opportunityProduct.getOpportunityId());
                }
                productOpportunity.put(opportunityProduct.getProductId(), ids);
            }
            List opportunityEntities = this.opportunityService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getDelFlag, (Object)Character.valueOf('0')));
            List opportunityEntitieList = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getCustomerStageId, Arrays.asList("6", "9223372036854775801"))).eq(OpportunityEntity::getDelFlag, (Object)Character.valueOf('0')));
            HashMap<Long, Long> opportunityCustomer = new HashMap<Long, Long>();
            HashMap<Long, Long> opportunityCustomerWin = new HashMap<Long, Long>();
            for (OpportunityEntity opportunityEntity : opportunityEntities) {
                if (opportunityEntity.getCustomerId() == null) continue;
                opportunityCustomer.put(opportunityEntity.getOpportunityId(), opportunityEntity.getCustomerId());
            }
            for (OpportunityEntity opportunityEntity : opportunityEntitieList) {
                if (opportunityEntity.getCustomerId() == null) continue;
                opportunityCustomerWin.put(opportunityEntity.getOpportunityId(), opportunityEntity.getCustomerId());
            }
            HashMap<Long, Set<Long>> productCustomerMap = new HashMap<Long, Set<Long>>();
            HashMap<Long, Set<Long>> productCustomerWinMap = new HashMap<Long, Set<Long>>();
            for (Long productId : productOpportunity.keySet()) {
                HashSet customerIds = new HashSet();
                HashSet winCustomerIds = new HashSet();
                for (Long opportunityId : (Set)productOpportunity.get(productId)) {
                    if (opportunityCustomer.containsKey(opportunityId)) {
                        customerIds.add(opportunityCustomer.get(opportunityId));
                    }
                    if (!opportunityCustomerWin.containsKey(opportunityId)) continue;
                    winCustomerIds.add(opportunityCustomer.get(opportunityId));
                }
                productCustomerMap.put(productId, customerIds);
                productCustomerWinMap.put(productId, winCustomerIds);
            }
            CustomerWeightRule productProportionRule = (CustomerWeightRule)this.customerWeightRuleService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomerWeightRule::getRuleName, (Object)WeightRuleEnum.ProductProportionRule));
            double threshold = ToolUtil.isNotEmpty((Object)productProportionRule) && ToolUtil.isNotEmpty((Object)productProportionRule.getThreshold()) ? (double)productProportionRule.getThreshold().intValue() : 50.0;
            ArrayList<ProductCustomerMark> productCustomerMarks = new ArrayList<ProductCustomerMark>();
            for (Product product : products) {
                List productCustomerLabels = this.productCustomerLabelService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProductCustomerLabel::getProductId, (Object)product.getProductId())).gt(ProductCustomerLabel::getIdentifierPercentage, (Object)threshold));
                ArrayList<String> aiTagLabels = new ArrayList<String>();
                ArrayList<String> tagLabels = new ArrayList<String>();
                ArrayList<String> industryLabels = new ArrayList<String>();
                ArrayList<String> customerAttributeLabels = new ArrayList<String>();
                ArrayList<String> provinceLabels = new ArrayList<String>();
                for (ProductCustomerLabel productCustomerLabel : productCustomerLabels) {
                    switch (productCustomerLabel.getIdentifierType()) {
                        case "1": {
                            aiTagLabels.add(productCustomerLabel.getIdentifierId());
                            break;
                        }
                        case "2": {
                            tagLabels.add(productCustomerLabel.getIdentifierId());
                            break;
                        }
                        case "3": {
                            industryLabels.add(productCustomerLabel.getIdentifierId());
                            break;
                        }
                        case "4": {
                            customerAttributeLabels.add(productCustomerLabel.getIdentifierId());
                            break;
                        }
                        case "5": {
                            provinceLabels.add(productCustomerLabel.getIdentifierId());
                        }
                    }
                }
                List productWeights = this.productWeightService.list((Wrapper)new LambdaQueryWrapper().eq(ProductWeight::getProductId, (Object)product.getProductId()));
                HashMap<String, ProductWeight> productWeightMap = new HashMap();
                if (ToolUtil.isNotEmpty((Object)productWeights)) {
                    productWeightMap = productWeights.stream().collect(Collectors.toMap(ProductWeight::getType, p -> p));
                }
                for (CustomerEntity customer : customers) {
                    boolean isPurchased = this.judgeProductCustomer(customer.getCustomerId(), product.getProductId(), productCustomerMap);
                    boolean isBargain = this.judgeProductCustomer(customer.getCustomerId(), product.getProductId(), productCustomerWinMap);
                    if (isBargain) {
                        ProductCustomerMarkServiceImpl.addProductCustomerMark(product, customer, productCustomerMarks, 0.0, "1", new StringBuffer());
                        continue;
                    }
                    if (isPurchased) {
                        ProductCustomerMarkServiceImpl.addProductCustomerMark(product, customer, productCustomerMarks, 0.0, "2", new StringBuffer());
                        continue;
                    }
                    double mark = 0.0;
                    StringBuffer markDetail = new StringBuffer();
                    mark = this.getTagMark(customer.getLabelId(), aiTagLabels, productWeightMap, "1", mark, labelMap, markDetail);
                    mark = this.getTagMark(customer.getAiTags(), tagLabels, productWeightMap, "2", mark, labelMap, markDetail);
                    mark = this.getMark(customer.getTrade(), industryLabels, productWeightMap, "3", mark, 10, industryMap, markDetail);
                    mark = this.getMark(customer.getCustomerAttribute(), customerAttributeLabels, productWeightMap, "4", mark, 30, attributeMap, markDetail);
                    mark = this.getMark(customer.getProvince(), provinceLabels, productWeightMap, "5", mark, 20, provinceMap, markDetail);
                    if (!(mark > 0.0)) continue;
                    markDetail.append("\u603b\u79ef\u5206: ").append(mark).append("\u5206\u3002");
                    ProductCustomerMarkServiceImpl.addProductCustomerMark(product, customer, productCustomerMarks, mark, "0", markDetail);
                }
            }
            ((ProductCustomerMarkMapper)this.getBaseMapper()).deleteAll();
            this.saveBatch(productCustomerMarks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addProductCustomerMark(Product product, CustomerEntity customer, List<ProductCustomerMark> productCustomerMarks, double mark, String customerFlag, StringBuffer stringBuffer) {
        ProductCustomerMark productCustomerMark = new ProductCustomerMark();
        productCustomerMark.setCustomerId(customer.getCustomerId());
        productCustomerMark.setProductId(product.getProductId());
        productCustomerMark.setMark(mark);
        productCustomerMark.setCustomerFlag(customerFlag);
        productCustomerMark.setCustomerMark(stringBuffer.toString());
        productCustomerMarks.add(productCustomerMark);
    }

    private boolean judgeProductCustomer(Long customerId, Long productId, Map<Long, Set<Long>> productCustomerMap) {
        if (!productCustomerMap.containsKey(productId)) {
            return false;
        }
        return productCustomerMap.get(productId).contains(customerId);
    }

    private double getMark(String label, List<String> labels, Map<String, ProductWeight> productWeightMap, String type, double mark, int intMark, Map<String, String> industryMap, StringBuffer markDetail) {
        if (labels.contains(label)) {
            if (mark == 0.0) {
                mark = 1.0;
            }
            int markRule = intMark;
            int weightRule = 1;
            if (ToolUtil.isNotEmpty(productWeightMap) && ToolUtil.isNotEmpty((Object)productWeightMap.get(type))) {
                markRule = productWeightMap.get(type).getMark();
                weightRule = productWeightMap.get(type).getWeight();
            }
            double markLabel = (ToolUtil.isNotEmpty((Object)markRule) ? markRule : 30) * (ToolUtil.isNotEmpty((Object)weightRule) ? weightRule : 1);
            mark *= markLabel;
            switch (type) {
                case "3": {
                    markDetail.append(industryMap.get(label)).append("\u884c\u4e1a: \u79ef\u5206").append(markLabel).append("; ");
                    break;
                }
                case "5": {
                    markDetail.append(industryMap.get(label)).append("\u5730\u57df: \u79ef\u5206").append(markLabel).append("; ");
                    break;
                }
                default: {
                    markDetail.append(industryMap.get(label)).append(": \u79ef\u5206").append(markLabel).append("; ");
                }
            }
        }
        return mark;
    }

    private double getTagMark(String tags, List<String> tagLabels, Map<String, ProductWeight> productWeightMap, String type, double mark, Map<String, String> labelMap, StringBuffer markDetail) {
        if (ToolUtil.isNotEmpty((Object)tags)) {
            String[] aiTags;
            for (String aiTag : aiTags = tags.split(",")) {
                if (!tagLabels.contains(aiTag)) continue;
                int markRule = 10;
                int weightRule = 1;
                if (ToolUtil.isNotEmpty(productWeightMap) && ToolUtil.isNotEmpty((Object)productWeightMap.get(type))) {
                    markRule = productWeightMap.get(type).getMark();
                    weightRule = productWeightMap.get(type).getWeight();
                }
                double markLabel = (ToolUtil.isNotEmpty((Object)markRule) ? markRule : 10) * (ToolUtil.isNotEmpty((Object)weightRule) ? weightRule : 1);
                mark += markLabel;
                markDetail.append(labelMap.get(aiTag)).append("\u6807\u7b7e: \u79ef\u5206").append(markLabel).append("; ");
            }
        }
        return mark;
    }

    @Override
    public List<CustomerEntity> getPotentialCustomer(Long productId) {
        int threshold;
        CustomerWeightRule productProportionRule = (CustomerWeightRule)this.customerWeightRuleService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomerWeightRule::getRuleName, (Object)WeightRuleEnum.ProductLimitRule));
        int n = threshold = ToolUtil.isNotEmpty((Object)productProportionRule) && ToolUtil.isNotEmpty((Object)productProportionRule.getThreshold()) ? productProportionRule.getThreshold() : 0;
        if (threshold == 0) {
            return ((ProductCustomerMarkMapper)this.getBaseMapper()).getPotentialCustomer(productId);
        }
        List productCustomerMarks = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProductCustomerMark::getProductId, (Object)productId)).gt(ProductCustomerMark::getMark, (Object)threshold));
        ArrayList<Long> customerIds = new ArrayList<Long>();
        for (ProductCustomerMark productCustomerMark : productCustomerMarks) {
            customerIds.add(productCustomerMark.getCustomerId());
        }
        return this.customerService.listByIds(customerIds);
    }
}

