/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.productcustomerlabel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.label.service.LabelService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.dao.ProductCustomerLabelMapper;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.model.ProductCustomerLabel;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.service.ProductCustomerLabelService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ProductCustomerLabelServiceImpl
extends ServiceImpl<ProductCustomerLabelMapper, ProductCustomerLabel>
implements ProductCustomerLabelService {
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CustomerService customerService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private LabelService labelService;

    @Override
    public void countLabelNumber() {
        List opportunityProducts = this.opportunityProductService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getDelFlag, (Object)"0"));
        HashMap productOpportunity = new HashMap();
        HashSet<Long> opportunityIds = new HashSet<Long>();
        for (OpportunityProduct opportunityProduct : opportunityProducts) {
            opportunityIds.add(opportunityProduct.getOpportunityId());
            Set<Long> ids = new HashSet<Long>();
            if (productOpportunity.containsKey(opportunityProduct.getProductId())) {
                ids = (Set)productOpportunity.get(opportunityProduct.getProductId());
                ids.add(opportunityProduct.getOpportunityId());
            } else {
                ids.add(opportunityProduct.getOpportunityId());
            }
            productOpportunity.put(opportunityProduct.getProductId(), ids);
        }
        List opportunityEntities = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OpportunityEntity::getOpportunityId, opportunityIds)).eq(OpportunityEntity::getDelFlag, (Object)"0")).in(OpportunityEntity::getCustomerStageId, Arrays.asList("6", "9223372036854775801")));
        HashSet<Long> customerIds = new HashSet<Long>();
        HashMap<Long, Long> opportunityCustomer = new HashMap<Long, Long>();
        for (OpportunityEntity opportunityEntity : opportunityEntities) {
            if (opportunityEntity.getCustomerId() == null) continue;
            customerIds.add(opportunityEntity.getCustomerId());
            opportunityCustomer.put(opportunityEntity.getOpportunityId(), opportunityEntity.getCustomerId());
        }
        List customerEntities = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerEntity::getCustomerId, customerIds)).eq(CustomerEntity::getDelFlag, (Object)Character.valueOf('0')));
        HashMap<Long, CustomerEntity> customerEntityMap = new HashMap<Long, CustomerEntity>();
        for (CustomerEntity customerEntity : customerEntities) {
            customerEntityMap.put(customerEntity.getCustomerId(), customerEntity);
        }
        ArrayList<ProductCustomerLabel> productCustomerLabels = new ArrayList<ProductCustomerLabel>();
        for (Long productId : productOpportunity.keySet()) {
            ProductCustomerLabel productCustomerLabel;
            HashMap<String, Integer> aiTags = new HashMap<String, Integer>();
            HashMap<String, Integer> tags = new HashMap<String, Integer>();
            HashMap<String, Integer> industry = new HashMap<String, Integer>();
            HashMap<String, Integer> province = new HashMap<String, Integer>();
            HashMap<String, Integer> customerAttribute = new HashMap<String, Integer>();
            Set longs = (Set)productOpportunity.get(productId);
            int counts = 0;
            HashSet<CustomerEntity> customerIdSet = new HashSet<CustomerEntity>();
            for (Long opportunityId : longs) {
                CustomerEntity customerEntity = (CustomerEntity)customerEntityMap.get(opportunityCustomer.get(opportunityId));
                if (Objects.isNull(customerEntity) || customerIdSet.contains(customerEntity)) continue;
                customerIdSet.add(customerEntity);
                ++counts;
                String[] labelIds = null;
                String[] aiLabel = null;
                if (!StringUtils.isEmpty((Object)customerEntity.getLabelId())) {
                    labelIds = customerEntity.getLabelId().split(",");
                }
                if (!StringUtils.isEmpty((Object)customerEntity.getAiTags())) {
                    aiLabel = customerEntity.getAiTags().split(",");
                }
                if (!StringUtils.isEmpty((Object)customerEntity.getTrade())) {
                    industry.merge(customerEntity.getTrade(), 1, Integer::sum);
                }
                if (!StringUtils.isEmpty((Object)customerEntity.getCustomerAttribute())) {
                    customerAttribute.merge(customerEntity.getCustomerAttribute(), 1, Integer::sum);
                }
                if (!StringUtils.isEmpty((Object)customerEntity.getProvince())) {
                    province.merge(customerEntity.getProvince(), 1, Integer::sum);
                }
                if (labelIds != null) {
                    for (String labelId : labelIds) {
                        aiTags.merge(labelId, 1, Integer::sum);
                    }
                }
                if (aiLabel == null) continue;
                for (String aitag : aiLabel) {
                    tags.merge(aitag, 1, Integer::sum);
                }
            }
            if (!CollectionUtils.isEmpty(aiTags)) {
                for (String aiTag : aiTags.keySet()) {
                    productCustomerLabel = new ProductCustomerLabel(aiTag, "1", productId, new BigDecimal((double)((Integer)aiTags.get(aiTag)).intValue() * 100.0 / (double)counts).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    productCustomerLabels.add(productCustomerLabel);
                }
            }
            if (!CollectionUtils.isEmpty(tags)) {
                for (String tag : tags.keySet()) {
                    productCustomerLabel = new ProductCustomerLabel(tag, "2", productId, new BigDecimal((double)((Integer)tags.get(tag)).intValue() * 100.0 / (double)counts).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    productCustomerLabels.add(productCustomerLabel);
                }
            }
            if (!CollectionUtils.isEmpty(industry)) {
                for (String tag : industry.keySet()) {
                    productCustomerLabel = new ProductCustomerLabel(tag, "3", productId, new BigDecimal((double)((Integer)industry.get(tag)).intValue() * 100.0 / (double)counts).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    productCustomerLabels.add(productCustomerLabel);
                }
            }
            if (!CollectionUtils.isEmpty(province)) {
                for (String tag : province.keySet()) {
                    productCustomerLabel = new ProductCustomerLabel(tag, "5", productId, new BigDecimal((double)((Integer)province.get(tag)).intValue() * 100.0 / (double)counts).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    productCustomerLabels.add(productCustomerLabel);
                }
            }
            if (CollectionUtils.isEmpty(customerAttribute)) continue;
            for (String tag : customerAttribute.keySet()) {
                productCustomerLabel = new ProductCustomerLabel(tag, "4", productId, new BigDecimal((double)((Integer)customerAttribute.get(tag)).intValue() * 100.0 / (double)counts).setScale(2, RoundingMode.HALF_UP).doubleValue());
                productCustomerLabels.add(productCustomerLabel);
            }
        }
        ((ProductCustomerLabelMapper)this.getBaseMapper()).deleteAll();
        this.saveBatch(productCustomerLabels);
    }
}

