/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.graph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.config.CrmProperties;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmcampaign1.model.CrmCampaign1;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmcampaign1.service.CrmCampaign1Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.model.BaseArea1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.label.model.LabelEntity;
import com.jxdinfo.crm.core.label.model.LabelGroupEntity;
import com.jxdinfo.crm.core.label.service.LabelGroupService;
import com.jxdinfo.crm.core.label.service.LabelService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.trackrecord.model.TrackRecord;
import com.jxdinfo.crm.core.trackrecord.service.TrackRecordService;
import com.jxdinfo.crm.knowledgegraph.city.model.City;
import com.jxdinfo.crm.knowledgegraph.city.service.CityService;
import com.jxdinfo.crm.knowledgegraph.contactcharger.model.ContactCharger;
import com.jxdinfo.crm.knowledgegraph.contactcharger.service.ContactChargerService;
import com.jxdinfo.crm.knowledgegraph.contactdepartment.dto.ContactDepartmentVo;
import com.jxdinfo.crm.knowledgegraph.contactdepartment.model.ContactDepartment;
import com.jxdinfo.crm.knowledgegraph.contactdepartment.service.ContactDepartmentService;
import com.jxdinfo.crm.knowledgegraph.contract.service.ContractService;
import com.jxdinfo.crm.knowledgegraph.customerType.model.CustomerType;
import com.jxdinfo.crm.knowledgegraph.customerType.service.CustomerTypeService;
import com.jxdinfo.crm.knowledgegraph.customerlabel.model.CustomerLabel;
import com.jxdinfo.crm.knowledgegraph.customerlabel.service.CustomerLabelService;
import com.jxdinfo.crm.knowledgegraph.graph.dao.AtlasMapper;
import com.jxdinfo.crm.knowledgegraph.graph.dto.AtlasResponse;
import com.jxdinfo.crm.knowledgegraph.graph.dto.CustomerRecommendVo;
import com.jxdinfo.crm.knowledgegraph.graph.dto.FilterForm;
import com.jxdinfo.crm.knowledgegraph.graph.job.service.CalculateWeightAddService;
import com.jxdinfo.crm.knowledgegraph.graph.job.service.CalculateWeightService;
import com.jxdinfo.crm.knowledgegraph.graph.service.NodeAndRelationService;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.service.ProductCustomerLabelService;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.model.ProductCustomerMark;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.service.ProductCustomerMarkService;
import com.jxdinfo.crm.knowledgegraph.productdept.model.ProductDepartment;
import com.jxdinfo.crm.knowledgegraph.productdept.service.ProductDepartmentService;
import com.jxdinfo.crm.knowledgegraph.productmanager.model.ProductManagerGraph;
import com.jxdinfo.crm.knowledgegraph.productmanager.service.ProductManagerGraphService;
import com.jxdinfo.crm.knowledgegraph.producttype.model.ProductType;
import com.jxdinfo.crm.knowledgegraph.producttype.service.ProductTypeService;
import com.jxdinfo.crm.knowledgegraph.province.model.Province;
import com.jxdinfo.crm.knowledgegraph.province.service.ProvinceService;
import com.jxdinfo.crm.knowledgegraph.salesdepartment.model.SalesDepartment;
import com.jxdinfo.crm.knowledgegraph.salesdepartment.service.SalesDepartmentService;
import com.jxdinfo.crm.knowledgegraph.salesperson.model.SalesPerson;
import com.jxdinfo.crm.knowledgegraph.salesperson.service.SalesPersonService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@HussarDs(value="graph")
public class NodeAndRelationServiceImpl
implements NodeAndRelationService {
    private static final Logger logger = LoggerFactory.getLogger(NodeAndRelationServiceImpl.class);
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ContactService contactService;
    @Resource
    private CompetitorService competitorService;
    @Resource
    private ProductService productService;
    @Resource
    private LabelService labelService;
    @Resource
    private LabelGroupService labelGroupService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private AtlasMapper atlasMapper;
    @Resource
    private CustomerLabelService customerLabelService;
    @Resource
    private ContactDepartmentService contactDepartmentService;
    @Resource
    private CustomerTypeService customerTypeService;
    @Resource
    private ProvinceService provinceService;
    @Resource
    private CityService cityService;
    @Resource
    private BaseArea1Service area1Service;
    @Autowired
    private CalculateWeightService calculateWeightService;
    @Autowired
    private CalculateWeightAddService calculateWeightAddService;
    @Autowired
    private ProductCustomerLabelService productCustomerLabelService;
    @Autowired
    private ProductCustomerMarkService productCustomerMarkService;
    @Resource
    private CrmProperties crmProperties;
    @Resource
    private ISysDicSingleService iSysDicSingleService;
    @Resource
    private SalesPersonService salesPersonService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private TrackRecordService trackRecordService;
    @Resource
    private CrmCampaign1Service crmCampaign1Service;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private SalesDepartmentService salesDepartmentService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ContactChargerService contactChargerService;
    @Resource
    private ProductDepartmentService productDepartmentService;
    @Resource
    private ProductTypeService productTypeService;
    @Resource
    private ProductManagerGraphService productManagerGraphService;
    @Resource
    private ContractService contractService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        logger.info("\u5f00\u59cb\u6784\u5efa\u56fe\u8c31");
        String url = this.crmProperties.getRequestGraphRebuildUrl();
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        try {
            String resultJson;
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setConnectTimeout(10000);
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((resultJson = br.readLine()) != null) {
                response.append(new String(resultJson.trim().getBytes(), "UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        AtlasResponse atlasResponse = (AtlasResponse)JSONObject.parseObject((String)String.valueOf(response), AtlasResponse.class);
        if (atlasResponse.isSuccess()) {
            logger.info("\u6784\u5efa\u56fe\u8c31\u7ed3\u675f", (Object)atlasResponse.getMsg());
        } else {
            logger.error("\u56fe\u8c31\u6784\u5efa\u5931\u8d25", (Object)atlasResponse.getMsg());
        }
    }

    @Override
    public void buildGraphData() throws Exception {
        this.contractService.saveContracts();
        logger.info("\u5f00\u59cb\u6267\u884c\u56fe\u8c31SQL\u811a\u672c");
        int tradeTypeExists = this.atlasMapper.getTableColumnExists("CRM_CUSTOMER", "TRADE_TYPE");
        if (tradeTypeExists == 0) {
            this.atlasMapper.executeSql("ALTER TABLE crm_customer ADD TRADE_TYPE varchar(100) NULL;");
        }
        InputStream inputStream = NodeAndRelationServiceImpl.class.getClassLoader().getResourceAsStream("graph.sql");
        String sql = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
        this.atlasMapper.executeSql(sql);
        logger.info("\u6267\u884c\u56fe\u8c31SQL\u811a\u672c\u7ed3\u675f");
        this.calculateWeightService.calculateWeight();
        this.calculateWeightAddService.calculateWeight();
        this.productCustomerLabelService.countLabelNumber();
        this.productCustomerMarkService.calculateMark();
        this.customerLabel();
        this.concatDept();
        this.customerType();
        this.changeProvinceId();
        this.addCustomerCity();
        this.addSalesPerson();
        this.addSalesDepartment();
        this.addSalesPersonLeader();
        this.addContactCharger();
        this.addProductDepartment();
        this.addProductType();
        this.addProductManager();
        this.rebuild();
    }

    private void addProductManager() {
        List products = this.productService.list();
        if (!CollectionUtils.isEmpty((Collection)products)) {
            List<ProductManagerGraph> productManagerGraphs = new ArrayList();
            for (Product product : products) {
                if (product.getProductManager() == null) continue;
                ProductManagerGraph productManagerGraph = new ProductManagerGraph();
                productManagerGraph.setManagerId(product.getProductManager());
                productManagerGraph.setManagerName(product.getProductManagerName());
                productManagerGraphs.add(productManagerGraph);
            }
            productManagerGraphs = productManagerGraphs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductManagerGraph>(Comparator.comparing(ProductManagerGraph::getManagerId))), ArrayList::new));
            this.productManagerGraphService.remove((Wrapper)new QueryWrapper());
            this.productManagerGraphService.saveBatch(productManagerGraphs);
        }
    }

    private void addProductType() {
        List dicSingles = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548457114390241280"));
        if (!CollectionUtils.isEmpty((Collection)dicSingles)) {
            ArrayList<ProductType> productTypes = new ArrayList<ProductType>();
            for (DicSingle dicSingle : dicSingles) {
                ProductType productType = new ProductType();
                productType.setProductTypeValue(dicSingle.getValue());
                productType.setProductTypeLabel(dicSingle.getLabel());
                productTypes.add(productType);
            }
            this.productTypeService.remove((Wrapper)new QueryWrapper());
            this.productTypeService.saveBatch(productTypes);
        }
    }

    private void addProductDepartment() {
        List products = this.productService.list();
        if (!CollectionUtils.isEmpty((Collection)products)) {
            List<ProductDepartment> productDepartments = new ArrayList();
            for (Product product : products) {
                if (product.getOwnDepartment() == null) continue;
                ProductDepartment productDepartment = new ProductDepartment();
                productDepartment.setDepartmentId(product.getOwnDepartment());
                productDepartment.setDepartmentName(product.getOwnDepartmentName());
                productDepartments.add(productDepartment);
            }
            productDepartments = productDepartments.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductDepartment>(Comparator.comparing(ProductDepartment::getDepartmentId))), ArrayList::new));
            this.productDepartmentService.remove((Wrapper)new QueryWrapper());
            this.productDepartmentService.saveBatch(productDepartments);
        }
    }

    private void addContactCharger() {
        List contactEntities = this.contactService.list();
        List<ContactCharger> contactChargers = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)contactEntities)) {
            for (ContactEntity contactEntity : contactEntities) {
                if (contactEntity.getChargePersonId() == null) continue;
                ContactCharger contactCharger = new ContactCharger();
                contactCharger.setChargePersonId(contactEntity.getChargePersonId());
                contactCharger.setChargePersonName(contactEntity.getChargePersonName());
                contactChargers.add(contactCharger);
            }
        }
        contactChargers = contactChargers.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ContactCharger>(Comparator.comparing(ContactCharger::getChargePersonId))), ArrayList::new));
        this.contactChargerService.remove((Wrapper)new QueryWrapper());
        this.contactChargerService.saveBatch(contactChargers);
    }

    @Override
    public void saveOpportunity(List<OpportunityEntity> opportunityEntities) {
        this.opportunityService.remove((Wrapper)new QueryWrapper());
        this.opportunityService.saveBatch(opportunityEntities);
    }

    @Override
    public void saveCustomer(List<CustomerEntity> customerEntities) {
        this.customerService.remove((Wrapper)new QueryWrapper());
        this.customerService.saveBatch(customerEntities);
    }

    @Override
    public void saveContact(List<ContactEntity> contactEntities) {
        this.contactService.remove((Wrapper)new QueryWrapper());
        this.contactService.saveBatch(contactEntities);
    }

    @Override
    public void saveCompetitor(List<Competitor> competitors) {
        this.competitorService.remove((Wrapper)new QueryWrapper());
        this.competitorService.saveBatch(competitors);
    }

    @Override
    public void saveProduct(List<Product> products) {
        this.productService.remove((Wrapper)new QueryWrapper());
        this.productService.saveBatch(products);
    }

    @Override
    public void saveLabel(List<LabelEntity> labelEntities) {
        this.labelService.remove((Wrapper)new QueryWrapper());
        this.labelService.saveBatch(labelEntities);
    }

    @Override
    public void saveLabelGroup(List<LabelGroupEntity> labelGroupEntities) {
        this.labelGroupService.remove((Wrapper)new QueryWrapper());
        this.labelGroupService.saveBatch(labelGroupEntities);
    }

    @Override
    public void saveOpportunityProducts(List<OpportunityProduct> opportunityProducts) {
        this.opportunityProductService.remove((Wrapper)new QueryWrapper());
        this.opportunityProductService.saveBatch(opportunityProducts);
    }

    @Override
    public void saveCompetitorAnalyses(List<CompetitorAnalysis> competitorAnalyses) {
        this.competitorAnalysisService.remove((Wrapper)new QueryWrapper());
        this.competitorAnalysisService.saveBatch(competitorAnalyses);
    }

    @Override
    public void saveSysUserRoles(List<SysUserRole> sysUserRoles) {
        this.iSysUserRoleService.remove((Wrapper)new QueryWrapper());
        this.iSysUserRoleService.saveBatch(sysUserRoles);
    }

    @Override
    public void saveSysUsers(List<SysUsers> sysUsers) {
        this.iSysUsersService.remove((Wrapper)new QueryWrapper());
        this.iSysUsersService.saveBatch(sysUsers);
    }

    @Override
    public void saveRecords(List<TrackRecord> trackRecords) {
        this.trackRecordService.remove((Wrapper)new QueryWrapper());
        this.trackRecordService.saveBatch(trackRecords);
    }

    @Override
    public void saveCampaigns(List<CrmCampaign1> campaign1s) {
        this.crmCampaign1Service.remove((Wrapper)new QueryWrapper());
        this.crmCampaign1Service.saveBatch(campaign1s);
    }

    @Override
    public void saveSysStrus(List<SysStru> sysStrus) {
        this.iSysStruService.remove((Wrapper)new QueryWrapper());
        this.iSysStruService.saveBatch(sysStrus);
    }

    @Override
    public void saveSysRoles(List<SysRoles> sysRoles) {
        this.iSysRolesService.remove((Wrapper)new QueryWrapper());
        this.iSysRolesService.saveBatch(sysRoles);
    }

    @Override
    public SalesPerson getSalesPerson(String id) {
        return (SalesPerson)this.salesPersonService.getOne((Wrapper)new LambdaQueryWrapper().eq(SalesPerson::getUserId, (Object)id));
    }

    @Override
    public List<CustomerRecommendVo> customerRecommend(List<String> customerFilter, FilterForm filter, Map<String, String> industryMap, Map<String, String> attributeMap, Map<String, String> straffMap, Map<String, String> labelMap, SalesStatisticsDto dto, Set<String> deptIds, Set<String> permissionCustomerIds) {
        ArrayList<CustomerRecommendVo> customerRecommendVos = new ArrayList<CustomerRecommendVo>();
        for (String opportunityId : customerFilter) {
            List opportunityProducts = this.opportunityProductService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId));
            OpportunityEntity opportunityEntity = (OpportunityEntity)this.opportunityService.getById((Serializable)((Object)opportunityId));
            if (CollectionUtils.isEmpty((Collection)opportunityProducts)) continue;
            HashSet<Long> productIds = new HashSet<Long>();
            HashMap<Long, String> productName = new HashMap<Long, String>();
            for (OpportunityProduct opportunityProduct : opportunityProducts) {
                productIds.add(opportunityProduct.getProductId());
                productName.put(opportunityProduct.getProductId(), opportunityProduct.getProductName());
            }
            for (Long productId : productIds) {
                List productCustomerMarks = this.productCustomerMarkService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ProductCustomerMark::getProductId, (Object)productId)).eq(ProductCustomerMark::getCustomerFlag, (Object)"0"));
                if (CollectionUtils.isEmpty((Collection)productCustomerMarks)) continue;
                HashMap<Long, ProductCustomerMark> customerMarkMap = new HashMap<Long, ProductCustomerMark>();
                HashSet<Long> customerIds = new HashSet<Long>();
                for (ProductCustomerMark productCustomerMark : productCustomerMarks) {
                    customerMarkMap.put(productCustomerMark.getCustomerId(), productCustomerMark);
                    customerIds.add(productCustomerMark.getCustomerId());
                }
                List customerEntities = this.customerService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CustomerEntity::getCustomerId, customerIds)).eq(!StringUtils.isEmpty((Object)filter.getIndustry()), CustomerEntity::getTrade, (Object)filter.getIndustry())).eq(!StringUtils.isEmpty((Object)filter.getProvince()), CustomerEntity::getProvince, (Object)filter.getProvince())).eq(!StringUtils.isEmpty((Object)filter.getAttribute()), CustomerEntity::getCustomerAttribute, (Object)filter.getAttribute())).in(!CollectionUtils.isEmpty(filter.getPerson()), CustomerEntity::getChargePersonId, filter.getPerson())).in(!CollectionUtils.isEmpty(filter.getDept()), CustomerEntity::getProvince, filter.getDept())).and(!CollectionUtils.isEmpty(filter.getLabel()), i -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.in(CustomerEntity::getLabelId, filter.getLabel())).or()).in(CustomerEntity::getAiTags, filter.getLabel());
                }));
                if (CollectionUtils.isEmpty((Collection)customerEntities)) continue;
                for (CustomerEntity customerEntity : customerEntities) {
                    if (dto.getPermissionDeptIds() == null && dto.getPermissionUserId() == null) {
                        this.addCustomerRecommend(opportunityEntity, productName, productId, customerEntity, customerMarkMap, industryMap, attributeMap, straffMap, labelMap, customerRecommendVos);
                        continue;
                    }
                    if (permissionCustomerIds.contains(customerEntity.getCustomerId().toString())) {
                        this.addCustomerRecommend(opportunityEntity, productName, productId, customerEntity, customerMarkMap, industryMap, attributeMap, straffMap, labelMap, customerRecommendVos);
                        continue;
                    }
                    if (customerEntity.getOwnDepartment() != null && deptIds.contains(customerEntity.getOwnDepartment().toString())) {
                        this.addCustomerRecommend(opportunityEntity, productName, productId, customerEntity, customerMarkMap, industryMap, attributeMap, straffMap, labelMap, customerRecommendVos);
                        continue;
                    }
                    if (dto.getPermissionUserId() != null && customerEntity.getChargePersonId() != null && dto.getPermissionUserId().toString().equals(customerEntity.getChargePersonId().toString())) {
                        this.addCustomerRecommend(opportunityEntity, productName, productId, customerEntity, customerMarkMap, industryMap, attributeMap, straffMap, labelMap, customerRecommendVos);
                        continue;
                    }
                    if (dto.getCurrentUserId() == null || customerEntity.getChargePersonId() == null || !dto.getCurrentUserId().toString().equals(customerEntity.getChargePersonId().toString())) continue;
                    this.addCustomerRecommend(opportunityEntity, productName, productId, customerEntity, customerMarkMap, industryMap, attributeMap, straffMap, labelMap, customerRecommendVos);
                }
            }
        }
        customerRecommendVos.sort(Comparator.comparing(CustomerRecommendVo::getScore).reversed());
        return customerRecommendVos;
    }

    private void addCustomerRecommend(OpportunityEntity opportunityEntity, Map<Long, String> productName, Long productId, CustomerEntity customerEntity, Map<Long, ProductCustomerMark> customerMarkMap, Map<String, String> industryMap, Map<String, String> attributeMap, Map<String, String> straffMap, Map<String, String> labelMap, List<CustomerRecommendVo> customerRecommendVos) {
        String[] labelIds;
        CustomerRecommendVo customerRecommendVo = new CustomerRecommendVo();
        customerRecommendVo.setOpportunityName(opportunityEntity != null ? opportunityEntity.getOpportunityName() : "");
        customerRecommendVo.setChargePersonName(opportunityEntity != null ? opportunityEntity.getChargePersonName() : "");
        customerRecommendVo.setChargeCustomer(opportunityEntity != null ? opportunityEntity.getCustomerName() : "");
        customerRecommendVo.setProductName(productName.get(productId));
        customerRecommendVo.setCustomerName(customerEntity.getCustomerName());
        customerRecommendVo.setScore(customerMarkMap.get(customerEntity.getCustomerId()).getMark());
        customerRecommendVo.setCalculateRule(customerMarkMap.get(customerEntity.getCustomerId()).getCustomerMark());
        customerRecommendVo.setCharger(customerEntity.getChargePersonName());
        customerRecommendVo.setDepartment(customerEntity.getOwnDepartmentName());
        customerRecommendVo.setTrackTime(customerEntity.getTrackTime());
        customerRecommendVo.setIndustry(!StringUtils.isEmpty((Object)customerEntity.getTrade()) ? industryMap.get(customerEntity.getTrade()) : "");
        customerRecommendVo.setAttribute(!StringUtils.isEmpty((Object)customerEntity.getCustomerAttribute()) ? attributeMap.get(customerEntity.getCustomerAttribute()) : "");
        customerRecommendVo.setStaffNumber(!StringUtils.isEmpty((Object)customerEntity.getStaffNumber()) ? straffMap.get(customerEntity.getStaffNumber()) : "");
        customerRecommendVo.setLabel("");
        if (!StringUtils.isEmpty((Object)customerEntity.getLabelId())) {
            for (String labelId : labelIds = customerEntity.getLabelId().split(",")) {
                if (labelMap.get(labelId) == null) continue;
                customerRecommendVo.setLabel(customerRecommendVo.getLabel() + (customerRecommendVo.getLabel().isEmpty() ? "" : ",") + labelMap.get(labelId));
            }
        }
        if (!StringUtils.isEmpty((Object)customerEntity.getAiTags())) {
            for (String labelId : labelIds = customerEntity.getAiTags().split(",")) {
                if (labelMap.get(labelId) == null) continue;
                customerRecommendVo.setLabel(customerRecommendVo.getLabel() + (customerRecommendVo.getLabel().isEmpty() ? "" : ",") + labelMap.get(labelId));
            }
        }
        customerRecommendVo.setAddress(customerEntity.getRegionLabel());
        customerRecommendVos.add(customerRecommendVo);
    }

    public void customerLabel() {
        CustomerLabel customerLabel;
        String[] split;
        List list = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(CustomerEntity::getLabelId)).ne(CustomerEntity::getLabelId, (Object)""));
        List list1 = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(CustomerEntity::getAiTags)).ne(CustomerEntity::getAiTags, (Object)""));
        ArrayList<CustomerLabel> customerLabels = new ArrayList<CustomerLabel>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (CustomerEntity customerEntity : list) {
                for (String s : split = customerEntity.getLabelId().split(",")) {
                    customerLabel = new CustomerLabel();
                    customerLabel.setCustomerId(customerEntity.getCustomerId().toString());
                    customerLabel.setLabelId(s);
                    customerLabels.add(customerLabel);
                }
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)list1)) {
            for (CustomerEntity customerEntity : list1) {
                for (String s : split = customerEntity.getAiTags().split(",")) {
                    customerLabel = new CustomerLabel();
                    customerLabel.setCustomerId(customerEntity.getCustomerId().toString());
                    customerLabel.setLabelId(s);
                    customerLabels.add(customerLabel);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(customerLabels)) {
            this.customerLabelService.remove((Wrapper)new QueryWrapper());
            this.customerLabelService.saveBatch(customerLabels);
        }
    }

    public void concatDept() {
        List<ContactDepartmentVo> contactDepartments = this.atlasMapper.getContactDepartments();
        ArrayList<ContactDepartment> contactDepartments1 = new ArrayList<ContactDepartment>();
        if (CollectionUtil.isNotEmpty(contactDepartments)) {
            for (ContactDepartmentVo contactDepartment : contactDepartments) {
                contactDepartments1.add(new ContactDepartment(contactDepartment.getCustomerId(), contactDepartment.getDepartmentName()));
            }
        }
        if (CollectionUtil.isNotEmpty(contactDepartments1)) {
            this.contactDepartmentService.remove((Wrapper)new QueryWrapper());
            this.contactDepartmentService.saveBatch(contactDepartments1);
        }
    }

    public void customerType() {
        ArrayList<CustomerType> customerTypes = new ArrayList<CustomerType>();
        List dicSingles = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548815204545470464"));
        if (!CollectionUtils.isEmpty((Collection)dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                customerTypes.add(new CustomerType(dicSingle.getLabel(), dicSingle.getValue()));
            }
        }
        this.customerTypeService.remove((Wrapper)new QueryWrapper());
        this.customerTypeService.saveBatch(customerTypes);
    }

    public void changeProvinceId() {
        List list = this.provinceService.list();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Province> provinces = new ArrayList<Province>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (Province province : list) {
                longList.add(province.getId());
                Province province1 = new Province();
                province1.setProvinceId(province.getProvinceId());
                province1.setProvinceName(province.getProvinceName());
                provinces.add(province1);
            }
            this.provinceService.removeByIds(longList);
            this.provinceService.saveBatch(provinces);
        }
    }

    public void addCustomerCity() {
        List customerEntities = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(CustomerEntity::getCity)).ne(CustomerEntity::getCity, (Object)""));
        HashSet<String> citys = new HashSet<String>();
        for (CustomerEntity customerEntity : customerEntities) {
            citys.add(customerEntity.getCity());
        }
        List provinces = this.provinceService.list();
        HashMap<String, String> provinceIds = new HashMap<String, String>();
        for (Province province : provinces) {
            provinceIds.put(province.getProvinceId().toString(), province.getId().toString());
        }
        List cityLists = this.area1Service.list((Wrapper)new LambdaQueryWrapper().in(BaseArea1::getBaseAreaid, citys));
        ArrayList<City> cities = new ArrayList<City>();
        for (BaseArea1 cityList : cityLists) {
            City city = new City();
            city.setCityId(cityList.getBaseAreaid().toString());
            city.setCityName(cityList.getName());
            city.setProvinceId((String)provinceIds.get(cityList.getParentid().toString()));
            cities.add(city);
        }
        this.cityService.remove((Wrapper)new QueryWrapper());
        this.cityService.saveBatch(cities);
    }

    public void addSalesPerson() {
        List sysUserRoles = this.iSysUserRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)"558961467144282112"));
        if (CollectionUtils.isEmpty((Collection)sysUserRoles)) {
            return;
        }
        ArrayList<SalesPerson> salesPeople = new ArrayList<SalesPerson>();
        HashSet<Long> userIds = new HashSet<Long>();
        for (SysUserRole sysUserRole : sysUserRoles) {
            userIds.add(sysUserRole.getUserId());
        }
        List sysUsers = this.iSysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, userIds));
        if (CollectionUtils.isEmpty((Collection)sysUsers)) {
            return;
        }
        for (SysUsers sysUser : sysUsers) {
            SalesPerson salesPerson = new SalesPerson();
            salesPerson.setUserId(sysUser.getId());
            salesPerson.setUserName(sysUser.getUserName());
            salesPerson.setDepartmentId(sysUser.getDepartmentId());
            salesPerson.setSalesPersonType("0");
            salesPeople.add(salesPerson);
        }
        this.salesPersonService.remove((Wrapper)new QueryWrapper());
        this.salesPersonService.saveBatch(salesPeople);
    }

    private void addSalesDepartment() {
        List salesPeople = this.salesPersonService.list();
        HashSet<Long> salesPeopleIds = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)salesPeople)) {
            for (SalesPerson salesPerson : salesPeople) {
                salesPeopleIds.add(salesPerson.getUserId());
            }
        }
        List sysUsers = this.iSysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, salesPeopleIds));
        HashSet<Long> departmentIds = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)sysUsers)) {
            for (SysUsers sysUser : sysUsers) {
                departmentIds.add(sysUser.getDepartmentId());
            }
        }
        List sysStrus = this.iSysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, departmentIds));
        ArrayList<SalesDepartment> salesDepartments = new ArrayList<SalesDepartment>();
        if (!CollectionUtils.isEmpty((Collection)sysStrus)) {
            for (SysStru strus : sysStrus) {
                SalesDepartment salesDepartment = new SalesDepartment();
                salesDepartment.setDepartmentId(strus.getId());
                salesDepartment.setDepartmentName(strus.getOrganAlias());
                salesDepartments.add(salesDepartment);
            }
        }
        this.salesDepartmentService.remove((Wrapper)new QueryWrapper());
        this.salesDepartmentService.saveBatch(salesDepartments);
    }

    private void addSalesPersonLeader() {
        List sysRoles = this.iSysRolesService.list((Wrapper)new LambdaQueryWrapper().like(SysRoles::getRoleName, (Object)"\u9886\u5bfc"));
        HashSet<Long> roleIds = new HashSet<Long>();
        if (!sysRoles.isEmpty()) {
            for (SysRoles sysRole : sysRoles) {
                roleIds.add(sysRole.getId());
            }
        }
        List sysUserRoles = this.iSysUserRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, roleIds));
        HashSet<Long> userIds = new HashSet<Long>();
        if (!sysUserRoles.isEmpty()) {
            for (SysUserRole sysUserRole : sysUserRoles) {
                userIds.add(sysUserRole.getUserId());
            }
        }
        List salesDepartments = this.salesDepartmentService.list();
        HashSet<Long> departmentIds = new HashSet<Long>();
        if (!salesDepartments.isEmpty()) {
            for (SalesDepartment salesDepartment : salesDepartments) {
                departmentIds.add(salesDepartment.getDepartmentId());
            }
        }
        List sysUsers = this.iSysUsersService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(!sysRoles.isEmpty(), SysUsers::getId, userIds)).in(!salesDepartments.isEmpty(), SysUsers::getDepartmentId, departmentIds));
        ArrayList<SalesPerson> salesPeople = new ArrayList<SalesPerson>();
        if (!sysUsers.isEmpty()) {
            for (SysUsers sysUser : sysUsers) {
                SalesPerson salesPerson = new SalesPerson();
                salesPerson.setUserId(sysUser.getId());
                salesPerson.setUserName(sysUser.getUserName());
                salesPerson.setDepartmentId(sysUser.getDepartmentId());
                salesPerson.setSalesPersonType("1");
                salesPeople.add(salesPerson);
            }
        }
        this.salesPersonService.saveBatch(salesPeople);
    }
}

