/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.graph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.config.CrmProperties;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmcampaign1.service.CrmCampaign1Service;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.label.model.LabelEntity;
import com.jxdinfo.crm.core.label.service.LabelGroupService;
import com.jxdinfo.crm.core.label.service.LabelService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.trackrecord.service.TrackRecordService;
import com.jxdinfo.crm.knowledgegraph.contract.service.ContractService;
import com.jxdinfo.crm.knowledgegraph.graph.dto.CustomerRecommendVo;
import com.jxdinfo.crm.knowledgegraph.graph.dto.FilterForm;
import com.jxdinfo.crm.knowledgegraph.graph.service.GraphService;
import com.jxdinfo.crm.knowledgegraph.graph.service.NodeAndRelationService;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.service.ProductCustomerMarkService;
import com.jxdinfo.crm.knowledgegraph.salesperson.model.SalesPerson;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GraphServiceImpl
implements GraphService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ContactService contactService;
    @Resource
    private CompetitorService competitorService;
    @Resource
    private ProductService productService;
    @Resource
    private LabelService labelService;
    @Resource
    private LabelGroupService labelGroupService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private NodeAndRelationService nodeAndRelationService;
    @Resource
    private ProductCustomerMarkService productCustomerMarkService;
    @Resource
    private ISysDicSingleService iSysDicSingleService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private TrackRecordService trackRecordService;
    @Resource
    private CrmCampaign1Service crmCampaign1Service;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private CrmProperties crmProperties;
    @Resource
    private ContractService contractService;
    @Resource
    private TeamMeberService teamMeberService;

    @Override
    public void buildGraph() throws Exception {
        List opportunityEntities = this.opportunityService.list();
        List customerEntities = this.customerService.list();
        List contactEntities = this.contactService.list();
        List competitors = this.competitorService.list();
        List products = this.productService.list();
        List labelEntities = this.labelService.list();
        List labelGroupEntities = this.labelGroupService.list();
        List opportunityProducts = this.opportunityProductService.list();
        List competitorAnalyses = this.competitorAnalysisService.list();
        List sysUserRoles = this.iSysUserRoleService.list();
        List sysUsers = this.iSysUsersService.list();
        List trackRecords = this.trackRecordService.list();
        List campaign1s = this.crmCampaign1Service.list();
        List sysStrus = this.iSysStruService.list();
        List sysRoles = this.iSysRolesService.list();
        if (!CollectionUtils.isEmpty((Collection)opportunityEntities)) {
            this.nodeAndRelationService.saveOpportunity(opportunityEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)customerEntities)) {
            this.nodeAndRelationService.saveCustomer(customerEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)contactEntities)) {
            this.nodeAndRelationService.saveContact(contactEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)competitors)) {
            this.nodeAndRelationService.saveCompetitor(competitors);
        }
        if (!CollectionUtils.isEmpty((Collection)products)) {
            this.nodeAndRelationService.saveProduct(products);
        }
        if (!CollectionUtils.isEmpty((Collection)labelEntities)) {
            this.nodeAndRelationService.saveLabel(labelEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)labelGroupEntities)) {
            this.nodeAndRelationService.saveLabelGroup(labelGroupEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)opportunityProducts)) {
            this.nodeAndRelationService.saveOpportunityProducts(opportunityProducts);
        }
        if (!CollectionUtils.isEmpty((Collection)competitorAnalyses)) {
            this.nodeAndRelationService.saveCompetitorAnalyses(competitorAnalyses);
        }
        if (!CollectionUtils.isEmpty((Collection)sysUserRoles)) {
            this.nodeAndRelationService.saveSysUserRoles(sysUserRoles);
        }
        if (!CollectionUtils.isEmpty((Collection)sysUsers)) {
            this.nodeAndRelationService.saveSysUsers(sysUsers);
        }
        if (!CollectionUtils.isEmpty((Collection)trackRecords)) {
            this.nodeAndRelationService.saveRecords(trackRecords);
        }
        if (!CollectionUtils.isEmpty((Collection)campaign1s)) {
            this.nodeAndRelationService.saveCampaigns(campaign1s);
        }
        if (!CollectionUtils.isEmpty((Collection)sysStrus)) {
            this.nodeAndRelationService.saveSysStrus(sysStrus);
        }
        if (!CollectionUtils.isEmpty((Collection)sysRoles)) {
            this.nodeAndRelationService.saveSysRoles(sysRoles);
        }
        this.contractService.saveContracts();
        this.nodeAndRelationService.buildGraphData();
    }

    @Override
    public Map<String, Object> customerFilter(Object object) {
        if (object == null) {
            return null;
        }
        Map dataMap = (Map)object;
        Map filterForm = (Map)dataMap.get("filterForm");
        FilterForm filter = new FilterForm();
        if (!StringUtils.isEmpty(filterForm.get("label"))) {
            filter.setLabel((List)filterForm.get("label"));
        }
        filter.setProvince(filterForm.get("province").toString());
        filter.setAttribute((String)filterForm.get("nature"));
        filter.setIndustry((String)filterForm.get("industry"));
        Map clientOwner = (Map)filterForm.get("clientOwner");
        filter.setType((String)clientOwner.get("type"));
        switch (filter.getType()) {
            case "all": {
                break;
            }
            case "department": {
                List objectList = (List)clientOwner.get("dept");
                ArrayList<Long> data = new ArrayList<Long>();
                for (Object o : objectList) {
                    data.add(Long.valueOf(o.toString()));
                }
                filter.setDept(data);
                break;
            }
            default: {
                List objectLists = (List)clientOwner.get("person");
                ArrayList<Long> datas = new ArrayList<Long>();
                for (Object o : objectLists) {
                    datas.add(Long.valueOf(o.toString()));
                }
                filter.setPerson(datas);
            }
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>((Map)dataMap.get("rawData"));
        if (!(CollectionUtils.isEmpty(filter.getPerson()) && CollectionUtils.isEmpty(filter.getLabel()) && StringUtils.isEmpty((Object)filter.getAttribute()) && StringUtils.isEmpty((Object)filter.getProvince()) && StringUtils.isEmpty((Object)filter.getIndustry()) && CollectionUtils.isEmpty(filter.getDept()))) {
            this.getCustomer(objectMap, filter);
        }
        System.out.println(object);
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        resultData.put("data", dataMap.get("rawData"));
        resultData.put("filterData", objectMap);
        return resultData;
    }

    @Override
    public List<CustomerRecommendVo> customerRecommend(Object customerFilters) {
        Map listMap = (Map)customerFilters;
        List customerFilter = (List)listMap.get("ids");
        FilterForm filter = new FilterForm();
        if (listMap.containsKey("filterForm")) {
            Map filterForm = (Map)listMap.get("filterForm");
            if (!StringUtils.isEmpty(filterForm.get("label"))) {
                filter.setLabel((List)filterForm.get("label"));
            }
            filter.setProvince(filterForm.get("province").toString());
            filter.setAttribute((String)filterForm.get("nature"));
            filter.setIndustry((String)filterForm.get("industry"));
            Map clientOwner = (Map)filterForm.get("clientOwner");
            filter.setType((String)clientOwner.get("type"));
            switch (filter.getType()) {
                case "all": {
                    break;
                }
                case "department": {
                    List objectList = (List)clientOwner.get("dept");
                    ArrayList<Long> data = new ArrayList<Long>();
                    Iterator iterator = objectList.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        data.add(Long.valueOf(o.toString()));
                    }
                    filter.setDept(data);
                    break;
                }
                default: {
                    List objectLists = (List)clientOwner.get("person");
                    ArrayList<Long> datas = new ArrayList<Long>();
                    Iterator iterator = objectLists.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        datas.add(Long.valueOf(o.toString()));
                    }
                    filter.setPerson(datas);
                }
            }
        }
        if (CollectionUtils.isEmpty((Map)listMap)) {
            return null;
        }
        List dicSingles = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548815204545470464"));
        HashMap<String, String> industryMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                industryMap.put(dicSingle.getValue(), dicSingle.getLabel());
            }
        }
        List dicSingleList = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548455363687751680"));
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)dicSingleList)) {
            for (DicSingle dicSingle : dicSingleList) {
                attributeMap.put(dicSingle.getValue(), dicSingle.getLabel());
            }
        }
        List dicSingleNumber = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548452666611867648"));
        HashMap<String, String> straffMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)dicSingleNumber)) {
            for (DicSingle dicSingle : dicSingleNumber) {
                straffMap.put(dicSingle.getValue(), dicSingle.getLabel());
            }
        }
        List labelEntities = this.labelService.list();
        HashMap<String, String> labelMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)labelEntities)) {
            for (LabelEntity labelEntity : labelEntities) {
                labelMap.put(labelEntity.getLabelId().toString(), labelEntity.getLabelName());
            }
        }
        SalesStatisticsDto dto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions((SalesStatisticsDto)dto, (CrmProperties)this.crmProperties);
        HashSet<String> opportunityIds = new HashSet<String>();
        HashSet<String> deptIds = new HashSet<String>();
        HashSet<String> customerIds = new HashSet<String>();
        HashSet<String> contactIds = new HashSet<String>();
        this.getPermissionFilter(dto, opportunityIds, deptIds, customerIds, contactIds);
        List<CustomerRecommendVo> customerRecommendVos = this.nodeAndRelationService.customerRecommend(customerFilter, filter, industryMap, attributeMap, straffMap, labelMap, dto, deptIds, customerIds);
        return customerRecommendVos;
    }

    @Override
    public ApiResponse getTreePathByNode(String id, String tag) {
        SalesPerson salesPerson;
        if (tag.equals("sales_persion") && (salesPerson = this.nodeAndRelationService.getSalesPerson(id)) != null) {
            id = salesPerson.getId().toString();
        }
        String url = this.crmProperties.getRequestGraphRebuildUrl();
        url = url.substring(0, url.indexOf("/graph")) + "/nebulaQuery/getTreePathByNode?id=" + id + "&tag=" + tag;
        StringBuilder response = this.httpGet(url);
        ApiResponse atlasResponse = (ApiResponse)JSONObject.parseObject((String)String.valueOf(response), ApiResponse.class);
        SalesStatisticsDto dto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions((SalesStatisticsDto)dto, (CrmProperties)this.crmProperties);
        Map datas = (Map)atlasResponse.getData();
        Map data = (Map)datas.get("datas");
        HashSet<String> opportunityIds = new HashSet<String>();
        HashSet<String> deptIds = new HashSet<String>();
        HashSet<String> customerIds = new HashSet<String>();
        HashSet<String> contactIds = new HashSet<String>();
        switch (tag) {
            case "Client": {
                this.getPermissionFilter(dto, opportunityIds, deptIds, customerIds, contactIds);
                this.permissionCustomer(data, dto, customerIds, deptIds);
                break;
            }
            case "Business": {
                this.getPermissionFilter(dto, opportunityIds, deptIds, customerIds, contactIds);
                this.permissionOpportunity(data, dto, opportunityIds, deptIds, customerIds);
                break;
            }
            case "Product": {
                this.getPermissionFilter(dto, opportunityIds, deptIds, customerIds, contactIds);
                this.permissionProduct(data, dto, opportunityIds, deptIds, customerIds);
                break;
            }
            case "sales_persion": {
                this.getPermissionFilter(dto, opportunityIds, deptIds, customerIds, contactIds);
                this.permissionSalesPeople(data, dto, opportunityIds, deptIds, customerIds, contactIds);
                break;
            }
            case "opportunityCharge": {
                this.getPermissionFilter(dto, opportunityIds, deptIds, customerIds, contactIds);
                this.permissionOpportunityCharge(data, dto, opportunityIds, deptIds, customerIds);
            }
        }
        return atlasResponse;
    }

    private void permissionOpportunityCharge(Map<String, Object> data, SalesStatisticsDto dto, Set<String> opportunityIds, Set<String> deptIds, Set<String> customerIds) {
        List mapList;
        if (data.isEmpty()) {
            return;
        }
        if (data.containsKey("label")) {
            if (data.get("label").toString().equals("\u5ba2\u6237")) {
                mapList = (List)data.get("children");
                if (data.containsKey("children")) {
                    HashSet<Map<String, Object>> customerFilterList = new HashSet<Map<String, Object>>();
                    for (Map map : mapList) {
                        if (!map.containsKey("properties")) continue;
                        this.getCustomerByPermission(map, customerIds, deptIds, dto, customerFilterList);
                    }
                    ArrayList<Map> customers = new ArrayList<Map>();
                    if (!CollectionUtils.isEmpty(customerFilterList)) {
                        for (Map objectMap : mapList) {
                            if (!customerFilterList.contains(objectMap)) continue;
                            customers.add(objectMap);
                        }
                    }
                    data.put("children", customers);
                    if (mapList.size() - customerFilterList.size() > 0) {
                        data.put("permission", "\u65e0\u6743\u9650(" + (mapList.size() - customerFilterList.size()) + ")");
                    }
                }
            }
            if (data.get("label").toString().equals("\u5546\u673a") && data.containsKey("children")) {
                this.permissionOpportunityDeal(data, dto, opportunityIds, deptIds);
            }
        }
        if (data.containsKey("children")) {
            mapList = (List)data.get("children");
            for (Map map : mapList) {
                this.permissionOpportunityCharge(map, dto, opportunityIds, deptIds, customerIds);
            }
        }
    }

    private void permissionSalesPeople(Map<String, Object> data, SalesStatisticsDto dto, Set<String> opportunityIds, Set<String> deptIds, Set<String> customerIds, Set<String> contactIds) {
        if (data.isEmpty()) {
            return;
        }
        if (data.containsKey("label")) {
            if (data.get("label").toString().equals("\u5ba2\u6237") && data.containsKey("children")) {
                this.permissionCustomerDeal(data, dto, customerIds, deptIds);
            }
            if ((data.get("label").toString().equals("\u5f85\u8ddf\u8fdb\u5546\u673a") || data.get("label").toString().equals("\u8ddf\u8fdb\u4e2d\u5546\u673a") || data.get("label").toString().equals("\u6210\u4ea4\u5546\u673a")) && data.containsKey("children")) {
                this.permissionOpportunityDeal(data, dto, opportunityIds, deptIds);
            }
            if (data.get("label").toString().equals("\u8054\u7cfb\u4eba") && data.containsKey("children")) {
                this.permissionOpportunityDeal(data, dto, contactIds, deptIds);
            }
        }
        if (data.containsKey("children")) {
            List mapList = (List)data.get("children");
            for (Map map : mapList) {
                this.permissionSalesPeople(map, dto, opportunityIds, deptIds, customerIds, contactIds);
            }
        }
    }

    private void permissionProduct(Map<String, Object> data, SalesStatisticsDto dto, Set<String> opportunityIds, Set<String> deptIds, Set<String> customerIds) {
        if (data.isEmpty()) {
            return;
        }
        if (data.containsKey("nodeType")) {
            if (data.get("label").toString().equals("\u5ba2\u6237") && data.containsKey("children")) {
                this.permissionCustomerDeal(data, dto, customerIds, deptIds);
            }
            if (data.get("label").toString().equals("\u5546\u673a") && data.containsKey("children")) {
                this.permissionOpportunityDeal(data, dto, opportunityIds, deptIds);
            }
        }
        if (data.containsKey("children")) {
            List mapList = (List)data.get("children");
            for (Map map : mapList) {
                this.permissionProduct(map, dto, opportunityIds, deptIds, customerIds);
            }
        }
    }

    private void getPermissionFilter(SalesStatisticsDto dto, Set<String> opportunityIds, Set<String> deptIds, Set<String> customerIds, Set<String> contactIds) {
        List teamMeberEntities = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getPersonId, (Object)dto.getCurrentUserId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).in(TeamMeberEntity::getBusinessType, new ArrayList<String>(Arrays.asList("1", "2", "3"))));
        if (!CollectionUtils.isEmpty((Collection)dto.getPermissionDeptIds())) {
            for (Long permissionDeptId : dto.getPermissionDeptIds()) {
                deptIds.add(permissionDeptId.toString());
            }
        }
        if (!StringUtils.isEmpty((Object)teamMeberEntities)) {
            for (Object teamMeberEntity : teamMeberEntities) {
                if (teamMeberEntity.getBusinessType().equals("1")) {
                    customerIds.add(teamMeberEntity.getBusinessId().toString());
                    continue;
                }
                if (teamMeberEntity.getBusinessType().equals("2")) {
                    opportunityIds.add(teamMeberEntity.getBusinessId().toString());
                    continue;
                }
                if (!teamMeberEntity.getBusinessType().equals("3")) continue;
                contactIds.add(teamMeberEntity.getBusinessId().toString());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getPermissionProductIds())) {
            List contactEntities;
            List opportunityEntities;
            List opportunityProducts = this.opportunityProductService.list((Wrapper)new LambdaQueryWrapper().in(OpportunityProduct::getProductId, (Collection)dto.getPermissionProductIds()));
            if (!CollectionUtils.isEmpty((Collection)opportunityProducts)) {
                for (OpportunityProduct opportunityProduct : opportunityProducts) {
                    opportunityIds.add(opportunityProduct.getOpportunityId().toString());
                }
            }
            if (!CollectionUtils.isEmpty(opportunityIds) && !CollectionUtils.isEmpty((Collection)(opportunityEntities = this.opportunityService.listByIds(opportunityIds)))) {
                for (OpportunityEntity opportunityEntity : opportunityEntities) {
                    if (opportunityEntity.getCustomerId() == null) continue;
                    customerIds.add(opportunityEntity.getCustomerId().toString());
                }
            }
            if (!CollectionUtils.isEmpty(customerIds) && !CollectionUtils.isEmpty((Collection)(contactEntities = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getCustomerId, customerIds)).isNotNull(ContactEntity::getCustomerId))))) {
                for (ContactEntity contactEntity : contactEntities) {
                    contactIds.add(contactEntity.getContactId().toString());
                }
            }
        }
    }

    private void permissionOpportunity(Map<String, Object> data, SalesStatisticsDto dto, Set<String> opportunityIds, Set<String> deptIds, Set<String> customerIds) {
        if (data.isEmpty()) {
            return;
        }
        if (data.containsKey("nodeType")) {
            if (data.get("nodeType").toString().equals("\u4ea7\u54c1") && data.containsKey("children")) {
                this.permissionCustomerDeal(data, dto, customerIds, deptIds);
            }
            if (data.get("label").toString().equals("\u8d1f\u8d23\u5ba2\u6237") && data.containsKey("children")) {
                this.permissionCustomerDeal(data, dto, customerIds, deptIds);
            }
            if (data.get("label").toString().equals("\u8d1f\u8d23\u5546\u673a") && data.containsKey("children")) {
                this.permissionOpportunityDeal(data, dto, opportunityIds, deptIds);
            }
        }
        if (data.containsKey("children")) {
            List mapList = (List)data.get("children");
            for (Map map : mapList) {
                this.permissionOpportunity(map, dto, opportunityIds, deptIds, customerIds);
            }
        }
    }

    private void permissionOpportunityDeal(Map<String, Object> data, SalesStatisticsDto dto, Set<String> opportunityIds, Set<String> deptIds) {
        HashSet<Map<String, Object>> opportunityFilterList = new HashSet<Map<String, Object>>();
        List mapList = (List)data.get("children");
        for (Map map : mapList) {
            if (!map.containsKey("properties")) continue;
            this.getOpportunityByPermission(map, opportunityIds, deptIds, dto, opportunityFilterList);
        }
        ArrayList<Map> customers = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(opportunityFilterList)) {
            for (Map objectMap : mapList) {
                if (!opportunityFilterList.contains(objectMap)) continue;
                customers.add(objectMap);
            }
        }
        data.put("children", customers);
        if (mapList.size() - opportunityFilterList.size() > 0) {
            data.put("permission", "\u65e0\u6743\u9650(" + (mapList.size() - opportunityFilterList.size()) + ")");
        }
    }

    private void getOpportunityByPermission(Map<String, Object> map, Set<String> opportunityIds, Set<String> deptIds, SalesStatisticsDto dto, Set<Map<String, Object>> opportunityFilterList) {
        List properties = (List)map.get("properties");
        HashMap<String, String> filterProperties = new HashMap<String, String>();
        for (Map property : properties) {
            if (property.containsKey("\u8d1f\u8d23\u4ebaID")) {
                filterProperties.put("\u8d1f\u8d23\u4ebaID", property.get("\u8d1f\u8d23\u4ebaID").toString());
            }
            if (property.containsKey("\u6240\u5c5e\u90e8\u95e8")) {
                filterProperties.put("\u6240\u5c5e\u90e8\u95e8", property.get("\u6240\u5c5e\u90e8\u95e8").toString());
            }
            if (!property.containsKey("ID")) continue;
            filterProperties.put("ID", property.get("ID").toString());
        }
        if (dto.getPermissionDeptIds() == null && dto.getPermissionUserId() == null) {
            opportunityFilterList.add(map);
            return;
        }
        if (opportunityIds.contains(filterProperties.get("ID"))) {
            opportunityFilterList.add(map);
            return;
        }
        if (deptIds.contains(filterProperties.get("\u6240\u5c5e\u90e8\u95e8"))) {
            opportunityFilterList.add(map);
            return;
        }
        if (dto.getPermissionUserId() != null && dto.getPermissionUserId().toString().equals(((String)filterProperties.get("\u8d1f\u8d23\u4ebaID")).toString())) {
            opportunityFilterList.add(map);
            return;
        }
        if (dto.getCurrentUserId() != null && dto.getCurrentUserId().toString().equals(((String)filterProperties.get("\u8d1f\u8d23\u4ebaID")).toString())) {
            opportunityFilterList.add(map);
        }
    }

    private void permissionCustomer(Map<String, Object> data, SalesStatisticsDto dto, Set<String> customerIds, Set<String> deptIds) {
        if (data.isEmpty()) {
            return;
        }
        if (data.containsKey("nodeType") && data.get("nodeType").toString().equals("\u4ea7\u54c1") && data.containsKey("children")) {
            this.permissionCustomerDeal(data, dto, customerIds, deptIds);
        }
        if (data.containsKey("children")) {
            List mapList = (List)data.get("children");
            for (Map map : mapList) {
                this.permissionCustomer(map, dto, customerIds, deptIds);
            }
        }
    }

    private void permissionCustomerDeal(Map<String, Object> data, SalesStatisticsDto dto, Set<String> customerIds, Set<String> deptIds) {
        List mapList = (List)data.get("children");
        if (data.get("nodeType").toString().equals("\u4ea7\u54c1") || data.get("label").toString().equals("\u5ba2\u6237")) {
            for (Map map : mapList) {
                if (!map.containsKey("children")) continue;
                HashSet<Map<String, Object>> customerFilterList = new HashSet<Map<String, Object>>();
                List customerList = (List)map.get("children");
                for (Map stringObjectMap : customerList) {
                    if (!stringObjectMap.containsKey("properties")) continue;
                    this.getCustomerByPermission(stringObjectMap, customerIds, deptIds, dto, customerFilterList);
                }
                ArrayList<Map> customers = new ArrayList<Map>();
                if (!CollectionUtils.isEmpty(customerFilterList)) {
                    for (Map objectMap : customerList) {
                        if (!customerFilterList.contains(objectMap)) continue;
                        customers.add(objectMap);
                    }
                }
                System.out.println(customerList.size() - customerFilterList.size());
                map.put("children", customers);
                if (customerList.size() - customerFilterList.size() <= 0) continue;
                map.put("permission", "\u65e0\u6743\u9650(" + (customerList.size() - customerFilterList.size()) + ")");
            }
        } else if (data.get("label").toString().equals("\u8d1f\u8d23\u5ba2\u6237")) {
            HashSet<Map<String, Object>> customerFilterList = new HashSet<Map<String, Object>>();
            for (Map map : mapList) {
                if (!map.containsKey("properties")) continue;
                this.getCustomerByPermission(map, customerIds, deptIds, dto, customerFilterList);
            }
            ArrayList<Map> customers = new ArrayList<Map>();
            if (!CollectionUtils.isEmpty(customerFilterList)) {
                for (Map objectMap : mapList) {
                    if (!customerFilterList.contains(objectMap)) continue;
                    customers.add(objectMap);
                }
            }
            data.put("children", customers);
            if (mapList.size() - customerFilterList.size() > 0) {
                data.put("permission", "\u65e0\u6743\u9650(" + (mapList.size() - customerFilterList.size()) + ")");
            }
        }
    }

    private void getCustomerByPermission(Map<String, Object> data, Set<String> customerIds, Set<String> departmentIds, SalesStatisticsDto dto, Set<Map<String, Object>> customerFilterList) {
        List properties = (List)data.get("properties");
        HashMap<String, String> filterProperties = new HashMap<String, String>();
        for (Map property : properties) {
            if (property.containsKey("\u8d1f\u8d23\u4ebaID")) {
                filterProperties.put("\u8d1f\u8d23\u4ebaID", property.get("\u8d1f\u8d23\u4ebaID").toString());
            }
            if (property.containsKey("\u6240\u5c5e\u90e8\u95e8")) {
                filterProperties.put("\u6240\u5c5e\u90e8\u95e8", property.get("\u6240\u5c5e\u90e8\u95e8").toString());
            }
            if (!property.containsKey("ID")) continue;
            filterProperties.put("ID", property.get("ID").toString());
        }
        if (dto.getPermissionDeptIds() == null && dto.getPermissionUserId() == null) {
            customerFilterList.add(data);
            return;
        }
        if (customerIds.contains(filterProperties.get("ID"))) {
            customerFilterList.add(data);
            return;
        }
        if (departmentIds.contains(filterProperties.get("\u6240\u5c5e\u90e8\u95e8"))) {
            customerFilterList.add(data);
            return;
        }
        if (dto.getPermissionUserId() != null && dto.getPermissionUserId().toString().equals(((String)filterProperties.get("\u8d1f\u8d23\u4ebaID")).toString())) {
            customerFilterList.add(data);
            return;
        }
        if (dto.getCurrentUserId() != null && dto.getCurrentUserId().toString().equals(((String)filterProperties.get("\u8d1f\u8d23\u4ebaID")).toString())) {
            customerFilterList.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder httpGet(String url) {
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        try {
            String resultJson;
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setConnectTimeout(10000);
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((resultJson = br.readLine()) != null) {
                response.append(new String(resultJson.trim().getBytes(), "UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    @Override
    public ApiResponse checkDefaultGraph(String userId) {
        String url = this.crmProperties.getRequestGraphRebuildUrl();
        url = url.substring(0, url.indexOf("/graph")) + "/graph/checkDefaultGraph?userId=" + userId;
        StringBuilder response = this.httpGet(url);
        ApiResponse atlasResponse = (ApiResponse)JSONObject.parseObject((String)String.valueOf(response), ApiResponse.class);
        return atlasResponse;
    }

    @Override
    public ApiResponse getCurrentConfig() {
        String url = this.crmProperties.getRequestGraphRebuildUrl();
        url = url.substring(0, url.indexOf("/graph")) + "/globalConfig/getCurrentConfig";
        StringBuilder response = this.httpGet(url);
        ApiResponse atlasResponse = (ApiResponse)JSONObject.parseObject((String)String.valueOf(response), ApiResponse.class);
        return atlasResponse;
    }

    @Override
    public ApiResponse list(String version) {
        String url = this.crmProperties.getRequestGraphRebuildUrl();
        url = url.substring(0, url.indexOf("/graph")) + "/nebulaQuery/list?version=" + version;
        StringBuilder response = this.httpGet(url);
        ApiResponse atlasResponse = (ApiResponse)JSONObject.parseObject((String)String.valueOf(response), ApiResponse.class);
        return atlasResponse;
    }

    private void getCustomer(Map<String, Object> objectMap, FilterForm filter) {
        List mapList;
        if (objectMap.isEmpty()) {
            return;
        }
        if (objectMap.containsKey("nodeType") && objectMap.get("nodeType").toString().equals("\u4ea7\u54c1") && objectMap.containsKey("children")) {
            mapList = (List)objectMap.get("children");
            for (Object map : mapList) {
                if (!map.containsKey("children")) continue;
                Map moreCustomerMap = new HashMap();
                HashSet<Map<String, Object>> hashSet = new HashSet<Map<String, Object>>();
                List customerList = (List)map.get("children");
                for (Map stringObjectMap : customerList) {
                    if (stringObjectMap.containsKey("properties")) {
                        this.filterData(stringObjectMap, filter, hashSet);
                    }
                    if (!stringObjectMap.containsKey("moreChildren")) continue;
                    moreCustomerMap = stringObjectMap;
                    List moreChildrenList = (List)stringObjectMap.get("moreChildren");
                    if (CollectionUtils.isEmpty((Collection)moreChildrenList)) continue;
                    for (Map moreChildren : moreChildrenList) {
                        this.filterData(moreChildren, filter, hashSet);
                    }
                }
                ArrayList<Map> customers = new ArrayList<Map>();
                if (!CollectionUtils.isEmpty(hashSet)) {
                    for (Map stringObjectMap : customerList) {
                        if (!hashSet.contains(stringObjectMap)) continue;
                        customers.add(stringObjectMap);
                    }
                }
                map.put("children", customers);
            }
        }
        if (objectMap.containsKey("label") && objectMap.get("label").toString().equals("\u8d1f\u8d23\u5ba2\u6237") && objectMap.containsKey("children")) {
            HashSet<Map<String, Object>> customerFilterList = new HashSet<Map<String, Object>>();
            List customerList = (List)objectMap.get("children");
            for (Map stringObjectMap : customerList) {
                if (!stringObjectMap.containsKey("properties")) continue;
                this.filterData(stringObjectMap, filter, customerFilterList);
            }
            ArrayList<Map> customers = new ArrayList<Map>();
            if (!CollectionUtils.isEmpty(customerFilterList)) {
                for (Map map : customerFilterList) {
                    customers.add(map);
                }
            }
            objectMap.put("children", customers);
        }
        if (objectMap.containsKey("children")) {
            mapList = (List)objectMap.get("children");
            for (Object map : mapList) {
                this.getCustomer((Map<String, Object>)map, filter);
            }
        }
    }

    private void filterData(Map<String, Object> stringObjectMap, FilterForm filter, Set<Map<String, Object>> customerFilterList) {
        List properties = (List)stringObjectMap.get("properties");
        HashMap<String, String> filterProperties = new HashMap<String, String>();
        for (Map property : properties) {
            if (property.containsKey("\u8d1f\u8d23\u4ebaID")) {
                filterProperties.put("\u8d1f\u8d23\u4ebaID", property.get("\u8d1f\u8d23\u4ebaID").toString());
            }
            if (property.containsKey("\u6240\u5c5e\u90e8\u95e8")) {
                filterProperties.put("\u6240\u5c5e\u90e8\u95e8", property.get("\u6240\u5c5e\u90e8\u95e8").toString());
            }
            if (property.containsKey("\u5ba2\u6237\u6027\u8d28")) {
                filterProperties.put("\u5ba2\u6237\u6027\u8d28", property.get("\u5ba2\u6237\u6027\u8d28").toString());
            }
            if (property.containsKey("\u7701\u4efd")) {
                filterProperties.put("\u7701\u4efd", property.get("\u7701\u4efd").toString());
            }
            if (property.containsKey("\u6807\u7b7e")) {
                filterProperties.put("\u6807\u7b7e", property.get("\u6807\u7b7e").toString());
            }
            if (property.containsKey("\u667a\u80fd\u6807\u7b7e")) {
                filterProperties.put("\u667a\u80fd\u6807\u7b7e", property.get("\u667a\u80fd\u6807\u7b7e").toString());
            }
            if (!property.containsKey("\u884c\u4e1a")) continue;
            filterProperties.put("\u884c\u4e1a", property.get("\u884c\u4e1a").toString());
        }
        int countNumber = 0;
        int containNumber = 0;
        if (!CollectionUtils.isEmpty(filter.getPerson())) {
            ++countNumber;
            for (Long l : filter.getPerson()) {
                if (!((String)filterProperties.get("\u8d1f\u8d23\u4ebaID")).equals(l.toString())) continue;
                ++containNumber;
                break;
            }
        }
        if (!CollectionUtils.isEmpty(filter.getDept())) {
            ++countNumber;
            for (Long l : filter.getDept()) {
                if (!((String)filterProperties.get("\u6240\u5c5e\u90e8\u95e8")).equals(l.toString())) continue;
                ++containNumber;
                break;
            }
        }
        if (!CollectionUtils.isEmpty(filter.getLabel())) {
            ++countNumber;
            for (String string : filter.getLabel()) {
                if (((String)filterProperties.get("\u6807\u7b7e")).contains(string)) {
                    ++containNumber;
                    break;
                }
                if (!((String)filterProperties.get("\u667a\u80fd\u6807\u7b7e")).contains(string)) continue;
                ++containNumber;
                break;
            }
        }
        if (!StringUtils.isEmpty((Object)filter.getAttribute())) {
            ++countNumber;
            if (filter.getAttribute().equals(filterProperties.get("\u5ba2\u6237\u6027\u8d28"))) {
                ++containNumber;
            }
        }
        if (!StringUtils.isEmpty((Object)filter.getIndustry())) {
            ++countNumber;
            if (filter.getIndustry().equals(filterProperties.get("\u884c\u4e1a"))) {
                ++containNumber;
            }
        }
        if (!StringUtils.isEmpty((Object)filter.getProvince())) {
            ++countNumber;
            if (filter.getProvince().equals(filterProperties.get("\u7701\u4efd"))) {
                ++containNumber;
            }
        }
        if (countNumber == containNumber) {
            customerFilterList.add(stringObjectMap);
        }
    }
}

