/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.graph.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.product.model.ProductTypeA;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.product.service.ProductTypeAService;
import com.jxdinfo.crm.knowledgegraph.customermark.model.CustomerMark;
import com.jxdinfo.crm.knowledgegraph.customermark.service.CustomerMarkService;
import com.jxdinfo.crm.knowledgegraph.graph.job.service.CalculateWeightService;
import com.jxdinfo.crm.knowledgegraph.weightrule.enums.WeightRuleEnum;
import com.jxdinfo.crm.knowledgegraph.weightrule.model.CustomerWeightRule;
import com.jxdinfo.crm.knowledgegraph.weightrule.service.CustomerWeightRuleService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CalculateWeightServiceImpl
implements CalculateWeightService {
    @Resource
    private CustomerService customerService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private ProductService productService;
    @Resource
    private CustomerWeightRuleService customerWeightRuleService;
    @Resource
    private CustomerMarkService customerMarkService;
    @Resource
    private ProductTypeAService productTypeAService;
    private static final String winningStage = "9223372036854775801";

    @Override
    public void calculateWeight() {
        try {
            List customerWeightRules = this.customerWeightRuleService.list();
            Map<String, CustomerWeightRule> customerWeightRuleMap = customerWeightRules.stream().collect(Collectors.toMap(CustomerWeightRule::getRuleName, p -> p));
            List customerEntities = this.customerService.list();
            ArrayList<CustomerMark> customerMarks = new ArrayList<CustomerMark>();
            ArrayList<CustomerEntity> strategicCustomers = new ArrayList<CustomerEntity>();
            for (CustomerEntity customerEntity : customerEntities) {
                String tags;
                String customerLevelLabel;
                double levelScore;
                Long customerId = customerEntity.getCustomerId();
                String customerName = customerEntity.getCustomerName();
                String customerAttribute = customerEntity.getCustomerAttribute();
                double mark = 0.0;
                String custLevel = customerEntity.getCustLevel();
                CustomerWeightRule attributeScoreRule = customerWeightRuleMap.get(WeightRuleEnum.AttributeScoreRule.getValue());
                int attributeScoreWeight = attributeScoreRule.getWeight();
                String customerAttributeName = "";
                double score = 0.0;
                if (ToolUtil.isNotEmpty((Object)customerAttribute)) {
                    switch (customerAttribute) {
                        case "1": {
                            score = 30 * attributeScoreWeight;
                            customerAttributeName = "\u592e\u4f01\u56fd\u4f01";
                            break;
                        }
                        case "2": {
                            score = 20 * attributeScoreWeight;
                            customerAttributeName = "\u7701\u5c5e\u56fd\u4f01";
                            break;
                        }
                        case "3": {
                            score = 10 * attributeScoreWeight;
                            customerAttributeName = "\u5e02\u5c5e\u56fd\u4f01";
                            break;
                        }
                        default: {
                            customerAttributeName = "\u5176\u4ed6";
                        }
                    }
                }
                mark += score;
                List winOpportunityEntities = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getCustomerId, (Object)customerId)).eq(OpportunityEntity::getCustomerStageId, (Object)winningStage));
                double count = winOpportunityEntities.size();
                CustomerWeightRule winningScoreRule = customerWeightRuleMap.get(WeightRuleEnum.WinningScoreRule.getValue());
                int winningScoreWeight = winningScoreRule.getWeight();
                double winningScore = count * 10.0 * (double)winningScoreWeight;
                mark += winningScore;
                double amount = 0.0;
                List<Object> productListWin = new ArrayList();
                int productAACount = 0;
                for (OpportunityEntity opportunity : winOpportunityEntities) {
                    double opportunityAmount = Double.parseDouble(opportunity.getOpportunityAmount());
                    amount += opportunityAmount;
                    Long opportunityId = opportunity.getOpportunityId();
                    List opportunityProducts = this.opportunityProductService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId));
                    for (OpportunityProduct opportunityProduct : opportunityProducts) {
                        Iterator<Object> productId = opportunityProduct.getProductId();
                        String string = opportunityProduct.getProductName();
                        productListWin.add(productId);
                    }
                }
                CustomerWeightRule amountScoreRule = customerWeightRuleMap.get(WeightRuleEnum.AmountScoreRule.getValue());
                int amountScoreWeight = amountScoreRule.getWeight();
                double amountScore = amount / 10000.0 * (double)amountScoreWeight;
                mark += amountScore;
                productListWin = productListWin.stream().distinct().collect(Collectors.toList());
                double productWinCountScore = CalculateWeightServiceImpl.getScore(customerWeightRuleMap, productListWin.size(), WeightRuleEnum.ProductWinCountScoreRule.getValue());
                mark += productWinCountScore;
                List productTypeAS = this.productTypeAService.list();
                ArrayList<Long> puductIds = new ArrayList<Long>();
                for (ProductTypeA productTypeA : productTypeAS) {
                    puductIds.add(productTypeA.getProductId());
                }
                for (Long l : productListWin) {
                    if (!puductIds.contains(l)) continue;
                    ++productAACount;
                }
                double productAACountScore = CalculateWeightServiceImpl.getScore(customerWeightRuleMap, productAACount, WeightRuleEnum.ProductAACountScoreRule.getValue());
                mark += productAACountScore;
                List opportunityEntities = this.opportunityService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getCustomerId, (Object)customerId));
                int oppoCount = opportunityEntities.size();
                List<Object> productList = new ArrayList();
                for (OpportunityEntity opportunity : opportunityEntities) {
                    Long opportunityId = opportunity.getOpportunityId();
                    List opportunityProducts = this.opportunityProductService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId));
                    for (OpportunityProduct opportunityProduct : opportunityProducts) {
                        Long productId = opportunityProduct.getProductId();
                        String productName = opportunityProduct.getProductName();
                        productList.add(productName);
                    }
                }
                productList = productList.stream().distinct().collect(Collectors.toList());
                double productCountScore = CalculateWeightServiceImpl.getScore(customerWeightRuleMap, productList.size(), WeightRuleEnum.ProductCountScoreRule.getValue());
                mark += productCountScore;
                double oppoCountScore = CalculateWeightServiceImpl.getScore(customerWeightRuleMap, oppoCount, WeightRuleEnum.OppoCountScoreRule.getValue());
                mark += oppoCountScore;
                CustomerWeightRule LevelScoreRule = customerWeightRuleMap.get(WeightRuleEnum.LevelScoreRule.getValue());
                int LevelScoreWeight = LevelScoreRule.getWeight();
                if ("1".equals(custLevel)) {
                    levelScore = 100 * LevelScoreWeight;
                    customerLevelLabel = "\u6218\u7565\u5ba2\u6237";
                } else {
                    levelScore = 0.0;
                    customerLevelLabel = "\u5176\u4ed6";
                }
                mark += levelScore;
                if (count > 0.0 || amountScore > 0.0) {
                    System.out.println(customerId + customerName + customerAttributeName + "  \u8d62\u5355\u6570" + count + "  \u5546\u673a\u6570\u91cf" + oppoCount + "  \u6027\u8d28\u5f97\u5206" + score + "  \u8d62\u5355\u8bb0\u5206" + winningScore + "  \u8d62\u5355\u91d1\u989d\u8bb0\u5206" + amountScore + "  \u5ba2\u6237\u6027\u8d28" + customerLevelLabel + "  \u5546\u673a\u4ea7\u54c1\u5217\u8868" + productList + "  \u8d62\u5355\u5546\u673a\u4ea7\u54c1\u5217\u8868" + productListWin + "  \u603b\u5f97\u5206" + mark);
                }
                int limit = customerWeightRuleMap.get(WeightRuleEnum.MarkLimitRule.getValue()).getThreshold();
                String string = tags = ToolUtil.isNotEmpty((Object)customerEntity.getAiTags()) ? customerEntity.getAiTags() : "";
                if (mark >= (double)limit) {
                    if ("".equals(tags)) {
                        customerEntity.setAiTags("789887029596135424");
                    } else if (!tags.contains("789887029596135424")) {
                        customerEntity.setAiTags(tags + ",789887029596135424");
                    }
                    System.out.println("\u79ef\u5206" + mark + "  \u5ba2\u6237\u540d\u79f0" + customerEntity.getCustomerName());
                }
                strategicCustomers.add(customerEntity);
                CustomerMark customerMark = (CustomerMark)this.customerMarkService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomerMark::getCustomerId, (Object)customerEntity.getCustomerId()));
                if (ToolUtil.isEmpty((Object)customerMark)) {
                    customerMark = new CustomerMark();
                }
                customerMark.setCustomerId(customerEntity.getCustomerId());
                customerMark.setMark(mark);
                customerMark.setAiTags(customerEntity.getAiTags());
                customerMark.setCustomerName(customerEntity.getCustomerName());
                customerMark.setStaffNum(Integer.parseInt(ToolUtil.isNotEmpty((Object)customerEntity.getStaffNumber()) ? customerEntity.getStaffNumber() : "0"));
                customerMark.setLastTime(LocalDateTime.now());
                customerMarks.add(customerMark);
            }
            this.customerService.updateBatchById(strategicCustomers);
            this.customerMarkService.saveOrUpdateBatch(customerMarks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static double getScore(Map<String, CustomerWeightRule> customerWeightRuleMap, double count, String key) {
        CustomerWeightRule countScoreRule = customerWeightRuleMap.get(key);
        int countScoreWeight = countScoreRule.getWeight();
        int countScoreIntValue = countScoreRule.getIntValue();
        int countScoreStep = countScoreRule.getStep();
        int countScoreThreshold = countScoreRule.getThreshold();
        double countScore = count < (double)countScoreThreshold ? 0.0 : (count == (double)countScoreThreshold ? (double)countScoreIntValue : (double)countScoreIntValue + (count - 1.0) * (double)countScoreStep);
        return countScore * (double)countScoreWeight;
    }
}

