/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.graph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.competitoranalysis.model.CompetitorAnalysis;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.config.CrmProperties;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.model.BaseArea1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.basearea1.service.BaseArea1Service;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.label.model.LabelEntity;
import com.jxdinfo.crm.core.label.model.LabelGroupEntity;
import com.jxdinfo.crm.core.label.service.LabelGroupService;
import com.jxdinfo.crm.core.label.service.LabelService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.knowledgegraph.city.model.City;
import com.jxdinfo.crm.knowledgegraph.city.service.CityService;
import com.jxdinfo.crm.knowledgegraph.contactdepartment.dto.ContactDepartmentVo;
import com.jxdinfo.crm.knowledgegraph.contactdepartment.model.ContactDepartment;
import com.jxdinfo.crm.knowledgegraph.contactdepartment.service.ContactDepartmentService;
import com.jxdinfo.crm.knowledgegraph.customerType.model.CustomerType;
import com.jxdinfo.crm.knowledgegraph.customerType.service.CustomerTypeService;
import com.jxdinfo.crm.knowledgegraph.customerlabel.model.CustomerLabel;
import com.jxdinfo.crm.knowledgegraph.customerlabel.service.CustomerLabelService;
import com.jxdinfo.crm.knowledgegraph.graph.dao.AtlasMapper;
import com.jxdinfo.crm.knowledgegraph.graph.dto.AtlasResponse;
import com.jxdinfo.crm.knowledgegraph.graph.job.service.CalculateWeightAddService;
import com.jxdinfo.crm.knowledgegraph.graph.job.service.CalculateWeightService;
import com.jxdinfo.crm.knowledgegraph.graph.service.NodeAndRelationService;
import com.jxdinfo.crm.knowledgegraph.productcustomerlabel.service.ProductCustomerLabelService;
import com.jxdinfo.crm.knowledgegraph.productcustomermark.service.ProductCustomerMarkService;
import com.jxdinfo.crm.knowledgegraph.province.model.Province;
import com.jxdinfo.crm.knowledgegraph.province.service.ProvinceService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

@Service
@HussarDs(value="graph")
public class NodeAndRelationServiceImpl
implements NodeAndRelationService {
    private static final Logger logger = LoggerFactory.getLogger(NodeAndRelationServiceImpl.class);
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ContactService contactService;
    @Resource
    private CompetitorService competitorService;
    @Resource
    private ProductService productService;
    @Resource
    private LabelService labelService;
    @Resource
    private LabelGroupService labelGroupService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private AtlasMapper atlasMapper;
    @Resource
    private CustomerLabelService customerLabelService;
    @Resource
    private ContactDepartmentService contactDepartmentService;
    @Resource
    private CustomerTypeService customerTypeService;
    @Resource
    private ProvinceService provinceService;
    @Resource
    private CityService cityService;
    @Resource
    private BaseArea1Service area1Service;
    @Autowired
    private CalculateWeightService calculateWeightService;
    @Autowired
    private CalculateWeightAddService calculateWeightAddService;
    @Autowired
    private ProductCustomerLabelService productCustomerLabelService;
    @Autowired
    private ProductCustomerMarkService productCustomerMarkService;
    @Resource
    private CrmProperties crmProperties;
    @Resource
    private ISysDicSingleService iSysDicSingleService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        logger.info("\u5f00\u59cb\u6784\u5efa\u56fe\u8c31");
        String url = this.crmProperties.getRequestGraphRebuildUrl();
        HttpURLConnection connection = null;
        StringBuilder response = new StringBuilder();
        try {
            String resultJson;
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setConnectTimeout(10000);
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((resultJson = br.readLine()) != null) {
                response.append(new String(resultJson.trim().getBytes(), "UTF-8"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        AtlasResponse atlasResponse = (AtlasResponse)JSONObject.parseObject((String)String.valueOf(response), AtlasResponse.class);
        if (atlasResponse.isSuccess()) {
            logger.info("\u6784\u5efa\u56fe\u8c31\u7ed3\u675f", (Object)atlasResponse.getMsg());
        } else {
            logger.error("\u56fe\u8c31\u6784\u5efa\u5931\u8d25", (Object)atlasResponse.getMsg());
        }
    }

    @Override
    public void buildGraphData() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u56fe\u8c31SQL\u811a\u672c");
        int tradeTypeExists = this.atlasMapper.getTableColumnExists("CRM_CUSTOMER", "TRADE_TYPE");
        if (tradeTypeExists == 0) {
            this.atlasMapper.executeSql("ALTER TABLE crm_customer ADD TRADE_TYPE varchar(100) NULL;");
        }
        File file = ResourceUtils.getFile((String)"classpath:graph.sql");
        String sql = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        this.atlasMapper.executeSql(sql);
        logger.info("\u6267\u884c\u56fe\u8c31SQL\u811a\u672c\u7ed3\u675f");
        this.calculateWeightService.calculateWeight();
        this.calculateWeightAddService.calculateWeight();
        this.productCustomerLabelService.countLabelNumber();
        this.productCustomerMarkService.calculateMark();
        this.customerLabel();
        this.concatDept();
        this.customerType();
        this.changeProvinceId();
        this.addCustomerCity();
        this.rebuild();
    }

    @Override
    public void saveOpportunity(List<OpportunityEntity> opportunityEntities) {
        this.opportunityService.remove((Wrapper)new QueryWrapper());
        this.opportunityService.saveBatch(opportunityEntities);
    }

    @Override
    public void saveCustomer(List<CustomerEntity> customerEntities) {
        this.customerService.remove((Wrapper)new QueryWrapper());
        this.customerService.saveBatch(customerEntities);
    }

    @Override
    public void saveContact(List<ContactEntity> contactEntities) {
        this.contactService.remove((Wrapper)new QueryWrapper());
        this.contactService.saveBatch(contactEntities);
    }

    @Override
    public void saveCompetitor(List<Competitor> competitors) {
        this.competitorService.remove((Wrapper)new QueryWrapper());
        this.competitorService.saveBatch(competitors);
    }

    @Override
    public void saveProduct(List<Product> products) {
        this.productService.remove((Wrapper)new QueryWrapper());
        this.productService.saveBatch(products);
    }

    @Override
    public void saveLabel(List<LabelEntity> labelEntities) {
        this.labelService.remove((Wrapper)new QueryWrapper());
        this.labelService.saveBatch(labelEntities);
    }

    @Override
    public void saveLabelGroup(List<LabelGroupEntity> labelGroupEntities) {
        this.labelGroupService.remove((Wrapper)new QueryWrapper());
        this.labelGroupService.saveBatch(labelGroupEntities);
    }

    @Override
    public void saveOpportunityProducts(List<OpportunityProduct> opportunityProducts) {
        this.opportunityProductService.remove((Wrapper)new QueryWrapper());
        this.opportunityProductService.saveBatch(opportunityProducts);
    }

    @Override
    public void saveCompetitorAnalyses(List<CompetitorAnalysis> competitorAnalyses) {
        this.competitorAnalysisService.remove((Wrapper)new QueryWrapper());
        this.competitorAnalysisService.saveBatch(competitorAnalyses);
    }

    public void customerLabel() {
        CustomerLabel customerLabel;
        String[] split;
        List list = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(CustomerEntity::getLabelId)).ne(CustomerEntity::getLabelId, (Object)""));
        List list1 = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(CustomerEntity::getAiTags)).ne(CustomerEntity::getAiTags, (Object)""));
        ArrayList<CustomerLabel> customerLabels = new ArrayList<CustomerLabel>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (CustomerEntity customerEntity : list) {
                for (String s : split = customerEntity.getLabelId().split(",")) {
                    customerLabel = new CustomerLabel();
                    customerLabel.setCustomerId(customerEntity.getCustomerId().toString());
                    customerLabel.setLabelId(s);
                    customerLabels.add(customerLabel);
                }
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)list1)) {
            for (CustomerEntity customerEntity : list1) {
                for (String s : split = customerEntity.getAiTags().split(",")) {
                    customerLabel = new CustomerLabel();
                    customerLabel.setCustomerId(customerEntity.getCustomerId().toString());
                    customerLabel.setLabelId(s);
                    customerLabels.add(customerLabel);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(customerLabels)) {
            this.customerLabelService.remove((Wrapper)new QueryWrapper());
            this.customerLabelService.saveBatch(customerLabels);
        }
    }

    public void concatDept() {
        List<ContactDepartmentVo> contactDepartments = this.atlasMapper.getContactDepartments();
        ArrayList<ContactDepartment> contactDepartments1 = new ArrayList<ContactDepartment>();
        if (CollectionUtil.isNotEmpty(contactDepartments)) {
            for (ContactDepartmentVo contactDepartment : contactDepartments) {
                contactDepartments1.add(new ContactDepartment(contactDepartment.getCustomerId(), contactDepartment.getDepartmentName()));
            }
        }
        if (CollectionUtil.isNotEmpty(contactDepartments1)) {
            this.contactDepartmentService.remove((Wrapper)new QueryWrapper());
            this.contactDepartmentService.saveBatch(contactDepartments1);
        }
    }

    public void customerType() {
        ArrayList<CustomerType> customerTypes = new ArrayList<CustomerType>();
        List dicSingles = this.iSysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getTypeId, (Object)"548815204545470464"));
        if (!CollectionUtils.isEmpty((Collection)dicSingles)) {
            for (DicSingle dicSingle : dicSingles) {
                customerTypes.add(new CustomerType(dicSingle.getLabel(), dicSingle.getValue()));
            }
        }
        this.customerTypeService.remove((Wrapper)new QueryWrapper());
        this.customerTypeService.saveBatch(customerTypes);
    }

    public void changeProvinceId() {
        List list = this.provinceService.list();
        ArrayList<Long> longList = new ArrayList<Long>();
        ArrayList<Province> provinces = new ArrayList<Province>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (Province province : list) {
                longList.add(province.getId());
                Province province1 = new Province();
                province1.setProvinceId(province.getProvinceId());
                province1.setProvinceName(province.getProvinceName());
                provinces.add(province1);
            }
            this.provinceService.removeByIds(longList);
            this.provinceService.saveBatch(provinces);
        }
    }

    public void addCustomerCity() {
        List customerEntities = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNotNull(CustomerEntity::getCity)).ne(CustomerEntity::getCity, (Object)""));
        HashSet<String> citys = new HashSet<String>();
        for (CustomerEntity customerEntity : customerEntities) {
            citys.add(customerEntity.getCity());
        }
        List provinces = this.provinceService.list();
        HashMap<String, String> provinceIds = new HashMap<String, String>();
        for (Province province : provinces) {
            provinceIds.put(province.getProvinceId().toString(), province.getId().toString());
        }
        List cityLists = this.area1Service.list((Wrapper)new LambdaQueryWrapper().in(BaseArea1::getBaseAreaid, citys));
        ArrayList<City> cities = new ArrayList<City>();
        for (BaseArea1 cityList : cityLists) {
            City city = new City();
            city.setCityId(cityList.getBaseAreaid().toString());
            city.setCityName(cityList.getName());
            city.setProvinceId((String)provinceIds.get(cityList.getParentid().toString()));
            cities.add(city);
        }
        this.cityService.remove((Wrapper)new QueryWrapper());
        this.cityService.saveBatch(cities);
    }
}

