/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.graph.service.impl;

import com.jxdinfo.crm.core.competitor.service.CompetitorService;
import com.jxdinfo.crm.core.competitoranalysis.service.CompetitorAnalysisService;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.label.service.LabelGroupService;
import com.jxdinfo.crm.core.label.service.LabelService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.knowledgegraph.graph.service.GraphService;
import com.jxdinfo.crm.knowledgegraph.graph.service.NodeAndRelationService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GraphServiceImpl
implements GraphService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ContactService contactService;
    @Resource
    private CompetitorService competitorService;
    @Resource
    private ProductService productService;
    @Resource
    private LabelService labelService;
    @Resource
    private LabelGroupService labelGroupService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private CompetitorAnalysisService competitorAnalysisService;
    @Resource
    private NodeAndRelationService nodeAndRelationService;

    @Override
    public void buildGraph() throws Exception {
        List opportunityEntities = this.opportunityService.list();
        List customerEntities = this.customerService.list();
        List contactEntities = this.contactService.list();
        List competitors = this.competitorService.list();
        List products = this.productService.list();
        List labelEntities = this.labelService.list();
        List labelGroupEntities = this.labelGroupService.list();
        List opportunityProducts = this.opportunityProductService.list();
        List competitorAnalyses = this.competitorAnalysisService.list();
        if (!CollectionUtils.isEmpty((Collection)opportunityEntities)) {
            this.nodeAndRelationService.saveOpportunity(opportunityEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)customerEntities)) {
            this.nodeAndRelationService.saveCustomer(customerEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)contactEntities)) {
            this.nodeAndRelationService.saveContact(contactEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)competitors)) {
            this.nodeAndRelationService.saveCompetitor(competitors);
        }
        if (!CollectionUtils.isEmpty((Collection)products)) {
            this.nodeAndRelationService.saveProduct(products);
        }
        if (!CollectionUtils.isEmpty((Collection)labelEntities)) {
            this.nodeAndRelationService.saveLabel(labelEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)labelGroupEntities)) {
            this.nodeAndRelationService.saveLabelGroup(labelGroupEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)opportunityProducts)) {
            this.nodeAndRelationService.saveOpportunityProducts(opportunityProducts);
        }
        if (!CollectionUtils.isEmpty((Collection)competitorAnalyses)) {
            this.nodeAndRelationService.saveCompetitorAnalyses(competitorAnalyses);
        }
        this.nodeAndRelationService.buildGraphData();
    }
}

