/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledgegraph.graph.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.knowledgegraph.customermark.model.CustomerMark;
import com.jxdinfo.crm.knowledgegraph.customermark.service.CustomerMarkService;
import com.jxdinfo.crm.knowledgegraph.graph.job.service.CalculateWeightAddService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CalculateWeightAddServiceImpl
implements CalculateWeightAddService {
    @Resource
    private CustomerService customerService;
    @Resource
    private CustomerMarkService customerMarkService;

    @Override
    public void calculateWeight() {
        try {
            List customerEntities = this.customerService.list();
            ArrayList<CustomerMark> customerMarks = new ArrayList<CustomerMark>();
            for (CustomerEntity customerEntity : customerEntities) {
                String staffNumber = customerEntity.getStaffNumber();
                if (!ToolUtil.isNotEmpty((Object)staffNumber)) continue;
                String tags = ToolUtil.isNotEmpty((Object)customerEntity.getAiTags()) ? customerEntity.getAiTags() : "";
                switch (staffNumber) {
                    case "1": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("794521287501553664");
                            break;
                        }
                        if (tags.contains("794521287501553664")) break;
                        customerEntity.setAiTags(tags + ",794521287501553664");
                        break;
                    }
                    case "2": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("794521381009367040");
                            break;
                        }
                        if (tags.contains("794521381009367040")) break;
                        customerEntity.setAiTags(tags + ",794521381009367040");
                        break;
                    }
                    case "3": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("794521459430268928");
                            break;
                        }
                        if (tags.contains("794521459430268928")) break;
                        customerEntity.setAiTags(tags + ",794521459430268928");
                        break;
                    }
                    case "4": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("794521511393501184");
                            break;
                        }
                        if (tags.contains("794521511393501184")) break;
                        customerEntity.setAiTags(tags + ",794521511393501184");
                        break;
                    }
                    case "5": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("794521592511340544");
                            break;
                        }
                        if (tags.contains("794521592511340544")) break;
                        customerEntity.setAiTags(tags + ",794521592511340544");
                        break;
                    }
                    case "6": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("794521687231307776,794521592511340544");
                            break;
                        }
                        if (tags.contains("794521687231307776")) break;
                        customerEntity.setAiTags(tags + ",794521687231307776");
                        if (tags.contains("794521592511340544")) break;
                        customerEntity.setAiTags(tags + ",794521687231307776,794521592511340544");
                        break;
                    }
                    case "7": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("792398738823061504,794521592511340544");
                            break;
                        }
                        if (tags.contains("792398738823061504")) break;
                        customerEntity.setAiTags(tags + ",792398738823061504");
                        if (tags.contains("794521592511340544")) break;
                        customerEntity.setAiTags(tags + ",792398738823061504,794521592511340544");
                        break;
                    }
                    case "8": {
                        if ("".equals(tags)) {
                            customerEntity.setAiTags("792398793810386944,794521592511340544");
                            break;
                        }
                        if (tags.contains("792398793810386944")) break;
                        customerEntity.setAiTags(tags + ",792398793810386944");
                        if (tags.contains("794521592511340544")) break;
                        customerEntity.setAiTags(tags + ",792398793810386944,794521592511340544");
                    }
                }
                CustomerMark customerMark = (CustomerMark)this.customerMarkService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomerMark::getCustomerId, (Object)customerEntity.getCustomerId()));
                if (ToolUtil.isEmpty((Object)customerMark)) {
                    customerMark = new CustomerMark();
                }
                customerMark.setCustomerId(customerEntity.getCustomerId());
                customerMark.setAiTags(customerEntity.getAiTags());
                customerMark.setCustomerName(customerEntity.getCustomerName());
                customerMark.setStaffNum(Integer.parseInt(customerEntity.getStaffNumber()));
                customerMark.setLastTime(LocalDateTime.now());
                customerMarks.add(customerMark);
            }
            this.customerService.updateBatchById((Collection)customerEntities);
            this.customerMarkService.saveOrUpdateBatch(customerMarks);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

