/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.timer.hutool;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.timer.api.exception.TimerException;
import cn.stylefeng.roses.kernel.timer.api.exception.enums.TimerExceptionEnum;
import cn.stylefeng.roses.kernel.timer.hutool.HutoolTimerExeServiceImpl;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerExeServiceImpl
extends HutoolTimerExeServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimerExeServiceImpl.class);

    @Override
    public void start() {
        CronUtil.setMatchSecond((boolean)true);
        if (!CronUtil.getScheduler().isStarted()) {
            CronUtil.start();
            log.info("scheduler{} is not started", (Object)CronUtil.getScheduler().toString());
        } else {
            log.info("scheduler{} has already started", (Object)CronUtil.getScheduler().toString());
        }
    }

    @Override
    public void startTimer(String taskId, String cron, String className, String params) {
        if (StrUtil.isBlank((CharSequence)taskId)) {
            throw new TimerException((AbstractExceptionEnum)TimerExceptionEnum.PARAM_HAS_NULL, new Object[]{"taskId"});
        }
        if (CronUtil.getScheduler().getTask(taskId) != null) {
            log.info("task ID:{} is existed\uff0cthen will replace before one", (Object)taskId);
            CronUtil.getScheduler().deschedule(taskId);
        }
        super.startTimer(taskId, cron, className, params);
    }
}

