/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.password;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.BCrypt;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordStoredEncryptApi;
import cn.stylefeng.roses.kernel.auth.api.pojo.password.SaltedEncryptResult;

public class BcryptPasswordStoredEncrypt
implements PasswordStoredEncryptApi {
    public String encrypt(String originPassword) {
        if (StrUtil.isBlank((CharSequence)originPassword)) {
            return null;
        }
        return BCrypt.hashpw((String)originPassword, (String)BCrypt.gensalt());
    }

    public SaltedEncryptResult encryptWithSalt(String originPassword) {
        SaltedEncryptResult saltedEncryptResult = new SaltedEncryptResult();
        String salt = RandomUtil.randomString((int)8);
        saltedEncryptResult.setPasswordSalt(salt);
        String encryptAfter = SecureUtil.md5((String)(originPassword + salt));
        saltedEncryptResult.setEncryptPassword(encryptAfter);
        return saltedEncryptResult;
    }

    public Boolean checkPassword(String encryptBefore, String encryptAfter) {
        return BCrypt.checkpw((String)encryptBefore, (String)encryptAfter);
    }

    public Boolean checkPasswordWithSalt(String encryptBefore, String passwordSalt, String encryptAfter) {
        return SecureUtil.md5((String)(encryptBefore + passwordSalt)).equals(encryptAfter);
    }
}

