/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.resolver.resource.UriEncodeUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UriResolver {
    private URL baseUrl;
    private boolean isLocalBaseUri;

    public UriResolver(String baseUri) {
        if (baseUri == null) {
            throw new IllegalArgumentException("baseUri");
        }
        this.resolveBaseUrlOrPath(baseUri);
    }

    public String getBaseUri() {
        return this.baseUrl.toExternalForm();
    }

    public URL resolveAgainstBaseUri(String uriString) throws MalformedURLException {
        URL resolvedUrl = null;
        uriString = uriString.trim();
        uriString = UriEncodeUtil.encode(uriString);
        if (this.isLocalBaseUri && !uriString.startsWith("file:")) {
            try {
                Path path = Paths.get(uriString, new String[0]);
                if (path.isAbsolute()) {
                    resolvedUrl = path.toUri().toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resolvedUrl == null) {
            resolvedUrl = new URL(this.baseUrl, uriString);
        }
        return resolvedUrl;
    }

    public boolean isLocalBaseUri() {
        return this.isLocalBaseUri;
    }

    private void resolveBaseUrlOrPath(String base) {
        base = base.trim();
        this.baseUrl = this.baseUriAsUrl(UriEncodeUtil.encode(base));
        if (this.baseUrl == null) {
            this.baseUrl = this.uriAsFileUrl(base);
        }
        if (this.baseUrl == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"Invalid base URI: {0}", (Object[])new Object[]{base}));
        }
    }

    private URL baseUriAsUrl(String baseUriString) {
        URL baseAsUrl = null;
        try {
            URI baseUri = new URI(baseUriString);
            if (baseUri.isAbsolute()) {
                baseAsUrl = baseUri.toURL();
                if ("file".equals(baseUri.getScheme())) {
                    this.isLocalBaseUri = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseAsUrl;
    }

    private URL uriAsFileUrl(String baseUriString) {
        URL baseAsFileUrl = null;
        try {
            Path path = Paths.get(baseUriString, new String[0]);
            if (this.isPathRooted(path, baseUriString)) {
                String str = "file:///" + this.encode(path, path.toAbsolutePath().normalize().toString());
                baseAsFileUrl = new URI(str).toURL();
            } else {
                String str = this.encode(path, baseUriString);
                URL base = Paths.get("", new String[0]).toUri().toURL();
                baseAsFileUrl = new URL(base, str);
            }
            this.isLocalBaseUri = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseAsFileUrl;
    }

    private String encode(Path path, String str) {
        str = str.replace("\\", "/");
        str = UriEncodeUtil.encode(str);
        if (Files.isDirectory(path, new LinkOption[0]) && !str.endsWith("/")) {
            str = str + "/";
        }
        str = str.replaceFirst("/*\\\\*", "");
        return str;
    }

    private boolean isPathRooted(Path path, String str) {
        return path.isAbsolute() || str.startsWith("/");
    }
}

