/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.util;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.converter.SvgConverter;
import com.itextpdf.svg.processors.ISvgProcessorResult;
import com.itextpdf.svg.processors.impl.SvgProcessorResult;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.PdfRootSvgNodeRenderer;

public class SvgProcessingUtil {
    private ResourceResolver resourceResolver;

    public SvgProcessingUtil(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Image createImageFromProcessingResult(ISvgProcessorResult result, PdfDocument pdfDocument) {
        PdfFormXObject xObject = this.createXObjectFromProcessingResult(result, pdfDocument);
        return new Image(xObject);
    }

    public PdfFormXObject createXObjectFromProcessingResult(ISvgProcessorResult result, PdfDocument pdfDocument) {
        ISvgNodeRenderer topSvgRenderer = result.getRootRenderer();
        float[] wh = SvgConverter.extractWidthAndHeight((ISvgNodeRenderer)topSvgRenderer);
        float width = wh[0];
        float height = wh[1];
        PdfFormXObject pdfForm = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        PdfCanvas canvas = new PdfCanvas(pdfForm, pdfDocument);
        ResourceResolver tempResolver = new ResourceResolver(null, this.resourceResolver.getRetriever());
        SvgDrawContext context = new SvgDrawContext(tempResolver, result.getFontProvider());
        if (result instanceof SvgProcessorResult) {
            context.setCssContext(((SvgProcessorResult)result).getContext().getCssContext());
        }
        context.addNamedObjects(result.getNamedObjects());
        context.pushCanvas(canvas);
        PdfRootSvgNodeRenderer root = new PdfRootSvgNodeRenderer(topSvgRenderer);
        root.draw(context);
        return pdfForm;
    }
}

