/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.spring.boot;

import com.alipay.api.DefaultAlipayClient;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.module.alipay.auth.AliCWebAuthorize;
import com.iteaj.util.module.oauth2.AuthorizeServlet;
import com.iteaj.util.module.wechat.authhorize.WxaEnterpriseAuthorize;
import com.iteaj.util.module.wechat.authhorize.WxaWebAuthorize;
import com.iteaj.util.module.wechat.authhorize.WxcEnterpriseAuthorize;
import com.iteaj.util.module.wechat.authhorize.WxcWebAuthorize;
import com.iteaj.util.module.wechat.basictoken.WxaBasicToken;
import com.iteaj.util.module.wechat.basictoken.WxcBasicToken;
import com.iteaj.util.module.wechat.jsapi.WxaJsApi;
import com.iteaj.util.module.wechat.jsapi.WxcJsApi;
import com.iteaj.util.spring.ApiManager;
import com.iteaj.util.spring.boot.IUtilsProperties;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@EnableConfigurationProperties(value={IUtilsProperties.class})
public class IUtilsAutoConfiguration
implements InitializingBean,
ApplicationContextAware {
    private String contextPath = "";
    private String redirectUri;
    @Autowired
    private IUtilsProperties properties;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ALI_CLIENT = "AlipayClient";
    private static Map<String, Object> param = new HashMap<String, Object>();

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public ServletRegistrationBean getOauth2GrantServlet() {
        String redirectUrl = this.properties.getRedirectUrl();
        if (!CommonUtils.isBlank(redirectUrl)) {
            return new ServletRegistrationBean((Servlet)new AuthorizeServlet(), new String[]{redirectUrl});
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        if (CommonUtils.isNotBlank(this.properties.getDomain())) {
            if (!this.properties.getDomain().startsWith("http")) {
                throw new BeanInitializationException("\u56de\u8c03\u5730\u5740\u8bbe\u7f6e\u9519\u8bef\uff1a\u5982\u679c\u914d\u7f6e\u4e86iutil.domain \u5219\u6b64\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934; \u4e5f\u53ef\u4ee5\u9009\u62e9\u4e0d\u914d\u7f6e\u5219\u9ed8\u8ba4\u83b7\u53d6\u5f53\u524d\u8bf7\u6c42\u5730\u5740");
            }
            this.redirectUri = !this.properties.getDomain().contains(this.contextPath) ? this.properties.getDomain() + this.contextPath + this.properties.getRedirectUrl() : this.properties.getDomain() + this.properties.getRedirectUrl();
            this.logger.info("\u7c7b\u522b\uff1a\u81ea\u52a8\u914d\u7f6e - \u52a8\u4f5c\uff1a\u751f\u6210Oauth2\u9700\u8981\u7684redirectUri - \u63cf\u8ff0\uff1a\u901a\u8fc7\u914d\u7f6e\u751f\u6210 - redirectUri\uff1a{}", (Object)this.redirectUri);
        } else {
            this.redirectUri = this.properties.getRedirectUrl();
            this.logger.warn("\u7c7b\u522b\uff1a\u81ea\u52a8\u914d\u7f6e - \u52a8\u4f5c\uff1a\u751f\u6210Oauth2\u9700\u8981\u7684redirectUri - \u63cf\u8ff0\uff1a\u6839\u636e\u8bf7\u6c42\u81ea\u52a8\u751f\u6210 - redirectUri\uff1a#{domain}+{}", (Object)this.redirectUri);
        }
        this.registerAlipayApi();
        this.registerWechatApi();
        this.registerWechatMpApi();
    }

    private void registerAlipayApi() {
        IUtilsProperties.Alipay alipay = this.properties.getAlipay();
        if (alipay == null) {
            return;
        }
        if (CommonUtils.isBlank(alipay.getPrivateKey()) || CommonUtils.isBlank(alipay.getAlipayPublicKey())) {
            throw new BeanInitializationException("\u672a\u914d\u7f6e\u652f\u4ed8\u5b9d\u5bc6\u94a5\uff1aiutil.alipay.alipay-public-key \u6216 iutil.alipay.private-key");
        }
        try {
            DefaultAlipayClient client = new DefaultAlipayClient(alipay.getApiGateway(), alipay.getAppId(), alipay.getPrivateKey(), alipay.getFormat(), alipay.getCharset(), alipay.getAlipayPublicKey(), alipay.getSignType());
            param.put(ALI_CLIENT, client);
            ApiManager.register(new AliCWebAuthorize(alipay.getAppId(), this.redirectUri).buildApi());
        }
        catch (Throwable e) {
            this.logger.error("\u7c7b\u522b\uff1a\u81ea\u52a8\u914d\u7f6e - \u52a8\u4f5c\uff1a\u6ce8\u518c\u652f\u4ed8\u5b9dApi - \u63cf\u8ff0\uff1a\u627e\u4e0d\u5230\u7c7b`DefaultAlipayClient` - \u89e3\u51b3\u65b9\u6848\uff1a\u5bfc\u5165\u652f\u4ed8\u5b9dcom.alipay.sdk\u5305");
            throw new BeanInitializationException(e.getMessage(), e);
        }
    }

    private void registerWechatMpApi() {
        IUtilsProperties.Wechat wechat = this.properties.getWechat();
        if (wechat == null || wechat.getMp() == null) {
            return;
        }
        IUtilsProperties.Wechat.Mp mp = wechat.getMp();
        if (!(CommonUtils.isNotBlank(mp.getAppId()) && CommonUtils.isNotBlank(mp.getAppSecret()) || mp.getAppId() == null && mp.getAppSecret() == null)) {
            throw new BeanInitializationException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f8\u5173Api\u6ce8\u518c\u5931\u8d25, \u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\uff1aiutil.wechat.mp.app-id \u548c iutil.wechat.mp.app-secret");
        }
    }

    private void registerWechatApi() {
        IUtilsProperties.Wechat wechat = this.properties.getWechat();
        if (null == wechat) {
            return;
        }
        if (CommonUtils.isNotBlank(wechat.getAppId()) && CommonUtils.isNotBlank(wechat.getAppSecret())) {
            WxaBasicToken wxaBasicToken = new WxcBasicToken(wechat.getAppId(), wechat.getAppSecret()).buildApi();
            ApiManager.register(wxaBasicToken);
            WxaJsApi wxaJsApi = new WxcJsApi(wechat.getAppId(), wechat.getAppSecret()).buildApi();
            ApiManager.register(wxaJsApi);
            WxaWebAuthorize wxaWebAuthorize = new WxcWebAuthorize(wechat.getAppId(), wechat.getAppSecret(), this.redirectUri).buildApi();
            ApiManager.register(wxaWebAuthorize);
        } else if (wechat.getAppId() != null || wechat.getAppSecret() != null) {
            throw new BeanInitializationException("\u5fae\u4fe1\u516c\u4f17\u53f7\u76f8\u5173Api\u6ce8\u518c\u5931\u8d25, \u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\uff1aiutil.wechat.app-id \u548c iutil.wechat.app-secret");
        }
        if (CommonUtils.isNotBlank(wechat.getCorpId()) && CommonUtils.isNotBlank(wechat.getCorpSecret()) && CommonUtils.isNotBlank(wechat.getAgentId())) {
            WxaEnterpriseAuthorize enterpriseAuthorize = new WxcEnterpriseAuthorize(wechat.getCorpId(), wechat.getCorpSecret(), wechat.getAgentId(), this.redirectUri).buildApi();
            ApiManager.register(enterpriseAuthorize);
        } else if (wechat.getCorpId() != null || wechat.getCorpSecret() != null || wechat.getAgentId() != null) {
            throw new BeanInitializationException("\u5fae\u4fe1\u4f01\u4e1a\u53f7\u76f8\u5173Api\u6ce8\u518c\u5931\u8d25, \u8bf7\u68c0\u67e5\u914d\u7f6e\u9879\uff1aiutil.wechat.corp-id \u548c iutil.wechat.corp-secret \u4ee5\u53ca iutil.wechat.agent-id");
        }
    }

    public static <R> R getParam(String key) {
        return (R)param.get(key);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            if (applicationContext instanceof WebApplicationContext) {
                this.contextPath = ((WebApplicationContext)applicationContext).getServletContext().getContextPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

