/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.spring;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayResponse;
import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.ApiParam;
import com.iteaj.util.core.ApiReturn;
import com.iteaj.util.core.UtilsApi;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.alipay.AliPAdaptor;
import com.iteaj.util.module.alipay.AliRAdaptor;
import com.iteaj.util.spring.boot.IUtilsAutoConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiManager {
    private static Map<Class<? extends ApiParam>, UtilsApi> apiMap;
    public static Logger logger;

    protected ApiManager() {
    }

    public static void register(UtilsApi api) {
        AssertUtils.isTrue(null != api, "\u4e0d\u5141\u8bb8\u6ce8\u518c\u7a7a\u7684Api", UtilsType.API);
        Class apiParamType = api.getParamType();
        AssertUtils.isTrue(null != apiParamType, "\u672a\u77e5\u7684Api\u53c2\u6570\u7c7b\u578b", UtilsType.API);
        apiMap.put(apiParamType, api);
        logger.info("\u7c7b\u522b\uff1aApi\u5de5\u5382 - \u52a8\u4f5c\uff1a\u6ce8\u518cApi - Api\uff1a{} - \u63cf\u8ff0\uff1a{}", (Object)api.getClass().getSimpleName(), (Object)api.desc());
    }

    public static <P extends ApiParam> UtilsApi getApi(Class<P> clazz) {
        return apiMap.get(clazz);
    }

    public static <T extends ApiReturn> T invoke(ApiParam<T> param, Object ... args) {
        AssertUtils.isTrue(null != param, "\u672a\u6307\u5b9a\u8c03\u7528api\u6240\u9700\u53c2\u6570", UtilsType.API);
        if (param instanceof AliPAdaptor) {
            try {
                AliPAdaptor adaptor = (AliPAdaptor)param;
                AlipayClient client = (AlipayClient)IUtilsAutoConfiguration.getParam("AlipayClient");
                AlipayResponse alipayResponse = CommonUtils.isNotBlank(adaptor.getAccessToken()) && CommonUtils.isNotBlank(adaptor.getAppAuthToken()) ? client.execute(adaptor.getAlipayRequest(), adaptor.getAccessToken(), adaptor.getAppAuthToken()) : (CommonUtils.isNotBlank(adaptor.getAccessToken()) ? client.execute(adaptor.getAlipayRequest(), adaptor.getAccessToken()) : client.execute(adaptor.getAlipayRequest()));
                return (T)new AliRAdaptor<AlipayResponse>(alipayResponse);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e, UtilsType.ALIPAY);
            }
        }
        UtilsApi api = ApiManager.getApi(param.getClass());
        AssertUtils.isTrue(null != api, "\u672a\u6ce8\u518c\u4e0e\u6b64\u7c7b\u578b\uff1a" + param.getClass().getSimpleName() + "\u5bf9\u5e94\u7684Api, \u539f\u56e0\u53ef\u80fd\u662f\uff1a\r\n 1. \u672a\u6ce8\u518c(\u8bf7\u5148\u8c03\u7528register\u65b9\u6cd5\u8fdb\u884c\u6ce8\u518c) \r\n 2. \u672a\u6307\u5b9a\u5bf9\u5e94\u7684\u914d\u7f6e\u53c2\u6570, \u6bd4\u5982\u5fae\u4fe1\u76f8\u5173Api\uff1aiutil.wechat.app-id\u548ciutil.wechat.app-secret", UtilsType.API);
        return (T)api.invoke(param, args);
    }

    static {
        logger = LoggerFactory.getLogger(ApiManager.class);
        apiMap = new ConcurrentHashMap<Class<? extends ApiParam>, UtilsApi>(32);
    }
}

