/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.xml;

import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.xml.XmlAdapter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.springframework.util.Assert;

public class Jaxb2Adapter
implements XmlAdapter {
    private final ConcurrentMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap<Class, JAXBContext>(64);

    @Override
    public String toXml(Object obj) {
        return Optional.ofNullable(obj).map(item -> {
            StringWriter writer = new StringWriter();
            try {
                Marshaller marshaller = this.createMarshaller(item.getClass());
                marshaller.marshal(obj, (Writer)writer);
            }
            catch (JAXBException e) {
                throw new UtilsException(e, UtilsType.XML);
            }
            return writer.toString();
        }).orElse(null);
    }

    @Override
    public <T> T toBean(String xml, Class<T> clazz) {
        return Optional.ofNullable(xml).map(item -> {
            try {
                return this.createUnmarshaller(clazz).unmarshal((Reader)new StringReader(xml));
            }
            catch (JAXBException e) {
                throw new UtilsException(e, UtilsType.XML);
            }
        }).orElse(null);
    }

    protected final Marshaller createMarshaller(Class clazz) {
        try {
            JAXBContext jaxbContext = this.getJaxbContext(clazz);
            return jaxbContext.createMarshaller();
        }
        catch (JAXBException var3) {
            throw new UtilsException(var3, UtilsType.XML);
        }
    }

    protected final Unmarshaller createUnmarshaller(Class clazz) throws JAXBException {
        try {
            JAXBContext jaxbContext = this.getJaxbContext(clazz);
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException var3) {
            throw new UtilsException(var3, UtilsType.XML);
        }
    }

    protected final JAXBContext getJaxbContext(Class clazz) {
        Assert.notNull((Object)clazz, (String)"'clazz' must not be null");
        JAXBContext jaxbContext = (JAXBContext)this.jaxbContexts.get(clazz);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                this.jaxbContexts.putIfAbsent(clazz, jaxbContext);
            }
            catch (JAXBException var3) {
                throw new UtilsException(var3, UtilsType.XML);
            }
        }
        return jaxbContext;
    }
}

