/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.pay.unified;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.HttpUtils;
import com.iteaj.util.PaySignUtils;
import com.iteaj.util.RandomUtils;
import com.iteaj.util.XmlUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.build.StreamBuilder;
import com.iteaj.util.module.wechat.WechatApiType;
import com.iteaj.util.module.wechat.WxaAbstract;
import com.iteaj.util.module.wechat.WxrAbstract;
import com.iteaj.util.module.wechat.pay.WechatSignType;
import com.iteaj.util.module.wechat.pay.WxcPayAbstract;
import com.iteaj.util.module.wechat.pay.unified.WxcUnifiedOrder;
import com.iteaj.util.module.wechat.pay.unified.WxpUnifiedOrder;

public class WxaUnifiedOrder
extends WxaAbstract<WxcUnifiedOrder, WxpUnifiedOrder> {
    protected WxaUnifiedOrder(WxcUnifiedOrder config) {
        super(config);
    }

    @Override
    public WechatApiType getApiType() {
        return WechatApiType.UnifiedOrder;
    }

    @Override
    public WxrAbstract invoke(WxpUnifiedOrder param, Object ... args) throws UtilsException {
        WxpUnifiedOrder.WxrUnifiedOrder order;
        AssertUtils.isTrue(param != null, "\u6ca1\u6709\u6307\u5b9a\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3\u6240\u9700\u7684\u53c2\u6570\uff1a" + WxpUnifiedOrder.class, UtilsType.WECHAT);
        this.paramValidateAndSetDefault(param);
        String xml = XmlUtils.toXml(param);
        if (logger.isDebugEnabled()) {
            logger.debug("type\uff1a\u5fae\u4fe1 - action\uff1a\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3 \u8bf7\u6c42 - content\uff1a{}", (Object)xml);
        }
        String response = HttpUtils.doPost(StreamBuilder.build(((WxcUnifiedOrder)this.getApiConfig()).getApiGateway()).setForXml(xml)).getContent("UTF-8");
        if (logger.isDebugEnabled()) {
            logger.debug("type\uff1a\u5fae\u4fe1 - action\uff1a\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3 \u8fd4\u56de - content\uff1a{}", (Object)response);
        }
        if (!(order = XmlUtils.toBean(response, WxpUnifiedOrder.WxrUnifiedOrder.class)).isOk()) {
            return order;
        }
        WxrUnifiedOrderReSign reSign = new WxrUnifiedOrderReSign(order.getPrepay_id(), param.getSign_type());
        PaySignUtils.invokeBrandWCPayRequestSign(reSign);
        return reSign;
    }

    private void paramValidateAndSetDefault(WxpUnifiedOrder param) {
        param.setApiConfig((WxcPayAbstract)this.getApiConfig());
        if (CommonUtils.isBlank(param.getMch_id())) {
            param.setMch_id(((WxcUnifiedOrder)this.getApiConfig()).getMchId());
            AssertUtils.isTrue(null != param.getMch_id(), "\u5fae\u4fe1\u4e0b\u5355\u63a5\u53e3\u9700\u6307\u5b9a\u53c2\u6570: mch_id", UtilsType.WECHAT);
        }
        if (CommonUtils.isBlank(param.getNotify_url())) {
            param.setNotify_url(((WxcUnifiedOrder)this.getApiConfig()).getNotifyUrl());
            AssertUtils.isTrue(null != param.getNotify_url(), "\u5fae\u4fe1\u4e0b\u5355\u63a5\u53e3\u9700\u6307\u5b9a\u53c2\u6570\uff1anotify_url", UtilsType.WECHAT);
        }
        if (CommonUtils.isBlank(param.getAppid())) {
            param.setAppid(((WxcUnifiedOrder)this.getApiConfig()).getAppId());
            AssertUtils.isTrue(null != param.getAppid(), "\u5fae\u4fe1\u4e0b\u5355\u63a5\u53e3\u9700\u6307\u5b9a\u53c2\u6570\uff1aappid", UtilsType.WECHAT);
        }
        if (null == param.getTrade_type()) {
            param.setTrade_type(((WxcUnifiedOrder)this.getApiConfig()).getTradeType());
        }
        if (null == param.getSign_type()) {
            param.setSign_type(((WxcUnifiedOrder)this.getApiConfig()).getSignType());
        }
        PaySignUtils.invokeWechatUnifiedOrderSign(param);
    }

    public class WxrUnifiedOrderReSign
    extends WxrAbstract {
        private String appId;
        private String timeStamp;
        private String nonceStr;
        private transient String prepayId;
        private String paySign;
        private WechatSignType signType;
        private transient WxcUnifiedOrder unifiedConfig;

        public WxrUnifiedOrderReSign(String prepayId, WechatSignType signType) {
            this(prepayId, signType, RandomUtils.create(16, RandomUtils.Type.L26));
        }

        public WxrUnifiedOrderReSign(String prepayId, WechatSignType signType, String nonceStr) {
            this.unifiedConfig = (WxcUnifiedOrder)WxaUnifiedOrder.this.getApiConfig();
            this.prepayId = prepayId;
            this.signType = signType;
            this.nonceStr = nonceStr;
            this.appId = ((WxcUnifiedOrder)WxaUnifiedOrder.this.getApiConfig()).getAppId();
            this.timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String getNonceStr() {
            return this.nonceStr;
        }

        public void setNonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
        }

        public WxcUnifiedOrder getUnifiedConfig() {
            return this.unifiedConfig;
        }

        public void setUnifiedConfig(WxcUnifiedOrder unifiedConfig) {
            this.unifiedConfig = unifiedConfig;
        }

        public String getPrepayId() {
            return this.prepayId;
        }

        public void setPrepayId(String prepayId) {
            this.prepayId = prepayId;
        }

        public String getPackage() {
            return "prepay_id=" + this.prepayId;
        }

        public WechatSignType getSignType() {
            return this.signType;
        }

        public void setSignType(WechatSignType signType) {
            this.signType = signType;
        }

        public String getPaySign() {
            return this.paySign;
        }

        public void setPaySign(String paySign) {
            this.paySign = paySign;
        }
    }
}

