/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.message;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.HttpUtils;
import com.iteaj.util.JsonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.build.StreamBuilder;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.wechat.WechatApiType;
import com.iteaj.util.module.wechat.WxaAbstract;
import com.iteaj.util.module.wechat.WxrAbstract;
import com.iteaj.util.module.wechat.basictoken.BasicToken;
import com.iteaj.util.module.wechat.basictoken.WxcBasicToken;
import com.iteaj.util.module.wechat.message.WxcTemplateMessage;
import com.iteaj.util.module.wechat.message.WxpTemplateMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxaTemplateMessage
extends WxaAbstract<WxcTemplateMessage, WxpTemplateMessage> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public WxaTemplateMessage(WxcTemplateMessage config) {
        super(config);
    }

    public MessageReturn invoke(WxpTemplateMessage param, Object ... args) {
        AssertUtils.isTrue(null != param, "\u5fae\u4fe1\u6a21\u7248\u6d88\u606f - \u53c2\u6570\u9519\u8bef", UtilsType.WECHAT);
        AssertUtils.isNotBlank(param.getOpenId(), "\u5fae\u4fe1\u6a21\u7248\u6d88\u606f - \u672a\u6307\u5b9a\u63a5\u53d7\u8005\u7684openId", UtilsType.WECHAT);
        AssertUtils.isNotBlank(param.getTemplateId(), "\u5fae\u4fe1\u6a21\u7248\u6d88\u606f - \u672a\u6307\u5b9a\u6a21\u7248\u7684templateId", UtilsType.WECHAT);
        AssertUtils.isTrue(CommonUtils.isNotEmpty(param.getItems()), "\u5fae\u4fe1\u6a21\u7248\u6d88\u606f - \u65e0\u6a21\u7248\u6570\u636e\u9879", UtilsType.WECHAT);
        try {
            WxcBasicToken tokenConfig = new WxcBasicToken(((WxcTemplateMessage)this.getApiConfig()).getAppId(), ((WxcTemplateMessage)this.getApiConfig()).getAppSecret());
            BasicToken invoke = ((WxcTemplateMessage)this.getApiConfig()).getTokenManager().getToken(tokenConfig);
            if (!invoke.isOk()) {
                throw new IllegalStateException("\u83b7\u53d6\u5fae\u4fe1AccessToken\u5931\u8d25\uff1a" + invoke.getErrmsg());
            }
            Json json = JsonUtils.builder();
            if (CommonUtils.isNotBlank(param.getUrl())) {
                json.add("url", param.getUrl());
            }
            if (CommonUtils.isNotBlank(param.getMiniprogram()) && CommonUtils.isNotBlank(param.getPagepath())) {
                Json build = JsonUtils.builder();
                build.add("appid", ((WxcTemplateMessage)this.getApiConfig()).getAppId()).add("pagepath", param.getPagepath());
                json.add("miniprogram", build);
            }
            Json data = JsonUtils.builder();
            for (WxpTemplateMessage.Item item : param.getItems()) {
                data.add(item.getKey(), item);
            }
            json.add("data", data);
            json.add("touser", param.getOpenId());
            json.add("template_id", param.getTemplateId());
            String message = json.toJsonString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u7c7b\u522b\uff1a\u5fae\u4fe1\u63a5\u53e3 - \u52a8\u4f5c\uff1a\u53d1\u9001\u6a21\u7248\u6d88\u606f - \u63cf\u8ff0\uff1a\u53d1\u9001\u62a5\u6587 {} - token\uff1a{}", (Object)message, (Object)invoke.getAccess_token());
            }
            StreamBuilder builder = StreamBuilder.build(((WxcTemplateMessage)this.getApiConfig()).getApiGateway());
            ((StreamBuilder)builder.addQueryParam("access_token", invoke.getAccess_token())).setForPlain(message);
            String result = HttpUtils.doPost(builder, "utf-8");
            MessageReturn response = JsonUtils.toBean(result, MessageReturn.class);
            if (!response.isOk() && response.getErrcode() == 40001) {
                ((WxcTemplateMessage)this.getApiConfig()).getTokenManager().refresh(tokenConfig);
            }
            return response;
        }
        catch (Exception e) {
            throw new UtilsException("\u53d1\u9001\u5fae\u4fe1\u6a21\u7248\u6d88\u606f\u5931\u8d25\uff1a", e, UtilsType.WECHAT);
        }
    }

    @Override
    public WechatApiType getApiType() {
        return WechatApiType.TemplateMessage;
    }

    public static class MessageReturn
    extends WxrAbstract {
        private String msgid;

        public String getMsgid() {
            return this.msgid;
        }

        public void setMsgid(String msgid) {
            this.msgid = msgid;
        }
    }
}

