/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.jsapi;

import com.iteaj.util.HttpUtils;
import com.iteaj.util.JsonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsFactory;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.HttpResponse;
import com.iteaj.util.module.http.build.UrlBuilder;
import com.iteaj.util.module.wechat.WechatApiType;
import com.iteaj.util.module.wechat.WechatExpires;
import com.iteaj.util.module.wechat.WxaAbstract;
import com.iteaj.util.module.wechat.WxcAbstract;
import com.iteaj.util.module.wechat.basictoken.BasicToken;
import com.iteaj.util.module.wechat.basictoken.WxcBasicToken;
import com.iteaj.util.module.wechat.jsapi.WxpJsApiTicket;

public class WxcJsApiTicket
extends WxcAbstract<WxaJsApiTicket> {
    public WxcJsApiTicket(String appId, String appSecret) {
        super(appId, appSecret, "https://api.weixin.qq.com/cgi-bin/ticket/getticket");
    }

    @Override
    public WxaJsApiTicket buildApi() {
        return new WxaJsApiTicket(this);
    }

    @Override
    public String warn() {
        return "\u8be6\u60c5\u89c1\uff1ahttps://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141115 (jsapi_ticket)";
    }

    public static class WxrJsApiTicket
    extends WechatExpires {
        private String ticket;
        private static WxrJsApiTicket ERR_TICKET = new WxrJsApiTicket(){

            @Override
            public boolean isOk() {
                return false;
            }

            @Override
            public String getErrmsg() {
                return "\u83b7\u53d6JsApiTicket\u5931\u8d25, \u672a\u77e5\u539f\u56e0";
            }

            @Override
            public Integer getErrcode() {
                return -999999;
            }
        };

        public String getTicket() {
            return this.ticket;
        }

        public void setTicket(String ticket) {
            this.ticket = ticket;
        }

        @Override
        protected boolean isExpires(int salt) {
            return super.isExpires(salt);
        }

        @Override
        protected void setInvokeTime(long invokeTime) {
            super.setInvokeTime(invokeTime);
        }
    }

    public class WxaJsApiTicket
    extends WxaAbstract<WxcJsApiTicket, WxpJsApiTicket> {
        public WxaJsApiTicket(WxcJsApiTicket config) {
            super(config);
        }

        @Override
        public WechatApiType getApiType() {
            return WechatApiType.JsApiTicket;
        }

        public WxrJsApiTicket invoke(WxpJsApiTicket param, Object ... args) throws UtilsException {
            WxcBasicToken basicToken = new WxcBasicToken(((WxcJsApiTicket)this.getApiConfig()).getAppId(), ((WxcJsApiTicket)this.getApiConfig()).getAppSecret());
            BasicToken token = UtilsFactory.getWechatTokenManager().getToken(basicToken);
            if (!token.isOk()) {
                return WxrJsApiTicket.ERR_TICKET;
            }
            UrlBuilder urlBuilder = (UrlBuilder)((UrlBuilder)UrlBuilder.build(((WxcJsApiTicket)this.getApiConfig()).getApiGateway()).addQueryParam("access_token", token.getAccess_token())).addQueryParam("type", "jsapi");
            HttpResponse response = HttpUtils.doGet(urlBuilder);
            if (!response.isOk()) {
                throw new UtilsException("\u83b7\u53d6JsApiTicket\u5931\u8d25", UtilsType.WECHAT);
            }
            return JsonUtils.toBean(response.getContent("UTF-8"), WxrJsApiTicket.class);
        }
    }
}

