/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.basictoken;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.module.wechat.WechatTokenManager;
import com.iteaj.util.module.wechat.basictoken.BasicToken;
import com.iteaj.util.module.wechat.basictoken.WxcBasicToken;
import com.iteaj.util.module.wechat.basictoken.WxcEnterpriseBasicToken;
import com.iteaj.util.module.wechat.basictoken.WxpBasicToken;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationWechatTokenManager
extends WechatTokenManager {
    private int count = 3;
    private static LocationWechatTokenManager tokenManager;
    private Map<String, Map<String, BasicToken>> tokenMap;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected LocationWechatTokenManager() {
        this.tokenMap = new ConcurrentHashMap<String, Map<String, BasicToken>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasicToken getBasicToken(WxcBasicToken config, boolean refresh) {
        Map<String, BasicToken> tokenMap = this.tokenMap.get(config.getAppId());
        if (CommonUtils.isNotEmpty(tokenMap)) {
            BasicToken basicToken = tokenMap.get(config.getAppSecret());
            if (null == basicToken) {
                LocationWechatTokenManager locationWechatTokenManager = this;
                synchronized (locationWechatTokenManager) {
                    if (null != tokenMap.get(config.getAppSecret())) {
                        return basicToken;
                    }
                    return this.initBasisToken(config);
                }
            }
            if (!refresh && !basicToken.isExpires(600)) {
                return basicToken;
            }
            LocationWechatTokenManager locationWechatTokenManager = this;
            synchronized (locationWechatTokenManager) {
                BasicToken token = tokenMap.get(config.getAppSecret());
                if (!token.isExpires(600)) {
                    return token;
                }
                return this.initBasisToken(config);
            }
        }
        LocationWechatTokenManager locationWechatTokenManager = this;
        synchronized (locationWechatTokenManager) {
            Map<String, BasicToken> basicTokenMap = this.tokenMap.get(config.getAppId());
            if (CommonUtils.isNotEmpty(basicTokenMap) && null != basicTokenMap.get(config.getAppSecret())) {
                return basicTokenMap.get(config.getAppSecret());
            }
            return this.initBasisToken(config);
        }
    }

    @Override
    protected BasicToken getBasicToken(WxcEnterpriseBasicToken config, boolean refresh) {
        return this.getBasicToken((WxcBasicToken)config, refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationWechatTokenManager instance() {
        if (null != tokenManager) {
            return tokenManager;
        }
        Class<LocationWechatTokenManager> clazz = LocationWechatTokenManager.class;
        synchronized (LocationWechatTokenManager.class) {
            if (null != tokenManager) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return tokenManager;
            }
            tokenManager = new LocationWechatTokenManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tokenManager;
        }
    }

    protected BasicToken initBasisToken(WxcBasicToken config) {
        long currentTimeMillis;
        BasicToken basicToken;
        int count = this.count;
        do {
            currentTimeMillis = System.currentTimeMillis();
            basicToken = config.buildApi().invoke(WxpBasicToken.instance(), new Object[0]);
            if (--count > 0) continue;
            this.logger.error("\u7c7b\u522b\uff1a\u5fae\u4fe1Api - \u52a8\u4f5c\uff1a\u83b7\u53d6Token - \u63cf\u8ff0\uff1a\u83b7\u53d6\u5fae\u4fe1token\u5931\u8d25 - \u5931\u8d25\u4fe1\u606f\uff1a{}", (Object)basicToken);
            return BasicToken.ErrBasicToken;
        } while (!basicToken.isOk());
        basicToken.setInvokeTime(currentTimeMillis);
        Map<String, BasicToken> basicTokenMap = this.tokenMap.get(config.getAppId());
        if (CommonUtils.isNotEmpty(basicTokenMap)) {
            basicTokenMap.put(config.getAppSecret(), basicToken);
        } else {
            HashMap<String, BasicToken> token = new HashMap<String, BasicToken>();
            token.put(config.getAppSecret(), basicToken);
            this.tokenMap.put(config.getAppId(), token);
        }
        return basicToken;
    }

    protected void setCount(int count) {
        this.count = count;
    }
}

