/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.authhorize;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.wechat.authhorize.AbstractWechatOAuth2ApiConfig;
import com.iteaj.util.module.wechat.authhorize.WxaWebAuthorize;

public class WxcWebAuthorize
extends AbstractWechatOAuth2ApiConfig<WxaWebAuthorize> {
    private String lang = "zh_CN";
    private String state = "auth";
    private String grantType;
    private String codeGateway;
    private String responseType = "code";
    private String accessGateway;
    private String apiGateway;
    private String redirectUrl;

    public WxcWebAuthorize(String appId, String appSecret, String redirectUrl) {
        super(appId, appSecret, null);
        this.redirectUrl = redirectUrl;
        this.grantType = "authorization_code";
        this.apiGateway = "https://api.weixin.qq.com/sns/userinfo";
        this.accessGateway = "https://api.weixin.qq.com/sns/oauth2/access_token";
        this.codeGateway = "https://open.weixin.qq.com/connect/oauth2/authorize";
    }

    @Override
    public WxaWebAuthorize buildApi() {
        AssertUtils.isNotBlank(this.getAppId(), "\u8bf7\u6307\u5b9aAppId", UtilsType.WECHAT);
        AssertUtils.isNotBlank(this.getAppSecret(), "\u8bf7\u6307\u5b9aAppSecret", UtilsType.WECHAT);
        return new WxaWebAuthorize(this);
    }

    @Override
    public String getApiGateway() {
        return this.apiGateway;
    }

    @Override
    public void setApiGateway(String gateway) {
        this.apiGateway = gateway;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getCodeGateway() {
        return this.codeGateway;
    }

    public void setCodeGateway(String codeGateway) {
        this.codeGateway = codeGateway;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getAccessGateway() {
        return this.accessGateway;
    }

    public void setAccessGateway(String accessGateway) {
        this.accessGateway = accessGateway;
    }

    @Override
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public String warn() {
        return "\u8be6\u60c5\u89c1\uff1ahttps://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140842";
    }
}

