/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.authhorize;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.wechat.authhorize.AbstractWechatOAuth2ApiConfig;
import com.iteaj.util.module.wechat.authhorize.WxaEnterpriseAuthorize;

public class WxcEnterpriseAuthorize
extends AbstractWechatOAuth2ApiConfig<WxaEnterpriseAuthorize> {
    private String state = "auth";
    private String userType;
    private String agentid;
    private String responseType;
    private String codeGateway;
    private String accessGateway;
    private String userInfoGateway;
    private String userDetailGateway;
    private String redirectUrl;

    public WxcEnterpriseAuthorize(String corpId, String corpSecret, String agentid) {
        this(corpId, corpSecret, agentid, null);
    }

    public WxcEnterpriseAuthorize(String corpId, String corpSecret, String agentId, String redirectUrl) {
        super(corpId, corpSecret, null);
        this.agentid = agentId;
        this.responseType = "code";
        this.redirectUrl = redirectUrl;
        this.accessGateway = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
        this.codeGateway = "https://open.weixin.qq.com/connect/oauth2/authorize";
        this.userInfoGateway = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserinfo";
        this.userDetailGateway = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserdetail";
    }

    @Override
    public WxaEnterpriseAuthorize buildApi() {
        AssertUtils.isNotBlank(this.getAppId(), "\u672a\u6307\u5b9aCorpId", UtilsType.WECHAT);
        AssertUtils.isNotBlank(this.getAgentid(), "\u672a\u6307\u5b9aAgentId", UtilsType.WECHAT);
        AssertUtils.isNotBlank(this.getAppSecret(), "\u672a\u6307\u5b9aCorpSecret", UtilsType.WECHAT);
        return new WxaEnterpriseAuthorize(this);
    }

    @Override
    public String getApiGateway() {
        return this.userInfoGateway;
    }

    @Override
    public void setApiGateway(String gateway) {
        this.userInfoGateway = gateway;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getAgentid() {
        return this.agentid;
    }

    public WxcEnterpriseAuthorize setAgentid(String agentid) {
        this.agentid = agentid;
        return this;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getCodeGateway() {
        return this.codeGateway;
    }

    public void setCodeGateway(String codeGateway) {
        this.codeGateway = codeGateway;
    }

    public String getAccessGateway() {
        return this.accessGateway;
    }

    public void setAccessGateway(String accessGateway) {
        this.accessGateway = accessGateway;
    }

    public String getUserInfoGateway() {
        return this.userInfoGateway;
    }

    public void setUserInfoGateway(String userInfoGateway) {
        this.userInfoGateway = userInfoGateway;
    }

    public String getUserDetailGateway() {
        return this.userDetailGateway;
    }

    public void setUserDetailGateway(String userDetailGateway) {
        this.userDetailGateway = userDetailGateway;
    }

    @Override
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public WxcEnterpriseAuthorize setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }
}

