/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.authhorize;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.HttpUtils;
import com.iteaj.util.JsonUtils;
import com.iteaj.util.module.http.build.UrlBuilder;
import com.iteaj.util.module.oauth2.AbstractAuthorizeResult;
import com.iteaj.util.module.oauth2.AbstractStorageContext;
import com.iteaj.util.module.oauth2.AuthorizePhase;
import com.iteaj.util.module.oauth2.PhaseChain;
import com.iteaj.util.module.wechat.AbstractWechatPhase;
import com.iteaj.util.module.wechat.WechatApiType;
import com.iteaj.util.module.wechat.WechatScope;
import com.iteaj.util.module.wechat.WxrAbstract;
import com.iteaj.util.module.wechat.authhorize.AbstractWechatOAuth2Api;
import com.iteaj.util.module.wechat.authhorize.WxcWebAuthorize;
import com.iteaj.util.module.wechat.authhorize.WxpWebAuthorize;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class WxaWebAuthorize
extends AbstractWechatOAuth2Api<WxcWebAuthorize, WxpWebAuthorize> {
    private EntryPhase entryPhase;

    public WxaWebAuthorize(WxcWebAuthorize config) {
        super(config);
        this.init();
    }

    protected void init() {
        UserPhase userPhase = new UserPhase(null);
        TokenPhase tokenPhase = new TokenPhase(userPhase);
        CodePhase codePhase = new CodePhase(tokenPhase);
        this.entryPhase = new EntryPhase(codePhase);
    }

    @Override
    public WechatWebResult authorizeResult() {
        return new WechatWebResult();
    }

    @Override
    public String getDescription() {
        return "\u5fae\u4fe1\u670d\u52a1\u53f7\u7f51\u9875\u6388\u6743";
    }

    @Override
    public AuthorizePhase getPhaseEntry() {
        return this.entryPhase;
    }

    @Override
    public String getProcessStage() {
        return "entry --> code --> token --> user";
    }

    @Override
    public WechatApiType getApiType() {
        return WechatApiType.WebAuthorize;
    }

    public static class UserInfo
    extends WxrAbstract {
        private String sex;
        private String city;
        private String openid;
        private String unionid;
        private String country;
        private String nickname;
        private String language;
        private String province;
        private String[] privilege;
        private String headimgurl;

        public String getSex() {
            return this.sex;
        }

        public void setSex(String sex) {
            this.sex = sex;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public String getOpenid() {
            return this.openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }

        public String getUnionid() {
            return this.unionid;
        }

        public void setUnionid(String unionid) {
            this.unionid = unionid;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public String[] getPrivilege() {
            return this.privilege;
        }

        public void setPrivilege(String[] privilege) {
            this.privilege = privilege;
        }

        public String getHeadimgurl() {
            return this.headimgurl;
        }

        public void setHeadimgurl(String headimgurl) {
            this.headimgurl = headimgurl;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public String toString() {
            return "UserInfo{sex='" + this.sex + '\'' + ", city='" + this.city + '\'' + ", openid='" + this.openid + '\'' + ", unionid='" + this.unionid + '\'' + ", country='" + this.country + '\'' + ", nickname='" + this.nickname + '\'' + ", language='" + this.language + '\'' + ", province='" + this.province + '\'' + ", privilege=" + Arrays.toString(this.privilege) + ", headimgurl='" + this.headimgurl + '\'' + '}';
        }
    }

    public static class AccessToken
    extends WxrAbstract {
        private String scope;
        private String openid;
        private String expires_in;
        private String access_token;
        private String refresh_token;

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getOpenid() {
            return this.openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }

        public String getExpires_in() {
            return this.expires_in;
        }

        public void setExpires_in(String expires_in) {
            this.expires_in = expires_in;
        }

        public String getAccess_token() {
            return this.access_token;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public String getRefresh_token() {
            return this.refresh_token;
        }

        public void setRefresh_token(String refresh_token) {
            this.refresh_token = refresh_token;
        }

        @Override
        public String toString() {
            return "AccessToken{scope='" + this.scope + '\'' + ", openid='" + this.openid + '\'' + ", expires_in='" + this.expires_in + '\'' + ", access_tToken='" + this.access_token + '\'' + ", refresh_token='" + this.refresh_token + '\'' + '}';
        }
    }

    public static class WechatWebResult
    extends AbstractAuthorizeResult {
        private String code;
        private String openId;
        private UserInfo userInfo;
        private AccessToken accessToken;

        @Override
        public void doBuild(AbstractStorageContext context) {
            this.code = (String)context.getParam("code");
            this.userInfo = (UserInfo)context.getParam("user");
            this.accessToken = (AccessToken)context.getParam("token");
            this.openId = this.accessToken != null ? this.accessToken.openid : null;
        }

        public String getCode() {
            return this.code;
        }

        public String getOpenId() {
            return this.openId;
        }

        public UserInfo getUserInfo() {
            return this.userInfo;
        }

        public AccessToken getAccessToken() {
            return this.accessToken;
        }
    }

    protected class UserPhase
    extends AbstractWechatPhase<WxpWebAuthorize> {
        public UserPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "user";
        }

        @Override
        public String getTypeAlias() {
            return WxaWebAuthorize.this.getTypeAlias();
        }

        @Override
        protected void doPhase(PhaseChain chain, WxpWebAuthorize context) {
            AccessToken token = (AccessToken)context.getParam("token");
            StringBuilder sb = new StringBuilder(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getApiGateway()).append("?").append("access_token=").append(token.getAccess_token()).append("&openid=").append(token.getOpenid()).append("&lang=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getLang());
            String result = HttpUtils.doGet(UrlBuilder.build(sb.toString()), "UTF-8");
            if (!this.isSuccess(context, result, this.phaseAlias())) {
                return;
            }
            UserInfo userInfo = JsonUtils.toBean(result, UserInfo.class);
            context.addParam(this.phaseAlias(), userInfo);
        }
    }

    protected class TokenPhase
    extends AbstractWechatPhase<WxpWebAuthorize> {
        public TokenPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "token";
        }

        @Override
        public void doPhase(PhaseChain chain, WxpWebAuthorize context) {
            StringBuilder sb = new StringBuilder(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getAccessGateway()).append("?").append("appid=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getAppId()).append("&secret=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getAppSecret()).append("&code=").append(context.getParam("code")).append("&grant_type=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getGrantType());
            String result = HttpUtils.doGet(UrlBuilder.build(sb.toString()), "UTF-8");
            if (!this.isSuccess(context, result, this.phaseAlias())) {
                return;
            }
            AccessToken token = JsonUtils.toBean(result, AccessToken.class);
            context.addParam(this.phaseAlias(), token);
            if (WechatScope.Base == context.getScope()) {
                return;
            }
            chain.doPhase(context);
        }

        @Override
        public String getTypeAlias() {
            return WxaWebAuthorize.this.getTypeAlias();
        }
    }

    protected class CodePhase
    extends AbstractWechatPhase<WxpWebAuthorize> {
        public CodePhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "code";
        }

        @Override
        public void doPhase(PhaseChain chain, WxpWebAuthorize context) {
            String code = context.getRequest().getParameter("code");
            String state = context.getRequest().getParameter("state");
            if (!this.isSuccess(context, code, this.phaseAlias())) {
                return;
            }
            context.addParam("code", code).addParam("state", state);
            chain.doPhase(context);
        }

        @Override
        public String getTypeAlias() {
            return WxaWebAuthorize.this.getTypeAlias();
        }
    }

    protected class EntryPhase
    extends AbstractWechatPhase<WxpWebAuthorize> {
        public EntryPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "entry";
        }

        @Override
        public void doPhase(PhaseChain chain, WxpWebAuthorize context) {
            try {
                String redirectUri = CommonUtils.isBlank(context.getRedirectUrl()) ? ((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getRedirectUrl() : context.getRedirectUrl();
                String redirectUrl = this.getRedirectUrl(context, redirectUri);
                String domain = context.getRequest().getServerName();
                if (!redirectUrl.contains(domain)) {
                    this.logger.warn("\u7c7b\u522b\uff1a\u5fae\u4fe1Api - \u52a8\u4f5c\uff1a\u83b7\u53d6code - \u63cf\u8ff0\uff1a{} - Domain\uff1a{} - redirectUrl\uff1a{}", new Object[]{"redirectUrl\u7684\u57df\u540d\u548c\u8bbf\u95ee\u57df\u540d\u4e0d\u4e00\u81f4, \u53ef\u80fd\u5bfc\u81f4\u5fae\u4fe1\u8fd4\u56de\u3010redirect_uri\u53c2\u6570\u9519\u8bef\u3011", domain, redirectUrl});
                }
                StringBuilder sb = new StringBuilder(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getCodeGateway());
                sb.append("?appid=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getAppId()).append("&redirect_uri=").append(redirectUrl).append("&response_type=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getResponseType()).append("&scope=").append(context.getScope().val).append("&state=").append(((WxcWebAuthorize)WxaWebAuthorize.this.getApiConfig()).getState()).append("#wechat_redirect");
                String html = String.format("<!DOCTYPE html><html lang=\"zh_cn\"><head><meta charset=\"UTF-8\"></head><body><a id=\"auto_submit\" href=\"%s\" /><script>document.getElementById(\"auto_submit\").click();</script></body></html>", sb.toString());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u7c7b\u522b\uff1a\u5fae\u4fe1Api - \u52a8\u4f5c\uff1a\u83b7\u53d6code - \u63cf\u8ff0\uff1a\u5199html\u53c2\u6570\u5230\u5fae\u4fe1\u5ba2\u6237\u7aef [{}]", (Object)html);
                }
                PrintWriter writer = context.getResponse().getWriter();
                context.getResponse().setContentType("text/html; charset=utf-8");
                writer.print(html);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("\u7c7b\u522b\uff1a\u5fae\u4fe1Api - \u52a8\u4f5c\uff1a\u6267\u884c\u7f51\u9875\u6388\u6743\u9636\u6bb5 - \u63cf\u8ff0\uff1a\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            }
        }

        @Override
        public String getTypeAlias() {
            return WxaWebAuthorize.this.getTypeAlias();
        }
    }
}

