/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.wechat.authhorize;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.HttpUtils;
import com.iteaj.util.JsonUtils;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.http.build.MultipartBuilder;
import com.iteaj.util.module.http.build.UrlBuilder;
import com.iteaj.util.module.json.Json;
import com.iteaj.util.module.oauth2.AuthorizePhase;
import com.iteaj.util.module.oauth2.PhaseChain;
import com.iteaj.util.module.wechat.AbstractWechatPhase;
import com.iteaj.util.module.wechat.WechatApiType;
import com.iteaj.util.module.wechat.authhorize.AbstractWechatOAuth2Api;
import com.iteaj.util.module.wechat.authhorize.WechatEnterpriseResult;
import com.iteaj.util.module.wechat.authhorize.WxcEnterpriseAuthorize;
import com.iteaj.util.module.wechat.authhorize.WxpEnterpriseAuthorize;
import java.io.IOException;
import java.io.PrintWriter;

public class WxaEnterpriseAuthorize
extends AbstractWechatOAuth2Api<WxcEnterpriseAuthorize, WxpEnterpriseAuthorize> {
    private EntryPhase entryPhase;

    public WxaEnterpriseAuthorize(WxcEnterpriseAuthorize config) {
        super(config);
        this.init();
    }

    protected void init() {
        UserDetailPhase detailPhase = new UserDetailPhase(null);
        UserPhase userPhase = new UserPhase(detailPhase);
        TokenPhase tokenPhase = new TokenPhase(userPhase);
        CodePhase codePhase = new CodePhase(tokenPhase);
        this.entryPhase = new EntryPhase(codePhase);
    }

    @Override
    public WechatEnterpriseResult authorizeResult() {
        return new WechatEnterpriseResult();
    }

    @Override
    public String getDescription() {
        return "\u5fae\u4fe1\u4f01\u4e1a\u53f7\u7f51\u9875\u6388\u6743";
    }

    @Override
    public AuthorizePhase getPhaseEntry() {
        return this.entryPhase;
    }

    @Override
    public String getProcessStage() {
        return "entry->code->token->user->detail";
    }

    @Override
    public WechatApiType getApiType() {
        return WechatApiType.EnterpriseAuthorize;
    }

    protected class UserDetailPhase
    extends AbstractWechatPhase<WxpEnterpriseAuthorize> {
        public UserDetailPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "detail";
        }

        @Override
        public String getTypeAlias() {
            return WxaEnterpriseAuthorize.this.getTypeAlias();
        }

        @Override
        protected void doPhase(PhaseChain chain, WxpEnterpriseAuthorize context) {
            Json token = (Json)context.getParam("token");
            WechatEnterpriseResult.UserInfo userInfo = (WechatEnterpriseResult.UserInfo)context.getParam("user");
            String accessToken = token.getString("access_token", new boolean[0]);
            MultipartBuilder builder = (MultipartBuilder)((MultipartBuilder)MultipartBuilder.build(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getUserDetailGateway()).addQueryParam("access_token", accessToken)).addBody(null, "{\"user_ticket\":\"" + userInfo.getUser_ticket() + "\"}");
            String result = HttpUtils.doPost(builder, "UTF-8");
            if (!this.isSuccess(context, result, this.phaseAlias())) {
                return;
            }
            WechatEnterpriseResult.UserDetail userDetail = JsonUtils.toBean(result, WechatEnterpriseResult.UserDetail.class);
            if (!userDetail.isOk()) {
                this.logger.error(ERROR_INFO, new Object[]{this.getTypeAlias(), this.phaseAlias(), "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8be6\u60c5\u5931\u8d25"});
                context.getAuthorizeResult().setSuccess(false).setErrMsg("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8be6\u60c5\u5931\u8d25");
                return;
            }
            context.addParam(this.phaseAlias(), userDetail);
        }
    }

    protected class UserPhase
    extends AbstractWechatPhase<WxpEnterpriseAuthorize> {
        public UserPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "user";
        }

        @Override
        public String getTypeAlias() {
            return WxaEnterpriseAuthorize.this.getTypeAlias();
        }

        @Override
        protected void doPhase(PhaseChain chain, WxpEnterpriseAuthorize context) {
            Json token = (Json)context.getParam("token");
            StringBuilder sb = new StringBuilder(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getUserInfoGateway()).append("?").append("access_token=").append(token.getString("access_token", new boolean[0])).append("&code=").append(context.getParam("code"));
            String result = HttpUtils.doGet(UrlBuilder.build(sb.toString()), "UTF-8");
            if (!this.isSuccess(context, result, this.phaseAlias())) {
                return;
            }
            WechatEnterpriseResult.UserInfo userInfo = JsonUtils.toBean(result, WechatEnterpriseResult.UserInfo.class);
            if (!userInfo.isOk()) {
                this.logger.error(ERROR_INFO, new Object[]{this.getTypeAlias(), this.phaseAlias(), result});
                context.getAuthorizeResult().setSuccess(false).setErrMsg(result);
                return;
            }
            context.addParam(this.phaseAlias(), userInfo);
            chain.doPhase(context);
        }
    }

    protected class TokenPhase
    extends AbstractWechatPhase<WxpEnterpriseAuthorize> {
        public TokenPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "token";
        }

        @Override
        public void doPhase(PhaseChain chain, WxpEnterpriseAuthorize context) {
            StringBuilder sb = new StringBuilder(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getAccessGateway()).append("?").append("corpid=").append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getAppId()).append("&corpsecret=").append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getAppSecret());
            String result = HttpUtils.doGet(UrlBuilder.build(sb.toString()), "UTF-8");
            if (!this.isSuccess(context, result, this.phaseAlias())) {
                return;
            }
            Json json = JsonUtils.builder(result);
            context.addParam(this.phaseAlias(), json);
            chain.doPhase(context);
        }

        @Override
        public String getTypeAlias() {
            return WxaEnterpriseAuthorize.this.getTypeAlias();
        }
    }

    protected class CodePhase
    extends AbstractWechatPhase<WxpEnterpriseAuthorize> {
        public CodePhase(AuthorizePhase nextPhase) {
            super(nextPhase);
        }

        @Override
        public String phaseAlias() {
            return "code";
        }

        @Override
        public void doPhase(PhaseChain chain, WxpEnterpriseAuthorize context) {
            String code = context.getRequest().getParameter("code");
            if (!this.isSuccess(context, code, this.phaseAlias())) {
                return;
            }
            context.addParam(this.phaseAlias(), code).addParam("state", context.getParam("state"));
            chain.doPhase(context);
        }

        @Override
        public String getTypeAlias() {
            return WxaEnterpriseAuthorize.this.getTypeAlias();
        }
    }

    protected class EntryPhase
    extends AbstractWechatPhase<WxpEnterpriseAuthorize> {
        private String html_pre;
        private String html_suf;

        public EntryPhase(AuthorizePhase nextPhase) {
            super(nextPhase);
            this.html_pre = "<!DOCTYPE html><html lang=\"zh_cn\"><head><meta charset=\"UTF-8\"></head><body><a id=\"auto_submit\" href=\"";
            this.html_suf = "\" /><script>document.getElementById(\"auto_submit\").click();</script></body></html>";
        }

        @Override
        public String phaseAlias() {
            return "entry";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doPhase(PhaseChain chain, WxpEnterpriseAuthorize context) {
            PrintWriter writer = null;
            try {
                StringBuilder sb = new StringBuilder(this.html_pre);
                String redirectUrl = CommonUtils.isBlank(context.getRedirectUrl()) ? ((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getRedirectUrl() : context.getRedirectUrl();
                AssertUtils.isNotBlank(redirectUrl, "\u8bf7\u6307\u5b9a\u4f01\u4e1a\u5fae\u4fe1\u7f51\u9875\u6388\u6743\u7684RedirectUrl\u53c2\u6570", UtilsType.WECHAT);
                sb.append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getCodeGateway()).append("?appid=").append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getAppId()).append("&redirect_uri=").append(this.getRedirectUrl(context, redirectUrl)).append("&response_type=").append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getResponseType()).append("&scope=").append(context.getScope().val).append("&agentid=").append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getAgentid()).append("&state=").append(((WxcEnterpriseAuthorize)WxaEnterpriseAuthorize.this.getApiConfig()).getState()).append("#wechat_redirect");
                sb.append(this.html_suf);
                String html = sb.toString();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u54cd\u5e94Html\uff1a{}", (Object)html);
                }
                writer = context.getResponse().getWriter();
                context.getResponse().setContentType("text/html; charset=utf-8");
                writer.print(html);
            }
            catch (IOException e) {
                this.logger.error("\u7c7b\u522b\uff1a\u5fae\u4fe1Api - \u52a8\u4f5c\uff1a\u83b7\u53d6Code - \u63cf\u8ff0\uff1a\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            }
            finally {
                writer.flush();
                writer.close();
            }
        }

        @Override
        public String getTypeAlias() {
            return WxaEnterpriseAuthorize.this.getTypeAlias();
        }
    }
}

