/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.oauth2;

import com.iteaj.util.core.task.TimeoutTask;
import com.iteaj.util.core.task.TimeoutTaskManager;
import com.iteaj.util.module.oauth2.AuthorizeContext;
import com.iteaj.util.module.oauth2.AuthorizeStorageManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapStorageManager
implements AuthorizeStorageManager {
    public Map<String, AuthorizeContext> storage;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public MapStorageManager() {
        this.storage = new ConcurrentHashMap<String, AuthorizeContext>();
    }

    @Override
    public int getTimeout() {
        return 30;
    }

    @Override
    public <T extends AuthorizeContext> T getContext(String key) {
        AuthorizeContext authorizeContext = this.storage.get(key);
        if (null == authorizeContext) {
            return null;
        }
        return (T)authorizeContext;
    }

    @Override
    public void putContext(final String key, AuthorizeContext context) {
        this.storage.put(key, context);
        TimeoutTaskManager.instance().addTask(new TimeoutTask(this.getTimeout(), TimeUnit.SECONDS){

            @Override
            public void run() {
                AuthorizeContext remove = MapStorageManager.this.storage.remove(key);
                if (MapStorageManager.this.logger.isDebugEnabled()) {
                    MapStorageManager.this.logger.debug("\u7c7b\u522b\uff1aOAuth2\u6388\u6743 - \u52a8\u4f5c\uff1a\u79fb\u9664\u8d85\u65f6\u6388\u6743\u4e0a\u4e0b\u6587 - \u8d85\u65f6(s)\uff1a{} - \u72b6\u6001\uff1a{}", (Object)this.getTimeout(), (Object)(remove != null ? "\u8d85\u65f6\u79fb\u9664" : "\u6b63\u5e38\u91ca\u653e"));
                }
            }
        });
    }

    @Override
    public AuthorizeContext removeContext(String key) {
        AuthorizeContext context = this.storage.remove(key);
        if (null != context) {
            return context;
        }
        return null;
    }
}

