/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.oauth2;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsFactory;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.oauth2.AbstractAuthorizeResult;
import com.iteaj.util.module.oauth2.AbstractStorageContext;
import com.iteaj.util.module.oauth2.AuthorizeStorageManager;
import com.iteaj.util.module.oauth2.HashPhaseChain;
import com.iteaj.util.module.oauth2.Oauth2ApiCallBack;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizeServlet
extends HttpServlet {
    private AuthorizeStorageManager storageManager;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static String INIT_PARAM_MANAGER = "OAuth2StorageManager";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String key = req.getParameter("utils_oauth2");
        if (!CommonUtils.isNotBlank(key)) {
            throw new UtilsException("\u5bf9\u4e8eOAuth2\u6388\u6743, \u671f\u5f85\u5728\u8ba4\u8bc1\u670d\u52a1\u5668(eg.\u5fae\u4fe1)", UtilsType.OAuth2);
        }
        Exception throwable = null;
        AbstractStorageContext storageContext = (AbstractStorageContext)this.storageManager.getContext(key);
        try {
            if (null == storageContext) {
                throw new ServletException("OAuth2 - \u6388\u6743\u4e0a\u4e0b\u6587\u91ca\u653e\u6216\u8fc7\u671f - key\uff1a" + key);
            }
            storageContext.overrideRequestAndResponse((ServletRequest)req, (ServletResponse)resp);
            HashPhaseChain.instance().doPhase(storageContext);
        }
        catch (Exception e) {
            throwable = e;
            this.logger.error("\u7c7b\u522b\uff1aOAuth2\u6388\u6743 - \u52a8\u4f5c\uff1a\u56de\u8c03\u5931\u8d25 - \u63cf\u8ff0\uff1a", (Object)e.getMessage(), (Object)e);
        }
        finally {
            storageContext.release();
            storageContext.getAuthorizeResult().build(storageContext);
            Oauth2ApiCallBack authorizeAction = storageContext.getCallBack();
            AbstractAuthorizeResult authorizeResult = storageContext.getAuthorizeResult();
            if (null != authorizeAction) {
                if (throwable != null) {
                    authorizeResult.setSuccess(false).setErrMsg(throwable.getMessage()).setException(throwable);
                    authorizeAction.call(authorizeResult, req, resp);
                } else {
                    authorizeResult.setSuccess(true);
                    authorizeAction.call(authorizeResult, req, resp);
                }
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String storageManager = this.getServletContext().getInitParameter(INIT_PARAM_MANAGER);
            if (CommonUtils.isNotBlank(storageManager)) {
                Class<?> forName = Class.forName(storageManager, true, ((Object)((Object)this)).getClass().getClassLoader());
                this.storageManager = (AuthorizeStorageManager)forName.newInstance();
                UtilsFactory.setDefaultStorageManager(this.storageManager);
            } else {
                this.storageManager = UtilsFactory.getDefaultStorageManager();
            }
            this.getServletContext().setAttribute(AuthorizeStorageManager.STORAGE_MANAGER, (Object)this.storageManager);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }
}

