/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.oauth2;

import com.iteaj.util.AssertUtils;
import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsFactory;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.oauth2.AbstractAuthorizeResult;
import com.iteaj.util.module.oauth2.AuthorizationType;
import com.iteaj.util.module.oauth2.AuthorizeContext;
import com.iteaj.util.module.oauth2.AuthorizePhase;
import com.iteaj.util.module.oauth2.AuthorizeStorageManager;
import com.iteaj.util.module.oauth2.Oauth2ApiCallBack;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractStorageContext
implements AuthorizeContext {
    private String contextKey;
    private String prevRequestUri;
    private AuthorizationType type;
    private AuthorizePhase nextPhase;
    private Oauth2ApiCallBack callBack;
    private Map<String, Object> storage;
    private transient ServletRequest request;
    private AuthorizeStorageManager storageManager;
    private transient ServletResponse response;
    private static transient Object lock = new Object();
    private transient AbstractAuthorizeResult authorizeResult;

    public AbstractStorageContext(ServletRequest request, ServletResponse response) {
        AssertUtils.isTrue(request != null && response != null, "\u672a\u6307\u5b9aHttp\u7684request\u3001response", UtilsType.OAuth2);
        this.request = request;
        this.response = response;
        this.storage = new HashMap<String, Object>();
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        this.prevRequestUri = servletRequest.getContextPath() + servletRequest.getRequestURI() + "?" + servletRequest.getQueryString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContextKey() {
        if (CommonUtils.isNotBlank(this.contextKey)) {
            return this.contextKey;
        }
        Object object = lock;
        synchronized (object) {
            this.contextKey = this.hashCode() + "-" + System.nanoTime();
        }
        return this.contextKey;
    }

    @Override
    public void release() {
        this.storageManager.removeContext(this.getContextKey());
    }

    protected void initContext(AuthorizationType type) throws Exception {
        this.type = type;
        this.nextPhase = type.getPhaseEntry();
        if (this.storageManager == null) {
            this.storageManager = UtilsFactory.getDefaultStorageManager();
        }
        AssertUtils.isTrue(this.nextPhase != null, "\u627e\u4e0d\u5230\u8981\u6267\u884c\u7684\u5165\u53e3\u9636\u6bb5\uff1aphaseEntry \u5728\u7c7b\u578b " + type.getClass().getName(), UtilsType.OAuth2);
        this.authorizeResult = type.authorizeResult();
        AssertUtils.isTrue(this.authorizeResult != null, "\u672a\u8fd4\u56deAbstractAuthorizeResult\u5bf9\u8c61", UtilsType.OAuth2);
        this.storageManager.putContext(this.getContextKey(), this);
    }

    @Override
    public String getPrevRequestUri() {
        return this.prevRequestUri;
    }

    @Override
    public Object getParam(String name) {
        return this.storage.get(name);
    }

    @Override
    public AuthorizeContext addParam(String name, Object value) {
        this.storage.put(name, value);
        return this;
    }

    @Override
    public AuthorizeContext removeParam(String name) {
        this.storage.remove(name);
        return this;
    }

    @Override
    public void overrideRequestAndResponse(ServletRequest request, ServletResponse response) {
        this.request = request;
        this.response = response;
    }

    protected AuthorizationType getType() {
        return this.type;
    }

    protected AuthorizePhase getNextPhase() {
        AuthorizePhase tempPhase = this.nextPhase;
        if (null == tempPhase) {
            return null;
        }
        this.nextPhase = tempPhase.nextPhase();
        return tempPhase;
    }

    protected Oauth2ApiCallBack getCallBack() {
        return this.callBack;
    }

    protected void setCallBack(Oauth2ApiCallBack callBack) {
        this.callBack = callBack;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public AbstractAuthorizeResult getAuthorizeResult() {
        return this.authorizeResult;
    }
}

