/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.oauth2;

import com.iteaj.util.CommonUtils;
import com.iteaj.util.core.UtilsException;
import com.iteaj.util.core.UtilsType;
import com.iteaj.util.module.oauth2.AbstractStorageContext;
import com.iteaj.util.module.oauth2.AuthorizePhase;
import com.iteaj.util.module.oauth2.PhaseChain;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizePhase<T extends AbstractStorageContext>
implements AuthorizePhase<T> {
    private AuthorizePhase nextPhase;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String ERROR_INFO = "\u6388\u6743\u7c7b\u578b\uff1a[{}],\u5728\u6267\u884c\u9636\u6bb5\uff1a[{}]\u65f6\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\uff1a[{}]";

    public AbstractAuthorizePhase(AuthorizePhase nextPhase) {
        this.nextPhase = nextPhase;
    }

    @Override
    public AuthorizePhase nextPhase() {
        return this.nextPhase;
    }

    @Override
    public void phase(PhaseChain chain, T context) {
        this.doPhase(chain, context);
    }

    protected abstract void doPhase(PhaseChain var1, T var2);

    protected String getRedirectUrl(AbstractStorageContext context, String redirectUrl) {
        if (CommonUtils.isBlank(redirectUrl)) {
            throw new UtilsException("\u672a\u6307\u5b9aRedirectUri", UtilsType.OAuth2);
        }
        try {
            StringBuilder requestURL;
            ServletRequest request = context.getRequest();
            StringBuilder stringBuilder = requestURL = redirectUrl.startsWith("http") ? new StringBuilder(redirectUrl) : new StringBuilder(request.getScheme()).append("://").append(request.getServerName()).append('/').append(request.getServletContext().getContextPath()).append(redirectUrl);
            if (-1 != requestURL.indexOf("?")) {
                requestURL.append("&");
            } else {
                requestURL.append('?');
            }
            requestURL.append("utils_oauth2").append('=').append(context.getContextKey());
            return URLEncoder.encode(requestURL.toString(), "utf-8");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e, UtilsType.OAuth2);
        }
    }
}

