/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.util.module.mvc;

import com.iteaj.util.AbstractResult;
import com.iteaj.util.Result;
import com.iteaj.util.module.mvc.ServiceException;
import java.beans.Transient;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class OptionalResult<E, R extends OptionalResult>
extends AbstractResult<R> {
    private Result result;
    private final E value;

    protected OptionalResult(E value) {
        super(null, null);
        this.value = value;
    }

    @Transient
    public E get() {
        return this.value;
    }

    public Optional<E> of() {
        return Optional.of(this.value);
    }

    public Optional<E> ofNullable() {
        return Optional.ofNullable(this.value);
    }

    public void ifFail(Predicate<OptionalResult> predicate, Result fail) {
        if (null != predicate && predicate.test(this)) {
            this.result = fail;
            this.response(fail);
        }
        if (null == predicate) {
            this.response(fail);
        }
    }

    public void failOfNull(Result fail) {
        if (this.value == null) {
            this.result = fail;
            this.response(fail);
        }
    }

    protected Result getResult() {
        return this.result;
    }

    protected void setResult(Result result) {
        this.result = result;
    }

    public Result response(Result success) {
        if (this.getResult() == null) {
            this.result = success;
        }
        if (this.getResult() == null) {
            throw new NullPointerException("\u672a\u8bbe\u7f6e\u54cd\u5e94\u7ed3\u679c");
        }
        this.setCode(this.result.getCode());
        this.setMessage(this.result.getMessage());
        return this.doResponse();
    }

    public Result response(Function<OptionalResult, Result> function) {
        if (null == function) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        Result apply = function.apply(this);
        return this.response(apply);
    }

    protected abstract R doResponse();
}

